VERSION 2.00
Begin Form Form1 
   Caption         =   "MetaDraw - Don't Look Now"
   ClientHeight    =   4995
   ClientLeft      =   1395
   ClientTop       =   1605
   ClientWidth     =   5010
   Height          =   5400
   Icon            =   EYES.FRX:0000
   Left            =   1335
   LinkTopic       =   "Form1"
   ScaleHeight     =   4995
   ScaleWidth      =   5010
   Top             =   1260
   Width           =   5130
   WindowState     =   1  'Minimized
   Begin Timer Timer1 
      Enabled         =   0   'False
      Interval        =   200
      Left            =   96
      Top             =   5088
   End
   Begin MetaDRAW MDraw1 
      Prop110         =   EYES.FRX:0302
      Align           =   1  'Align Top
      AutoScale       =   2  ' 2 - Fit to window
      BackColor       =   &H00808080&
      FillColor       =   &H0000FF00&
      FontName        =   "Helv"
      FontSize        =   0
      Height          =   5004
      Left            =   0
      LineColor       =   &H000000FF&
      LineWidth       =   0
      MouseCursor     =   EYES.FRX:0304
      MousePointer    =   13  'User defined
      OrigHeight      =   5767
      OrigWidth       =   5767
      PicBackColor    =   &H00FFFF00&
      PicBorderColor  =   &H00808080&
      Picture         =   EYES.FRX:0412
      PictureImage    =   EYES.FRX:0776
      picXSize        =   4980
      picYSize        =   4980
      TabIndex        =   0
      TextColor       =   &H00800000&
      Top             =   0
      Width           =   5016
   End
End
Option Explicit

Dim dx%, dy%

Declare Sub GetCursorPos Lib "User" (lpPoint As VB_POINT)
Declare Sub ScreenToClient Lib "User" (ByVal hWnd As Integer, lpPoint As VB_POINT)

Declare Function GetDC Lib "User" (ByVal hWnd As Integer) As Integer
Declare Function ReleaseDC Lib "User" (ByVal hWnd As Integer, ByVal hDC As Integer) As Integer

Sub Form_Load ()
    Me.ScaleMode = 3
    '
    MDraw1.HotSpots = True      ' Enable HotSpots
    MDraw1.MarkerSize = 0       ' Don't show markers
End Sub

Sub Form_Resize ()
    MDraw1.Height = Me.ScaleHeight
    Timer1.Enabled = Me.WindowState = 1
End Sub

Sub MDraw1_Click ()
    MDraw1.Action = ACT_IMAGESWAP
End Sub

Sub MDraw1_MouseMove (Button As Integer, Shift As Integer, x As Single, y As Single)
   x = x / Screen.TwipsPerPixelX
   y = y / Screen.TwipsPerPixelY
   Call MoveEyes(x, y)
End Sub

Sub MDraw1_OnHotSpot (x As Integer, y As Integer, State As Integer)
    Select Case State
    Case STATE_ENTER:
      If MDraw1.ObjType = OT_CONTAINER Then
        MDraw1.ObjMove = MOVE_CHILD_LAST
        MDraw1.ObjVisible = True
        MDraw1.ObjMove = MOVE_PREV
        MDraw1.ObjVisible = False
        MDraw1.ObjMove = MOVE_PREV
        'MDraw1.FillColor = RGB(0, 255, 0)
      End If
    Case STATE_LEAVE:
      If MDraw1.ObjType = OT_CONTAINER Then
        MDraw1.ObjMove = MOVE_CHILD_LAST
        MDraw1.ObjVisible = False
        MDraw1.ObjMove = MOVE_PREV
        MDraw1.ObjVisible = True
        MDraw1.ObjMove = MOVE_PREV
        'MDraw1.FillColor = RGB(0, 192, 0)
      End If
    End Select
End Sub

Sub MoveEyes (ByVal x%, ByVal y%)
   MDraw1.ObjMove = MOVE_CONT_FIRST
   MDraw1.ObjMove = MOVE_NEXT
   Call SetEllipseOff(x, y)
   MDraw1.ObjMove = MOVE_NEXT
   Call SetEllipseOff(x, y)
End Sub

Sub SetEllipseOff (ByVal x!, ByVal y!)
   Dim xo!, yo!, xs!, ys!, an As Single
   Dim bnd As VB_RECT, bnd_eye As VB_RECT

   x = MDraw1.ClientToLogicX(x)
   y = MDraw1.ClientToLogicY(y)

   'MDraw1.Current = hnd&
   Call MD_GetBounds(MDraw1, bnd, CRD_LOGIC)
   MDraw1.ObjMove = MOVE_NEXT
   Call MD_GetBounds(MDraw1, bnd_eye, CRD_LOGIC)
   
   xo = (bnd.Left + bnd.Right) / 2
   yo = (bnd.Top + bnd.Bottom) / 2
   xs = (bnd.Right - bnd.Left) - (bnd_eye.Right - bnd_eye.Left)
   ys = (bnd.Bottom - bnd.Top) - (bnd_eye.Bottom - bnd_eye.Top)
   x = x - xo: y = y - yo
   xs = x / xs: ys = y / ys
   an = Sqr(xs * xs + ys * ys)
   If an > .001 Then an = .5 / an
   x = xo + an * x: y = yo + an * y

   dx = x - (bnd_eye.Right + bnd_eye.Left) / 2
   dy = y - (bnd_eye.Bottom + bnd_eye.Top) / 2
   Call MD_MoveObjects(MDraw1, dx, dy, CRD_LOGIC + CRD_CHANGE)
End Sub

Sub Timer1_Timer ()
    Dim pt As VB_POINT
    Call GetCursorPos(pt)
    Call ScreenToClient(MDraw1.hWnd, pt)
    Call MoveEyes(pt.x, pt.y)
    If Me.WindowState = 1 And (dx Or dy) Then
      Dim hDC%, res As Integer
      hDC% = GetDC(Me.hWnd)
      MDraw1.Current = OBJ_CONT_MAIN
      MDraw1.ExportLeft = 0
      MDraw1.ExportTop = 0
      MDraw1.ExportWidth = Me.ScaleWidth
      MDraw1.ExportHeight = Me.ScaleHeight
      MDraw1.ExportDC = hDC%
      res = ReleaseDC(Me.hWnd, hDC%)
    End If
End Sub

