VERSION 2.00
Begin Form frmHyperMap 
   Caption         =   "HyperMap Example"
   ClientHeight    =   5316
   ClientLeft      =   516
   ClientTop       =   1236
   ClientWidth     =   6132
   FillStyle       =   0  'Solid
   Height          =   6084
   Left            =   456
   LinkTopic       =   "HyperMap"
   MinButton       =   0   'False
   ScaleHeight     =   5316
   ScaleWidth      =   6132
   Top             =   528
   Width           =   6252
   WindowState     =   2  'Maximized
   Begin MetaDRAW MDraw 
      Prop110         =   HYPERMAP.FRX:0000
      BackColor       =   &H00808080&
      FillColor       =   &H00008000&
      FontName        =   "Helv"
      FontSize        =   0
      Height          =   3852
      HotSpots        =   -1  'True
      Left            =   0
      LineColor       =   &H000000FF&
      LineStyle       =   5  'Null line
      LineWidth       =   0
      MarkerSize      =   0
      MouseCursor     =   HYPERMAP.FRX:0002
      OrigHeight      =   6481
      OrigWidth       =   11521
      picHeight       =   2000
      Picture         =   HYPERMAP.FRX:0004
      picWidth        =   2363
      picXSize        =   11521
      picYSize        =   6481
      TabIndex        =   5
      TextColor       =   &H00800000&
      Top             =   360
      Width           =   6132
   End
   Begin SSPanel pnlToolBar 
      Align           =   1  'Align Top
      Alignment       =   1  'Left Justify - MIDDLE
      ForeColor       =   &H00000000&
      Height          =   396
      Left            =   0
      TabIndex        =   1
      Top             =   0
      Width           =   6132
      Begin CommandButton btnUp 
         Caption         =   "&Up level"
         Height          =   300
         Left            =   96
         TabIndex        =   4
         Top             =   48
         Width           =   972
      End
      Begin SSPanel pnlCoords 
         BevelOuter      =   1  'Inset
         ForeColor       =   &H00000000&
         Height          =   300
         Left            =   2016
         TabIndex        =   3
         Top             =   48
         Width           =   1068
      End
      Begin SSPanel pnlZoom 
         BevelOuter      =   1  'Inset
         Caption         =   "100%"
         ForeColor       =   &H00000000&
         Height          =   300
         Left            =   1248
         TabIndex        =   2
         Top             =   48
         Width           =   684
      End
   End
   Begin CommonDialog dlgFiles 
      Left            =   96
      Top             =   4320
   End
   Begin SSPanel pnlInfo 
      Align           =   2  'Align Bottom
      BevelInner      =   1  'Inset
      BorderWidth     =   4
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   9.6
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   516
      Left            =   0
      TabIndex        =   0
      Top             =   4800
      Width           =   6132
   End
   Begin Menu mnFile 
      Caption         =   "&File"
      Begin Menu mnNew 
         Caption         =   "&New picture..."
      End
      Begin Menu mn_N12 
         Caption         =   "-"
      End
      Begin Menu mnExit 
         Caption         =   "E&xit"
      End
   End
   Begin Menu mnView 
      Caption         =   "&View"
      Begin Menu mnFitWin 
         Caption         =   "&Fit to window"
         Shortcut        =   ^F
      End
      Begin Menu mn_N21 
         Caption         =   "-"
      End
      Begin Menu mnZoomIn 
         Caption         =   "Zoom &In"
         Shortcut        =   ^I
      End
      Begin Menu mnZoomOut 
         Caption         =   "Zoom &Out"
         Shortcut        =   ^O
      End
      Begin Menu mn_N22 
         Caption         =   "-"
      End
      Begin Menu mnAuto 
         Caption         =   "&Auto zoom"
         Checked         =   -1  'True
      End
   End
End
Option Explicit

Dim Zoom As Single
Dim cenX, cenY As Integer
Dim RButton As Integer

Declare Function GetSystemMetrics Lib "User" (ByVal nIndex%) As Integer

Sub AdjustView (ByVal Zm As Single)
    Dim w As Long, h As Long
    Dim wd As Long, hg As Long

    w = MDraw.OrigWidth
    h = MDraw.OrigHeight
    wd = MDraw.Width - Screen.TwipsPerPixelX * GetSystemMetrics(5) * 2
    hg = MDraw.Height - Screen.TwipsPerPixelY * GetSystemMetrics(6) * 2
    If Zm = 0 Then
      Dim bnd As VB_RECT, wc As Long, hc As Long
      Dim ZmSt As Integer
      MDraw.ObjMove = MOVE_CONT_MAIN    ' Set Current to main container
      wc = MDraw.Current                ' wc is Main Container
      MDraw.ObjMove = MOVE_CONT_OPENED
      ZmSt = (wc <> MDraw.Current)
      MD_GetBounds MDraw, bnd, CRD_LOGIC
      wc = (bnd.right - bnd.left) * w / MDraw.picWidth
      hc = (bnd.bottom - bnd.Top) * h / MDraw.picHeight
      If ZmSt Then
        wd = wd - Screen.TwipsPerPixelX * GetSystemMetrics(2)    ' VScroll x-size
        hg = hg - Screen.TwipsPerPixelY * GetSystemMetrics(3)    ' HScroll y-size
        wc = wc + wc / 10
        hc = hc + hc / 10
      End If

      Zm = 1#
      If wc <> wd Then
        Zm = wd / wc
      End If
      If hc * Zm > hg Then
        Zm = hg / hc
      End If
      cenX = (bnd.left + bnd.right) / 2
      cenY = (bnd.Top + bnd.bottom) / 2
    End If
    
    If (Zm > 20#) Then Zm = 20#
    wd = wd / 2: hg = hg / 2
    MDraw.Redraw = False
    MDraw.picXSize = w * Zm
    MDraw.picYSize = h * Zm
    MDraw.picXOfs = ((cenX - MDraw.picLeft) * MDraw.picXSize) / MDraw.picWidth - wd
    MDraw.picYOfs = ((cenY - MDraw.picTop) * MDraw.picYSize) / MDraw.picHeight - hg
    MDraw.Redraw = True
    Zoom = Zm
    
    cenX = MDraw.ClientToLogicX(wd / Screen.TwipsPerPixelX)
    cenY = MDraw.ClientToLogicY(hg / Screen.TwipsPerPixelY)
    
    pnlZoom.Caption = Format$(Zoom * 100, "0") + "%"
End Sub

Sub btnUp_Click ()
    MDraw.ObjMove = MOVE_CONT_OPENED
    ChangeSelection (False)
    MDraw.ObjMove = MOVE_CONT_OPENED
    ChangeVisible (False)
    MDraw.ObjMove = MOVE_CONT_OPENED
    MDraw.ObjOpened = False
    AdjustView (0#)
End Sub

Sub ChangeSelection (IsOn As Integer)
    ' "Current" contains handle to object for select
    On Error Resume Next
    If MDraw.ObjType = OT_CONTAINER Then
        MDraw.ObjMove = MOVE_CHILD_FIRST
        While (MDraw.Current > OBJ_NULL)
          If MDraw.ObjType <> OT_TEXT Then
          If MDraw.ObjVisible And IsOn Then
            MDraw.FillStyle = 7
          Else
            MDraw.FillStyle = 0
          End If
          End If
          MDraw.ObjMove = MOVE_NEXT
        Wend
    Else
      If MDraw.ObjType <> OT_TEXT Then
      If MDraw.ObjVisible And MDraw.ObjHotSpot And IsOn Then
        MDraw.FillStyle = 7
      Else
        MDraw.FillStyle = 0
      End If
      End If
    End If
End Sub

Sub ChangeVisible (IsOpen As Integer)
    If MDraw.ObjType = OT_CONTAINER Then
      MDraw.ObjMove = MOVE_CHILD_FIRST
      While MDraw.Current > OBJ_NULL
        Select Case Mid$(MDraw.ObjTag, 1, 1)
        Case "V"
          MDraw.ObjVisible = IsOpen
        Case "v"
          MDraw.ObjVisible = Not IsOpen
        End Select
        MDraw.ObjMove = MOVE_NEXT
      Wend
    Else
      Select Case Mid$(MDraw.ObjTag, 1, 1)
      Case "V"
        MDraw.ObjVisible = IsOpen
      Case "v"
        MDraw.ObjVisible = Not IsOpen
      End Select
    End If
End Sub

Sub Form_Load ()
    cenX = 0: cenY = 0
    Zoom = 0
    MDraw.ObjMove = MOVE_CONT_FIRST
    If (MDraw.Current > OBJ_NULL) Then MDraw.PicBackColor = MDraw.BackColor
End Sub

Sub Form_Resize ()
    Dim h, w As Long
    If Me.WindowState = 1 Then Exit Sub
        
    If Me.Height < 2400 Then Me.Height = 2400
    If Me.Width < 2400 Then Me.Width = 2400
    MDraw.Redraw = False
    MDraw.Top = pnlToolBar.Height
    MDraw.Height = Me.ScaleHeight - pnlInfo.Height - pnlToolBar.Height
    MDraw.Width = Me.ScaleWidth
    MDraw.Redraw = True
    AdjustView (Zoom)
End Sub

Sub Form_Unload (Cancel As Integer)
    End
End Sub

Sub MDraw_DblClick ()
    btnUp_Click
End Sub

Sub MDraw_HitObject (X As Integer, Y As Integer)
    ' "Current" property is the topmost object on which mouse was clicked
    If MDraw.ObjHotSpot And MDraw.ObjType = OT_CONTAINER And Mid$(MDraw.ObjTag, 2, 1) = "O" Then
      MDraw.ObjOpened = True
      MDraw.ObjMove = MOVE_CONT_OPENED
      ChangeSelection (False)
      MDraw.ObjMove = MOVE_CONT_OPENED
      ChangeVisible (True)
      If mnAuto.Checked Then AdjustView (0#)
    Else
      pnlInfo = Mid$(MDraw.ObjTag, 3)
    End If
End Sub

Sub MDraw_MouseDown (Button As Integer, Shift As Integer, X As Single, Y As Single)
    If Button = 2 Then RButton = True
End Sub

Sub MDraw_MouseMove (Button As Integer, Shift As Integer, X As Single, Y As Single)
    Dim crX, crY As Integer
    crX = MDraw.ClientToLogicX(X / Screen.TwipsPerPixelX)
    crY = MDraw.ClientToLogicY(Y / Screen.TwipsPerPixelY)
    If crX < MDraw.picLeft Then crX = MDraw.picLeft
    If crY < MDraw.picTop Then crY = MDraw.picTop
    If crX > MDraw.picLeft + MDraw.picWidth Then crX = MDraw.picLeft + MDraw.picWidth
    If crY > MDraw.picTop + MDraw.picHeight Then crY = MDraw.picTop + MDraw.picHeight
    pnlCoords.Caption = Format$(crX) + " : " + Format$(crY)
    RButton = False
End Sub

Sub MDraw_MouseUp (Button As Integer, Shift As Integer, X As Single, Y As Single)
    If RButton And (Button = 2) Then
      cenX = MDraw.ClientToLogicX(X / Screen.TwipsPerPixelX)
      cenY = MDraw.ClientToLogicY(Y / Screen.TwipsPerPixelY)
      If Shift <> 0 Then
        mnZoomOut_Click
      Else
        mnZoomIn_Click
      End If
    End If
End Sub

Sub MDraw_OnHotSpot (X As Integer, Y As Integer, State As Integer)
    Select Case State
    Case 0
      ChangeSelection (True)
      pnlInfo = "Click the left mouse button for view details"
    Case 1
      ChangeSelection (False)
      pnlInfo = ""
    End Select
End Sub

Sub mnAuto_Click ()
    mnAuto.Checked = Not mnAuto.Checked
End Sub

Sub mnExit_Click ()
    Unload Me
End Sub

Sub mnFitWin_Click ()
    AdjustView (0#)
End Sub

Sub mnNew_Click ()
    dlgFiles.DialogTitle = "Open Picture"
    dlgFiles.Filter = "All pictures|*.bmp;*.dib;*.wmf|Metafiles|*.wmf|Bitmaps|*.bmp;*.dib"
    dlgFiles.FilterIndex = 1
    dlgFiles.DefaultExt = "wmf"
    dlgFiles.Flags = &H1804
    dlgFiles.Filename = "*.bmp;*.dib;*.wmf"

    dlgFiles.CancelError = True
    On Error Resume Next: Err = 0
    dlgFiles.Action = 1
    If Err = 0 Then
      MDraw.Redraw = False
      MDraw.Picture = LoadPicture(dlgFiles.Filename)
      MDraw.Redraw = True
      If Err Then
        MsgBox "File [" & dlgFiles.Filename & "]: not found or bad format", 48
      Else
        cenX = 0: cenY = 0
        MDraw.ObjMove = MOVE_CONT_FIRST
        MDraw.PicBackColor = MDraw.BackColor
        AdjustView (0#)
      End If
    End If
End Sub

Sub mnZoomIn_Click ()
    AdjustView (Zoom * 2)
End Sub

Sub mnZoomOut_Click ()
    AdjustView (Zoom / 2)
End Sub

