
'[ObjType]
' Values for ObjType property (Type of the object)

Global Const OT_CONTAINER = 0   ' Container (group of objects)
Global Const OT_LINE = 1        ' Line
Global Const OT_RECTANGLE = 2   ' Rectangle
Global Const OT_ROUNDRECT = 3   ' Rounded rectangle
Global Const OT_ELLIPSE = 4     ' Ellipse (circle)
Global Const OT_ARC = 5         ' Arc
Global Const OT_PIE = 6         ' Pie (Sector)
Global Const OT_CHORD = 7       ' Chord
Global Const OT_POLYLINE = 8    ' Polyline
Global Const OT_POLYGON = 9     ' Polygon
Global Const OT_TEXT = 10       ' Text
Global Const OT_BITMAP = 11     ' Bitmap picture
Global Const OT_IMAGE = 12      ' Image saved in the PictureImage property

'[OBJ_xxxx]
' Reserved object handles (for get/set Current property)

Global Const OBJ_NULL = -1      ' Returned value if action was failed
Global Const OBJ_CONTAINER = 1  ' Apply action on the current open container
Global Const OBJ_SELECTED = 2   ' Apply action on all selected objects
Global Const OBJ_SEL_ATTR = 3   ' Apply action on all selected objects
				' or if its failed on opened container
Global Const OBJ_CURR_ATTR = 4  ' Use current attributes for get/set operations
Global Const OBJ_CURRENT = 4    ' Use 'Current' state for object
Global Const OBJ_CONT_MAIN = 5  ' Specifies the Main Container
Global Const OBJ_IMAGE = 6      ' Specifies picture in PictureImage (only for ObjCount)
Global Const OBJ_VALID = 10     ' Used to check for real object handle

'[ObjMove]
' Values for move object property (ObjMove)

Global Const MOVE_NEXT = 0          ' Move pointer "Current" to next object
Global Const MOVE_PREV = 1          ' Move pointer "Current" to previous object
Global Const MOVE_FIRST = 2         ' Move pointer "Current" to first object in container list
Global Const MOVE_LAST = 3          ' Move pointer "Current" to last object in container list
Global Const MOVE_PARENT = 4        ' Move pointer to the parent container
Global Const MOVE_CHILD_FIRST = 5   ' Move pointer to first child in container list
Global Const MOVE_CHILD_LAST = 6    ' Move pointer to first child in container list
Global Const MOVE_SEL_NEXT = 7      ' Move pointer to the next selected object
Global Const MOVE_SEL_PREV = 8      ' Move pointer to the previous selected object

Global Const MOVE_SEL_FIRST = 10    ' Move pointer to first selected object in container
Global Const MOVE_SEL_LAST = 11     ' Move pointer to first selected object in container
Global Const MOVE_CONT_OPENED = 12  ' Move pointer to the open container
Global Const MOVE_CONT_MAIN = 13    ' Move pointer to the main container
				    ' If no more specifing objects "Current" will be NULL
Global Const MOVE_CONT_FIRST = 14   ' Move pointer to first child in the open container
Global Const MOVE_CONT_LAST = 15    ' Move pointer to last child in the open container

'[Action]
' Values for object action property (Action)

Global Const ACT_GROUP = 0          ' Group selected objects in container
Global Const ACT_UNGROUP = 1        ' Ungroup container (or all selected)
Global Const ACT_SENDBACK = 2       ' Send one or more objects to the back
Global Const ACT_MOVEFRONT = 3      ' Bring one or more objets to the front
Global Const ACT_ONEDOWN = 4        ' Move object(s) before previous object
Global Const ACT_ONEUP = 5          ' Move object(s) after next object
Global Const ACT_FLIPHORZ = 6       ' Flip object(s) horizontally
Global Const ACT_FLIPVERT = 7       ' Flip object(s) vertically
Global Const ACT_ROTATELEFT = 8     ' Rotate object in a clockwise direction
Global Const ACT_ROTATERIGHT = 9    ' Rotate object by a counter clockwise direction
Global Const ACT_IMAGEINSERT = 10   ' Insert picture from PictureImage to opened container
Global Const ACT_IMAGECOPY = 11     ' Copy object(s) specified in Current to PictureImage
Global Const ACT_IMAGEPICTURE = 12  ' Create new picture from PictureImage
Global Const ACT_IMAGESWAP = 13     ' Swap main picture and PictureImage
Global Const ACT_DUPLICATE = 14     ' Duplicate objects referenced by the Current property

'[PicType]
' Values for the PicType property:
Global Const PICTYPE_NONE = 0
Global Const PICTYPE_METAFILE = 1
Global Const PICTYPE_BITMAP = 2
Global Const PICTYPE_ICON = 3
Global Const PICTYPE_PLAINWMF = 4
Global Const PICTYPE_DIB = 5

'[ScrollBars]
' Values for the ScrollBars property:

Global Const BAR_NONE = 0       ' Scrollbars disabled
Global Const BAR_AUTO = 1       ' Scrollbars are shown when scroll is possible
Global Const BAR_ALWAYS = 2     ' Scrollbars are always visible

'[AutoScale]
' Values for the AutoScale property:

Global Const SCALE_NONE = 0     ' Size is specified by picXSize, picYSize
Global Const SCALE_RESIZE = 1   ' Resize picture with window
Global Const SCALE_FIT = 2      ' Fit picture to the window
Global Const SCALE_ORIG = 3     ' Display picture with original sizes

'[EditMode]
' Values for the EditMode property

Global Const ED_VIEW = 0        ' No mouse action
Global Const ED_LINE = 1        ' Draw line
Global Const ED_RECT = 2        ' Draw rectangle
Global Const ED_ROUND = 3       ' Draw rounded rectangle
Global Const ED_ELLIPSE = 4     ' Draw ellipse
Global Const ED_ARC = 5         ' Draw arc
Global Const ED_PIE = 6         ' Draw pie
Global Const ED_CHORD = 7       ' Draw chord
Global Const ED_POLYLINE = 8    ' Draw polyline
Global Const ED_POLYGON = 9     ' Draw polygon
Global Const ED_TEXT = 10       ' Add text
Global Const ED_SELECT = 11     ' Selection mode
Global Const ED_EDIT = 11       ' Edit mode
Global Const ED_IMAGE = 12      ' Add object which is specified in
				' PictureImage property

'[MousePointer]
' Values for the MousePointer property

Global Const MPTR_DEFAULT = 0
Global Const MPTR_ARROW = 1
Global Const MPTR_CROSS = 2
Global Const MPTR_HBEAM = 3
Global Const MPTR_ICON = 4
Global Const MPTR_SIZE = 5
Global Const MPTR_SIZENESW = 6
Global Const MPTR_SIZENS = 7
Global Const MPTR_SIZENWSE = 8
Global Const MPTR_SIZEWE = 9
Global Const MPTR_UPARROW = 10
Global Const MPTR_HOURGLASS = 11
Global Const MPTR_NODROP = 12
Global Const MPTR_USER = 15
Global Const MPTR_MOVE = 16
Global Const MPTR_SCROLL = 17
Global Const MPTR_HOTSPOT = 18
Global Const MPTR_DRAWPEN = 19
Global Const MPTR_VIEW = 20
Global Const MPTR_LINE = 21
Global Const MPTR_RECT = 22
Global Const MPTR_ROUND = 23
Global Const MPTR_ELLIPSE = 24
Global Const MPTR_ARC = 25
Global Const MPTR_PIE = 26
Global Const MPTR_CHORD = 27
Global Const MPTR_POLYLINE = 28
Global Const MPTR_POLYGON = 29
Global Const MPTR_TEXT = 30
Global Const MPTR_SELECT = 31
Global Const MPTR_IMAGE = 32

'[EditFlags]
' Values for the EditFlags property (you can use OR orepation to set
' more then one flags:

Global Const EFLG_SELECT = 1    ' Mouse can select object(s)
Global Const EFLG_SELSHIFT = 2  ' Mouse can select object(s)
Global Const EFLG_SELGROUP = 4  ' Mouse can select (and enum) objects inside
				' specified rectangle
Global Const EFLG_DRAWSCEL = 8  ' Draw only object scelecton while it moving
Global Const EFLG_MOVE = &H10   ' Mouse can move object(s)
Global Const EFLG_RESIZE = &H20 ' Mouse can change size of the object(s)
Global Const EFLG_OPEN = &H40   ' Mouse can open/close container

'[EventMask]
' Values for the EventMask property
' (you can use OR orepation to set more then one flags):

Global Const EMSK_HITOBJECT = &H1       ' Invoke HitObject Event
Global Const EMSK_ONHOTSPOT = &H2       ' Invoke OnHotSpot Event

Global Const EMSK_SELECT = &H10         ' Invoke Change event when object(s)
					' selection was changed
Global Const EMSK_ADD = &H20            ' Invoke Change event when new object
					' was added
Global Const EMSK_MOVE = &H40           ' Invoke Change event when object(s)
					' was moved
Global Const EMSK_RESIZE = &H80         ' Invoke Change event when object(s)
					' was resized (move marker)
Global Const EMSK_OPEN = &H100          ' Invoke Change event when object(s) or
					' container was opened
Global Const EMSK_CHANGE = &H200        ' Object(s) have been changed
Global Const EMSK_DELETE = &H400        ' Object(s) was deleted

'[Repaint]
' Values for the Repaint property

Global Const PAINT_NORMAL = 0           ' Repaint picture as object by object
Global Const PAINT_BUFFERED = 1         ' Repaint picture using offscreen bitmap

'[OpenDraw]
' Values for the OpenDraw property

Global Const OPDR_FULL = 0              ' Draw whole picture
Global Const OPDR_CONTAINER = 1         ' Draw only opened container
Global Const OPDR_HATCHED = 2           ' Draw object lies outside opened container
					' as hatched lines
'[DropMode]
' Values for the DropMode property

Global Const FDROP_NONE = 0             ' Disable the processing of dropped files.
Global Const FDROP_FIRST = 1            ' Process only the first file in the list.
Global Const FDROP_ALL = 2              ' Process each file in the list.

'[FillStyle]
' Values for the FillStyle property

Global Const FS_SOLID = 0       ' solid
Global Const FS_TRANSPARENT = 1 ' transparent
Global Const FS_HORIZONTAL = 2  ' =====
Global Const FS_VERTICAL = 3    ' | | | | |
Global Const FS_FDIAGONAL = 4   ' \ \ \ \ \
Global Const FS_BDIAGONAL = 5   ' / / / / /
Global Const FS_CROSS = 6       ' +++++
Global Const FS_DIAGCROSS = 7   ' xxxxx
Global Const FS_PATTERN = 8     ' use bitmap pattern

'[FillStyle]
' Values for the DrawMode property

Global Const R2_BLACK = 1
Global Const R2_NOTMERGEPEN = 2
Global Const R2_MASKNOTPEN = 3
Global Const R2_NOTCOPYPEN = 4
Global Const R2_MASKPENNOT = 5
Global Const R2_NOT = 6
Global Const R2_XORPEN = 7
Global Const R2_NOTMASKPEN = 8
Global Const R2_MASKPEN = 9
Global Const R2_NOTXORPEN = 10
Global Const R2_NOP = 11
Global Const R2_MERGENOTPEN = 12
Global Const R2_COPYPEN = 13
Global Const R2_MERGEPENNOT = 14
Global Const R2_MERGEPEN = 15
Global Const R2_WHITE = 16

'[FillStyle]
' Values for the DrawMode property

Global Const PS_SOLID = 0       ' ___________
Global Const PS_DASH = 1        ' _ _ _ _ _ _
Global Const PS_DOT = 2         ' . . . . . .
Global Const PS_DASHDOT = 3     ' _ . _ . _ . _
Global Const PS_DASHDOTDOT = 4  ' _ . . _ . . _
Global Const PS_NULL = 5        ' Ignore border
Global Const PS_INSIDEFRAME = 6

'[TextHAlign]
' Values for the TextHAlign property

Global Const TXT_LEFT = 0
Global Const TXT_CENTER = 1
Global Const TXT_RIGHT = 2

'[TextVAlign]
' Values for the TextVAlign property

Global Const TXT_TOP = 0
'Global Const TXT_CENTER = 1
Global Const TXT_BOTTOM = 2

'[Change]
' ChageType parameter values in the "Change" event

Global Const CHG_NONE = 0               ' No changed performed
Global Const CHG_SELECTION = 1          ' Object(s) selection was changed
Global Const CHG_OBJECTADD = 2          ' New object(s) was added
Global Const CHG_OBJECTMOVE = 3         ' Object(s) was moved
Global Const CHG_OBJECTRESIZE = 4       ' Object was resized
Global Const CHG_OBJECTOPEN = 5         ' Object was opened or closed
Global Const CHG_OBJECTCHANGE = 6       ' Object was opened or closed
Global Const CHG_OBJECTDELETE = 7       ' Object was opened or closed

'[OnHotSpot]
' State parameter values in the "OnHotSpot" event

Global Const STATE_ENTER = 0            ' Mouse is moved upon object first time
Global Const STATE_LEAVE = 1            ' Mouse pointer leaves 'hotspot' object
Global Const STATE_DRAG = 2             ' Mouse is moving upon object

'[Export]
' State parameter values in the "Export" event

Global Const EXP_FINISH = 0             ' Finish exporting
Global Const EXP_START = 1              ' Start exporting
Global Const EXP_PROCESS = 2            ' Process exporting
Global Const EXP_SKIP = 3               ' Skip currently exported file

'[crdType]
' Values for the crdType parameter in API functions

Global Const CRD_LOGIC = 0              ' Use global logical coordinates
Global Const CRD_LOGIC_LOCAL = 2        ' All coordinates (or offsets) is specified
					' in local (container) logical units
Global Const CRD_PIXELS = 4             ' All coordinates (or offsets) is specified
					' in client pixels
Global Const CRD_ADD = &H200            ' Add new points to polyline, polygon
					' objects in MD_SetParams function
Global Const CRD_CHECK = &H200          ' Check offsets while moving object
Global Const CRD_SET = &H400            ' Set new boundaries after move object
Global Const CRD_CHANGE = &H600         ' Set new boundaries after move with
					' checking (see CRD_CHECK)
Global Const CRD_SELECTED = &H800       ' Apply action only for selected objects
Global Const CRD_VISIBLE = &H1000       ' Apply Action only for "Visible" objects
Global Const CRD_HOTSPOT = &H2000       ' Apply Action only for "HotSpot" objects
Global Const CRD_HITABLE = &H4000       ' Apply action only for "Hitable" objects

'[picType]
' Values for the picDst/picSrc parameter in LoadPicture/SavePicture functions
Global Const PIC_PICTURE = 0		' Load/Save to/from picture determined
					' by Picture property.
Global Const PIC_PICTURECLIP = 1	' Load/Save to/from picture referenced
					' by the PictureClip property.
Global Const PIC_PICTUREIMAGE = 2	' Load/Save to/from picture determined
					' by the Pictureimage property.

'[MetaDraw Type declaration]
' Declaration of the types used in functions associated with MetaDraw.VBX

Type VB_RECT
  Left As Integer
  Top As Integer
  Right As Integer
  Bottom As Integer
End Type

Type VB_POINT
  x As Integer
  y As Integer
End Type

'[MetaDraw API function]
' Declaration of the functions associated with MetaDraw.VBX

Declare Function MD_ObjectHitTest Lib "METADRAW.VBX" (MDraw As Control, ByVal posX As Integer, ByVal posY As Integer, ByVal crdType As Integer) As Integer
Declare Sub MD_MoveObjects Lib "METADRAW.VBX" (MDraw As Control, ofsX As Integer, ofsY As Integer, ByVal crdType As Integer)
Declare Sub MD_GetBounds Lib "METADRAW.VBX" (MDraw As Control, rcBounds As VB_RECT, ByVal crdType As Integer)
Declare Sub MD_SetBounds Lib "METADRAW.VBX" (MDraw As Control, rcBounds As VB_RECT, ByVal crdType As Integer)
Declare Sub MD_GetParams Lib "METADRAW.VBX" (MDraw As Control, ByVal FstPar As Integer, NumPar As Integer, Params As VB_POINT, ByVal crdType As Integer)
Declare Sub MD_SetParams Lib "METADRAW.VBX" (MDraw As Control, ByVal FstPar As Integer, ByVal NumPar As Integer, Params As VB_POINT, ByVal crdType As Integer)
Declare Sub MD_LoadPicture Lib "METADRAW.VBX" (MDraw As Control, ByVal FileName As String, ByVal picDst As Integer, ByVal picType As Integer)
Declare Sub MD_SavePicture Lib "METADRAW.VBX" (MDraw As Control, ByVal FileName As String, ByVal picSrc As Integer)
