VERSION 2.00
Begin Form frmViewer 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Picture viewer"
   ClientHeight    =   6048
   ClientLeft      =   1308
   ClientTop       =   852
   ClientWidth     =   6732
   Height          =   6816
   Left            =   1248
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   6048
   ScaleWidth      =   6732
   Top             =   144
   Width           =   6852
   Begin SSPanel Panel3D1 
      Align           =   1  'Align Top
      Caption         =   "Panel3D1"
      ForeColor       =   &H00000000&
      Height          =   6495
      Left            =   0
      TabIndex        =   0
      Top             =   0
      Width           =   6735
      Begin MetaDRAW MDraw 
         Prop110         =   VIEWER.FRX:0000
         BackColor       =   &H00808080&
         FillColor       =   &H0000FF00&
         FontName        =   "System"
         FontSize        =   0
         Height          =   3372
         Left            =   120
         LineColor       =   &H000000FF&
         LineWidth       =   0
         MouseCursor     =   VIEWER.FRX:0002
         OrigHeight      =   5760
         OrigWidth       =   5760
         picXSize        =   5760
         picYSize        =   5760
         ScrollKeyboard  =   -1  'True
         ShowInvisible   =   -1  'True
         TabIndex        =   13
         TextColor       =   &H00800000&
         Top             =   120
         Width           =   6492
      End
      Begin SSPanel pnlZoom 
         Alignment       =   1  'Left Justify - MIDDLE
         BevelOuter      =   1  'Inset
         ForeColor       =   &H00000000&
         Height          =   756
         Left            =   90
         TabIndex        =   5
         Top             =   3615
         Width           =   6540
         Begin SSOption optFit 
            Caption         =   "Fit To Window"
            Height          =   255
            Index           =   0
            Left            =   96
            TabIndex        =   8
            Top             =   96
            Value           =   -1  'True
            Width           =   1800
         End
         Begin SSOption optZoom 
            Caption         =   "&Zoom x 1"
            Height          =   255
            Left            =   96
            TabIndex        =   7
            TabStop         =   0   'False
            Top             =   384
            Width           =   1650
         End
         Begin HScrollBar scZoom 
            Enabled         =   0   'False
            Height          =   300
            LargeChange     =   10
            Left            =   1905
            Max             =   90
            Min             =   -90
            TabIndex        =   6
            Top             =   390
            Width           =   4530
         End
         Begin Label lblStrH 
            BackColor       =   &H00C0C0C0&
            Caption         =   "Height: 0"
            FontBold        =   0   'False
            FontItalic      =   0   'False
            FontName        =   "MS Sans Serif"
            FontSize        =   9.6
            FontStrikethru  =   0   'False
            FontUnderline   =   0   'False
            Height          =   300
            Left            =   5265
            TabIndex        =   12
            Top             =   60
            Width           =   1245
         End
         Begin Label lblStrW 
            BackColor       =   &H00C0C0C0&
            Caption         =   "Width: 0"
            FontBold        =   0   'False
            FontItalic      =   0   'False
            FontName        =   "MS Sans Serif"
            FontSize        =   9.6
            FontStrikethru  =   0   'False
            FontUnderline   =   0   'False
            Height          =   300
            Left            =   4050
            TabIndex        =   11
            Top             =   60
            Width           =   1395
         End
         Begin Label lblStrT 
            BackColor       =   &H00C0C0C0&
            Caption         =   "Right:0"
            FontBold        =   0   'False
            FontItalic      =   0   'False
            FontName        =   "MS Sans Serif"
            FontSize        =   9.6
            FontStrikethru  =   0   'False
            FontUnderline   =   0   'False
            Height          =   300
            Left            =   2955
            TabIndex        =   10
            Top             =   60
            Width           =   1245
         End
         Begin Label lblStrL 
            BackColor       =   &H00C0C0C0&
            Caption         =   "Left: 0"
            FontBold        =   0   'False
            FontItalic      =   0   'False
            FontName        =   "MS Sans Serif"
            FontSize        =   9.6
            FontStrikethru  =   0   'False
            FontUnderline   =   0   'False
            Height          =   300
            Left            =   1980
            TabIndex        =   9
            Top             =   60
            Width           =   1260
         End
      End
      Begin SSPanel Panel3D3 
         BevelOuter      =   1  'Inset
         ForeColor       =   &H00000000&
         Height          =   1452
         Left            =   90
         TabIndex        =   4
         Top             =   4470
         Width           =   6540
         Begin DriveListBox lstDrive 
            Height          =   300
            Left            =   96
            TabIndex        =   3
            Top             =   1056
            Width           =   2988
         End
         Begin DirListBox lstDir 
            Height          =   888
            Left            =   96
            TabIndex        =   1
            Top             =   96
            Width           =   3012
         End
         Begin FileListBox lstFile 
            Height          =   1176
            Left            =   3168
            Pattern         =   "*.wmf;*.bmp;*.dib;*.ico"
            TabIndex        =   2
            Top             =   96
            Width           =   3276
         End
      End
   End
   Begin Menu mnFile 
      Caption         =   "&File"
      Begin Menu mnInfo 
         Caption         =   "&Information..."
      End
      Begin Menu mn_N11 
         Caption         =   "-"
      End
      Begin Menu mnCheck 
         Caption         =   "&Check scrolling"
         Checked         =   -1  'True
      End
      Begin Menu mnRepaint 
         Caption         =   "&Fast looking redraw"
         Checked         =   -1  'True
      End
      Begin Menu mn_N12 
         Caption         =   "-"
      End
      Begin Menu mnExit 
         Caption         =   "E&xit"
      End
   End
End

Option Explicit

Dim Stretch As Integer
Dim Zoom As Single

Sub AdjustView ()
    Dim w, h, wd, hg As Long, Zm As Single
    
    Zm = Zoom
    MDraw.Visible = False
    w = MDraw.OrigWidth
    h = MDraw.OrigHeight
    wd = MDraw.Width - Screen.TwipsPerPixelX * 2
    hg = MDraw.Height - Screen.TwipsPerPixelY * 2
    If Stretch Then
      Zm = 1#
      If w <> wd Then
        Zm = wd / w
      End If
      If h * Zm > hg Then
        Zm = hg / h
      End If
    End If
    MDraw.picXSize = w * Zm
    MDraw.picYSize = h * Zm
    MDraw.Visible = True
    optZoom.Caption = "&Zoom x " & Format$(Zm, "0.00")
End Sub

Sub Form_Load ()
    Me.Top = Screen.Height / 2 - Me.Height / 2
    Me.Left = Screen.Width / 2 - Me.Width / 2
    Stretch = True
    Zoom = 1#
End Sub

Sub Form_Unload (Cancel As Integer)
    End
End Sub

Sub lstDir_Change ()
    lstFile.Path = lstDir.Path
End Sub

Sub lstDir_KeyPress (KeyAscii As Integer)
    If KeyAscii = 13 Then
        lstDir.Path = lstDir.List(lstDir.ListIndex)
    End If
End Sub

Sub lstDrive_Change ()
    On Error Resume Next
    lstDir.Path = lstDrive.Drive
End Sub

Sub lstDrive_KeyPress (KeyAscii As Integer)
    Select Case KeyAscii
    Case 13
      lstDrive_Change
      lstDir.SetFocus
    Case 27
      lstDrive.ListIndex = lstDrive.ListIndex
    End Select
End Sub

Sub lstFile_Click ()
    On Error Resume Next: Err = 0
    MDraw.Visible = False
    If MDraw.ScrollCheck Then
      MDraw.Picture = LoadPicture(lstFile.Path + "\" + lstFile.FileName)
    Else
      Call MD_LoadPicture(MDraw, lstFile.Path + "\" + lstFile.FileName, 0, 0)
    End If
    If Err Then
      MsgBox Error
    Else
      Me.Caption = "Picture Viewer [" + lstFile.FileName + "]"
      lblStrL = "Left: " + MDraw.picLeft
      lblStrT = "Top: " + MDraw.picTop
      lblStrW = "Width: " + MDraw.picWidth
      lblStrH = "Height: " + MDraw.picHeight
    End If
    AdjustView
End Sub

Sub mnCheck_Click ()
    MDraw.ScrollCheck = Not MDraw.ScrollCheck
    mnCheck.Checked = MDraw.ScrollCheck
End Sub

Sub mnExit_Click ()
    Unload Me
End Sub

Sub mnInfo_Click ()
    frmInfo.Show 1
End Sub

Sub mnRepaint_Click ()
    If MDraw.Repaint > 0 Then
      MDraw.Repaint = 0
    Else
      MDraw.Repaint = 1
    End If
    mnRepaint.Checked = (MDraw.Repaint = 1)
End Sub

Sub mnStretch_Click ()
    Stretch = Not Stretch
    AdjustView
End Sub

Sub optFit_Click (Index As Integer, Value As Integer)
    scZoom.Enabled = False
    Stretch = True
    AdjustView
End Sub

Sub optZoom_Click (Value As Integer)
    scZoom.Enabled = True
    Stretch = False
    AdjustView
End Sub

Sub optZoom_DblClick (Value As Integer)
    scZoom.Enabled = True
    Stretch = False
    Zoom = 1#
    scZoom.Value = 0
    AdjustView
End Sub

Sub scZoom_Change ()
    If scZoom.Value >= 0 Then
      Zoom = scZoom.Value / 10 + 1
    Else
      Zoom = 10 / (10 - scZoom.Value)
    End If
    AdjustView
End Sub

Sub scZoom_Scroll ()
    If scZoom.Value >= 0 Then
      Zoom = scZoom.Value / 10 + 1
    Else
      Zoom = 10 / (10 - scZoom.Value)
    End If
    AdjustView
End Sub

