//
// worked derived largely directly from Duffet-Smith 
// Stolen shamelessly from the "xephem" package and ported
// to Win32 by Bob Denny <rdenny@dc3.com> (18-Jul-96)
//

#ifndef PI
#define	PI		3.141592653589793
#endif

/* conversions among hours (of ra), degrees and radians. */
#define	degrad(x)	((x)*PI/180.)
#define	raddeg(x)	((x)*180./PI)
#define	hrdeg(x)	((x)*15.)
#define	deghr(x)	((x)/15.)
#define	hrrad(x)	degrad(hrdeg(x))
#define	radhr(x)	deghr(raddeg(x))

/* ratio of from synodic (solar) to sidereal (stellar) rate */
#define	SIDRATE		.9972695677

#define	SPD	(24.0*3600.0)	/* seconds per day */

/* manifest names for planets.
 * N.B. must coincide with usage in pelement.c and plans.c.
 */
#define	MERCURY			0
#define	VENUS			1
#define	MARS			2
#define	JUPITER			3
#define	SATURN			4
#define	URANUS			5
#define	NEPTUNE			6
#define	PLUTO			7
// following for INTERNAL use only, not with plans()!!!
#define	SUN				8
#define	MOON			9

/* starting point for MJD calculations
 */
#define MJD0  2415020.0				/* JD of MJD epoch */
#define J2000 (2451545.0 - MJD0)    /* JD of year 2000 */

/*
 * Date formatting preferences for fmt_mjd() and scn_date()
 */
#define	DATE_YMD		0
#define DATE_MDY		1
#define DATE_DMY		2

/*
 * Timezone name preferences for tz_name()
 */
#define DATE_UTCTZ		3
#define DATE_LOCALTZ	4

/* global function declarations */

/* aa_hadec.c */
extern void aa_hadec P_((double lat, double alt, double az, double *ha,
    double *dec));
extern void hadec_aa P_((double lat, double ha, double dec, double *alt,
    double *az));

/* aberration.c */
extern void ab_ecl P_((double mjd, double lsn, double *lam, double *bet));
extern void ab_eq P_((double mjd, double lsn, double *ra, double *dec));

/* anomaly.c */
extern void anomaly P_((double ma, double s, double *nu, double *ea));

/* comet.c */
extern void comet P_(( double mjd, double ep, double inc, double ap, double qp,
    double om, double *lpd, double *psi, double *rp, double *rho, double *lam,
    double *bet));

/* eq_ecl.c */
extern void eq_ecl P_((double mjd, double ra, double dec, double *lat,
    double *lng));
extern void ecl_eq P_((double mjd, double lat, double lng, double *ra,
    double *dec));

/* eq_gal.c */
extern void eq_gal P_((double mjd, double ra, double dec, double *lat,
    double *lng));
extern void gal_eq P_((double mjd, double lat, double lng, double *ra,
    double *dec));

/* mjd.c */
extern void cal_mjd P_((int mn, double dy, int yr, double *mjd));
extern void mjd_cal P_((double mjd, int *mn, double *dy, int *yr));
extern int mjd_dow P_((double mjd, int *dow));
extern void mjd_dpm P_((double mjd, int *ndays));
extern void mjd_year P_((double mjd, double *yr));
extern void year_mjd P_((double y, double *mjd));
extern void rnd_second P_((double *t));
extern double mjd_day P_((double jd));
extern double mjd_hr P_((double jd));
extern double mjd_2000(void);
extern void range P_((double *v, double r));

/* moon.c */
extern void moon P_((double mjd, double *lam, double *bet, double *hp,
    double *msp, double *mdp));

/* mooncolong.c */
extern void moon_colong P_((double mjd, double lt, double lg, double *cp,
    double *kp, double *ap, double *sp));

/* nutation.c */
extern void nutation P_((double mjd, double *deps, double *dpsi));
extern void nut_eq P_((double mjd, double *ra, double *dec));

/* obliq.c */
extern void obliquity P_((double mjd, double *eps));

/* parallax.c */
extern void ta_par P_((double tha, double tdec, double phi, double ht,
    double ehp, double *aha, double *adec));
extern void at_par P_((double aha, double adec, double phi, double ht, 
	double ehp, double *tha, double *tdec));

/* plans.c */
extern void plans P_((double mjd, int p, double *lpd0, double *psi0,
    double *rp0, double *rho0, double *lam, double *bet, double *dia,
    double *mag));
extern void plans_fast P_((double mjd, int p, double *lpd0, double *psi0, 
	double *rp0, double *rho0, double *lam, double *bet, double *dia, 
	double *mag));

/* precess.c */
extern void precess P_((double mjd1, double mjd2, double *ra, double *dec));
extern void precess_fast P_((double mjd1, double mjd2, double *ra, double *dec));

/* reduce.c */
extern void reduce_elements P_((double mjd0, double mjd, double inc0,
    double ap0, double om0, double *inc, double *ap, double *om));

/* refract.c */
extern void refract P_((double pr, double tr, double ta, double *aa));
void unrefract P_((double pr, double tr, double aa, double *ta));

/* riset.c */
extern void riset P_((double ra, double dec, double lat, double dis,
    double *lstr, double *lsts, double *azr, double *azs, int *status));

/* sphcart.c */
extern void sphcart P_((double l, double b, double r,
    double *x, double *y, double *z));
extern void cartsph P_((double x, double y, double z,
    double *l, double *b, double *r));

/* sphere.c */
extern void solve_sphere P_((double A, double b, double cosc, double sinc,
    double *cosap, double *Bp));
extern double delra (double dra);

/* sun.c */
extern void sunpos P_((double mjd, double *lsn, double *rsn, double *bsn));

/* time.c */
extern double now_mjd (void);
extern double now_lst (double lng);
extern double unix_mjd (unsigned long /*time_t*/ t);
extern unsigned long /*time_t*/ mjd_unix (double mjd);
extern double mjd_vb (double v);
extern double vb_mjd (double mjd);
extern int utc_offs (void);
extern void tz_name (char *buf, int tzpref);
extern void fmt_sexa (char *out, double a, int w, int fracbase);
extern void fmt_mjd (char *out, double mjd, int pref);
extern double scn_sexa (double o, char *bp);
extern void scn_date (char *bp, int *m, double *d, int *y, int pref);

/* utc_gst.c */
extern void utc_gst P_((double mjd, double utc, double *gst));
extern void gst_utc P_((double mjd, double gst, double *utc));
