// detesvw.cpp : implementation of the CDetestView class
//

#include "stdafx.h"
#include "detest.h"
#include "decenc.h"

#include "detesdoc.h"
#include "detesvw.h"
#include "dispfile.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDetestView

IMPLEMENT_DYNCREATE(CDetestView, CView)

BEGIN_MESSAGE_MAP(CDetestView, CView)
    //{{AFX_MSG_MAP(CDetestView)
    ON_COMMAND(ID_FILE_DECODE, OnFileDecode)
    ON_COMMAND(ID_FILE_ENCODEMIME, OnFileEncodemime)
    ON_COMMAND(ID_FILE_ENCODEUUENCODED, OnFileEncodeuuencoded)
    ON_COMMAND(ID_FILE_DECODE_SHOWFILENAMES, OnFileDecodeShowfilenames)
    ON_COMMAND(ID_FILE_DECODE_OVERWRITEPROMPTONLY, OnFileDecodeOverwritepromptonly)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDetestView construction/destruction

CDetestView::CDetestView()
{
    // TODO: add construction code here
}

CDetestView::~CDetestView()
{
}

/////////////////////////////////////////////////////////////////////////////
// CDetestView drawing

void CDetestView::OnDraw(CDC* )
{
    CDetestDoc* pDoc = GetDocument();
    ASSERT_VALID(pDoc);

    // TODO: add draw code for native data here
}

/////////////////////////////////////////////////////////////////////////////
// CDetestView diagnostics

#ifdef _DEBUG
void CDetestView::AssertValid() const
{
    CView::AssertValid();
}

void CDetestView::Dump(CDumpContext& dc) const
{
    CView::Dump(dc);
}

CDetestDoc* CDetestView::GetDocument() // non-debug version is inline
{
    ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CDetestDoc)));
    return (CDetestDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CDetestView message handlers

void CDetestView::OnFileDecode()
{          
    int nDecodeType;
    CString strFileIn, strFileOut, strViewer;
    CString strExeFilter = "All Files|*.*||";
    CFileDialog fileOpen(TRUE, NULL, strViewer, 
                    OFN_PATHMUSTEXIST | OFN_NOCHANGEDIR | OFN_FILEMUSTEXIST,
                    strExeFilter, this);
    CString strDir = strViewer;
    int nIndex = strDir.ReverseFind('\\');
    if (nIndex != -1)
        strDir = strDir.Left(nIndex + 1);
    fileOpen.m_ofn.lpstrInitialDir = (LPCSTR)strDir;

    if (fileOpen.DoModal() == IDOK)
    {
        strFileIn = fileOpen.GetPathName();
        nDecodeType = DecodeFile(strFileIn, strFileOut, PROMPT_ALL);
        if (nDecodeType)
        {             
            strFileOut.ReleaseBuffer();
            TRACE1("Decoded file: %s\n", strFileOut);
        }
    }
}

void CDetestView::OnFileEncodemime()
{        
    CString strFileIn, strFileOut, strViewer;
    CString strExeFilter = "All Files|*.*||";
    CFileDialog fileOpen(TRUE, NULL, strViewer, 
                    OFN_PATHMUSTEXIST | OFN_NOCHANGEDIR | OFN_FILEMUSTEXIST,
                    strExeFilter, this);
    CString strDir = strViewer;
    int nIndex = strDir.ReverseFind('\\');
    if (nIndex != -1)
        strDir = strDir.Left(nIndex + 1);
    fileOpen.m_ofn.lpstrInitialDir = (LPCSTR)strDir;

    if (fileOpen.DoModal() == IDOK)
    {
		SetEncodingApplication(AfxGetAppName());
        strFileOut = strFileIn = fileOpen.GetPathName();
        int nIndex = strFileOut.ReverseFind('.');
        if (nIndex != -1)
            strFileOut = strFileOut.Left(nIndex);
        strFileOut += ".MIM";
        if (EncodeFile(strFileIn, strFileOut, B64_TYPE, FALSE))
        {
            TRACE1("Encoded file: %s\n", strFileOut);
        }
    }
}

void CDetestView::OnFileEncodeuuencoded()
{
    CString strFileIn, strFileOut, strViewer;
    CString strExeFilter = "All Files|*.*||";
    CFileDialog fileOpen(TRUE, NULL, strViewer, 
                    OFN_PATHMUSTEXIST | OFN_NOCHANGEDIR | OFN_FILEMUSTEXIST,
                    strExeFilter, this);
    CString strDir = strViewer;
    int nIndex = strDir.ReverseFind('\\');
    if (nIndex != -1)
        strDir = strDir.Left(nIndex + 1);
    fileOpen.m_ofn.lpstrInitialDir = (LPCSTR)strDir;

    if (fileOpen.DoModal() == IDOK)
    {
        strFileOut = strFileIn = fileOpen.GetPathName();
        int nIndex = strFileOut.ReverseFind('.');
        if (nIndex != -1)
            strFileOut = strFileOut.Left(nIndex);
        strFileOut += ".UUE";
        if (EncodeFile(strFileIn, strFileOut, UUE_TYPE, FALSE))
        {
            TRACE1("Encoded file: %s\n", strFileOut);
        }
    }
}

void CDetestView::OnFileDecodeShowfilenames()
{
    CString strFileIn, strFileOut, strViewer;
    CString strExeFilter = "All Files|*.*||";
    CFileDialog fileOpen(TRUE, NULL, strViewer, 
                    OFN_PATHMUSTEXIST | OFN_NOCHANGEDIR | OFN_FILEMUSTEXIST,
                    strExeFilter, this);
    CString strDir = strViewer;
    int nIndex = strDir.ReverseFind('\\');
    if (nIndex != -1)
        strDir = strDir.Left(nIndex + 1);
    fileOpen.m_ofn.lpstrInitialDir = (LPCSTR)strDir;

    if (fileOpen.DoModal() == IDOK)
    {
        strFileIn = fileOpen.GetPathName();
        CDispFilesDlg dlg(strFileIn, this);
        dlg.DoModal();
    }
}

void CDetestView::OnFileDecodeOverwritepromptonly()
{
    int nDecodeType;
    CString strFileIn, strFileOut, strViewer;
    CString strExeFilter = "All Files|*.*||";
    CFileDialog fileOpen(TRUE, NULL, strViewer, 
                    OFN_PATHMUSTEXIST | OFN_NOCHANGEDIR | OFN_FILEMUSTEXIST,
                    strExeFilter, this);
    CString strDir = strViewer;
    int nIndex = strDir.ReverseFind('\\');
    if (nIndex != -1)
        strDir = strDir.Left(nIndex + 1);
    fileOpen.m_ofn.lpstrInitialDir = (LPCSTR)strDir;

    if (fileOpen.DoModal() == IDOK)
    {
        strFileIn = fileOpen.GetPathName();
        nDecodeType = DecodeFile(strFileIn, strFileOut, PROMPT_OVERWRITE);
        if (nDecodeType)
        {             
            strFileOut.ReleaseBuffer();
            TRACE1("Decoded file: %s\n", strFileOut);
        }
    }
}
