' BalloonHelp demo for VB 3.0:
'    Erik Baas (not the poet...).
'
'
' Golfiery/Ballunatic: Copyright (C) 1995 by Alfons Hoogervorst



Type Rect
 Left As Integer
 Top As Integer
 Right As Integer
 Bottom As Integer
End Type

Type PointApi
 x As Integer
 y As Integer
End Type

'*** Gets the window bounds (in screen coords) ***
Declare Sub GetWindowRect Lib "User" (ByVal hWnd As Integer, LPRECT As Rect)
Declare Sub GetClientRect Lib "User" (ByVal hWnd As Integer, LPRECT As Rect)
Declare Sub ClientToScreen Lib "User" (ByVal hWnd As Integer, lpPoint As PointApi)


'***************************************************************
'****************** The Golfiery functions *********************
'***************************************************************

' Tooltips like functions
Declare Sub FlyByHint Lib "golfiery.dll" (ByVal hwndFrame%, rcArea As Rect, ByVal szString$)
Declare Sub FlyByHintFromWindow Lib "golfiery.dll" (ByVal hwndFrame%, ByVal hwndArea%, ByVal szString$)
Declare Sub VBFlyByHint Lib "golfiery.dll" (ByVal hwndFrame%, VBObject As Any, ByVal szString$)


' ****** BalloonHelp ******

' *** Styles for the xxxBalloonHelpEx functions: BLNS_xxx
Global Const BLNS_DEFAULT = 0      ' Let the balloon do the calcs
Global Const BLNS_LEFTTOP = 1      ' Rest should be obvious
Global Const BLNS_RIGHTTOP = 2
Global Const BLNS_RIGHTBOTTOM = 3
Global Const BLNS_LEFTBOTTOM = 4

' *** Draws thin border
Global Const BLNS_THINBORDER = &H10

' *** Use the BLNS_BALLOONATPOINT style with the BalloonHelpEx procedure only!
' If you use this style golfiery will neglect the rcArea.right and rcArea.bottom parameters
' and places the tag at (rcArea.left, rcArea.top)
Global Const BLNS_BALLOONATPOINT = &H20

Global Const BLNS_NOTAG = &H40


Declare Sub BalloonHelp Lib "golfiery.dll" (ByVal hwndFrame%, rcArea As Rect, ByVal szTitle$, ByVal szText$)
Declare Sub BalloonHelpEx Lib "golfiery.dll" (ByVal hwndFrame%, rcArea As Rect, ByVal szTitle$, ByVal szText$, ByVal wStyle%)
Declare Sub BalloonHelpFromWindow Lib "golfiery.dll" (ByVal hwndFrame%, ByVal hWndInfoAbout%, ByVal szTitle$, ByVal szText$)

' Special functions for Visual Basic
Declare Sub VBBalloonHelp Lib "golfiery.dll" (ByVal hwndFrame%, VBObject As Any, ByVal szTitle$, ByVal szText$)
Declare Sub VBBalloonHelpEx Lib "golfiery.dll" (ByVal hwndFrame%, VBObject As Any, ByVal szTitle$, ByVal szText$, ByVal wStyle%)

Function BorderWidth% (F As Form) ' EJB, 220295
 Dim w As Rect, C As Rect
 GetWindowRect F.hWnd, w
 GetClientRect F.hWnd, C
 BorderWidth = (w.Right - w.Left - C.Right) / 2
End Function

Function CaptionHeight% (F As Form) ' EJB, 220295
 Dim w As Rect, C As Rect
 GetWindowRect F.hWnd, w
 GetClientRect F.hWnd, C
 CaptionHeight = w.Bottom - w.Top - C.Bottom - 2 * BorderWidth(F)
End Function

Sub CenterOnScreen (F As Form)
 ' --- Centers form on screen ---
 F.Move (Screen.Width - F.Width) \ 2, (Screen.Height - F.Height) \ 2
End Sub

Sub GetControlRect (C As Control, P As Rect) ' EJB, 230295.
 ' Screen coords of C to P (pixels !)
 '
 ' C.Parent.ScaleMode should be 3 ! :
 If C.Parent.ScaleMode <> 3 Then
  Beep
  MsgBox "Error: C.Parent.ScaleMode <> 3 !!"
  Stop
 End If
 ' A lot of work...
 P.Left = C.Parent.Left / Screen.TwipsPerPixelX + C.Left + BorderWidth(C.Parent)
 P.Right = P.Left + C.Width
 P.Top = C.Parent.Top / Screen.TwipsPerPixelY + C.Top + CaptionHeight(C.Parent) + BorderWidth(C.Parent)
 P.Bottom = P.Top + C.Height
End Sub

