#ifdef __sdlfxcvsdkl__
/*** golfiery.h ***
   Header file for golfiery.dll.

   Written by Alfons Hoogervorst
   Produced by The Programming with Puns Facility

   Alfons Hoogervorst can be reached at:

   fidonet:  <2:500/121>
   internet: <a.hoogervorst@dosgg.nl> (E-mail)

Special shoutouts:
   Arthur Hoogervorst    - Bughunter #1
   Erik Baas             - VB Proof Reader
   Fabio Cereda Cordeiro - Brazilian connection
   Rob de Voer           - Ex-sysop DOSBoss West "The C Programmers Board"
   Alex Stienstra        - Sysop DOSBoss West

DOSBoss West:

Lines 1 & 2 are open 24 hours a day for all types of activity, incl. Freqs.
            line 1:   020-6124530, 14.400Baud
            line 2:   020-6123040, 14.400Baud
Line 3  is open 24 hours a day for Mail and 16 hours a day for Freqs
        and BBS usage, from 08:00-24:00 (CET).
            line 3:   020-6891854, 28.800Baud

Copyright notice:
The author nor any of the above (or in the software) mentioned persons or
companies make NO WARRANTY, either express or implied, regarding the
quality or fitness of this software for a particular purpose. This software
is provided on an "AS IS" basis, it's the user who assumes the entire risk as
to its quality and fitness.

This software is copyright (C) 1995 Alfons Hoogervorst

Permission is hereby granted to use, copy, modify, and distribute this
software (or portions thereof) for any purpose, *without fee*, subject to
these conditions:

1. If any part of the source code for this software is distributed, then this
file must be included, with this copyright and no-warranty notice unaltered;
and any additions, deletions, or *changes* to the original files must be
clearly indicated in accompanying documentation.

2. Permission for use of this software is granted only if the user accepts
full responsibility for any undesirable consequences; the author nor any of
the aforementioned persons or companies can be held responsible or liable for
damages of any kind resulting from incorrect/improper working of the descibed
software.

The author specifically permits and encourages the use of this software in
commercial products, provided that all warranty or liability claims are
assumed by the product vendor.
*******************/
#endif

#ifndef __golfiery_h
#define __golfiery_h

/*** For programmers who want to superclass the FlyByHints ***/
#define FLYBYHINTCLASSNAME "Ahii_FlyByToolTip"

/*** Classname of the balloon help window class ***/
#define BALLOONCLASSNAME      "Ahii_Balloon"

/*** This define is for the long time ballunatic fans ***/
#define OLDBALLOONCLASSNAME   "Ahii_Ballunatic"

/*** Styles ***/
#define BLNS_DEFAULT          (0)      /*** Let the balloon do the calcs ***/
#define BLNS_LEFTTOP          (1)      /*** Rest should be obvious       ***/
#define BLNS_RIGHTTOP         (2)
#define BLNS_RIGHTBOTTOM      (3)
#define BLNS_LEFTBOTTOM       (4)
#define BLNS_TAGPOSITION      (0x07)

#define BLNS_THINBORDER       (0x010)  /*** Does not draw anti alias border ***/
#define BLNS_BALLOONATPOINT   (0x020)
#define BLNS_NOTAG            (0x040)

/*** These messaged don't work like their WM_GETFONT/WM_SETFONT
     counterparts. They should be intercepted by a superclass ***/

// Undefined in v. 1.2. Always route to old window procedure
#define BLNM_SETTITLEFONT     (WM_USER + 0)

// Defined
#define BLNM_GETTITLEFONT     (WM_USER + 1)

// Undefined in v. 1.2. Always route to old window procedure
#define BLNM_SETTEXTFONT      (WM_USER + 2)

// Defined
#define BLNM_GETTEXTFONT      (WM_USER + 3)

/*** Use these messages with superclassing only ***/
#define BLNM_SETBALLOONDIM    (WM_USER + 4)
#define BLNM_GETBALLOONDIM    (WM_USER + 5)

/*** Send with WM_CTLCOLOR message. Intercept WM_CTLCOLOR to modify
     the dc before drawing takes place ***/
#define CTLCOLOR_TITLEFONT    (50)
#define CTLCOLOR_TEXTFONT     (CTLCOLOR_TITLEFONT + 1)

#ifdef __cplusplus
extern "C" {
#endif


/*** A structure used by BLNM_SETBALLOONDIM & BLNM_GETBALLOONDIM
     After calculating the correct balloon dimensions, the balloon
     window sends the BLNM_SETBALLOONDIM to itself. Upon receiving
     this message the balloon saves the balloondim structure in a
     locally allocated data structure. If you need to customize
     the balloon dimensions, intercept BLNM_SETBALLOONDIM,
     change the *((LPBALLOONDIM)lParam) structure and pass the
     message to the old balloon class function.

     This structure is also used in the informational BLNM_GETBALLOONDIM
     message. The IntBalloonHelpEngine (internal function) uses this
     message to position and redimension the balloon before displaying
     the balloon with ShowWindow/UpdateWindow.
***/
#pragma pack(1)
typedef struct {
   int   nX;               /*** position and dimension ***/
   int   nY;
   int   nCx;
   int   nCy;
   int   nTextWidth;       /*** width of text body ***/
   int   nTextHeight;      /*** height of text body ***/
   int   nSeparator;       /*** distance between text and title ***/
   int   nTitleHeight;     /*** height of title ***/
   int   nRRWidth;         /*** Rectangle rounded corners based on used fonts ***/
   int   nRRHeight;
} BLNDIM, FAR* LPBLNDIM, NEAR* NPBLNDIM, * PBLNDIM;
#pragma pack()


/*** FlyByHint ("ToolTip") functions ***/

BOOL WINAPI FlyByHint (HWND, LPRECT, LPCSTR);
BOOL WINAPI FlyByHintFromWindow (HWND, HWND, LPCSTR);
BOOL WINAPI FlyByHintFromClass (HINSTANCE, LPCSTR, HWND, LPRECT, LPCSTR);


/*** BalloonHelp functions ***/

BOOL WINAPI BalloonHelp (HWND, LPRECT, LPCSTR, LPCSTR);
BOOL WINAPI BalloonHelpEx (HWND, LPRECT, LPCSTR, LPCSTR, WORD);
BOOL WINAPI BalloonHelpFromWindow (HWND, HWND, LPCSTR, LPCSTR);
BOOL WINAPI BalloonHelpFromClass (HINSTANCE, LPCSTR, HWND, LPRECT, LPCSTR, LPCSTR, WORD);
#ifdef __cplusplus
}
#endif


#endif /*** !__golfiery_h ***/