// maclib.h
// fichier d'en-tte de maclib.dll
// header file for maclib.dll
// (c) Pierre DUHEM 1995-96 - Reproduction interdite - All rights reserved

/*	MacLIB, bibliothque de lecture/criture/formatage de supports Macintosh,
	peut tre utilise librement par les utilisateurs licencis pour la cration
	d'applications traitant les donnes sur des volumes Macintosh (programmes de
	retouche d'image, programmes de traitement en amont d'un RIP de flashage, etc.),
     mais non pas de programmes gnriques de transfert de donnes entre Macintosh
     et PC (utilitaires gnriques de lecture/criture/formatage de supports
     magntiques Macintosh), dont nous nous rservons l'exclusivit.
	L'acquisition de la licence de la bibliothque est rpute constituer
	une acceptation de ces conditions.
	*/

/*	MacLIB, dynamic library for reading/writing/formatting Macintosh volumes,
	can be freely used by registered users to program specific applications
	like image processing, processing data sent to RIPs (flashing), and so on.
	We explicitely reserve the exclusivity for the general purpose Macintosh-PC
	file transfer utilities. Therefore, you may not use this library to program
	and distribute such general purpose utilities.
	Buying the licence of the library is an explicit acknomlegment of this
	condition.
	*/

     
#ifdef FLAT
	#if !defined (_MACLIB_)
		#define MACLIB __declspec(dllimport)
	#else
		#define MACLIB __declspec(dllexport)
	#endif
#else
	#if !defined (_MACLIB_)
		#define MACLIB
	#else
		#define MACLIB __export
	#endif
#endif

/*	Le prsent fichier d'en-tte doit tre inclus dans les modules de votre
	programme qui utilisent les fonctions dclares ci-dessous. Vous ne devez
	 pas dclarer _MACLIB_. De cette manire, vous obtenez des dclarations de
	 fonction qui s'importent correctement.
	 */

/*	This header file should be included in your code files using the functions
	declared below. You should not declare _MACLIB_. This way, the declarations
	 below become imported functions.
	 */

#define ulong unsigned long
#ifdef FLAT
	#define uint  unsigned short
#else
	#define uint  unsigned int
#endif

typedef struct {
	int num;				// Numro du fichier/file number
	ulong dpos;			// Pointeur l/e branche de donnes/Data fork r/w pointer
	ulong rpos;			// Pointeur l/e branche de ressources/Resource fork r/w pointer
	char rf[128];			// Buffer holding a file structure
	} MAC_FILE;			// Tampon contenant une structure de gestion de fichiers


typedef struct tagMOFN { 			// Structure envoye  la bote de slection d'un fichier Macintosh
								// Struct sent to the dialog to open a Macintosh file
	DWORD         lStructSize;		// Taille de la struct/Size of struc
	HWND          hwndOwner;			// Fentre d'appel/Calling windows
	HINSTANCE     hInstance;			// Instance d'appel/Calling Instance
	LPSTR         lpstrFilter; 		// Pointeur sur double tableau de chanes de signatures
								// comme "Word Macintosh/MSWDWDBN"
								// Ignor pour le moment
								// Pointer to a double string table storing the signatures
								// Ignored for the time being
	LPSTR         lpstrCustomFilter;	// Rserv/Reserved
	DWORD         nMaxCustFilter;		// Ignor/Ignored
	DWORD         nFilterIndex;		// Ignor/Ignored
	LPSTR         lpstrFile;			// Chane d'initialisation du masque de slection
								// String to init the selection mask
	DWORD         nMaxFile;			// Longueur du tampon ci-dessus
								// Length of the buffer pointed to by lpstrfFile
	LPSTR         lpstrFileTitle;		// Tampon o placer le nom du fichier en retour
								// Buffer to put the returned filename
	DWORD         nMaxFileTitle;		// Longueur du tampon ci-dessus
								// Length of the buffer to put the filename
	LPSTR         lpstrInitialDir;		// Toujours ignor (toujours rpertoire courant)
								// Always ignored (always works from the current dir)
	LPSTR         lpstrTitle;			// Chane  afficher comme titre de la bote de dialogue
								// String to display as title (Open File as default)
/*	Pour permettre un affichage multilingue sans trop de problmes, nous analysons ce
	pointeur comme un pointeur sur un tableau de chanes C bornes par des zros, la
	dernire chane tant borne par un double zro.
	To allow a multilingual dialog box, we look to this pointer as a pointer to an array
	of C strings, the last being terminated with two zeros.
	*/
// Partie ignore dans la version 1/Ignored in release 1
//    DWORD         Flags;			// Toujours ignor/Always ignored
//    WORD          nFileOffset;		// Toujours ignor/Always ignored
//    WORD          nFileExtension;	// Toujours ignor/Always ignored
//    LPSTR         lpstrDefExt; 		// Toujours ignor/Always ignored
//    DWORD         lCustData;		// Toujours ignor/Always ignored
//    LPOFNHOOKPROC lpfnHook;			// Ignor (version 1)/Ignored (release 1)
//    LPSTR         lpTemplateName; 	// Toujours ignor/Always ignored
} MACOPENFILENAME;


#if !defined (DEF_RUBMAC)
#define DEF_RUBMAC
typedef struct {		// Structure de gestion des donnes des fichiers
	char	sel;			// Bascule de slection
	char type;		// 2 pour les fichiers, 1 pour les rpertoires
	char nom[33];		// 32 octets utiles, + 1 pour le 0
	char lgd[9];		// Longueur des donnes (maxi 4 Go = 4000000k)
	char lgr[9];		// Longueur des ressources
	char creat[9];		// Chane de crateur + type, + 1 pour le 0
	char datec[15];	// Date de cration et de dernire modif
	char datem[15];	// 14 octets utiles, + 1 pour le 0
	} RUBMAC;
#endif

/*	Reste  faire/Remains to code
	mac_rename
	mac_rendir
	*/

// Prototypes
int		far MACLIB mac_aspi_host (void);
int		far MACLIB mac_aspi_hostinquiry (char *t);
int		far MACLIB mac_aspi_inquiry (int host, int drive, char *t);
int		far MACLIB mac_aspi_lock (int host, int drive, int code);
int		far MACLIB mac_aspi_readcap (int host, int drive, char *t);
int		far MACLIB mac_chdir (char *p);
void		far MACLIB mac_cnv2Ansi (char *d, char *s);
void		far MACLIB mac_cnv2Ascii (char *d, char *s);
void		far MACLIB mac_cnvAnsi (char *d, char *s);
void		far MACLIB mac_cnvAscii (char *d, char *s);
int		far MACLIB mac_fclose (MAC_FILE *mfp);
int 		far MACLIB mac_feof (MAC_FILE *mfp);
int		far MACLIB mac_feof_res (MAC_FILE *mfp);
int 		far MACLIB mac_fexist (char *n);
ulong	far MACLIB mac_filelength (MAC_FILE *mfp);
ulong	far MACLIB mac_filelength_res (MAC_FILE *mfp);
int		far MACLIB mac_flength (char *fn, char *s);
int		far MACLIB mac_flength_res (char *fn, char *s);
int		far MACLIB mac_findfirst (RUBMAC *p, int code);
int		far MACLIB mac_findnext (void);
int		far MACLIB mac_format_volume(char *p, char *label);
MAC_FILE*	far MACLIB mac_fopen (char *fnom, const char *mode);
ulong	far MACLIB mac_fread (void *t, uint nb, uint sz, MAC_FILE *mfp);
ulong	far MACLIB mac_fread_res (void *t, uint nb, uint sz, MAC_FILE *mfp);
int		far MACLIB mac_fseek (MAC_FILE *mfp, long pos, int whence);
int		far MACLIB mac_fseek_res (MAC_FILE *mfp, long pos, int whence);
long 	far MACLIB mac_ftell (MAC_FILE *mfp);
long 	far MACLIB mac_ftell_res (MAC_FILE *mfp);
int		far MACLIB mac_fwrite (void *t, uint nb, uint sz, MAC_FILE *mfp);
int		far MACLIB mac_fwrite_res (void *t, uint nb, uint sz, MAC_FILE *mfp);
int		far MACLIB mac_getcdrom (char *);
int		far MACLIB mac_getdir (char *p);
int		far MACLIB mac_getdrive (char *p);
int 		far MACLIB mac_getfsignature (MAC_FILE *mfp, char *p);
int 		far MACLIB mac_getftime (MAC_FILE *mfp, struct ftime *ftimep);
int		far MACLIB mac_getnbpartition (char *p);
ulong	far MACLIB mac_getpartition (char *p, int n);
ulong	far MACLIB mac_getvolcap (void);
ulong	far MACLIB mac_getvolfree (void);
int		far MACLIB mac_mkdir (char *p);
int		far MACLIB mac_open_volume (char *p);
int		far MACLIB mac_rename (char *fnold, char *fnnew);
int		far MACLIB mac_rewind (MAC_FILE *mfp);
int		far MACLIB mac_rewind_res (MAC_FILE *mfp);
int		far MACLIB mac_rmdir (char *rn);
int 		far MACLIB mac_setfsignature (MAC_FILE *mfp, char *p);
int 		far MACLIB mac_setftime (MAC_FILE *mfp, struct ftime *ftimep);
int		far MACLIB mac_swap_int (int i);
long		far MACLIB mac_swap_long (long l);
int		far MACLIB mac_unlink (char *fn);
int		far MACLIB maclib_close (void);
int		far MACLIB maclib_open (void);
// interface de type "botes de dialogue communes"
// Common dialog interface
int 		far MACLIB mac_comdlg_openfile (MACOPENFILENAME *);
int 		far MACLIB mac_comdlg_aspiscan (int type, char *, HWND parent);
#ifndef FLAT
	int 	far MACLIB mac_comdlg_mscdexscan (char *, HWND parent);
#endif
// Prototypes


// Variables globales/Global variables
// Fin des variables/End of global variables


/*	Dans une application traitant des CD-ROM, il est possible de brancher
	entre le code spcifique MS-DOS et le code spcifique Macintosh en
	utilisant la fonction 0x15 de l'interruption 0x2F.

	***** Sous-fonction 02		Lecture du fichier de rserve des droits
	Appel
	AX		1502
	ES:BX	Pointeur sur tampon (512 octets conviennent)
	CX		Numro du lecteur (A = 0, etc.)
	Retour
	CF		Arm si le lecteur n'est pas un CD-ROM
	AX		000F si mme condition
	CF		Dsarm si OK
	Dans le cas d'un disque Mac, la fonction retourne un tampon vide.
	(Fichier non trouv)

	Le retour d'une chane non vide indique un CD-ROM ISO 9600 ou High
	Sierra, le retour d'une chane vide indique un CD-ROM Macintosh
	(pour simplifier).
	*/

/*	In a program which manages both types of CD-ROMs (ISO 9660 and HFS
	from the Macintosh), it is possible to make a distinction between to
	types, to branch on the corresponding code, with an interrupt.
	interrupt 0x2F
	Function 	0x15
	Sub-function 2
	Call :
	AX		1502
	ES:BX	Address of a buffer to get the string (512 bytes is fine)
	CX		Drive's id (A = 0, etc.)
	Return :
	CF set and AX = 000FD if the drive is not a CD-ROM drive
	CF reset if a CD-ROM.
	On an ISO 9660 drive, the buffer holds a string. On a Macintosh
	CD-ROM, the function returns an empty array. In this case, branch
	to the Mac code.
	*/

//************************* fin de maclib.h *******************************
