// mccomdlg.c
// (c) Pierre Duhem 1996
// Module de botes de dialogue communes pour MacLib
// Module of common dialogs for MacLib

#define STRICT
#include <windows.h>

#include <io.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "\io\io.h"
#include "\io\iobcb.h"
//#include "\io\ioaspi.h"
#include "\io\iodisk.h"
//#include "\io\iodpmi.h"
#include "\io\iostring.h"
#ifdef FLAT
	#include "\io\ioaspi32.h"
	#include "\io\iocdrm32.h"
#else
	#include "\io\ioaspi16.h"
	#include "\io\iocdrom.h"
#endif
#include "mddisk.h"
#include "maclib.h"
#include "mccomdid.h"

// Prototypes locaux
BOOL CALLBACK MACCDOPENPROC (HWND, WORD, WPARAM, LPARAM);
BOOL CALLBACK MACCDASPIPROC (HWND, WORD, WPARAM, LPARAM);
#ifndef FLAT
	BOOL CALLBACK MACCDMSCDEXPROC (HWND, WORD, WPARAM, LPARAM);
#endif
static void near mac_dlgdirlist (HWND hDlg, int idliste, int idfname, int idfsize);
static int near affichage_perif (HWND hDlg, int nb_cartes, int carte, TABLE_LECTEURS *table);
// Fin des prototypes locaux

int MCD_result;

#pragma argsused
BOOL CALLBACK MACCDOPENPROC (HWND hDlg, WORD wMess, WPARAM wParam, LPARAM lParam)
/*	Fonction de gestion de la bote de dialogue commune pour l'ouverture d'un
	fichier sur un volume Macintosh.
	Function managing the common dialog box to open a Macintosh file.
	*/
{
static MACOPENFILENAME *mofn;
char *ptr;
int i;
ulong lgf, lgo;
char ligne[128];
char chne[40];

switch (wMess) {
	case WM_INITDIALOG :
		mofn = (MACOPENFILENAME*) lParam;	// Sauvegarde du pointeur/Saving ptr
		ptr = mofn->lpstrFile;			// Chane de slection/Selection mask
		SetDlgItemText (hDlg, ID_TYPE, ptr);
		lgo = mac_getvolcap ();			// Capacit totale/Total capacity
		lgf = mac_getvolfree ();			// Capacit libre/Free capacity
		ltoa (lgf, ligne, 10);
		SetDlgItemText (hDlg, ID_KBFREE, ligne);
		lgo -= lgf;
		ltoa (lgo, ligne, 10);
		SetDlgItemText (hDlg, ID_KBBUSY, ligne);
		ptr = mofn->lpstrTitle;			// Chanes d'affichage/Display strings
		mac_getdrive (chne);  			// Label du volume/Volume's label
		strcpy (ligne, ptr);			// Premire partie/First part
		strcat (ligne, " [");
		strcat (ligne, chne);
		strcat (ligne, "]");
		SetWindowText (hDlg, ligne);		// Titre de la fentre/Window title
		SetDlgItemText (hDlg, ID_CURRENT, chne);
		for (i = ID_CURTXT; i <= ID_HELP; i++) {
			ptr = strchr (ptr, 0);		// Recherche du zro/Looking for nul
			if (!ptr)					// Echec = fin /Failure = end
				break;
			ptr++;					// On avance/stepping forward
			SetDlgItemText (hDlg, i, ptr);
			}
		mac_dlgdirlist (hDlg, ID_LISTE, ID_NAME, ID_FSIZE);
		EnableWindow (GetDlgItem (hDlg, ID_HELP), FALSE);
		return (TRUE);
	case WM_COMMAND :
		#ifdef FLAT
		switch (LOWORD(wParam)) {
		#else
		switch (wParam) {
		#endif
			case ID_LISTE :
				#ifdef FLAT
				i = HIWORD (wParam);
				#else
				i = HIWORD(lParam);
				#endif
				if (i == LBN_SELCHANGE) {
					// Il faut retrouver le fichier et dterminer sa longueur pour renseigner les
					// deux zones d'dition du bas de la bote.
					// We have to get the file's name and length to put this data in the two
					// lower edits of the dialog box.
					lgf = SendDlgItemMessage (hDlg, ID_LISTE, LB_GETCURSEL, 0, 0L);				// Index du fichier/File index
					SendDlgItemMessage (hDlg, ID_LISTE, LB_GETTEXT, (WPARAM) lgf, (LPARAM) ligne);	// Extraction du nom/File name
					if (ligne[1] == 0x46) {		// F = Fichier/file
						SetDlgItemText (hDlg, ID_NAME, &ligne[4]);
						i = mac_flength (&ligne[4], chne);
						if (!i) {
							ptr = chne;
							while (*ptr == 0x20) ptr++;				// Supprimons les espaces
							SetDlgItemText (hDlg, ID_FSIZE, ptr);	// Affichage/Display
							}
						}
					}
				if (i == LBN_DBLCLK) {
					// Le double clic est destin  ouvrir un sous-rpertoire.
					// Double-clic to open a subdirectory.
					lgf = SendDlgItemMessage (hDlg, ID_LISTE, LB_GETCURSEL, 0, 0L);				// Index du fichier/File index
					SendDlgItemMessage (hDlg, ID_LISTE, LB_GETTEXT, (WPARAM) lgf, (LPARAM) ligne);	// Extraction du nom/File name
					if (ligne[1] == 0x44) {		// D = Directory
						SetDlgItemText (hDlg, ID_CURRENT, &ligne[4]);
						i = mac_chdir (&ligne[4]);
						if (!i)
							mac_dlgdirlist (hDlg, ID_LISTE, ID_NAME, ID_FSIZE);
						}
					}
				return (TRUE);
			case ID_HELP :
				// WinHelp (hDlg, nom_faide, HELP_KEY, (DWORD) (LPSTR) str_Informations);
				return (TRUE);
			case ID_OK :
				lgf = SendDlgItemMessage (hDlg, ID_LISTE, LB_GETCURSEL, 0, 0L);				// Index du fichier/File index
				SendDlgItemMessage (hDlg, ID_LISTE, LB_GETTEXT, (WPARAM) lgf, (LPARAM) ligne);	// Extraction du nom/File name
				strcpy (mofn->lpstrFileTitle, &ligne[4]);
                    MCD_result = 1;
				EndDialog (hDlg, 1);
				return (TRUE);
			case ID_CANCEL :
               	MCD_result = 0;
				EndDialog (hDlg, FALSE);
				return (TRUE);
			case ID_ROOT :
				mac_chdir ("\\");
				mac_dlgdirlist (hDlg, ID_LISTE, ID_NAME, ID_FSIZE);
				mac_getdrive (chne);  			// Label du volume/Volume's label
				SetDlgItemText (hDlg, ID_CURRENT, chne);
				return (TRUE);
			case ID_PARENT :
				mac_chdir ("..");
				mac_dlgdirlist (hDlg, ID_LISTE, ID_NAME, ID_FSIZE);
				mac_getdir (chne);  			// Nom du rper/Dir's name
				SetDlgItemText (hDlg, ID_CURRENT, chne);
				return (TRUE);
			}	// fin du switch sur le paramtre
		return (FALSE);
	case WM_SYSCOMMAND :
		switch(wParam & 0xFFF0) {
			case SC_CLOSE :
				EndDialog(hDlg, FALSE);
				return (TRUE);
			}
		break;
	}
return (FALSE);
}	// fin de MACCDOPENPROC


static void near mac_dlgdirlist (HWND hDlg, int idliste, int idfname, int idfsize)
{
int done;
RUBMAC rubmac;
char ligne[128];

SendDlgItemMessage (hDlg, idliste, LB_RESETCONTENT, 0, 0L); 		// Nettoyage
strcpy (rubmac.nom, "*");			// Pas de slection/no selection
done = mac_findfirst (&rubmac, -1); 	// -1 = Tout/everything
while (!done) {
	// On diffrencie suivant qu'il s'agit de rpertoires ou de fichiers
	if (rubmac.type == 1) 			// Rpertoires/Directories
		strcpy (ligne, "[D] ");
	else                        		// Fichiers/files
		strcpy (ligne, "[F] ");
	strcat (ligne, rubmac.nom);
	SendDlgItemMessage (hDlg, idliste, LB_ADDSTRING, 0, (LPARAM) (LPCSTR) ligne);
	done = mac_findnext ();			// Suivant/Next one
	}
SetDlgItemText (hDlg, idfname, "");
SetDlgItemInt (hDlg, idfsize, 0, FALSE);
}	// fin de mac_dlgdirlist


static int near affichage_perif (HWND hDlg, int nb_cartes, int carte, TABLE_LECTEURS *table)
/*	Fonction dont le rle est d'afficher le contenu de la table, qui a t
	renseigne par liste_perif. La fonction balaie la table. Si rien n'est
	trouv pour une carte, on passe automatiquement  la suivante. S'il n'y
	a pas de suivante, on affiche une table vide.
     La fonction gre totalement les deux boutons "Carte suivante" et "Carte
     prcdente".
	*/
{
int k, i;
int nbp, index;
//char brou[128];

index = 0;			// Initialisation
if (carte) {			// On ne demande pas la premire
	while (1) {		// donc nous cherchons dans la table
		if ((table[index].adapt == (char) carte) && (table[index].adr == (char) -1))
			break;	// On y est, c'est bon
		index++;
		}
	}
for (i = carte; i < nb_cartes; i++) {
	nbp = 0;
	SetDlgItemText (hDlg, cmd_dvr, table[index].mod);	// Nous affichons le pilote ASPI
	index++;
	while (table[index].adapt == i) {
		k = cmd_0 + table[index].adr;
		EnableWindow (GetDlgItem (hDlg, k), TRUE);		// Validation du bouton
		SetDlgItemText (hDlg, k+100, (LPSTR) table[index].fab);	// Type
		SetDlgItemText (hDlg, k+200, (LPSTR) table[index].mod);	// Modle
		SetDlgItemText (hDlg, k+300, (LPSTR) table[index].ver);	// Version
		index++;
		nbp++;
		}	// fin du while
	if (nbp) {
		if (nbp == 1)
			nbp = k - cmd_0;
          else
          	nbp = 0xFF;
		break;
		}
	else {
     	nbp = 0xFF;
          if ( i < (nb_cartes-1))
			adaptateur++;
          }
	}	// fin du for sur les cartes
if (adaptateur == nb_cartes -1)			// C'est la dernire carte
	EnableWindow (GetDlgItem (hDlg, ID_SUITE), FALSE);		// Nous inhibons le bouton suite
else
	EnableWindow (GetDlgItem (hDlg, ID_SUITE), TRUE);		// Nous le validons
if (!adaptateur)						// C'est la premire carte
	EnableWindow (GetDlgItem (hDlg, ID_PRECE), FALSE);		// Nous inhibons le bouton prece
else
	EnableWindow (GetDlgItem (hDlg, ID_PRECE), TRUE);		// Nous le validons
return (nbp);
}	// fin de affichage_perif


#pragma argsused
BOOL CALLBACK MACCDASPIPROC (HWND hDlg, WORD wMess, WPARAM wParam, LPARAM lParam)
{
static int type;
extern int nb_cartes;
extern uchar adaptateur, lecteur;
static char *chne_ptr;
ulong lg;
uchar numper;
char buffnom[512];

switch(wMess) {
	case WM_INITDIALOG:			// Il faut renseigner les donnes  afficher
		chne_ptr =  (char*) lParam;
		type = chne_ptr[0];
		lecteur = 0xFF;
		adaptateur = 0;
		EnableWindow (GetDlgItem (hDlg, ID_PRECE), FALSE);		// Nous inhibons les deux
		EnableWindow (GetDlgItem (hDlg, ID_SUITE), FALSE);
		nb_cartes = liste_perif (&table_lecteurs[0], type);
		numper = (uchar) (nb_cartes && 0xFF);			// Octet de poids faible
		nb_cartes >>=8;							// Octet de poids fort
		if (nb_cartes == 0 || numper == 0) { 	// Rien !!
			MCD_result = 0;
			EndDialog (hDlg, 0xFF);
			return (TRUE);
			}
		numper = (uchar) affichage_perif (hDlg, nb_cartes, 0, &table_lecteurs[0]);
		if (numper != 0xFF) {					// Situation spciale d'un seul prif
			CheckRadioButton (hDlg, cmd_0, cmd_7, numper + cmd_0);
			lecteur = numper;
			}
		return (TRUE);
	case WM_COMMAND:
		#ifdef FLAT
		switch (LOWORD(wParam)) {		// Paramtre identifiant les contrles d'origine
		#else
		switch (wParam) {
		#endif
			case ID_SUITE :		// Bouton de la carte suivante
				adaptateur++;		// Incrmentation
				numper = (uchar) affichage_perif (hDlg, nb_cartes, adaptateur, &table_lecteurs[0]);
				if (numper != 0xFF) {					// Situation spciale d'un seul prif
					CheckRadioButton (hDlg, cmd_0, cmd_7, numper + cmd_0);
					lecteur = numper;
					}
				return (TRUE);
			case cmd_0 :	// Boutons  cocher
			case cmd_1 :
			case cmd_2 :
			case cmd_3 :
			case cmd_4 :
			case cmd_5 :
			case cmd_6 :
			case cmd_7 :
				CheckRadioButton (hDlg, cmd_0, cmd_7, wParam);
				lecteur = (uchar) (wParam - cmd_0);	// Delta = bouton 0
				return (TRUE);
			case IDCANCEL :			// Touche ESC
			case ID_CANCEL:			// Simple fermeture...
				lecteur = adaptateur = 0xFF;
				MCD_result = -1;
				EndDialog (hDlg, FALSE);
				return (TRUE);
			case ID_OK :				// Fermeture aprs slection
				if (lecteur == 0xFF) {	// Il n'y a pas de lecteur slectionn
					MessageBeep (-1);
					}
				else {				// Tout est bon, mon cochon...
					uint res, nbt;
					nbt = 0;
					while (1) {
						res = (uint) aspi_readcap (adaptateur, lecteur, buffnom);
						if (res == 1)
							break;
						nbt++;
						if (nbt == 10) {
							MCD_result = -2;
							EndDialog (hDlg, 0xFF);
							return (TRUE);
							}
						}
					lg = swap32b (*(ulong*)buffnom);
					if (lg)
						nb.total = lg;
					lg = swap32b (*(ulong*) &buffnom[4]);
					if (lg)
						nb.octets = (uint) (lg);
					if (type == 5)
						chne_ptr[0] = 'C';
					else
						chne_ptr[0] = 'A';
					chne_ptr[1] = (uchar) (adaptateur + 0x30);
					chne_ptr[2] = (uchar) (lecteur + 0x30);
					chne_ptr[3] = 0x30;
					chne_ptr[4] = 0;
                         MCD_result = 0;
					EndDialog (hDlg, TRUE);
					}
				return (TRUE);
			}	// fin du switch sur wParam
	case WM_SYSCOMMAND :
		switch(wParam & 0xFFF0) {
			case SC_CLOSE :
				lecteur = 0xFF;
                    MCD_result = -1;
				EndDialog(hDlg, FALSE);
				return (TRUE);
			}
		return (FALSE);
	}
return FALSE;
}	// fin de MACCDASPIPROC

#ifndef FLAT
#pragma argsused
BOOL CALLBACK MACCDMSCDEXPROC (HWND hDlg, WORD wMess, WPARAM wParam, LPARAM lParam)
/*	Fonction de slection des lecteurs de CD-ROM (version 16 bits pour MSCDEX).
	Function for selecting a CD-ROM drive (16-bit version interfaced with MSCDEX).
	*/
{
static char *chne_ptr;
HWND hText;
int i, nb_lecteurs;
long lgf;
char brou[128];

switch (wMess) {
	case WM_INITDIALOG :
		chne_ptr = (char *) lParam;	// Sauvegarde du pointeur/Saving ptr
		hText = GetDlgItem (hDlg, ID_LISTE);
		nb_lecteurs = check_mscdex ();  	// lecteur est renseign avec le premier
		brou[0] = 0x20;
		brou[1] = 0x5B;
		brou[3] = 0x3A;
		brou[4] = 0x5D;
		brou[5] = 0x20;
		brou[6] = 0x00;
		strcat (brou, "CD-ROM drive/Lecteur de CD");
		while (1) {
			brou[2] = lecteur + 0x41;
			SendMessage (hText, LB_ADDSTRING, 0, (LPARAM) brou);
			nb_lecteurs--;
			if (!nb_lecteurs)
				break;
			while (1) {
				lecteur++;
				if (check_drive (lecteur))
					break;
				}
			}
		SetFocus (hText);
		return (TRUE);
	case WM_COMMAND :
		#ifdef FLAT
		switch (LOWORD(wParam)) {
		#else
		switch (wParam) {
		#endif
			case ID_LISTE :
				#ifdef FLAT
				i = HIWORD (wParam);
				#else
				i = HIWORD(lParam);
				#endif
				if (i == LBN_DBLCLK) {
					// Le double clic quivaut  une slection
					// Double-clic to select directly the drive
					lgf = SendDlgItemMessage (hDlg, ID_LISTE, LB_GETCURSEL, 0, 0L);				// Index du fichier/File index
					SendDlgItemMessage (hDlg, ID_LISTE, LB_GETTEXT, (WPARAM) lgf, (LPARAM) brou);	// Extraction du nom/File name
					//... Composer la chane de sortie
					EndDialog (hDlg, 1);
					}
				return (TRUE);
//			case ID_HELP :
//				WinHelp (hDlg, nom_faide, HELP_KEY, (DWORD) (LPSTR) str_Informations);
//				return (TRUE);
			case ID_OK :
				lgf = SendDlgItemMessage (hDlg, ID_LISTE, LB_GETCURSEL, 0, 0L);				// Index du fichier/File index
				if (lgf == LB_ERR) {
					return (TRUE);
					}
				SendDlgItemMessage (hDlg, ID_LISTE, LB_GETTEXT, (WPARAM) lgf, (LPARAM) brou);	// Extraction du nom/File name
				strncpy (chne_ptr, &brou[2], 2);
				chne_ptr[2] = 0;
				MCD_result = 0;
				EndDialog (hDlg, 1);
				return (TRUE);
			case ID_CANCEL :
				MCD_result = -1;
				EndDialog (hDlg, FALSE);
				return (TRUE);
			}	// fin du switch sur le paramtre
		return (FALSE);
	case WM_SYSCOMMAND :
		switch(wParam & 0xFFF0) {
			case SC_CLOSE :
				MCD_result = -1;
				EndDialog(hDlg, FALSE);
				return (TRUE);
			}
		break;
	}
return (FALSE);
}	// fin de MACCDMSCDEXPROC
#endif // sur FLAT


BOOL	far _export mac_comdlg_openfile (MACOPENFILENAME *mofn)
{
extern HANDLE MACLIB_hInst;

#ifdef FLAT

MCD_result = 0;
DialogBoxParam (MACLIB_hInst, MAKEINTRESOURCE(dlg_MCDO), mofn->hwndOwner, (DLGPROC) MACCDOPENPROC, (LPARAM) mofn);

#else

DLGPROC lpproc;
MCD_result = 0;
lpproc = (DLGPROC) MakeProcInstance ((FARPROC)MACCDOPENPROC, MACLIB_hInst);
DialogBoxParam (MACLIB_hInst, MAKEINTRESOURCE(dlg_MCDO), mofn->hwndOwner, lpproc, (LPARAM) mofn);
FreeProcInstance((FARPROC)lpproc);

#endif

return (MCD_result);
}	// fin de mac_comdlg_openfile


BOOL	far _export mac_comdlg_aspiscan (int type, char *chne, HWND parent)
{
extern HANDLE MACLIB_hInst;

#ifdef FLAT

MCD_result = 0;
chne[0] = (unsigned char) type;
DialogBoxParam (MACLIB_hInst, MAKEINTRESOURCE(dlg_MCDA), parent, (DLGPROC) MACCDASPIPROC, (LPARAM) chne);

#else

DLGPROC lpproc;
MCD_result = 0;
chne[0] = (unsigned char) type;
lpproc = (DLGPROC) MakeProcInstance ((FARPROC)MACCDASPIPROC, MACLIB_hInst);
DialogBoxParam (MACLIB_hInst, MAKEINTRESOURCE(dlg_MCDA), parent, (DLGPROC) lpproc, (LPARAM) chne);
FreeProcInstance((FARPROC)lpproc);

#endif

return (MCD_result);
}	// fin de mac_comdlg_aspiscan


#ifndef FLAT
BOOL	far _export mac_comdlg_mscdexscan (char *chne, HWND parent)
{
extern HANDLE MACLIB_hInst;
DLGPROC lpproc;

MCD_result = 0;

lpproc = (DLGPROC) MakeProcInstance ((FARPROC)MACCDMSCDEXPROC, MACLIB_hInst);
DialogBoxParam (MACLIB_hInst, MAKEINTRESOURCE (dlg_MCDM), parent, lpproc, (LPARAM) chne);
FreeProcInstance((FARPROC)lpproc);
return (MCD_result);
}	// fin de mac_comdlg_mscdexscan
#endif


//****************************** fin de mccomdlg.c *************************************