// mcdmpw
// (c) Pierre Duhem 1994-96
// Exemple d'application utilisant la bibliothque MacLib.dll
// Sample application interfacing with the MacLib.dll library
// Programme construit sur la base de l'exemple hdump fourni avec le
// compilateur Borland
// Program written from the hdump example delivered with the
// Borland C compiler

//	Historique, voir mcdmp.his

#define STRICT
#include <windows.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <bios.h>
#include <ctype.h>
#include <io.h>
#include <dos.h>
#include <dir.h>
//#include <windowsx.h>
#ifndef FLAT
	#include <ctl3d.h>
#endif

#pragma hdrstop

#include "maclib.h"
#include "mcdmp.h"
#include "mcdmpid.h"

SCROLLKEYS key2scroll [] ={
	{ VK_HOME,  WM_VSCROLL, SB_TOP },		// Home
	{ VK_END,   WM_VSCROLL, SB_BOTTOM },	// Fin
	{ VK_PRIOR, WM_VSCROLL, SB_PAGEUP },	// Page Haut
	{ VK_NEXT,  WM_VSCROLL, SB_PAGEDOWN },	// Page Bas
	{ VK_UP,    WM_VSCROLL, SB_LINEUP },	// Flche Haut
	{ VK_DOWN,  WM_VSCROLL, SB_LINEDOWN }	// Flche Bas
	};

# define NUMKEYS (sizeof key2scroll / sizeof key2scroll[0])

char *dlgstrings = "Open Mac File on\0Directory:\0Name:\0Typ:\0Open\0Cancel\0Help\0\0";

LRESULT CALLBACK _export WndProc (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
// Fentre principale de l'application/Main window of the program
{
static char nomfich[MAXPATH];
MACOPENFILENAME mofn;
DLGPROC lpproc;
char buf[128];
int i;

switch (message) {
	case WM_CREATE:
		return (0);
	case WM_COMMAND:
		switch (wParam) {
			case IDM_ANS :		// 200 = ANSI, valeur par dfaut
			case IDM_DOS :		// 201 = ASCII DOS
			case IDM_MAC :		// 202 = ASCII Macintosh
				CheckMenuItem (hMenu, POLICE, MF_UNCHECKED);
				CheckMenuItem (hMenu, wParam, MF_CHECKED);
				POLICE = (uint) wParam;
				InvalidateRect(hWnd, NULL, TRUE);
				UpdateWindow (hWnd);
				affichage (hWndMain);
				UpdateWindow(hWnd);
				return (TRUE);
			case IDM_DECI :		// Numration dcimale
				if (radix != 10) {
					CheckMenuItem (hMenu, IDM_HEXA, MF_UNCHECKED);
					CheckMenuItem (hMenu, IDM_DECI, MF_CHECKED);
					radix = 10;
					}
				InvalidateRect(hWnd, NULL, TRUE);
				UpdateWindow (hWnd);
				affichage (hWndMain);
				UpdateWindow(hWnd);
				return (TRUE);
			case IDM_HEXA :		// Numration hexadcimale
				if (radix != 16) {
					CheckMenuItem (hMenu, IDM_HEXA, MF_CHECKED);
					CheckMenuItem (hMenu, IDM_DECI, MF_UNCHECKED);
					radix = 16;
					}
				InvalidateRect(hWnd, NULL, TRUE);
				UpdateWindow (hWnd);
				affichage (hWndMain);
				UpdateWindow(hWnd);
				return (TRUE);
			case IDM_QUIT:      // Menu Quitter
				if (maclib) {
					maclib_close ();
					maclib = 0;
					}
				PostMessage(hWnd, WM_CLOSE, 0, 0L);
				break;
			case IDM_ABOUT:     // Menu A propos de ...
				lpproc = (DLGPROC) MakeProcInstance((FARPROC)About, hInst);
				DialogBox (hInst, MAKEINTRESOURCE(ABOUT), hWnd, lpproc);
				#ifndef FLAT
					FreeProcInstance ((FARPROC)lpproc);
				#endif
				break;
//			case IDM_HELP :
//				MessageBox (hWnd, develop, revend, MB_OK);
//				return (TRUE);
			case IDM_OPEN_FLOPPY :   	// Ouverture d'un volume sur disquette
			case IDM_OPEN_CDROM :		// Ouverture d'un volume sur CD-ROM
			case IDM_OPEN_ASPI :  		// Ouverture d'un volume gr par l'ASPI
				if (!maclib)			// Bibliothque non ouverte/Library not opened yet
					maclib = maclib_open ();
				switch (wParam) {
					case IDM_OPEN_FLOPPY :   // Ouverture d'un volume sur disquette
						i = mac_open_volume ("A:");	// Disquette/Floppy disk
						if (i == -2)
							MessageBox (hWnd, "Erreur  l'ouverture du volume Macintosh\nError opening the Macintosh volume.", revend, MB_OK);
						if (i == -7)
							MessageBox (hWnd, "Utilisez la bibliothque 16 bits.\nYou should use the 16-bit library.", revend, MB_OK);
						if (i)					// Non nul, toutes les erreurs
							return (TRUE);			// Non zero, errors
						break;
					case IDM_OPEN_CDROM :		// Ouverture d'un volume sur CD-ROM
						i = mac_getcdrom (buf);
						switch (i) {
							case 0 :		// Pas de CD-ROM/No CD-ROM
								MessageBeep (1);
								return (TRUE);
							case 1 :		// Un lecteur/One drive
								i = mac_open_volume (buf);	// CD-ROM
								if (i == -2)              	// Erreur physique  l'ouverture
									MessageBox (hWnd, "Erreur  l'ouverture du volume Macintosh\nError opening the Macintosh volume.", revend, MB_OK);
								if (i == -8)              	// Erreur physique  l'ouverture
									MessageBox (hWnd, "Erreur : Utilisation de la DLL 16 bits sous Windows 95 !\nError: Calling 16-bit DLL under Windows 95!", revend, MB_OK);
								if (i)					// Non nul, toutes les erreurs
									return (TRUE);			// Non zero, errors
								break;
							default :		// Plusieurs lecteurs/Several drives
								#ifdef FLAT
									i = mac_comdlg_aspiscan (5, buf, hWnd);
								#else
									i = mac_comdlg_mscdexscan (buf, hWnd);
								#endif
								if (!i) {
									i = mac_open_volume (buf);
									if (i == -2)              	// Erreur physique  l'ouverture
										MessageBox (hWnd, "Erreur  l'ouverture du volume Macintosh\nError opening the Macintosh volume.", revend, MB_OK);
									if (i == -8)              	// Erreur physique  l'ouverture
										MessageBox (hWnd, "Erreur : Utilisation de la DLL 16 bits sous Windows 95 !\nError: Calling 16-bit DLL under Windows 95!", revend, MB_OK);
									if (i)					// Non nul, toutes les erreurs
										return (TRUE);			// Non zero, errors
                                             }
                                        else
									return (TRUE);
								break;
							}
						break;
					case IDM_OPEN_ASPI :  		// Ouverture d'un volume gr par l'ASPI
						i = mac_comdlg_aspiscan (-2, buf, hWnd);
						if (!i) {
							i = mac_open_volume (buf);	// Volume gr par l'ASPI
							if (i == -2)              	// Erreur physique  l'ouverture
								MessageBox (hWnd, "Erreur  l'ouverture du volume Macintosh\nError opening the Macintosh volume.", revend, MB_OK);
                                   if (i)					// Non nul, toutes les erreurs
								return (TRUE);			// Non zero, errors
                                   }
                              else		// Sortie par Annulation/Exit with Cancel
                              	return (TRUE);
						break;
					}
				memset (&mofn, 0, sizeof (MACOPENFILENAME));
				mofn.lStructSize = sizeof (MACOPENFILENAME);
				mofn.hwndOwner = hWnd;
				mofn.hInstance = hInst;
				mofn.lpstrTitle = dlgstrings;
				mofn.lpstrFile = "*.*";
				mofn.lpstrFileTitle = nomfich;			// Tampon local
				i = mac_comdlg_openfile (&mofn);
				if (i == -1 || i == 0)	// Erreur ou annulation
					break;
				mfp = mac_fopen (nomfich, "");          	// Ouverture du fichier Mac
				if (mfp) { 							// Il faudrait encore afficher
                    	EnableMenuItem (hMenu, IDM_CLOSE, MF_ENABLED | MF_BYCOMMAND);
					sprintf(buf, "%s - %s", titre, nomfich); // Nom complexe de la fentre
					SetWindowText(hWnd, buf);			// avec le fichier
					fsize = mac_filelength (mfp);			// Longueur du fichier
					nbtotal = fsize >> 9;
					if ((nbtotal << 9 ) < fsize)
						nbtotal ++;
					while (1) {						// Calcul d'une taille de bloc
						if ((fsize / bloc) <= 32767)		// pour le dfilement vertical
							break;					// dans de bonnes conditions
						bloc += 512;					// incrmentation par 512 octets
						}
					nbblocs = (fsize / bloc);			// Nombre de blocs
					if (fsize % bloc)					// Un bloc incomplet...
						nbblocs++;
					nbs = (uchar) (nbtotal / nbblocs);			// Units de dfilement
					mac_fread (tampon, 1, 512, mfp);		// Lecture d'un tampon de 3 * 512 octets
					affichage (hWndMain);				// Premier affichage
					}
				else { 								// Erreur  l'ouverture....
					SetWindowText(hWnd, titre);
					nbblocs = 0;
					}
				SetScrollRange (hWnd, SB_VERT, 0, (int) nbblocs, FALSE);
				SetScrollPos (hWnd, SB_VERT, 0, TRUE);	// Paramtrage de l'ascenseur
				InvalidateRect(hWnd, NULL, TRUE);  	// Affichage du dbut du fichier
				UpdateWindow(hWnd);
				break;
			case IDM_CLOSE :		// Fermeture du fichier/Closing the file
               	mac_fclose (mfp);
                    mfp = NULL;
				EnableMenuItem (hMenu, IDM_CLOSE, MF_GRAYED | MF_BYCOMMAND);
				InvalidateRect(hWnd, NULL, TRUE);
				UpdateWindow (hWnd);
				break;
			case IDM_SAUV :		// Sauvegarde d'un bout dans un fichier
				MessageBeep (-1);
				break;
			case IDM_RECH :		// Recherche d'une chane
				MessageBeep (-1);
			case IDM_REBE :		// Poursuite de la recherche
				MessageBeep (-1);
				break;
			default:
				break;
			}    // Fin du switch sur WM_COMMAND
		break;
	case WM_VSCROLL:    // Action sur l'ascenseur
		switch (wParam) {			// Code de commande pass
			case SB_TOP:
				secteur = 0;		// Dbut du texte
				break;
			case SB_BOTTOM:
				secteur = nbtotal-1;
				break;
			case SB_LINEUP :
			case SB_PAGEUP:
				if (secteur)
					secteur--;
				else
					MessageBeep (-1);
				break;
			case SB_LINEDOWN :
			case SB_PAGEDOWN:
				if (secteur < nbtotal-1)
					secteur++;
				else
					MessageBeep (-1);
				break;
			case SB_THUMBPOSITION:
				secteur = LOWORD (lParam);	// Valeur exprime en units nbblocs
				secteur *= nbs;			// Retour en secteurs
				break;
			}
		SetScrollPos (hWnd, SB_VERT, (int) (secteur/nbs), TRUE);	// Paramtrage de l'ascenseur
		lecture ();					// Relecture ventuelle
		InvalidateRect(hWnd, NULL, TRUE);  // Nettoyage de la fentre
		affichage (hWndMain);			// Affichage du tampon
		break;
	case WM_KEYDOWN:    // Correspondance entre frappes et dfilements
		for (i = 0; i < NUMKEYS; i++) {
			if (wParam == key2scroll[i].wVirtkey) {
				SendMessage(hWnd, key2scroll[i].iMessage, key2scroll[i].wRequest, 0L);
				break;
				}
			}
		break;
	case WM_PAINT: // Dessin de la zone client de la fentre
		affichage (hWnd);
		break;
	case WM_CLOSE:           // Fermeture simple
		if (maclib) {
			maclib_close ();
			maclib = 0;
			}
		PostQuitMessage(0);
		break;
	default:                 // Laissons filer le reste...
		return(DefWindowProc(hWnd, message, wParam, lParam));
    }     // Fin du switch sur le message
return (DefWindowProc (hWnd, message, wParam, lParam));
}    // Fin de WndProc


static void near lecture (void)
{
ulong pos;

pos = secteur;					// Position en secteurs
pos <<= 9;					// Multiplication par 512
memset (tampon, 0, 512);
mac_fseek (mfp, pos, 0);			// Repositionnement dans le fichier
mac_fread (tampon, 1, 512, mfp);	// Lecture d'un tampon d'un secteur
}	// fin de lecture


#pragma argsused
int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpszCmdLine, int cmdShow)
// WinMain - fonction principale de filedump
{
MSG   msg;
WNDCLASS wc;

#ifndef FLAT
	Ctl3dRegister (hInstance);
	Ctl3dAutoSubclass (hInstance);
#endif

// Initialisation de l'application. Si ce n'est pas la premire instanciation, il
// faut dclarer la fentre
if (! hPrevInstance) {
    wc.lpszClassName = szappname;
    wc.hInstance     = hInstance;
    wc.lpfnWndProc   = WndProc;
    wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
    wc.hIcon         = LoadIcon(hInstance, szappname);
    wc.lpszMenuName  = (LPSTR) szappname;
    wc.hbrBackground = GetStockObject (LTGRAY_BRUSH);
    wc.style         = CS_HREDRAW | CS_VREDRAW;
    wc.cbClsExtra    = 0;
    wc.cbWndExtra    = 0;
    RegisterClass(&wc);
    }

initdump (hInstance, cmdShow);  	// initialisations gnrales
tampon = (char*) calloc (1536,1);
radix = 10;					// Dcimal pour commencer
POLICE = 200;					// Ansi
bloc = 512;			// Taille des blocs de base

// Boucle d'appel et de distribution des messages
while (GetMessage(&msg, NULL, 0, 0)) {
	TranslateMessage(&msg);
	DispatchMessage(&msg);
	}

closedump ();

#ifndef FLAT
	Ctl3dUnregister (hInstance);
#endif

return(msg.wParam);
}    // fin de WinMain


void initdump (HINSTANCE hInstance, int cmdShow)
{
TEXTMETRIC tm;
HDC        hDC;
//char szFaceName[200];

hInst = hInstance;       // Sauvegarde dans une globale

// Creation de la fentre principale de l'application
hWndMain = CreateWindow (
	szappname,     // Classe de la fentre
	szappname,     // Titre de la fentre
	WS_OVERLAPPED|WS_CAPTION|WS_SYSMENU|WS_MINIMIZEBOX | WS_VSCROLL,
	0,             // x  = Coin suprieur gauche
	0,             // y idem
	540,           // Largeur
	440,           // Hauteur
	NULL,          // Pas de parent
	NULL,          // Menu de la classe
	hInstance,     // Instance du programme
	NULL           // Pas de paramtres
	);

// Poigne sur le contexte de priphrique
hDC = GetDC(hWndMain);

// Construction d'une police  chappement fixe pour l'affichage
curfont.lfHeight         =  -11;
curfont.lfWidth          =  0;	// Pour slectionner par dfaut
curfont.lfEscapement     =  0;
curfont.lfOrientation    =  0;
curfont.lfWeight         =  FW_DONTCARE;
curfont.lfItalic         =  FALSE;
curfont.lfUnderline      =  FALSE;
curfont.lfStrikeOut      =  FALSE;
curfont.lfCharSet        =  ANSI_CHARSET;
curfont.lfOutPrecision   =  OUT_TT_PRECIS;
curfont.lfClipPrecision  =  CLIP_DEFAULT_PRECIS;
curfont.lfQuality        =  PROOF_QUALITY;
curfont.lfPitchAndFamily =  FIXED_PITCH | FF_DONTCARE;
// curfont.lfFaceName 		=  NULL;
//strcpy((char *)curfont.lfFaceName, "MS Sans Serif");

hnewfont = CreateFontIndirect((LPLOGFONT) &curfont);

// Installation de la police dans le contexte de priphrique
holdfont = SelectObject(hDC, hnewfont);
//GetTextFace (hDC, sizeof szFaceName, szFaceName);

// Obtention des donnes d'affichage
GetTextMetrics(hDC, &tm);
xChar = tm.tmAveCharWidth;
yChar = tm.tmHeight + tm.tmExternalLeading;
yChar -= 2;
yCharnl = tm.tmHeight;

// Termin avec le DC
ReleaseDC(hWndMain, hDC);

hMenu = GetMenu (hWndMain);
#ifdef FLAT
	EnableMenuItem (hMenu, IDM_OPEN_FLOPPY, MF_GRAYED | MF_BYCOMMAND);
#endif

// Mj de l'affichage
SetWindowText(hWndMain, titre);
ShowWindow(hWndMain, cmdShow);
UpdateWindow(hWndMain);
}    // Fin de initdump


static void near closedump (void)
{
free (tampon);
DeleteObject(hnewfont);
if (mfp)
	mac_fclose (mfp);
}	// fin de closedump


static void near affichage (HWND hWnd)
// Affichage d'un secteur du fichier // Display of a file sector
// hWnd  = fentre de la fonction appelante/Calling window handle
{
PAINTSTRUCT  ps;
HDC  hDC;
int  lpos;
int  num_ligne;
char ligne[128];
char *ptr;
int  i;

if (mfp) {
	offset = secteur;
	offset <<= 9;
	BeginPaint (hWnd, (LPPAINTSTRUCT) &ps);
	hDC = ps.hdc;
	SetBkMode (hDC, TRANSPARENT);		// Affichage transparent
	SelectObject(hDC, hnewfont); 		// Slection de la police cre antrieurement
	lpos = 0;						// Position d'affichage
	num_ligne = 0;
	ptr = tampon;  				// Pointeur sur le tampon
	for (i = 0; i < 32 ; i++){
		formate_ligne (ligne, ptr, offset + (i*16));
		TextOut (hDC, 0 , lpos, ligne, strlen(ligne));
		num_ligne++;
		lpos += yChar;
		if (!(num_ligne % 8))   // pour former des blocs de 8 lignes
			lpos+= 4;
		ptr += 16;
		}
	EndPaint(hWnd, (LPPAINTSTRUCT) &ps);
    }	// fin du if sur mfp
}	// fin de affichage


static void near formate_ligne (char *ligne, char *tamp, ulong offset)
//	Fonction crant la ligne  afficher
{
int i;
ulong temp;
int c;
uchar  buff[80];
char *hptr;
uchar *pt;

memset (ligne, 0x20, 80);	// Nettoyage
ligne[80] = 0;				// Bornage

temp = offset;				// Affichage de l'offset
for (i=7; i >= 0; i--) {
	ligne[i] = ch_hexa[(int) (temp % radix)];
	temp /= radix;      	// dcalage d'un cran
	 }

pt = (uchar*) tamp;			// Passage de l'adresse
hptr = &ligne[9];
for (i = 0; i < 16; i++) {	// Affichage de la partie mdiane
	c = *pt++;
	*hptr++ = ch_hexa[c/16];
	*hptr++ = ch_hexa[c%16];
	hptr++;
	if (i == 7)			// Espace supplmentaire au milieu
		hptr++;
	buff[i] = (uchar) c;			// Sauvegarde de la chane
	}

switch (POLICE) {
	case ANSI :
		for (i = 0 ; i < 16; i++) {
			c = buff[i];
			if (c)
				*hptr = (uchar) c;
			hptr++;
			}
		break;
	case ASCII :
		for (i = 0; i < 16; i++) {
			c = DOS2WIN[buff[i]];
			if (c)
				*hptr = (uchar) c;
			hptr++;
			}
		break;
	case ASCMAC :
		for (i = 0; i < 16; i++) {
			c = MAC2SCREEN[buff[i]];
			if (c)
				*hptr = (uchar) c;
			hptr++;
			}
		break;
	}
}	// fin de formate_ligne


#pragma argsused
BOOL CALLBACK _export About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
switch (message) {
	case WM_INITDIALOG :
	   return(TRUE);
	case WM_COMMAND :
		switch (wParam)  {
			case IDOK:
				EndDialog(hDlg, TRUE);
				return(TRUE);
			default:
				return(TRUE);
			}
    }
return(FALSE);
}    // fin de About



//******************************* fin de mcdmpw.c ************************************

