// mfcers16.cpp : implementation file
//

#include "stdafx.h"
#include "MfceRs16.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

//  special macro that throws a comm exception.
///////////////////////////////////////////////////////////////////////
#define RAISE_EXCP(eval)    { if(eval) THROW( new CCommException(this));    }

///////////////////////////////////////////////////////////////////////

//  Runtime class implementations for exceptions
///////////////////////////////////////////////////////////////////////
IMPLEMENT_DYNAMIC(CCommException, CException)

/////////////////////////////////////////////////////////////////////////////
// CComm
/*  RS232.DLL Function Prototypes  */
extern "C" {
int     FAR PASCAL rsinit(  WORD APortNo, WORD ABaudRate,
                            WORD AParity, WORD AByteSize,
                            WORD AStopBits, BOOL AnXModem,
                            WORD ATimeout );
int     FAR PASCAL rsdone( int nCid);
int     FAR PASCAL rswrts( int nCid, LPCSTR lpszBuf);
int     FAR PASCAL rsrds( int nCid, LPSTR lpszBuf, WORD nMaxLen);
int     FAR PASCAL rswrtb( int nCid, VOID FAR* lpBuf, WORD nLength);
int     FAR PASCAL rsrdb( int nCid, VOID FAR* lpBuf, WORD nLength);
int     FAR PASCAL rsrdterm( int nCid, LPSTR lpszBuf, WORD nMaxLen, char cTermChr);
}

CComm::CComm( BOOL bRaiseException)
    :CObject(),
    m_hFile(-1),
    m_iPortNo(0),
    m_bRaiseException(bRaiseException)
{
}

CComm::CComm( UINT iPortNo, 
        WORD baudRate,
        WORD parity, 
        WORD byteSize,
        WORD stopBits, 
        BOOL xmodem,
        WORD timeout,
        BOOL bRaiseException)
    :CObject(),
    m_bRaiseException(bRaiseException)
{
    Open( iPortNo, baudRate, parity, byteSize, stopBits, xmodem, timeout);
}

CComm::~CComm()
{
    Close();
}

BOOL CComm::rswrts( const CString& strWrt)
{
    int ret = ::rswrts( m_hFile, strWrt);
    RAISE_EXCP( ret != 0);
    return ret == 0;
}

BOOL CComm::rsrds( CString& strRd)
{                      
    return rsrdterm( strRd, 0x0A);
}

BOOL CComm::rswrtb( PVOID pBuf, UINT uLen)
{
    int ret = ::rswrtb( m_hFile, pBuf, uLen);
    RAISE_EXCP( ret != 0);
    return ret == 0;
}

BOOL CComm::rsrdb( PVOID pBuf, UINT uMaxLen)
{
    int ret = ::rsrdb( m_hFile, pBuf, uMaxLen);
    RAISE_EXCP( ret != 0);
    return ret == 0;
}

BOOL CComm::rsrdterm( CString& strRd, CHAR cTermChar)
{
    CHAR szBuf[2048];
    int ret = ::rsrdterm( m_hFile, szBuf, 2047, cTermChar);

    CHAR szToFind[2];
    wsprintf( szToFind, "%c", cTermChar);
    PCHAR pc = strstr( szBuf, szToFind);
    if( pc == NULL)
        szToFind[0] = 0x00;
    else
        *pc = 0x00;
    strRd = szBuf;
    RAISE_EXCP( ret != 0);
    return ret == 0;
}

//  helper functions
void CComm::Open( UINT iPortNo,
                    WORD baudRate,
                    WORD parity,
                    WORD byteSize,
                    WORD stopBits,
                    BOOL xmodem,
                    WORD timeout )
{
    m_hFile = ::rsinit( iPortNo, baudRate, parity, byteSize, stopBits, xmodem, timeout);
    RAISE_EXCP( m_hFile == -1);
    m_iPortNo = iPortNo;
}

BOOL CComm::Close()
{
    int ret = ::rsdone( m_hFile);
    m_iPortNo = 0;
    m_hFile = -1;
    return ret == 0;
}

/////////////////////////////////////////////////////////////////////////////
// CCommException

CCommException::CCommException( CComm* pComm)
    :CException()   
{
    m_pComm = pComm;
}

