// mfcers16.h : header file
// MFC extension for serial comms 
// (c)1996 Kikusui Electronics Corp
// 25/04/1995  The first revision

#ifndef __MFCERS32_H__
#define __MFCERS32_H__

#ifdef _WIN32
    #error Must be compiled as a Win16 project
#endif

typedef void FAR* PVOID;
typedef char CHAR;
typedef char FAR* PCHAR;

/////////////////////////////////////////////////////////////////////////////
// CComm

class CComm : public CObject    {
public:
    BOOL m_bRaiseException;
    HFILE m_hFile;
    UINT  m_iPortNo;
    CComm( BOOL bRaiseException = TRUE);
    CComm(      UINT iPortNo,
            WORD baudRate,
        WORD parity = NOPARITY, 
        WORD byteSize = 8,
        WORD stopBits = ONESTOPBIT, 
        BOOL xmodem = FALSE,
        WORD timeout = 3000,
        BOOL bRaiseException = TRUE );
    ~CComm();
public:
    BOOL rswrts( const CString& strWrt);
    BOOL rsrds( CString& strRd);
    BOOL rsrdterm( CString& strRd, CHAR cTermChar);
    BOOL rswrtb( PVOID pBuf, UINT uLen);
    BOOL rsrdb( PVOID pBuf, UINT uMaxLen);
    //  helper functions
    void Open( UINT iPortNo,
                WORD baudRate,
        WORD parity = NOPARITY, 
            WORD byteSize = 8,
        WORD stopBits = ONESTOPBIT, 
        BOOL xmodem = FALSE,
        WORD timeout = 3000 );
    BOOL Close();
    HFILE GetHandle() { return m_hFile; }
};

/////////////////////////////////////////////////////////////////////////////
// CCommException

class CCommException : public CException
{
    DECLARE_DYNAMIC(CCommException)
public:
    CComm* m_pComm;
    CCommException( CComm* pComm = NULL);
};

#endif  //__MFCERS32_H__
