// DlgMain.cpp : implementation file
//

#include "stdafx.h"
#include "MfcSamp.h"
#include "DlgMain.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainDlg dialog

CMainDlg::CMainDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMainDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMainDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CMainDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMainDlg)
	DDX_Control(pDX, IDC_EDIT_WRITE, m_txtWrite);
	DDX_Control(pDX, IDC_EDIT_READ, m_txtRead);
	DDX_Control(pDX, IDC_EDIT_HFILE, m_txthFile);
	DDX_Control(pDX, IDC_COMBO_BAUDRATE, m_cboBaudRate);
	DDX_Control(pDX, IDC_COMBO_DATA, m_cboData);
	DDX_Control(pDX, IDC_COMBO_PORT, m_cboPort);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMainDlg, CDialog)
	//{{AFX_MSG_MAP(CMainDlg)
	ON_BN_CLICKED(IDC_BUTTON_INIT, OnButtonInit)
	ON_BN_CLICKED(IDC_BUTTON_READ, OnButtonRead)
	ON_BN_CLICKED(IDC_BUTTON_WRITE, OnButtonWrite)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMainDlg message handlers

BOOL CMainDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
/*
	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
*/	
	// TODO: Add extra initialization here
	m_cboPort.SetCurSel(0);
	m_cboBaudRate.SetCurSel(0);
	m_cboData.SetCurSel(1);
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CMainDlg::OnButtonInit() 
{
	// TODO: Add your control notification handler code here
	UINT auPorts[] = {1, 2};	
	WORD awBaudRates[] = {9600, 19200, 38400};	
	WORD awData[] = {7, 8};	
	
	UINT uPort = auPorts[m_cboPort.GetCurSel()];
	WORD wBaudRate = awBaudRates[m_cboBaudRate.GetCurSel()];
	WORD wData = awData[m_cboData.GetCurSel()];

	CString strhFile;
	try	{
		m_comm.Open( uPort, wBaudRate, NOPARITY, wData, ONESTOPBIT, FALSE, 10000);
	}
	catch( CCommException* pE)	{
		MessageBox( "Cannot open serial device");
	}
	strhFile.Format( "hFile = %d", m_comm.m_hFile);
	m_txthFile.SetWindowText( strhFile);
}

void CMainDlg::OnButtonRead() 
{
	// TODO: Add your control notification handler code here
	CString strRd;
	try	{
		m_comm.rsrds( strRd);
	}
	catch( CCommException* pE)	{
		MessageBox( "Cannot read from serial device");
	}
	m_txtRead.SetWindowText( strRd);	
}

void CMainDlg::OnButtonWrite() 
{
	// TODO: Add your control notification handler code here
	CString strWrt;
	try	{
		m_txtWrite.GetWindowText( strWrt);
	}
	catch( CCommException* pE)	{
		MessageBox( "Cannot write to serial device");
	}
	m_comm.rswrts( strWrt);
}
