// mfcers32.cpp : implementation file
//
// (c)1996 Kikusui Electronics Corp
// 25/04/1996  The first revision
// 30/04/1996  Unicode support for rsinit/Windows NT
//

#include "stdafx.h"
#include "MfceRs32.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

//  special macro that throws a comm exception.
///////////////////////////////////////////////////////////////////////
#define RAISE_EXCP(eval)    { if(eval) throw( new CCommException(this));    }

///////////////////////////////////////////////////////////////////////

//  Runtime class implementations for exceptions
///////////////////////////////////////////////////////////////////////
IMPLEMENT_DYNAMIC(CCommException, CException)

/////////////////////////////////////////////////////////////////////////////
// CComm
/*  RSDRV32.DLL Function Prototypes  */
extern "C" {
HFILE _stdcall rsinitA(    
            LPCSTR APortName, 
            WORD ABaudRate,
            WORD AParity, 
            WORD AByteSize,
            WORD AStopBits, 
            BOOL AnXModem,
            WORD ATimeout );
HFILE _stdcall rsinitW( 	
			LPCWSTR APortName, 
			WORD ABaudRate,
            WORD AParity, 
            WORD AByteSize,
            WORD AStopBits, 
            BOOL AnXModem,
            WORD ATimeout );

int _stdcall rsdone( HFILE hComDev);
int _stdcall rswrt( HFILE hComDev, PVOID pBuf, DWORD dwLen);
int _stdcall rsrd( HFILE hComDev, PVOID pBuf, DWORD dwMaxLen);
int _stdcall rsrdterm( HFILE hComDev, PVOID pBuf, DWORD dwMaxLen, UINT uTermCode);
}

CComm::CComm( BOOL bRaiseException)
    :CObject(),
    m_hFile(-1),
    m_iPortNo(0),
    m_bRaiseException(bRaiseException)
{
}

CComm::CComm( UINT iPortNo, 
        WORD baudRate,
        WORD parity, 
        WORD byteSize,
        WORD stopBits, 
        BOOL xmodem,
        WORD timeout,
        BOOL bRaiseException)
    :CObject(),
    m_bRaiseException(bRaiseException)
{
    Open( iPortNo, baudRate, parity, byteSize, stopBits, xmodem, timeout);
}

CComm::~CComm()
{
    Close();
}

BOOL CComm::rswrts( const CString& strWrt)
{
    CString strTemp( strWrt + "\r\n");
    return rswrtb( (PVOID)(LPCTSTR)strTemp, strTemp.GetLength());
}

BOOL CComm::rsrds( CString& strRd)
{
    return rsrdterm( strRd, 0x0A);
}

BOOL CComm::rswrtb( PVOID pBuf, UINT uLen)
{
    int ret = ::rswrt( m_hFile, pBuf, uLen);
    RAISE_EXCP( ret != 0);
    return ret == 0;
}

BOOL CComm::rsrdb( PVOID pBuf, UINT uMaxLen)
{
    int ret = ::rsrd( m_hFile, pBuf, uMaxLen);
    RAISE_EXCP( ret != 0);
    return ret == 0;
}

BOOL CComm::rsrdterm( CString& strRd, TCHAR cTermChar)
{
    TCHAR szBuf[65535];
    int ret = ::rsrdterm( m_hFile, szBuf, 65535, cTermChar);

    TCHAR szToFind[2];
    wsprintf( szToFind, "%c", cTermChar);
    PCHAR pc = strstr( szBuf, szToFind);
    if( pc == NULL)
        szToFind[0] = 0x00;
    else
        *pc = 0x00;
    strRd = szBuf;
    RAISE_EXCP( ret != 0);
    return ret == 0;
}

//  helper functions
void CComm::Open( UINT iPortNo,
                    WORD baudRate,
                    WORD parity,
                    WORD byteSize,
                    WORD stopBits,
                    BOOL xmodem,
                    WORD timeout )
{
    CString strPortName;
    strPortName.Format( "COM%u", iPortNo);
    m_hFile = ::rsinit( strPortName, baudRate, parity, byteSize, stopBits, xmodem, timeout);
    RAISE_EXCP( m_hFile == -1);
    m_iPortNo = iPortNo;
}

BOOL CComm::Close()
{
    int ret = ::rsdone( m_hFile);
    m_iPortNo = 0;
    m_hFile = -1;
    return ret == 0;
}

/////////////////////////////////////////////////////////////////////////////
// CCommException

CCommException::CCommException( CComm* pComm)
    :CException()   
{
    m_pComm = pComm;
}

