// mfcers32.h : header file
// MFC extension for serial comms 
// (c)1996 Kikusui Electronics Corp
// 25/04/1996  The first revision
// 30/04/1996  Unicode support for rsinit/Windows NT

#ifndef __MFCERS32_H__
#define __MFCERS32_H__

#ifndef _WIN32
    #error Must be compiled as a Win32 project
#endif

//  Conditional compilation for ANSI and UNICODE
#if defined(UNICODE)
   #define rsinit rsinitW
#else
   #define rsinit rsinitA
#endif

/////////////////////////////////////////////////////////////////////////////
// CComm

class CComm : public CObject    {
public:
    BOOL m_bRaiseException;
    HFILE m_hFile;
    UINT  m_iPortNo;
    CComm( BOOL bRaiseException = TRUE);
    CComm(  UINT iPortNo,
            WORD baudRate,
            WORD parity = NOPARITY, 
            WORD byteSize = 8,
            WORD stopBits = ONESTOPBIT, 
            BOOL xmodem = FALSE,
            WORD timeout = 3000,
            BOOL bRaiseException = TRUE );
    ~CComm();
public:
    BOOL rswrts( const CString& strWrt);
    BOOL rsrds( CString& strRd);
    BOOL rsrdterm( CString& strRd, TCHAR cTermChar);
    BOOL rswrtb( PVOID pBuf, UINT uLen);
    BOOL rsrdb( PVOID pBuf, UINT uMaxLen);
    //  helper functions
    void Open( UINT iPortNo,
                WORD baudRate,
                WORD parity = NOPARITY, 
                WORD byteSize = 8,
                WORD stopBits = ONESTOPBIT, 
                BOOL xmodem = FALSE,
                WORD timeout = 3000 );
    BOOL Close();
    HFILE GetHandle() { return m_hFile; }
};

/////////////////////////////////////////////////////////////////////////////
// CCommException

class CCommException : public CException
{
    DECLARE_DYNAMIC(CCommException)
public:
    CComm* m_pComm;
    CCommException( CComm* pComm = NULL);
};

#endif  //__MFCERS32_H__
