Attribute VB_Name = "RSCOMM32"
Option Explicit

'   ----------------------------------------------------------
'   RSCOMM32.BAS - DLL interfaces for RSDRV32.DLL
'
'   RSDRV32.DLL  : (c)1995 Kikusui Electronics Corp
'   RSCOMM32.BAS : (c)1996 Kikusui Electronics Corp
'   ----------------------------------------------------------

Declare Function rs32_init Lib "RSDRV32.dll" Alias "rsinitA" _
            (ByVal lpszPortName As String, _
                ByVal iBaudRate As Integer, _
                ByVal iParity As Integer, _
                ByVal iByteSize As Integer, _
                ByVal iStopBits As Integer, _
                ByVal bXModem As Long, _
                ByVal iTimeout As Integer) As Long

Declare Function rsdone Lib "RSDRV32.dll" (ByVal hFile As Long) As Long

Declare Function rs32_wrts Lib "RSDRV32.dll" Alias "rswrt" _
    (ByVal hFile As Long, ByVal lpWrt As String, ByVal dwLen As Long) As Long

Declare Function rsrdterm Lib "RSDRV32.dll" (ByVal _
    hFile As Long, ByVal lpRdBuf As String, ByVal dwMaxLen As Long, ByVal uTermCode As Long) As Long

Declare Function rswrtb Lib "RSDRV32.dll" Alias "rswrt" _
    (ByVal hFile As Long, lpBuf As Any, ByVal dwLen As Long) As Long

Declare Function rsrdb Lib "RSDRV32.dll" Alias "rsrd" _
    (ByVal hFile As Long, lpBuf As Any, ByVal dwMaxLen As Long) As Long


Global Const NOPARITY = 0
Global Const ODDPARITY = 1
Global Const EVENPARITY = 2
Global Const MARKPARITY = 3
Global Const SPACEPARITY = 4

Global Const ONESTOPBIT = 0
Global Const ONE5STOPBITS = 1
Global Const TWOSTOPBITS = 2



Function rsinit(ByVal iPortNo As Integer, ByVal iBaudRate As Integer, ByVal iParity As Integer, ByVal iByteSize As Integer, ByVal iStopBits As Integer, ByVal bXModem As Integer, ByVal iTimeout As Integer) As Integer
    Dim strPortName As String
    strPortName = "COM" & iPortNo
    Dim hFile As Integer
    hFile = rs32_init(strPortName, iBaudRate, iParity, iByteSize, iStopBits, bXModem, iTimeout)
    rsinit = hFile
End Function


Function rsrds(ByVal hFile As Integer, strRdBuf As String, ByVal iMaxLen As Integer) As Integer
    Dim r As Integer
    r = rsrdterm(hFile, strRdBuf, iMaxLen, 10)
    rsrds = r
End Function


Function rswrts(ByVal hFile As Integer, ByVal strWrt As String) As Integer
    Dim r As Integer
    r = rs32_wrts(hFile, strWrt + Chr(13) + Chr(10), Len(strWrt) + 2)
    rswrts = r
End Function

