/******************************************************************************
*               Demonstrates a Win32 DLL with shared data space               *
*                    3/1/95 by Mark Gamber - Public Domain                    *
*                                                                             *
* This program uses a DLL to maintain two strings per application. A "local"  *
* string being one kept as a global variable within the DLL but global only   *
* to it's instance and a "shared" string being one which is common to all     *
* instances of this program. Selecting Get-Local Name returns the handle of   *
* the window to uniquely identify it. Selecting "Set!" sets a string based on *
* the window handle in the shared string. Following a set, Get-Shared Name    *
* returns the string that was set. The same string is returned to all running *
* instances of this program, demonstrating that the memory is shared.         *
*    This shared memory is about the same as normal data space of a DLL in 16 *
* bit Windows, so if there's a need to keep that sort of environment, this is *
* one way to do so in Win32.                                                  *
*                                                                             *
* By using this program or any included part the users assumes full respon-   *
*   -sibility for it's use and may not hold the author liable for any loss or *
*   damage. If unable to accept this condition, the program and all included  *
*   parts may not be used and must be destroyed immediately.                  *
******************************************************************************/

#include "windows.h"

//  === Function Prototypes for DLL functions =================================

BOOL CALLBACK SetLocalName( LPSTR );
BOOL CALLBACK SetSharedName( LPSTR );
BOOL CALLBACK GetLocalName( LPSTR );
BOOL CALLBACK GetSharedName( LPSTR );

//  === Function Prototypes for this Module ===================================

LRESULT WINAPI MainWndProc( HWND, UINT, WPARAM, LPARAM );

//  === Global Variables ======================================================

HINSTANCE hInst;                                //  Application instance handle
HWND hMainWnd;                                           //  Main window handle

//  === Application Entry Point ===============================================

int APIENTRY WinMain( HINSTANCE hInstance, HINSTANCE hPrev, LPSTR lpCmd,
							 int nShow )
{
	WNDCLASS wc;
	MSG msg;


	wc.style = 0;
	wc.lpfnWndProc = MainWndProc;             //  Register the main window class
	wc.hInstance = hInstance;
	wc.lpszClassName = "DLLTEST";
	wc.lpszMenuName = wc.lpszClassName;
	wc.hIcon = LoadIcon( NULL, IDI_APPLICATION );
	wc.hCursor = LoadCursor( NULL, IDC_ARROW );
	wc.hbrBackground = (HBRUSH)( COLOR_WINDOW + 1 );
	wc.cbClsExtra = wc.cbWndExtra = 0;
	if( ! RegisterClass( &wc ) )
		return( FALSE );                           //  Fail if registration fails

	hInst = hInstance;                                //  Create the main window
	hMainWnd = CreateWindow( "DLLTEST", "DLL Test", WS_OVERLAPPEDWINDOW,
									 CW_USEDEFAULT, CW_USEDEFAULT,
									 CW_USEDEFAULT, CW_USEDEFAULT,
									 NULL, NULL, hInstance, NULL );
	if( ! hMainWnd )
		return( FALSE );                            //  Quit if main window fails

	ShowWindow( hMainWnd, nShow );                    //  Display the window and
	UpdateWindow( hMainWnd );                         //  start the message loop
	while( GetMessage( &msg, NULL, 0, 0 ) )
	{
		TranslateMessage( &msg );
		DispatchMessage( &msg );
	}
	return( FALSE );
}                                                          //  End of WinMain()

//  ===  Main Window Procedure ================================================

LRESULT WINAPI MainWndProc( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam )
{
	switch( msg )
	{
		case WM_CREATE:                        //  When this window is created...
		{
			char szBuffer[ 256 ];

         wsprintf( szBuffer, "hWnd=%.8x", hWnd );       //  Set local string to
			SetLocalName( szBuffer );                        //  some unique value
			break;
		}


		case WM_DESTROY:
			PostQuitMessage( 0 );        //  Close application if window is closed
			break;


		case WM_COMMAND:
			if( wParam == 100 )                        //  If "Set" is selected...
			{
				char szBuffer[ 256 ];
                                       //  Make a string with the window handle
            wsprintf( szBuffer, "%.8x set this last", hWnd );
   			SetSharedName( szBuffer );     //  and set in the DLL shared memory
				break;
			}
			if( wParam == 102 || wParam == 103 )        //  If one of the Get's...
			{
				char szBuffer[ 256 ];

				if( wParam == 102 )
					GetLocalName( szBuffer );            //  Get the local string or
				else
					GetSharedName( szBuffer );             //  the shared string and
                                                                 //  display it
				MessageBox( hWnd, szBuffer, "Data", MB_OK );
				break;
			}
         if( wParam == 104 )
         {
            DestroyWindow( hWnd );
            break;
         }
			break;


		default:
			return( DefWindowProc( hWnd, msg, wParam, lParam ) );
	}
	return( FALSE );
}                                                      //  End of MainWndProc()

