/***************************************************************

   slidetst.c

   Tests the slider control

   Author:  Wade Cobb

   Date:    August 3, 1993

****************************************************************/
#define  STRICT
#include <windows.h>
#include <stdlib.h>
#include "slider.h"
#include "slidetst.h"

//These are globals for convenience only.
HWND        hVertEdit;
HWND        hHorzEdit;
HWND        hWndVert;
HWND        hWndHorz;
HWND        hInfo;
int         nLow,nHigh;
HINSTANCE   hInstMain;
/***************************************************************

                  Main Window Procedure

****************************************************************/
int PASCAL WinMain (HINSTANCE hInstance, 
                    HINSTANCE hPrevInstance,
                    LPSTR     lpszCmdLine, 
                    int       nCmdShow)
{
    WNDCLASS    wc;
    HWND        hWnd;
    MSG         msg;
    TEXTMETRIC  tm;
    HDC         hDC;
    WORD        cxFont;
    WORD        cyFont;


    if (!hPrevInstance)
    {
        wc.style          = CS_HREDRAW | CS_VREDRAW;
        wc.lpfnWndProc    = slidetstWndProc;
        wc.cbClsExtra     = 0;
        wc.cbWndExtra     = 0;
        wc.hInstance      = hInstance;
        wc.hIcon          = LoadIcon(hInstance, "slidetstIcon");
        wc.hCursor        = LoadCursor(NULL, IDC_ARROW);
        wc.hbrBackground  = (HBRUSH)(COLOR_WINDOW + 1);
        wc.lpszMenuName   = "slidetstMenu";
        wc.lpszClassName  = "slidetst";


        if (!RegisterClass(&wc))
            return FALSE;
    }

    hInstMain=hInstance;

    //Create and show main window.
    hWnd=CreateWindow("slidetst", "Slider Test",
                      WS_MINIMIZEBOX | WS_OVERLAPPEDWINDOW,
                      35, 35, 350, 340,
                      NULL, NULL, hInstance, NULL);

    ShowWindow(hWnd, nCmdShow);
    UpdateWindow(hWnd);

      // Force the slider dll to load
    registerSlider();

    //Get text dimensions on which to base control sizes.
    hDC=GetDC(hWnd);
    GetTextMetrics(hDC, &tm);
    cxFont=tm.tmAveCharWidth;
    cyFont=tm.tmHeight;
    ReleaseDC(hWnd, hDC);

    hVertEdit=CreateWindow("edit", "50",
                 WS_VISIBLE | WS_CHILD | ES_LEFT | WS_BORDER,
                 2+10*cxFont, 2, 10*cxFont, (cyFont*3)/2,
                 hWnd, (HMENU)ID_VERTEDIT, hInstance, 0L);

    SendMessage(hVertEdit, EM_LIMITTEXT, 2, 0L);

    /*
     * Width is forced odd with 1+(2*cxFont) so the small triangle
     * looks perfectly centered.  Simple aesthetics.
     *
     * Parent window is default associate.
     */

    hWndVert=CreateWindow("slider", "30,6000,35",
                 WS_VISIBLE | WS_CHILD | 
                 SCS_VERTICAL|SCS_TEXTHASRANGE|
                 SCS_RIGHTTICKS|SCS_LEFTTICKS,
                 2+20*cxFont+4, 2, 40, 180,
                 hWnd, (HMENU)ID_VERTSCROLL, hInstance, 0L);

    //Create a horizonal edit control with a horizontal slider
    hHorzEdit=CreateWindow("edit", "50",
                 WS_VISIBLE | WS_CHILD | ES_LEFT | WS_BORDER,
                 2, 180, 10*cxFont, (cyFont*3)/2,
                 hWnd, (HMENU)ID_HORZEDIT, hInstance, 0L);

    //Parent window is default associate.
    hWndHorz=CreateWindow("slider", "1,32767,50",
                 WS_VISIBLE | WS_CHILD | 
                 SCS_HORIZONTAL|
                 SCS_TEXTHASRANGE|SCS_TOPTICKS|SCS_BOTTOMTICKS,
                 2, 216, 280, 40,
                 hWnd, (HMENU)ID_HORZSCROLL, hInstance, 0L);

    hInfo=CreateWindow("static", "",
                 WS_VISIBLE | WS_CHILD,
                 2, 260, 200, 20,
                 hWnd, (HMENU)ID_INFO, hInstance, 0L);


    while (GetMessage(&msg, NULL, 0, 0))
    {
        TranslateMessage(&msg);
        DispatchMessage(&msg);
    }

    return msg.wParam;
}



/*
 * slidetstWndProc
 *
 * Purpose:
 *  Window class procedure.  Standard callback.
 *
 * Parameters:
 *  The standard.  See Section 2.4 Windows SDK Guide to Programming,
 *  page 2-4.
 *
 * Return Value:
 *  See Parameters, above.
 *
 */

long FAR PASCAL slidetstWndProc(HWND hWnd, UINT iMessage,
			       WPARAM wParam, LPARAM lParam)
{
    short       wPos;
    char        szNum[200];
    int         nNum;
    LONG        lVal;
    FARPROC     fp;

    switch (iMessage)
        {
        case WM_CREATE:
            break;

        case WM_DESTROY:
            PostQuitMessage(0);
            break;

        case WM_CTLCOLOR:
            if ( (HWND)LOWORD(lParam)==hWndVert ||
                 (HWND)LOWORD(lParam)==hWndHorz)
            {
               SetBkColor((HDC)wParam,RGB(192,192,192));
            }
            break;

        case WM_COMMAND:
            switch (wParam)
                {
                case IDM_EXIT:
                    PostMessage(hWnd, WM_CLOSE, 0, 0L);
                    break;

                case IDM_ENABLEVERT:
                    EnableWindow(hWndVert,TRUE);
                    break;

                case IDM_DISABLEVERT:
                    EnableWindow(hWndVert,FALSE);
                    break;

                case IDM_ENABLEHORZ:
                    EnableWindow(hWndHorz,TRUE);
                    break;

                case IDM_DISABLEHORZ:
                    EnableWindow(hWndHorz,FALSE);
                    break;

                case IDM_GETRANGEHORZ:
                    lVal=SendMessage(hWndHorz,SCM_GETRANGE,0,0L);
                    wsprintf(szNum,"%d to %d",
                             LOWORD(lVal),HIWORD(lVal));
                    MessageBox(hWnd,szNum,"Horizontal Range",MB_OK);
                    break;

                case IDM_GETRANGEVERT:
                    lVal=SendMessage(hWndVert,SCM_GETRANGE,0,0L);
                    wsprintf(szNum,"%d to %d",
                             LOWORD(lVal),HIWORD(lVal));
                    MessageBox(hWnd,szNum,"Vertical Range",MB_OK);
                    break;

                case IDM_SETRANGEVERT:
                    fp=MakeProcInstance((FARPROC)setRangeDlgProc,hInstMain);     
                    if (DialogBox(hInstMain,"SETRANGE",
                                  hWnd,(DLGPROC)setRangeDlgProc))
                    {
                        SendMessage(hWndVert,SCM_SETRANGE,
                                    0,MAKELONG(nLow,nHigh));
                    }
                    FreeProcInstance(fp);
                    break;

                case IDM_SETRANGEHORZ:
                    fp=MakeProcInstance((FARPROC)setRangeDlgProc,hInstMain);     
                    if (DialogBox(hInstMain,"SETRANGE",
                                  hWnd,(DLGPROC)setRangeDlgProc))
                    {
                        SendMessage(hWndHorz,SCM_SETRANGE,
                                    0,MAKELONG(nLow,nHigh));
                    }
                    FreeProcInstance(fp);
                    break;

                case IDM_SETPOSVERT:
                    GetDlgItemText(hWnd,ID_VERTEDIT,szNum,20);
                    nNum=atoi(szNum);
                    SendMessage(hWndVert,SCM_SETPOS,nNum,0L);
                    break;

                case IDM_SETPOSHORZ:
                    GetDlgItemText(hWnd,ID_HORZEDIT,szNum,20);
                    nNum=atoi(szNum);
                    SendMessage(hWndHorz,SCM_SETPOS,nNum,0L);
                    break;
                }
            break;

        case WM_HSCROLL:

              // Update edit control
            wPos=(short)SendMessage(hWndHorz,SCM_GETPOS,0,0L);
            wsprintf(szNum, "%d", wPos);
            SetDlgItemText(hWnd, ID_HORZEDIT, szNum);
            break;


        case WM_VSCROLL:

                  // Update edit control
            wPos=(short)SendMessage(hWndVert,SCM_GETPOS,0,0L);
            wsprintf(szNum, "%d", wPos);
            SetDlgItemText(hWnd, ID_VERTEDIT, szNum);
            break;

        default:
            return (DefWindowProc(hWnd, iMessage, wParam, lParam));
        }

    return 0L;
}

/***************************************************************

   setRangeDlgProc

   Dialog proc for the set range dialog box

****************************************************************/
BOOL	 FAR PASCAL setRangeDlgProc(HWND hWnd, UINT message, 
                                  WPARAM wParam, LPARAM lParam)
{
static char     szVal[20];

   switch (message)
   {
      case WM_COMMAND:
         switch (wParam)
         {
            case IDOK:
               GetDlgItemText(hWnd,IDC_LOW,szVal,20);
               nLow=atoi(szVal);
               GetDlgItemText(hWnd,IDC_HIGH,szVal,20);
               nHigh=atoi(szVal);
               EndDialog(hWnd,TRUE);
               break;

            case IDCANCEL:
               EndDialog(hWnd,FALSE);
               break;

            default:
               return FALSE;

         }
         break;

      default:
         return FALSE;
   }
   return TRUE;
}


