//
//              VPEDEMO.CPP
//              ===========
//
// Demonstration of VPE
//
// 1995, 1996 by IDEAL Software, T. Radde
//

#include <windows.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <time.h>

#include "vpiface.h"
#include "vpecomon.h"
#include "colors.h"
#include "vpedemo.rh"



//----------------------------------------------------------------------------
// Defines:
//----------------------------------------------------------------------------



//----------------------------------------------------------------------------
// Prototypes:
//----------------------------------------------------------------------------
// "Hidden" in VPENGINE.DLL:
BOOL FAR PASCAL _export InitCtl3d(HINSTANCE hInstance);
void FAR PASCAL _export UnInstallCtl3d(HINSTANCE hInstance);



//----------------------------------------------------------------------------
// Globals:
//----------------------------------------------------------------------------
HWND hMainWindow;
HWND hMainDlg;

long Precision = 0;
long PBackGnd = 0;
long Speed = 0;
long Colors = 0;
long Report = 0;
long Render = 0;


char *DemoText =
"The moment of impact bursts through the silence and in a roar of sound, the "
"final second is prolonged in a world of echoes as if concrete and clay of "
"Broadway itself was reliving its memories.\n"
"The last great march past. Newsman stands limp as a whimper as audience and "
"eventare locked as one. Bing Crosby coos 'You don't have to feel pain "
"to sing the blues, you don't have to holla - you don't feel a thing in your "
"dollar collar.' Martin Luther cries 'Everybody Sing!' and rings the grand old "
"liberty bell. Leary, weary of his prison cell, walks on heaven, talks on hell.\n"
"Who needs Medicare and the 35c flat rate fare, when Fred Astaire and "
"Ginger Rogers are dancing through the air? From Broadway Melody stereotypes "
"the band returns to 'Stars and Stripes' bringing a tear to the moonshiner, "
"who's been pouring out his spirit from the illegal still. The pawn broker "
"clears the noisy till and clutches his lucky dollar bill.\n"
"Then the blackout.\n\n"
"(Genesis, 'The Lamb lies down on Broadway')";



//----------------------------------------------------------------------------
//                               Precision
//----------------------------------------------------------------------------
#define HEADLINE 1      // ordinal for storing a setting


// Page 1 of Precision demo
// ========================
void page1(long hdoc)
{
   int y;
   
   y = VpeWriteBox(hdoc, 575, 200, 1625, -1,
   "[Center PenSize 3]This demo shows the capabilities and precision of VPE.\n"
   "Print this page and compare not only the "
   "positions of the frames,\nbut the positions of each letter that can be seen.\n"
   "(Switch the grid on.)\n"
   "This is true WYSIWYG !!!\n('What you see is what you get')\n"
   "Note, that the nearest result can be seen at a scaling of 1:1.\n"
   "With every other scaling you get 'best results' in comparison to execution speed.");
   
   y = VpeWriteBox(hdoc, 100, y + 75, 2000, -1,
   "['Arial' FontSize 14 Left Bold Italic Underline PenSize 0]"
   "RIGHT ALIGNED, 0.25 cm blue frame, light-blue backgr., red bold text, Arial 9pt");
   VpeStoreSet(hdoc, HEADLINE);
   
   VpeSelectFont(hdoc, "Arial", 9);
   VpeSetPen(hdoc, 25, PS_SOLID, COLOR_BLUE);
   VpeSetTextColor(hdoc, COLOR_LTRED);
   VpeSetFontAttr(hdoc, ALIGN_RIGHT, 1, 0, 0);
   VpeSetTransparentMode(hdoc, 0);
   VpeSetBkgColor(hdoc, COLOR_CYAN);
   // y+30 because frame = 0.25cm --> frame drawn around center of coordinates
   // we also want a little gap between the headline and the frame
   y = VpeWriteBox(hdoc, 150, y + 30, 1850, -1, DemoText);
   VpeSetTransparentMode(hdoc, 1);

   VpeUseSet(hdoc, HEADLINE);
   y = VpeWrite(hdoc, 250, y + 75, 2000, -1, "JUSTIFIED, no frame, Times New Roman 11pt");
   
   VpeSelectFont(hdoc, "Times New Roman", 11);
   VpeSetFontAttr(hdoc, ALIGN_JUSTIFIED, 0, 0, 0);
   y = VpeWriteBox(hdoc, 250, y + 20, 1550, -1, DemoText);

   VpeUseSet(hdoc, HEADLINE);
   y = VpeWriteBox(hdoc, 250, y + 75, 2000, -1, "CENTERED, thin yellow frame, Times New Roman 11pt");
   
   VpeSelectFont(hdoc, "Times New Roman", 11);
   VpeSetFontAttr(hdoc, ALIGN_CENTER, 0, 0, 0);
   VpeSetPen(hdoc, 5, PS_SOLID, COLOR_LTYELLOW);
   y = VpeWriteBox(hdoc, 150, y + 20, 1850, -1, DemoText);
}








// Page 2 of Precision demo
// ========================
void page2(long hdoc)
{
   int y;
   
   VpePageBreak(hdoc);
   VpeUseSet(hdoc, HEADLINE);
   y = VpeWriteBox(hdoc, 200, 200, 2000, -1, "An example of drawing (better to turn the grid off here):");
   VpeSetPen(hdoc, 8, PS_SOLID, COLOR_BLACK);
   VpeBox(hdoc, 200, 300, 1700, 1800);
   VpeSetPen(hdoc, 3, PS_SOLID, COLOR_BLACK);
        
   double xr = 6, xstep = xr / 750;
   double yr = 18;
   double x;
   char s[160];
   int index, skip, first, xx, oldy, segments=0;
   long p;

   // The following graph is created with VpeAddPolyPoint().
   // Note, that all routines contain complex handling of clipping.
   x = -xr;
   skip = 0;
   VpeSetPen(hdoc, 2, PS_SOLID, COLOR_BLUE);
   p = VpePolyLine(hdoc, 0, 1500);
        
   for (xx = 200; xx < 1700; xx++)
   {
      y = 1050 - (pow(x, 3) - 2*pow(x, 2) - 8*x) / ( yr / 750);
      x += xstep;
      
      if (y < 300)
      {
         y = 300;
         skip = 1;
         continue;
      }
      else if (y > 1800)
      {
         y = 1800;
         skip = 1;
         continue;
      }
      
      if (skip == 1)
      {
         VpeAddPolyPoint(hdoc, p, -1, -1);
         oldy = y;
         skip = 2;
      }
      else
      {
         if (skip == 2)
         {
            VpeAddPolyPoint(hdoc, p, xx-1, oldy);
            skip = 0;
         }
         VpeAddPolyPoint(hdoc, p, xx, y);
         segments++;
      }
   }
        


   // The following graph is created directly with VpePolyLine()
   POINT *points = (POINT *)malloc(3 * 1500 * sizeof(POINT));
   x = -xr;
   first = 1;
   VpeSetPen(hdoc, 2, PS_SOLID, COLOR_LTRED);
   index = 0;
   for (xx = 200; xx < 1700; xx++)
   {
      y = 1050 - (3*pow(x, 2) - 4*x - 8) / ( yr / 750);
      x += xstep;
      
      if (y < 300)
      {
         y = 300;
         skip = 1;
         continue;
      }
      else if (y > 1800)
      {
         y = 1800;
         skip = 1;
         continue;
      }
      
      if (skip == 1)
      {
         if (index > 0)    // Array must not begin with -1,-1 pair!
         {
            points[index].x = -1;
            points[index].y = -1;
         }
         // don't increment index here, so we don't have multiple
         // (redundant AND FORBIDDEN) -1, -1 pairs in the array
         oldy = y;
         skip = 2;
      }
      else
      {
         if (skip == 2)
         {
            if (index > 0)
               index++;
            points[index].x = xx - 1;
            points[index].y = oldy;
            index++;
            skip = 0;
         }
         points[index].x = xx;
         points[index].y = y;
         index++;
         segments++;
      }
   }
   
   VpePolyLine(hdoc, points, index);
   free(points);
        


   // The following graph is created "manually" VpeLine()
   // Never use it for such tasks, it's slow and memory exhausting
   // in comparision to VpePolyLine()
   x = -xr;
   first = 1;
   VpeSetPen(hdoc, 2, PS_SOLID, COLOR_GREEN);
   for (xx = 200; xx < 1700; xx++)
   {
      y = 1050 - (3*x - 4) / ( yr / 750);
      x += xstep;
      
      if (y < 300)
      {
         y = 300;
         first = 1;
         continue;
      }
      else if (y > 1800)
      {
         y = 1800;
         first = 1;
         continue;
      }
      
      if (first)
         oldy = y;
      else
      {
         VpeLine(hdoc, xx-1, oldy, xx, y);
         segments++;
         oldy = y;
      }
      first = 0;
   }


   VpeSetPen(hdoc, 3, PS_SOLID, COLOR_BLACK);
   VpeLine(hdoc, 200, 1050, 1700, 1050);
   VpeLine(hdoc, 950, 300, 950, 1800);

   VpeSelectFont(hdoc, "Arial", 10);
   VpeSetFontAttr(hdoc, ALIGN_LEFT, 0, 0, 0);
   VpeSetPen(hdoc, 1, PS_DOT, COLOR_BLACK);
   for (xx = 1; xx < xr; xx++)
   {
      VpeLine(hdoc, 950 + xx * 750 / 6, 300, 950 + xx * 750 / 6, 1800);
      wsprintf(s, "%d", xx);
      VpePrint(hdoc, 960 + xx * 750 / 6, 1050, s);
      VpeLine(hdoc, 950 - xx * 750 / 6, 300, 950 - xx * 750 / 6, 1800);
      wsprintf(s, "%d", -xx);
      VpePrint(hdoc, 960 - xx * 750 / 6, 1050, s);
   }

   for (y = 2; y < yr; y += 2)
   {
      VpeLine(hdoc, 200, 1050 + y * 750 / yr, 1700, 1050 + y * 750 / yr);
      wsprintf(s, "%d", y);
      VpePrint(hdoc, 960, 1050 - y * 750 / yr, s);
      VpeLine(hdoc, 200, 1050 - y * 750 / yr, 1700, 1050 - y * 750 / yr);
      wsprintf(s, "%d", -y);
      VpePrint(hdoc, 960, 1050 + y * 750 / yr, s);
   }

   y = 1850;
   wsprintf(s, "[S 14]The three graphs together consist of %d (number determined during runtime) single lines!\n\nVPE manages this data bulk for you FAST!", segments);
   VpeWrite(hdoc, 200, y, 2000, -1, s);
}











// Page 3 and 4 of Precision demo
// ==============================
void page3_4(long hdoc)
{
   int y;
   
   VpePageBreak(hdoc);

   VpeNoPen(hdoc);
   VpeSetFontAttr(hdoc, ALIGN_CENTER, 0, 1, 0);
   VpeSelectFont(hdoc, "Arial", 18);
   VpeWrite(hdoc, 0, 150, 2100, 300, "The supported barcode-types:");
   VpeSelectFont(hdoc, "Arial", 10);
   VpeSetBold(hdoc, 1);
   
   VpeWrite(hdoc, 200, 300, 550, 400, "2 of 5:");
   VpeBarcode(hdoc, 200, 360, 550, 560, BCT_2OF5, "123789", NULL);

   VpeWrite(hdoc, 700, 300, 1200, 400, "Interleaved 2 of 5:");
   VpeBarcode(hdoc, 700, 360, 1200, 560, BCT_INTERLEAVED2OF5, "123895783482", NULL);

   VpeWrite(hdoc, 1350, 300, 1750, 400, "Code 39 (text on top):");
   VpeSetBarcodeParms(hdoc, 1, 0);
   VpeBarcode(hdoc, 1350, 360, 1750, 560, BCT_CODE39, "ABC123", NULL);

   VpeWrite(hdoc, 200, 700, 550, 800, "Code 93 (rotated):");
   VpeSetBarcodeParms(hdoc, 0, 0);
   VpeSetRotation(hdoc, 900);
   VpeBarcode(hdoc, 275, 760, -300, -200, BCT_CODE93, "DEF987", NULL);

   VpeWrite(hdoc, 700, 700, 1200, 800, "[Rot 0]Codabar (rotated):");
   VpeSetRotation(hdoc, 1800);
   VpeBarcode(hdoc, 700, 760, -500, -200, BCT_CODABAR, "123456", NULL);

   VpeWrite(hdoc, 1400, 700, 1700, 800, "[Rot 0]EAN-8 (rotated):");
   VpeSetRotation(hdoc, 2700);
   VpeBarcode(hdoc, 1450, 760, -300, -200, BCT_EAN8, "40167794", NULL);

   VpeWrite(hdoc, 200, 1200, 500, 1400, "[Rot 0]EAN-8 + 2:");
   VpeSetBarcodeParms(hdoc, 0, 1);
   VpeBarcode(hdoc, 200, 1260, 500, 1460, BCT_EAN8_2, "12345670", "12");

   VpeWrite(hdoc, 700, 1200, 1200, 1400, "EAN-8 + 5:");
   VpeSetBarcodeParms(hdoc, 0, 0);
   VpeBarcode(hdoc, 700, 1260, 1200, 1460, BCT_EAN8_5, "98765430", "12345");

   VpeWrite(hdoc, 1350, 1200, 1750, 1400, "EAN-13:");
   VpeBarcode(hdoc, 1350, 1260, 1750, 1460, BCT_EAN13, "9781556153952", NULL);

   VpeWrite(hdoc, 200, 1600, 600, 1800, "EAN-13 + 2:");
   VpeBarcode(hdoc, 200, 1660, 600, 1860, BCT_EAN13_2, "4501645096787", "12");

   VpeWrite(hdoc, 700, 1600, 1200, 1800, "EAN-13 + 5:");
   VpeSetBarcodeParms(hdoc, 0, 1);
   VpeBarcode(hdoc, 700, 1660, 1200, 1860, BCT_EAN13_5, "9781556153952", "12345");

   VpeWrite(hdoc, 1350, 1600, 1750, 1800, "EAN-128 A:");
   VpeSetBarcodeParms(hdoc, 0, 0);
   VpeBarcode(hdoc, 1350, 1660, 1750, 1860, BCT_EAN128A, "EAN-128 A", NULL);

   VpeWrite(hdoc, 200, 2000, 600, 2200, "EAN-128 B:");
   VpeBarcode(hdoc, 200, 2060, 600, 2260, BCT_EAN128B, "ean-128 b", NULL);

   VpeWrite(hdoc, 700, 2000, 1200, 2200, "EAN-128 C:");
   VpeBarcode(hdoc, 700, 2060, 1200, 2260, BCT_EAN128C, "128902", NULL);

   VpeWrite(hdoc, 1350, 2000, 1850, 2200, "POSTNET (1.20) 5 or 9 digits:");
   VpeBarcode(hdoc, 1350, 2060, 1628, 2120, BCT_POSTNET, "12345", NULL);
   VpeBarcode(hdoc, 1350, 2150, 1850, 2210, BCT_POSTNET, "414649623", NULL);

   VpePageBreak(hdoc);

   VpeSetFontAttr(hdoc, ALIGN_CENTER, 0, 1, 0);
   VpeSelectFont(hdoc, "Arial", 18);
   VpeWrite(hdoc, 0, 150, 2100, 300, "The supported barcode-types (continued):");
   VpeSelectFont(hdoc, "Arial", 10);
   VpeSetBold(hdoc, 1);

   VpeWrite(hdoc, 200, 300, 550, 400, "UPC-A:");
   VpeBarcode(hdoc, 200, 360, 550, 560, BCT_UPCA, "07447079382", NULL);

   VpeWrite(hdoc, 700, 300, 1100, 400, "UPC-A + 2:");
   VpeBarcode(hdoc, 700, 360, 1100, 560, BCT_UPCA_2, "07447079382", "01");

   VpeWrite(hdoc, 1350, 300, 1800, 400, "UPC-A + 5:");
   VpeBarcode(hdoc, 1350, 360, 1800, 560, BCT_UPCA_5, "03126764825", "94687");

   VpeWrite(hdoc, 200, 700, 550, 900, "UPC-E:");
   VpeBarcode(hdoc, 200, 760, 550, 960, BCT_UPCE, "0378492", NULL);

   VpeWrite(hdoc, 700, 700, 1100, 900, "UPC-E + 2:");
   VpeBarcode(hdoc, 700, 760, 1100, 960, BCT_UPCE_2, "0378492", "14");

   VpeWrite(hdoc, 1350, 700, 1800, 900, "UPC-E + 5:");
   VpeBarcode(hdoc, 1350, 760, 1800, 960, BCT_UPCE_5, "0364825", "79462");

   VpeSetFontAttr(hdoc, ALIGN_LEFT, 0, 0, 0);
   y = VpeWrite(hdoc, 200, 1100, 1800, VFREE,
                "VPE supports 21 barcode types. Barcodes can be rotated in 90 degree steps, the "
                "text can be drawn on bottom or top of the barcode, and also independently "
                "the add-on text. Any of these features can be combined.");

   y = VpePrint(hdoc, 500, y+100, "[S 24 U C LtYellow]Text and images");
   VpePrint(hdoc, VRIGHT, VBOTTOM, "[Rot 900 C Blue] can be freely ");
   VpeWriteBox(hdoc, 500, VBOTTOM, VLEFT, VFREE, "[Rot 1800 C Red CE]rotated in 90");

   // The WIDTH (after rotation it's the height) is the top of the last inserted text
   // minus the bottom of the first inserted object.
   VpeWriteBox(hdoc, 400, y, -(VpeGet(hdoc, VTOP) - y), VFREE, "[Rot 2700 C Green]degree steps");
}







// Page 5 of Precision demo
// ========================
void page5(long hdoc)
{
   int y, x;
   
   VpePageBreak(hdoc);
   VpeUseSet(hdoc, HEADLINE);
   y = VpeWriteBox(hdoc, 100, 200, 2000, -1,
                   "VPE is also able to manage bitmaps for you!\n"
                   "Place your logo wherever you want.");
   y = VpeWriteBox(hdoc, 100, y, 1400, -1,
       "[S 10 L BO IO UO](Note: These are 256-color bitmaps, in 16-color mode it doesn't look very good)");

   y = VpeWriteBox(hdoc, 100, y + 50, 1400, -1, "[N B U]VPE supports the following graphics file formats:");
       VpeWriteBox(hdoc, 100, y, 1400, -1,
       "-Windows and OS/2 Bitmaps (2 / 16 / 256 / True Color)\n"
       "-Windows WMF (Metafile)\n"
       "-AutoCAD DXF\n"
       "-GIF (2 / 16 / 256 Colors)\n"
       "-PCX (2 / 16 / 256 Colors)\n"
       "-JPG (256 / True Color)\n"
       "-TIFF 5.0 (2 / 16 / 256 / True Color, LZW / PackBits / Fax G3 & G4 / Tiled Images)\n"
       "-Microsoft filters (feature, some restrictions and only 16-bit version)");
   VpeSetPen(hdoc, 5, PS_SOLID, COLOR_BLACK);
   VpePicture(hdoc, 1400, 150, -1, -1, "logo.bmp", PIC_KEEPIMAGE | PIC_KEEP_DIB_PAGE);
   y = VpeGet(hdoc, VBOTTOM);
   x = VpeGet(hdoc, VRIGHT);
   VpeWriteBox(hdoc, 1400, y, x, -1, "[N S 14 CE C White BC Red TO Italic Bold]IDEAL Software");
   VpeDefaultBitmapDPI(hdoc, 96, 96);
   VpePicture(hdoc, 1400, VpeGet(hdoc, VBOTTOM) + 100, -1, -1, "fruits.bmp", PIC_KEEPIMAGE | PIC_KEEP_DIB_PAGE);

   y = VpeWriteBox(hdoc, 150, y + 400, 1500, -1,
               "[S 14 CE PS 0]Scale your bitmaps as you like:");
   y += 20;
   VpeSetPen(hdoc, 3, PS_SOLID, COLOR_BLACK);
   VpePicture(hdoc, 150, y, 200, -1, "logo.bmp", PIC_KEEPIMAGE | PIC_KEEP_DIB_PAGE);
   VpePicture(hdoc, VpeGet(hdoc, VRIGHT) + 100, y, VpeGet(hdoc, VRIGHT) + 250, -1, "logo.bmp", PIC_KEEPIMAGE | PIC_KEEP_DIB_PAGE);
   VpePicture(hdoc, VpeGet(hdoc, VRIGHT) + 100, y, VpeGet(hdoc, VRIGHT) + 750, -1, "logo.bmp", PIC_KEEPIMAGE | PIC_KEEP_DIB_PAGE);

   y = VpeGet(hdoc, VBOTTOM) + 300;
   y = VpePrint(hdoc, 150, y, "[N U]Draw! Set the Pen, Background Color and Hatch Style:");
   y += 50;
   VpeSetTransparentMode(hdoc, 0);
   VpeSetBkgColor(hdoc, COLOR_BLUE);
   VpeBox(hdoc, 150, y, -300, -300);

   VpeSetHatchStyle(hdoc, HS_BDIAGONAL);
   VpeSetHatchColor(hdoc, COLOR_BLUE);
   VpeSetBkgColor(hdoc, COLOR_LTYELLOW);
   VpeNoPen(hdoc);
   long p = VpePolygon(hdoc, NULL, 4);
   VpeAddPolygonPoint(hdoc, p, 250, y+400);
   VpeAddPolygonPoint(hdoc, p, 500, y+600);
   VpeAddPolygonPoint(hdoc, p, 300, y+700);
   VpeAddPolygonPoint(hdoc, p, 150, y+1000);

   VpeSetPen(hdoc, 6, PS_SOLID, COLOR_BLACK);
   p = VpePolygon(hdoc, NULL, 4);
   VpeAddPolygonPoint(hdoc, p, 650, y);
   VpeAddPolygonPoint(hdoc, p, 1000, y+200);
   VpeAddPolygonPoint(hdoc, p, 700, y+300);
   VpeAddPolygonPoint(hdoc, p, 550, y+600);

   VpeNoPen(hdoc);
   VpeSetHatchStyle(hdoc, HS_DIAGCROSS);
   VpeSetHatchColor(hdoc, COLOR_RED);
   VpeSetBkgColor(hdoc, COLOR_CYAN);
   VpeEllipse(hdoc, 750, 2150, -500, -300);

   VpeSetHatchStyle(hdoc, HS_FDIAGONAL);
   VpeSetPen(hdoc, 10, PS_SOLID, COLOR_GREEN);
   VpeSetTransparentMode(hdoc, 1);
   int y2 = VpeWrite(hdoc, 1200, y + 200, -500, -1, "[S 12 B CE]Write text beyond,");
   VpeEllipse(hdoc, 1200, y, -500, -500);
   VpeWrite(hdoc, 1200, y2, -500, -1, "or above the hatching.");

   VpeSetTransparentMode(hdoc, 0);
   VpeWriteBox(hdoc, 770, 2280, -460, -1, "[PS 3 PC Black HSN BC Cyan S 10 NB]Or blank the hatching out.");

   VpeSetTransparentMode(hdoc, 1);
}


   





// Page 6 of Precision demo
// ========================
void page6(long hdoc)
{
   VpePageBreak(hdoc);

   VpeNoPen(hdoc);
   VpePicture(hdoc, 0, 0, -1, -1, "gew.tif", PIC_KEEPIMAGE | PIC_KEEP_DIB_PAGE);
 
   VpeWrite(hdoc, 250, 110, 1200, -1, "[S 24 C LtRed L PS 0]Stadt Xhausen");
   VpeWrite(hdoc, 250, 500, 1000, -1, "[S 14 C Blue]Mustermann & Co.\nFeinkost Im- und Export");
   VpeWrite(hdoc, 1200, 460, 1700, -1, "[S 11 B]Dsseldorf");
   VpeWrite(hdoc, 250, 670, 750, -1, "Schmidt");
   VpeWrite(hdoc, 250, 840, 750, -1, "24.7. 1947");
   VpeWrite(hdoc, 500, 835, 1000, -1, "Oberammergau");
   VpeWrite(hdoc, 250, 1010, 750, -1, "Zunderstr. 93");
   VpeWrite(hdoc, 1000, 1000, 1750, -1, "0 27 84 / 16 45 98");
   VpeWrite(hdoc, 250, 1255, 1750, -1, "Willi-Graf-Str. 17");                   
   VpeWrite(hdoc, 1000, 1255, 1750, -1, "0 27 84 / 23 54 90");
   VpeWrite(hdoc, 1220, 660, 1750, -1, "Heinz - Willi");
   VpeWrite(hdoc, 1100, 1500, 1950, -1,
   "[S 10 J I]"
   "It is very important to mention here, that the bitmap form has a resolution of 96 "
   "DPI only. The print will not be very nice. Just try a 300 DPI bitmap on your own!");
}




  

  


// Precision demo
// ==============
void precision(int mode = 0)
{
   long hdoc;

   if (mode == 0)
   {
      hdoc = VpeOpenDoc(hMainWindow, "Precision + Capabilities", -1, -1, VPE_EMBEDDED | VPE_GRID_POSSIBLE | VPE_ROUTE_HELP);
      Precision = hdoc;
   }
   else
   {
      hdoc = VpeOpenDoc(hMainWindow, "Precision + Capabilities",  -1, -1, 0);
      PBackGnd = hdoc;
   }

   VpeSetAutoBreak(hdoc, AUTO_BREAK_NO_LIMITS);
   VpeSetFontAttr(hdoc, ALIGN_LEFT, 0, 1, 1);
   VpeSetPen(hdoc, 0, PS_SOLID, 0);
   VpeDefineHeader(hdoc, 100, 100, 1000, 150, "Precision + Capabilities   /  IDEAL Software");
   VpeSetUnderlined(hdoc, 0);
   VpeDefineFooter(hdoc, 1900, 2800, 2100, 2900, "Page @PAGE");

   page1(hdoc);
   page2(hdoc);
   page3_4(hdoc);
   page5(hdoc);
   page6(hdoc);

   VpeRemoveSet(hdoc, HEADLINE);
   VpeGotoPage(hdoc, 1);

   if (mode == 0)
      VpePreviewDoc(hdoc, NULL, VPE_SHOW_NORMAL);
   else
   {
      VpePrintDoc(hdoc, FALSE);
      VpeCloseDoc(hdoc);
   }
}






//----------------------------------------------------------------------------
// Report Demo
//
// This all is done manually, only for your eyes...
//----------------------------------------------------------------------------
void reporttest()
{
   long hdoc;
   int y;
    
   hdoc = VpeOpenDoc(hMainWindow, "Report", -1, -1, 0);
   VpeSetAutoBreak(hdoc, AUTO_BREAK_NO_LIMITS);
   Report = hdoc;
   VpeSetPen(hdoc, 5, PS_SOLID, COLOR_BLACK);
   VpePicture(hdoc, 1650, 150, -1, -1, "fruits.bmp", PIC_KEEPIMAGE | PIC_KEEP_DIB_PAGE);
   VpeWriteBox(hdoc, 1650, VpeGet(hdoc, VBOTTOM), VpeGet(hdoc, VRIGHT), -1, "[N S 9 CE I C Blue BC Gray TO]Fruits of Doom Software");
   y = VpeGet(hdoc, VBOTTOM) + 100;
   VpePrint(hdoc, 150, 200, "[N S 26 U]Year End Results");
   VpePrint(hdoc, 150, 400, "[N S 32]Fruits of Doom Software");

   VpeLine(hdoc, 150, y, 2000, y);
   y += 50;

   VpeNoPen(hdoc);
   VpePrintBox(hdoc, 150, y, "[N S 18 C Blue]Product: Apples");
   y = VpeGet(hdoc, VBOTTOM) + 10;
   VpePrint(hdoc, 150, y, "[S 16 C Purple]Country");
   VpePrint(hdoc, 650, y, "Quantity");
   VpePrint(hdoc, 1150, y, "Value (in $)");

   y = VpeGet(hdoc, VBOTTOM);
   VpeSetTransparentMode(hdoc, FALSE);
   VpeSetBkgColor(hdoc, COLOR_GRAY);
   VpeBox(hdoc, 150, y, 1550, y+60);
   VpeSetTransparentMode(hdoc, TRUE);
   VpePrint(hdoc, 150, y, "[S 14 C Black]Germany");
   VpeWrite(hdoc, 650, y, 900, y+60, "[R]2.450,00");
   VpeWrite(hdoc, 1150, y, 1450, y+60, "120.050,00");

   y = VpeGet(hdoc, VBOTTOM);
   VpeSetTransparentMode(hdoc, FALSE);
   VpeSetBkgColor(hdoc, COLOR_CYAN);
   VpeBox(hdoc, 150, y, 1550, y+60);
   VpeSetTransparentMode(hdoc, TRUE);
   VpePrint(hdoc, 150, y, "Great Britain");
   VpeWrite(hdoc, 650, y, 900, y+60, "2.250,00");
   VpeWrite(hdoc, 1150, y, 1450, y+60, "110.250,00");

   y = VpeGet(hdoc, VBOTTOM);
   VpeSetTransparentMode(hdoc, FALSE);
   VpeSetBkgColor(hdoc, COLOR_GRAY);
   VpeBox(hdoc, 150, y, 1550, y+60);
   VpeSetTransparentMode(hdoc, TRUE);
   VpePrint(hdoc, 150, y, "France");
   VpeWrite(hdoc, 650, y, 900, y+60, "1.700,00");
   VpeWrite(hdoc, 1150, y, 1450, y+60, "83.300,00");

   y = VpeGet(hdoc, VBOTTOM);
   VpeSetTransparentMode(hdoc, FALSE);
   VpeSetBkgColor(hdoc, COLOR_CYAN);
   VpeBox(hdoc, 150, y, 1550, y+60);
   VpeSetTransparentMode(hdoc, TRUE);
   VpePrint(hdoc, 150, y, "USA");
   VpeWrite(hdoc, 650, y, 900, y+60, "3.200,00");
   VpeWrite(hdoc, 1150, y, 1450, y+60, "156.800,00");

   y = VpeGet(hdoc, VBOTTOM);
   VpeSetTransparentMode(hdoc, FALSE);
   VpeSetBkgColor(hdoc, COLOR_GRAY);
   VpeBox(hdoc, 150, y, 1550, y+60);
   VpeSetTransparentMode(hdoc, TRUE);
   VpePrint(hdoc, 150, y, "Australia");
   VpeWrite(hdoc, 650, y, 900, y+60, "1.080,00");
   VpeWrite(hdoc, 1150, y, 1450, y+60, "52.920,00");

   y = VpeGet(hdoc, VBOTTOM);
   VpePrint(hdoc, 150, y, "Total");
   VpeWrite(hdoc, 650, y, 900, y+60, "10.680,00");
   VpeWrite(hdoc, 1150, y, 1450, y+60, "523.320,00");




   y += 210;
   VpePrintBox(hdoc, 150, y, "[N S 18 C Blue]Product: Oranges");
   y = VpeGet(hdoc, VBOTTOM) + 10;
   VpePrint(hdoc, 150, y, "[S 16 C Purple]Country");
   VpePrint(hdoc, 650, y, "Quantity");
   VpePrint(hdoc, 1150, y, "Value (in $)");

   y = VpeGet(hdoc, VBOTTOM);
   VpeSetTransparentMode(hdoc, FALSE);
   VpeSetBkgColor(hdoc, COLOR_GRAY);
   VpeBox(hdoc, 150, y, 1550, y+60);
   VpeSetTransparentMode(hdoc, TRUE);
   VpePrint(hdoc, 150, y, "[S 14 C Black]Germany");
   VpeWrite(hdoc, 650, y, 900, y+60, "[R]2.450,00");
   VpeWrite(hdoc, 1150, y, 1450, y+60, "120.050,00");

   y = VpeGet(hdoc, VBOTTOM);
   VpeSetTransparentMode(hdoc, FALSE);
   VpeSetBkgColor(hdoc, COLOR_CYAN);
   VpeBox(hdoc, 150, y, 1550, y+60);
   VpeSetTransparentMode(hdoc, TRUE);
   VpePrint(hdoc, 150, y, "Great Britain");
   VpeWrite(hdoc, 650, y, 900, y+60, "2.250,00");
   VpeWrite(hdoc, 1150, y, 1450, y+60, "110.250,00");

   y = VpeGet(hdoc, VBOTTOM);
   VpeSetTransparentMode(hdoc, FALSE);
   VpeSetBkgColor(hdoc, COLOR_GRAY);
   VpeBox(hdoc, 150, y, 1550, y+60);
   VpeSetTransparentMode(hdoc, TRUE);
   VpePrint(hdoc, 150, y, "France");
   VpeWrite(hdoc, 650, y, 900, y+60, "1.700,00");
   VpeWrite(hdoc, 1150, y, 1450, y+60, "83.300,00");

   y = VpeGet(hdoc, VBOTTOM);
   VpeSetTransparentMode(hdoc, FALSE);
   VpeSetBkgColor(hdoc, COLOR_CYAN);
   VpeBox(hdoc, 150, y, 1550, y+60);
   VpeSetTransparentMode(hdoc, TRUE);
   VpePrint(hdoc, 150, y, "USA");
   VpeWrite(hdoc, 650, y, 900, y+60, "3.200,00");
   VpeWrite(hdoc, 1150, y, 1450, y+60, "156.800,00");

   y = VpeGet(hdoc, VBOTTOM);
   VpeSetTransparentMode(hdoc, FALSE);
   VpeSetBkgColor(hdoc, COLOR_GRAY);
   VpeBox(hdoc, 150, y, 1550, y+60);
   VpeSetTransparentMode(hdoc, TRUE);
   VpePrint(hdoc, 150, y, "Australia");
   VpeWrite(hdoc, 650, y, 900, y+60, "1.080,00");
   VpeWrite(hdoc, 1150, y, 1450, y+60, "52.920,00");

   y = VpeGet(hdoc, VBOTTOM);
   VpePrint(hdoc, 150, y, "Total");
   VpeWrite(hdoc, 650, y, 900, y+60, "10.680,00");
   VpeWrite(hdoc, 1150, y, 1450, y+60, "523.320,00");



   y += 210;
   VpePrintBox(hdoc, 150, y, "[N S 18 C Blue]Product: Bananas");
   y = VpeGet(hdoc, VBOTTOM) + 10;
   VpePrint(hdoc, 150, y, "[S 16 C Purple]Country");
   VpePrint(hdoc, 650, y, "Quantity");
   VpePrint(hdoc, 1150, y, "Value (in $)");

   y = VpeGet(hdoc, VBOTTOM);
   VpeSetTransparentMode(hdoc, FALSE);
   VpeSetBkgColor(hdoc, COLOR_GRAY);
   VpeBox(hdoc, 150, y, 1550, y+60);
   VpeSetTransparentMode(hdoc, TRUE);
   VpePrint(hdoc, 150, y, "[S 14 C Black]Germany");
   VpeWrite(hdoc, 650, y, 900, y+60, "[R]2.450,00");
   VpeWrite(hdoc, 1150, y, 1450, y+60, "120.050,00");

   y = VpeGet(hdoc, VBOTTOM);
   VpeSetTransparentMode(hdoc, FALSE);
   VpeSetBkgColor(hdoc, COLOR_CYAN);
   VpeBox(hdoc, 150, y, 1550, y+60);
   VpeSetTransparentMode(hdoc, TRUE);
   VpePrint(hdoc, 150, y, "Great Britain");
   VpeWrite(hdoc, 650, y, 900, y+60, "2.250,00");
   VpeWrite(hdoc, 1150, y, 1450, y+60, "110.250,00");

   y = VpeGet(hdoc, VBOTTOM);
   VpeSetTransparentMode(hdoc, FALSE);
   VpeSetBkgColor(hdoc, COLOR_GRAY);
   VpeBox(hdoc, 150, y, 1550, y+60);
   VpeSetTransparentMode(hdoc, TRUE);
   VpePrint(hdoc, 150, y, "France");
   VpeWrite(hdoc, 650, y, 900, y+60, "1.700,00");
   VpeWrite(hdoc, 1150, y, 1450, y+60, "83.300,00");

   y = VpeGet(hdoc, VBOTTOM);
   VpeSetTransparentMode(hdoc, FALSE);
   VpeSetBkgColor(hdoc, COLOR_CYAN);
   VpeBox(hdoc, 150, y, 1550, y+60);
   VpeSetTransparentMode(hdoc, TRUE);
   VpePrint(hdoc, 150, y, "USA");
   VpeWrite(hdoc, 650, y, 900, y+60, "3.200,00");
   VpeWrite(hdoc, 1150, y, 1450, y+60, "156.800,00");

   y = VpeGet(hdoc, VBOTTOM);
   VpeSetTransparentMode(hdoc, FALSE);
   VpeSetBkgColor(hdoc, COLOR_GRAY);
   VpeBox(hdoc, 150, y, 1550, y+60);
   VpeSetTransparentMode(hdoc, TRUE);
   VpePrint(hdoc, 150, y, "Australia");
   VpeWrite(hdoc, 650, y, 900, y+60, "1.080,00");
   VpeWrite(hdoc, 1150, y, 1450, y+60, "52.920,00");

   y = VpeGet(hdoc, VBOTTOM);
   VpePrint(hdoc, 150, y, "Total");
   VpeWrite(hdoc, 650, y, 900, y+60, "10.680,00");
   VpeWrite(hdoc, 1150, y, 1450, y+60, "523.320,00");

   y = VpeGet(hdoc, VBOTTOM) + 210;
   VpePrint(hdoc, 150, y, "[N S 20 U]Yearly Country Sales Total: $1.569.960,00");

   // Draw a pie
   // use the VpeGet()-stuff to easily position this anywhere on the paper
   // ====================================================================
   VpePageBreak(hdoc);
   VpeSelectFont(hdoc, "Times New Roman", 12);
   VpePrint(hdoc, 200, VBOTTOM, "[N S 18 U]Analyze of Paradise:");
   VpeSetPen(hdoc, 3, PS_SOLID, COLOR_BLACK);
   VpeSetTransparentMode(hdoc, FALSE);
   VpeSetBkgColor(hdoc, COLOR_RED);

   VpePie(hdoc, 200, VpeGet(hdoc, VBOTTOM) + 100, -600, -600, 0, 300);
   VpeStorePos(hdoc);
   VpeBox(hdoc, VpeGet(hdoc, VRIGHT) + 200, VpeGet(hdoc, VTOP) + 20, -30, -30);
   VpePrint(hdoc, VpeGet(hdoc, VRIGHT) + 30, VpeGet(hdoc, VTOP) - 10, "[N T]Apples");

   VpeRestorePos(hdoc);
   VpeSetBkgColor(hdoc, COLOR_BLUE);
   VpePie(hdoc, VLEFT, VTOP, VRIGHT, VBOTTOM, 300, 750);
   VpeStorePos(hdoc);
   VpeBox(hdoc, VpeGet(hdoc, VRIGHT) + 200, VpeGet(hdoc, VTOP) + 70, -30, -30);
   VpePrint(hdoc, VpeGet(hdoc, VRIGHT) + 30, VpeGet(hdoc, VTOP) - 10, "[N T]Oranges");

   VpeRestorePos(hdoc);
   VpeSetBkgColor(hdoc, COLOR_LTYELLOW);
   VpePie(hdoc, VLEFT, VTOP, VRIGHT, VBOTTOM, 750, 1500);
   VpeStorePos(hdoc);
   VpeBox(hdoc, VpeGet(hdoc, VRIGHT) + 200, VpeGet(hdoc, VTOP) + 120, -30, -30);
   VpePrint(hdoc, VpeGet(hdoc, VRIGHT) + 30, VpeGet(hdoc, VTOP) - 10, "[N T]Bananas");

   VpeRestorePos(hdoc);
   VpeSetBkgColor(hdoc, COLOR_GREEN);
   VpePie(hdoc, VLEFT, VTOP, VRIGHT, VBOTTOM, 1500, 2900);
   VpeStorePos(hdoc);
   VpeBox(hdoc, VpeGet(hdoc, VRIGHT) + 200, VpeGet(hdoc, VTOP) + 170, -30, -30);
   VpePrint(hdoc, VpeGet(hdoc, VRIGHT) + 30, VpeGet(hdoc, VTOP) - 10, "[N T]Cherries");

   VpeRestorePos(hdoc);
   VpeSetBkgColor(hdoc, COLOR_CYAN);
   VpePie(hdoc, VLEFT, VTOP, VRIGHT, VBOTTOM, 2900, 0);
   VpeStorePos(hdoc);
   VpeBox(hdoc, VpeGet(hdoc, VRIGHT) + 200, VpeGet(hdoc, VTOP) + 220, -30, -30);
   VpePrint(hdoc, VpeGet(hdoc, VRIGHT) + 30, VpeGet(hdoc, VTOP) - 10, "[N T]Coconuts");

   VpeSetTransparentMode(hdoc, TRUE);

   VpeGotoPage(hdoc, 1);
   VpePreviewDoc(hdoc, NULL, VPE_SHOW_NORMAL);
}







//----------------------------------------------------------------------------
//                               Colortest
//----------------------------------------------------------------------------
void colortest()
{
   const int range = 1400;
   const int step = 1;
   const int color_step = 2;
   const int min_color = 0;
   const int max_color = 255;
   
   long hdoc;
   RECT rc;
   int x, y;
   int r, g, b;
   int delta_r, delta_g, delta_b;
   double xx, factor;
   
   hdoc = VpeOpenDoc(hMainWindow, "Colors", -1, -1, VPE_NO_MOUSE_SCALE | VPE_NO_USER_MOVE | VPE_NO_USER_CLOSE | VPE_NO_STATBAR | VPE_NO_RULER | VPE_NO_HELPBTN | VPE_NO_INFOBTN);
   VpeSetAutoBreak(hdoc, AUTO_BREAK_NO_LIMITS);
   VpeSetScale(hdoc, 0.25);
   Colors = hdoc;
  
   VpeSetPen(hdoc, 0, PS_SOLID, COLOR_BLACK);
   VpeSelectFont(hdoc, "Arial", 30);

   xx = -3.1415;
   factor = 2 * fabs(xx) / (double)range * (double)step;

   r = 192;
   delta_r = color_step;
   g = min_color+1;
   delta_g = color_step;
   b = min_color+1;
   delta_b = color_step;
   
   for (x = 100; x < range+100; x+=step)
   {
     y = sin(xx) * 500.0 + 500;
     VpeSetTextColor(hdoc, RGB( r, g, b));
     VpeWriteBox(hdoc, x, y, x+800, y + 120, "Color Test");

     if (x % 10 == 0)
     {
        xx += factor;
        x += step;
        y = sin(xx) * 500.0 + 500;
        VpeSetTextColor(hdoc, COLOR_BLACK);
        VpeWriteBox(hdoc, x, y, x+800, y + 120, "Color Test");
     }
     
     xx += factor;
     if (r > min_color && r < max_color)
     {
        r += delta_r;
        if (r < min_color)
           r = min_color;
        if (r > max_color)
           r = max_color;
     }
     else if (g > min_color && g < max_color)
     {
        g += delta_g;
        if (g < min_color)
           g = min_color;
        if (g > max_color)
           g = max_color;
     }
     else if (b > min_color && b < max_color)
     {
        b += delta_b;
        if (b < min_color)
           b = min_color;
        if (b > max_color)
           b = max_color;
     }

     if (r >= max_color && b >= max_color)
     {
        delta_r = -color_step;
        r = max_color-1;
     }
     if (r >= min_color && g >= max_color)
     {
        delta_g = -color_step;
        g = max_color-1;
     }
     if (g == min_color && b >= max_color)
     {
        delta_b = -color_step;
        b = max_color-1;
     }

     if (r==min_color && g==min_color && b==min_color)
     {
        r = min_color+1; g=min_color+1; b=min_color+1;
        delta_r = delta_g = delta_b = color_step;
     }
   }

   rc.left = 0;
   rc.top = 0;
   rc.right = 280;
   rc.bottom =200;
   VpePreviewDoc(hdoc, &rc, VPE_SHOW_NORMAL);
}










// ========================================================================
//                            SpeedTest
// ========================================================================

#define RPT_PATH        "journal.rpt"


// ========================================================================
//                            Globals
// ========================================================================
double sum_amount=0, sum_prorated=0, sum_tax=0;



// ========================================================================
//                            striplf
// ========================================================================
void striplf(char *s)
{
   int i;

   for (i=strlen(s)-1; i>=0 && s[i]=='\n'; i--)
      s[i] = 0;
}






// ========================================================================
//                            stof
// ========================================================================
double stof(char *s)
{
   int i;
   char *p = s;

   while (*s)
   {
      if (*s == ',')
         *s = '.';
      else if (*s == '.')
      {
         for (i=0; s[i]; i++)
            s[i] = s[i+1];
      }
      s++;
   }

   return atof(p);
}







// ========================================================================
//                            stoDM
// ========================================================================
void stoDM(char *s)
{
   int i, begin, tocopy;
   char *p, tmp[128];
 
   strcpy(tmp, s);
   p = tmp;
 
   while (*p)
   {
      if (*p == '.')
         *p = ',';
      p++;
   }
 
   i = strlen(tmp) - 3;    // 2 Nachkommastellen und tausender-punkt
   p = tmp;
   begin = TRUE;
   *s = '\0';
 
   while (i > 0)
   {
      tocopy = i % 3;
      if (tocopy == 0)
      {
         if (!begin)
            strcat(s, ".");
         tocopy = 3;
      }
      strncat(s, p, tocopy);
      p += tocopy;
      i -= tocopy;
      begin = FALSE;
   }
 
   strcat(s, p);
}





// ========================================================================
//                              PrintJournal
//
// Structure of input-file
// =======================
// User-Name
// Year
// Start Month (or blank)
// End Month (or blank)
// <@>Table-Name --> start a new table!!!
// No.
// Date
// Amount
// Prorated Amount
// Tax
// Remark
// Remark
//
// NOTE: In this demo Y2 has a constant value for much faster processing
//
// ========================================================================

// ========================================================================
//                              GenerateReport
// ========================================================================
void GenerateReport()
{
   FILE *fh;
   int i, stepper, min, z;
   long count = 0;
   long table = 1;

   srand((int)clock());
   SetDlgItemText(hMainDlg, 110, "Generating pseudo report-file...");

   fh = fopen(RPT_PATH, "wt");
   fprintf(fh, "Test-Document\n");
   fprintf(fh, "1996\n\n");
   z = 0;
   
   while (count < 20000L)
   {
      if (z++ < rand() % 5 + 10)
      {
         stepper = 4;
         min = 3;
      }
      else
      {
         stepper = 21;
         min = 20;
         z = 0;
      }
      
      fprintf(fh, "@Table %ld\n", table++);
      for (i=rand() % stepper + min; i > 0; i--)
      {
         fprintf(fh, "%ld\n%2d.%02d.95\n", count, rand() % 28 + 1, rand() %12+1);
         fprintf(fh, "%d,%02d\n", rand(), rand() % 100);
         fprintf(fh, "%d,%02d\n", rand(), rand() % 100);
         fprintf(fh, "%d,%02d\n\n\n", rand(), rand() % 100);
         count += 7;
      }
   }

   fclose(fh);
   
   SetDlgItemText(hMainDlg, 110, "Report generation finished.");
}







// ========================================================================
//                              PrintHeader
// ========================================================================
void PrintHeader(long hdoc, char *table)
{
   VpeSetAlign(hdoc, ALIGN_CENTER);
   VpeSelectFont(hdoc, "Arial", 14);
   VpeSetBkgColor(hdoc, COLOR_LTGRAY);
   VpeWriteBox(hdoc, VLEFTMARGIN, VBOTTOM, VRIGHTMARGIN, -60, table);

   VpeSetFontAttr(hdoc, ALIGN_CENTER, 1, 0, 0);
   VpeSelectFont(hdoc, "Arial", 11);
   VpeWriteBox(hdoc, VLEFTMARGIN, VBOTTOM, -200, -50, "No.");
   VpeWriteBox(hdoc, VRIGHT, VTOP, -200, VBOTTOM, "Date");
   VpeWriteBox(hdoc, VRIGHT, VTOP, -250, VBOTTOM, "Amount");
   VpeWriteBox(hdoc, VRIGHT, VTOP, -250, VBOTTOM, "Prorated Amount");
   VpeWriteBox(hdoc, VRIGHT, VTOP, -250, VBOTTOM, "Tax");
   VpeWriteBox(hdoc, VRIGHT, VTOP, VRIGHTMARGIN, VBOTTOM, "Remark");
   VpeSetFontAttr(hdoc, ALIGN_LEFT, 0, 0, 0);
   VpeSetBkgColor(hdoc, RGB(255, 255, 255));
}




// ========================================================================
//                              PrintFooter
// ========================================================================
void PrintFooter(long hdoc)
{
   char s[20];
 
   VpeSetFontAttr(hdoc, ALIGN_CENTER, 1, 0, 0);
   VpeSetBkgColor(hdoc, COLOR_LTGRAY);
   VpeWriteBox(hdoc, VLEFTMARGIN, VBOTTOM, -400, -50, "Sum");
   VpeSetFontAttr(hdoc, ALIGN_RIGHT, 1, 0, 0);
   sprintf(s, "%.2f", sum_amount);
   stoDM(s);
   VpeWriteBox(hdoc, VRIGHT, VTOP, -250, VBOTTOM, s);
   sprintf(s, "%.2f", sum_prorated);
   stoDM(s);
   VpeWriteBox(hdoc, VRIGHT, VTOP, -250, VBOTTOM, s);
   sprintf(s, "%.2f", sum_tax);
   stoDM(s);
   VpeWriteBox(hdoc, VRIGHT, VTOP, -250, VBOTTOM, s);
   VpeWriteBox(hdoc, VRIGHT, VTOP, VRIGHTMARGIN, VBOTTOM, "");
   VpeSetFontAttr(hdoc, ALIGN_LEFT, 0, 0, 0);
   VpeSetBkgColor(hdoc, RGB(255, 255, 255));
}





// ========================================================================
//                              PrintFoot
// ========================================================================
void PrintPageFooter(long hdoc, char *name, int page)
{
   char buf[32];

   VpeStorePos(hdoc);
   VpeNoPen(hdoc);
   VpeWriteBox(hdoc, VLEFTMARGIN, VBOTTOMMARGIN, VpeGet(hdoc, VRIGHTMARGIN) - 400, -50, name);
   sprintf(buf, "Journal Page %d", page);
   VpeSetAlign(hdoc, ALIGN_RIGHT);
   VpeWriteBox(hdoc, VRIGHT, VBOTTOMMARGIN, VRIGHTMARGIN, -50, buf);
   VpeSetPen(hdoc, 3, PS_SOLID, COLOR_BLACK);
   VpeRestorePos(hdoc);
}






// ========================================================================
//                              PageBreak
// ========================================================================
void PageBreak(long hdoc, int page)
{
   char z[80];
   
   VpePageBreak(hdoc);
   
   if (page % 10 == 0)
   {
      wsprintf(z, "now reading inputfile and generating page %d", page);
      SetDlgItemText(hMainDlg, 110, z);
   }
}





// ========================================================================
//                              PrintJournal
// ========================================================================
BOOL PrintJournal()
{
   long hdoc;
   FILE *fh;
   char s[256], buf[514];
   char name[80], year[8], period[32], table[128];
   int  footer_ok = FALSE, page = 1;
 
   HCURSOR hOldCursor;
   hOldCursor = SetCursor(LoadCursor(NULL, IDC_WAIT));
   
   if ((fh=fopen(RPT_PATH, "rt")) == NULL)
   {
      SetDlgItemText(hMainDlg, 110, "ERROR: Report-file not found!");
      return FALSE;
   }
 
   hdoc = VpeOpenDoc(hMainWindow, "Speed + Tables", -1, -1, VPE_GRID_POSSIBLE);
   VpeSetAutoBreak(hdoc, AUTO_BREAK_NO_LIMITS);
   Speed = hdoc;
   VpeSetTransparentMode(hdoc, FALSE);


   // Read constant data block:
   // =========================
   fgets(name, sizeof(name), fh);
   striplf(name);
   fgets(year, sizeof(year), fh);
   striplf(year);
   fgets(s, sizeof(s), fh);
   striplf(s);
   
   if (strlen(s) > 0)
   {
      if (strncmp(s, "Month", 5) == 0)       // if "Month" possibly eliminate 2 Blanks
      {
         if (s[7] == ' ')
         {
            s[6] = s[8];
            s[7] = '\0';
         }
      }
      strcpy(period, ", ");
      strcat(period, s);
   }
   else
      *period = '\0';

   sprintf(s, "Journal %s%s", year, period);
   VpeSetPen(hdoc, 0, 0, COLOR_BLACK);
   VpeSetFontAttr(hdoc, ALIGN_CENTER, 0, 1, 0);
   VpeSelectFont(hdoc, "Arial", 16);
   VpeWriteBox(hdoc, VLEFTMARGIN, VTOPMARGIN, VRIGHTMARGIN, VFREE, s);

   VpeSetPen(hdoc, 3, PS_SOLID, COLOR_BLACK);
   VpeSetFontAttr(hdoc, ALIGN_LEFT, 0, 0, 0);
   VpeSelectFont(hdoc, "Arial", 11);

   // process variable data:
   // ======================
   while (!feof(fh) && fgets(s, sizeof(s), fh))
   {
      striplf(s);
      if (*s == '@')
      {
         // Beginning of a new table:
         // =========================
         if (footer_ok)
            PrintFooter(hdoc);
         sum_amount=sum_prorated=sum_tax=0;

         // Is the room to the page-bottom big enough for a new table ?
         if (VpeGet(hdoc, VBOTTOMMARGIN) - VpeGet(hdoc, VBOTTOM) < 400)
         {
            // No, add a new page:
            PrintPageFooter(hdoc, name, page);
            PageBreak(hdoc, page);
            page++;
         }
         else
         {
            // Beginning of new table is 1cm below previous table:
            VpeSet(hdoc, VBOTTOM, VpeGet(hdoc, VBOTTOM) + 100);
         }
         strcpy(table, s+1);
         PrintHeader(hdoc, table);
         footer_ok = FALSE;
      }
      else
      {
         // list part:
         // ==========
         footer_ok = TRUE;
         VpeSetTransparentMode(hdoc, 1);
         VpeSetAlign(hdoc, ALIGN_RIGHT);
         VpeWriteBox(hdoc, VLEFTMARGIN, VBOTTOM, -200, -50, s);

         fgets(s, sizeof(s), fh);
         striplf(s);
         VpeWriteBox(hdoc, VRIGHT, VTOP, -200, VBOTTOM, s);

         fgets(s, sizeof(s), fh);
         striplf(s);
         sum_amount += stof(s);
         stoDM(s);
         VpeWriteBox(hdoc, VRIGHT, VTOP, -250, VBOTTOM, s);

         fgets(s, sizeof(s), fh);
         striplf(s);
         sum_prorated += stof(s);
         stoDM(s);
         VpeWriteBox(hdoc, VRIGHT, VTOP, -250, VBOTTOM, s);

         fgets(s, sizeof(s), fh);
         striplf(s);
         sum_tax += stof(s);
         stoDM(s);
         VpeWriteBox(hdoc, VRIGHT, VTOP, -250, VBOTTOM, s);

         fgets(s, sizeof(s), fh);
         striplf(s);
         strcpy(buf, s);
         strcat(buf, " ");
         fgets(s, sizeof(s), fh);
         striplf(s);
         strcat(buf, s);
         VpeSetAlign(hdoc, ALIGN_LEFT);
         VpeSelectFont(hdoc, "Arial", 6);
         VpeWriteBox(hdoc, VRIGHT, VTOP, VRIGHTMARGIN, VBOTTOM, buf);
         VpeSelectFont(hdoc, "Arial", 11);
         VpeSetTransparentMode(hdoc, 0);
         
         if (VpeGet(hdoc, VBOTTOM) + 150 > VpeGet(hdoc, VBOTTOMMARGIN))
         {
            // Bottom of page reached:
            // =======================
            PrintFooter(hdoc);
            PrintPageFooter(hdoc, name, page);
            PageBreak(hdoc, page);
            page++;
            PrintHeader(hdoc, table);
         }
      } // else
   } // while
 
   fclose(fh);
 
   PrintFooter(hdoc);
   PrintPageFooter(hdoc, name, page);
 
   VpeGotoPage(hdoc, 1);
 
   wsprintf(s, "Generated %d pages out of textfile!", VpeGetPageCount(hdoc));
   VpeWriteBox(hdoc, 100, 100, 1000, 150, s);
 
   SetCursor(hOldCursor);
   SetDlgItemText(hMainDlg, 110, "");
 
   VpePreviewDoc(hdoc, NULL, VPE_SHOW_MAXIMIZED);
   
   return TRUE;
}





// ========================================================================
//                              AutoRender
// ========================================================================
#define MAX_TEXT_LEN 64000L     // due to 16-bit windows limits

void AutoRender()
{
   long hdoc, len;
   FILE *fh;
   char *text;
   HCURSOR hOldCursor;

   if ((fh=fopen(".\\c\\vpedemo.cpp", "rb")) == NULL)
   {
      SetDlgItemText(hMainDlg, 110, "ERROR: file '.\\c\\vpedemo.cpp' not found!");
      return;
   }

   hOldCursor = SetCursor(LoadCursor(NULL, IDC_WAIT));
   
   text = (char *)malloc(MAX_TEXT_LEN + 1);
   len = fread(text, 1, MAX_TEXT_LEN, fh);
   text[len] = '\0';
   fclose(fh);
   
   hdoc = VpeOpenDoc(hMainWindow, "Auto Rendering", -1, -1, VPE_GRID_POSSIBLE);
   Render = hdoc;

   VpeSelectFont(hdoc, "Courier New", 10);

   // Header will be placed outside default output rectangle:
   VpeNoPen(hdoc);
   VpeSetUnderlined(hdoc, 1);
   VpeDefineHeader(hdoc, 100, 100, -700, -50, "Auto Text Break Demo - Page @PAGE");

   // On every intial page:
   // VLEFT   = VLEFTMARGIN
   // VTOP    = VTOPMARGIN
   // VRIGHT  = VRIGHTMARGIN
   // VBOTTOM = VBOTTOMMARGIN !!!!!!!!!!
   VpeSetUnderlined(hdoc, 0);
   VpeSetPen(hdoc, 3, PS_SOLID, 0);
   VpeWriteBox(hdoc, VLEFT, VBOTTOM, VRIGHT, VFREE, "[N TO BC LtGray CE S 12 B]Start of Listing");
   VpeWriteBox(hdoc, VLEFT, VBOTTOM, VRIGHT, VFREE, text);
   VpeWriteBox(hdoc, VLEFT, VBOTTOM, VRIGHT, VFREE, "[N TO BC LtGray CE S 12 B]End of Listing");

   free(text);
   VpeGotoPage(hdoc, 1);
   SetCursor(hOldCursor);
   VpePreviewDoc(hdoc, NULL, VPE_SHOW_MAXIMIZED);
}
   






// ========================================================================
//                              DlgSelectProc
// ========================================================================
BOOL FAR PASCAL _export DlgSelectProc(HWND hDlg, UINT message, UINT wParam, LONG /* lParam */)
{
   switch (message)
   {
    case WM_INITDIALOG:
       hMainDlg = hDlg;
       return TRUE;

    case WM_COMMAND:
       SetDlgItemText(hMainDlg, 110, "");
       switch(wParam)
       {
          case ID_PRECISION:
             if (Precision)
                SetDlgItemText(hMainDlg, 110, "Precision test is already running");
             else
             {
                SetDlgItemText(hMainDlg, 110, "The window titled 'VPE' is the applications main window. It's content is an embedded window from the VPE-DLL!!! You just need a few lines of code!");
                precision();
                EnableWindow(GetDlgItem(hMainDlg, ID_CPRECISION), TRUE);
                EnableWindow(GetDlgItem(hMainDlg, ID_PAGE_LEFT), TRUE);
                EnableWindow(GetDlgItem(hMainDlg, ID_PAGE_RIGHT), TRUE);
             }
             break;
             
          case ID_CPRECISION:
             if (!VpeCloseDoc(Precision))
                SetDlgItemText(hMainDlg, 110, "Can't close, task 'precision test' is currently printing");
             break;

          case ID_PAGE_LEFT:
             VpeSetUpdate(Precision, TRUE);
             VpeGotoPage(Precision, VpeGetCurrentPage(Precision)-1);
             VpeSetUpdate(Precision, FALSE);
             break;
             
          case ID_PAGE_RIGHT:
             VpeSetUpdate(Precision, TRUE);
             VpeGotoPage(Precision, VpeGetCurrentPage(Precision)+1);
             VpeSetUpdate(Precision, FALSE);
             break;

          case ID_PBACKGND:
              SetDlgItemText(hMainDlg, 110, "Here no preview is shown. Also no printer-setup is done - the settings of the default printer are taken");
              EnableWindow(GetDlgItem(hMainDlg, ID_PBACKGND), FALSE);
             precision(1);
             break;
             

          case ID_GENERATE:
             GenerateReport();
             break;
   
          case ID_REMOVEREP:
             remove(RPT_PATH);
             break;

          case ID_SPEED:
             if (Speed)
                SetDlgItemText(hMainDlg, 110, "Speed test is already running");
             else
             {
                if (PrintJournal())
                   EnableWindow(GetDlgItem(hMainDlg, ID_CSPEED), TRUE);
             }
             break;
             
          case ID_CSPEED:
             if (!VpeCloseDoc(Speed))
                SetDlgItemText(hMainDlg, 110, "Can't close, task 'speed test' is currently printing");
             break;
             
          case ID_COLORS:
             if (Colors)
                SetDlgItemText(hMainDlg, 110, "Color test is already running");
             else
             {
                colortest();
                EnableWindow(GetDlgItem(hMainDlg, ID_CCOLORS), TRUE);
             }
             break;
             
          case ID_CCOLORS:
             if (!VpeCloseDoc(Colors))
                SetDlgItemText(hMainDlg, 110, "Can't close, task 'color test' is currently printing");
             break;

             
          case ID_REPORT:
             if (Report)
                SetDlgItemText(hMainDlg, 110, "Report test is already running");
             else
             {
                reporttest();
                EnableWindow(GetDlgItem(hMainDlg, ID_CREPORT), TRUE);
             }
             break;
             
          case ID_CREPORT:
             if (!VpeCloseDoc(Report))
                SetDlgItemText(hMainDlg, 110, "Can't close, task 'report test' is currently printing");
             break;


          case ID_AUTORENDER:
             if (Render)
                SetDlgItemText(hMainDlg, 110, "Auto Rendering Demo is already running");
             else
             {
                AutoRender();
                EnableWindow(GetDlgItem(hMainDlg, ID_CRENDER), TRUE);
             }
             break;
             
          case ID_CRENDER:
             if (!VpeCloseDoc(Render))
                SetDlgItemText(hMainDlg, 110, "Can't close, task 'Auto Render Demo' is currently printing");
             break;


          case IDOK:
          case IDCANCEL:
             if (SendMessage(hMainWindow, WM_CLOSE, 0, 0))
             {
                EndDialog(hDlg, 0);
             }
             return TRUE;
       }
       break;
   }
   
   return FALSE;
}







// ========================================================================
//                              WndProc
// ========================================================================
long FAR PASCAL _export WndProc(HWND hwnd, UINT message, UINT wParam, LONG lParam)
{
   static HANDLE  hInstance;
   static BOOL    no_close;        
   FARPROC lpfnDlgProc;
   
   switch (message)
   {
      case WM_CREATE:
         no_close = FALSE;
         hMainWindow = hwnd;
         hInstance = ((LPCREATESTRUCT) lParam)->hInstance;
         lpfnDlgProc = MakeProcInstance ((FARPROC) DlgSelectProc, hInstance);
         CreateDialog(hInstance, "DLG_TEST", hwnd, lpfnDlgProc);
         return 0;


      case VPE_DESTROYWINDOW:
         if (Precision == lParam)
         {
            Precision = 0;
            EnableWindow(GetDlgItem(hMainDlg, ID_CPRECISION), FALSE);
            EnableWindow(GetDlgItem(hMainDlg, ID_PAGE_LEFT), FALSE);
            EnableWindow(GetDlgItem(hMainDlg, ID_PAGE_RIGHT), FALSE);
         }
         else if (Speed == lParam)
         {
            Speed = 0;
            EnableWindow(GetDlgItem(hMainDlg, ID_CSPEED), FALSE);
         }
         else if (Colors == lParam)
         {
            Colors = 0;
            EnableWindow(GetDlgItem(hMainDlg, ID_CCOLORS), FALSE);
         }
         else if (Report == lParam)
         {
            Report = 0;
            EnableWindow(GetDlgItem(hMainDlg, ID_CREPORT), FALSE);
         }
         else if (Render == lParam)
         {
            Render = 0;
            EnableWindow(GetDlgItem(hMainDlg, ID_CRENDER), FALSE);
         }
         break;

                              
      case VPE_PRINT:
      case VPE_PRINTCANCEL:
         if (wParam)
         {
            no_close++;
         }
         else
         {
            no_close--;
            if (lParam == PBackGnd)
            {
               PBackGnd = 0;
               EnableWindow(GetDlgItem(hMainDlg, ID_PBACKGND), TRUE);
               if (message == VPE_PRINT)
                  SetDlgItemText(hMainDlg, 110, "Message: Background-Processing finished.");
               else
                  SetDlgItemText(hMainDlg, 110, "Message: Background-Processing aborted.");
            }
         }
         return 0;


      case VPE_HELP:
         MessageBox(hwnd, "User requested help!", "Note:", MB_OK);
         break;

      case WM_SIZE:
         if (Precision)   // this is an embedded window
         {
            MoveWindow(VpeWindowHandle(Precision), 0, 0, LOWORD(lParam), HIWORD(lParam), FALSE);
         }
         return 0;


      case WM_KEYDOWN:
         if (Precision)   // this is an embedded window
         {
            SendMessage(VpeWindowHandle(Precision), WM_KEYDOWN, wParam, lParam);
         }
         return 0;


      case WM_CLOSE:
         if (!no_close)      // can't close, because printing?
         {
            DestroyWindow(hwnd);
            return 1;
         }
         MessageBox(hwnd, "Can't close, job is printing!", "WARNING:", MB_OK);
         return 0;
                
             
      case WM_DESTROY:
         PostQuitMessage(0);
         return 0;
   }

   return DefWindowProc (hwnd, message, wParam, lParam) ;
}









// ========================================================================
//                              WinMain
// ========================================================================
int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR , int nCmdShow)
{
   static char szAppName [] = "VPE";
   MSG         msg ;
   HWND        hwnd ;
   WNDCLASS    wndclass ;

   InitCtl3d(hInstance);

   if (!hPrevInstance)
   {
      wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
      wndclass.lpfnWndProc   = WndProc ;
      wndclass.cbClsExtra    = 0 ;
      wndclass.cbWndExtra    = 0 ;
      wndclass.hInstance     = hInstance ;
      wndclass.hIcon         = LoadIcon (hInstance, "APP_ICON");
      wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
      wndclass.hbrBackground = GetStockObject (WHITE_BRUSH) ;
      wndclass.lpszMenuName  = szAppName ;
      wndclass.lpszClassName = szAppName ;
      RegisterClass(&wndclass) ;
   }

   hwnd = CreateWindow(szAppName, szAppName,
                       WS_OVERLAPPEDWINDOW,
                       CW_USEDEFAULT, CW_USEDEFAULT,
                       CW_USEDEFAULT, CW_USEDEFAULT,
                       NULL, NULL, hInstance, NULL) ;

     
   ShowWindow (hwnd, nCmdShow) ;
   UpdateWindow (hwnd) ;

   while (GetMessage (&msg, NULL, 0, 0))
   {
           TranslateMessage (&msg) ;
           DispatchMessage (&msg) ;
   }

   UnInstallCtl3d(hInstance);
   return msg.wParam;
}
