// NumberCtl.cpp : Implementation of the CNumberCtrl OLE control class.

#include "stdafx.h"
#include "Number.h"
#include "NumberCtl.h"
#include "NumberPpg.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


IMPLEMENT_DYNCREATE(CNumberCtrl, COleControl)


/////////////////////////////////////////////////////////////////////////////
// Message map

BEGIN_MESSAGE_MAP(CNumberCtrl, COleControl)
	//{{AFX_MSG_MAP(CNumberCtrl)
	// NOTE - ClassWizard will add and remove message map entries
	//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG_MAP
	ON_OLEVERB(AFX_IDS_VERB_PROPERTIES, OnProperties)
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// Dispatch map

BEGIN_DISPATCH_MAP(CNumberCtrl, COleControl)
	//{{AFX_DISPATCH_MAP(CNumberCtrl)
	DISP_PROPERTY_NOTIFY(CNumberCtrl, "Number1", m_number1, OnNumber1Changed, VT_I2)
	DISP_PROPERTY_NOTIFY(CNumberCtrl, "Number2", m_number2, OnNumber2Changed, VT_I2)
	//}}AFX_DISPATCH_MAP
	DISP_FUNCTION_ID(CNumberCtrl, "AboutBox", DISPID_ABOUTBOX, AboutBox, VT_EMPTY, VTS_NONE)
END_DISPATCH_MAP()


/////////////////////////////////////////////////////////////////////////////
// Event map

BEGIN_EVENT_MAP(CNumberCtrl, COleControl)
	//{{AFX_EVENT_MAP(CNumberCtrl)
	// NOTE - ClassWizard will add and remove event map entries
	//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_EVENT_MAP
END_EVENT_MAP()


/////////////////////////////////////////////////////////////////////////////
// Property pages

// TODO: Add more property pages as needed.  Remember to increase the count!
BEGIN_PROPPAGEIDS(CNumberCtrl, 1)
	PROPPAGEID(CNumberPropPage::guid)
END_PROPPAGEIDS(CNumberCtrl)


/////////////////////////////////////////////////////////////////////////////
// Initialize class factory and guid

IMPLEMENT_OLECREATE_EX(CNumberCtrl, "NUMBER.NumberCtrl.1",
	0x19ac0303, 0xc37f, 0x11cf, 0x97, 0x20, 0, 0x20, 0xaf, 0xf3, 0x4d, 0x4d)


/////////////////////////////////////////////////////////////////////////////
// Type library ID and version

IMPLEMENT_OLETYPELIB(CNumberCtrl, _tlid, _wVerMajor, _wVerMinor)


/////////////////////////////////////////////////////////////////////////////
// Interface IDs

const IID BASED_CODE IID_DNumber =
		{ 0x19ac0301, 0xc37f, 0x11cf, { 0x97, 0x20, 0, 0x20, 0xaf, 0xf3, 0x4d, 0x4d } };
const IID BASED_CODE IID_DNumberEvents =
		{ 0x19ac0302, 0xc37f, 0x11cf, { 0x97, 0x20, 0, 0x20, 0xaf, 0xf3, 0x4d, 0x4d } };


/////////////////////////////////////////////////////////////////////////////
// Control type information

static const DWORD BASED_CODE _dwNumberOleMisc =
	OLEMISC_ACTIVATEWHENVISIBLE |
	OLEMISC_SETCLIENTSITEFIRST |
	OLEMISC_INSIDEOUT |
	OLEMISC_CANTLINKINSIDE |
	OLEMISC_RECOMPOSEONRESIZE;

IMPLEMENT_OLECTLTYPE(CNumberCtrl, IDS_NUMBER, _dwNumberOleMisc)


/////////////////////////////////////////////////////////////////////////////
// CNumberCtrl::CNumberCtrlFactory::UpdateRegistry -
// Adds or removes system registry entries for CNumberCtrl

BOOL CNumberCtrl::CNumberCtrlFactory::UpdateRegistry(BOOL bRegister)
{
	// TODO: Verify that your control follows apartment-model threading rules.
	// Refer to MFC TechNote 64 for more information.
	// If your control does not conform to the apartment-model rules, then
	// you must modify the code below, changing the 6th parameter from
	// afxRegApartmentThreading to 0.

	if (bRegister)
		return AfxOleRegisterControlClass(
			AfxGetInstanceHandle(),
			m_clsid,
			m_lpszProgID,
			IDS_NUMBER,
			IDB_NUMBER,
			afxRegApartmentThreading,
			_dwNumberOleMisc,
			_tlid,
			_wVerMajor,
			_wVerMinor);
	else
		return AfxOleUnregisterClass(m_clsid, m_lpszProgID);
}


/////////////////////////////////////////////////////////////////////////////
// CNumberCtrl::CNumberCtrl - Constructor

CNumberCtrl::CNumberCtrl()
{
	InitializeIIDs(&IID_DNumber, &IID_DNumberEvents);

	// TODO: Initialize your control's instance data here.
}


/////////////////////////////////////////////////////////////////////////////
// CNumberCtrl::~CNumberCtrl - Destructor

CNumberCtrl::~CNumberCtrl()
{
	// TODO: Cleanup your control's instance data here.
}


/////////////////////////////////////////////////////////////////////////////
// CNumberCtrl::OnDraw - Drawing function

void CNumberCtrl::OnDraw(
			CDC* pdc, const CRect& rcBounds, const CRect& rcInvalid)
{
	pdc->FillRect(rcBounds, CBrush::FromHandle((HBRUSH)GetStockObject(WHITE_BRUSH)));

   // Very simple, display the two number properties

   CString  strOutput;
   strOutput.Format( "%d,%d", m_number1,m_number2 );

   pdc->TextOut(0,0,strOutput);
}


/////////////////////////////////////////////////////////////////////////////
// CNumberCtrl::DoPropExchange - Persistence support

void CNumberCtrl::DoPropExchange(CPropExchange* pPX)
{
	ExchangeVersion(pPX, MAKELONG(_wVerMinor, _wVerMajor));
	COleControl::DoPropExchange(pPX);

	// TODO: Call PX_ functions for each persistent custom property.

}


/////////////////////////////////////////////////////////////////////////////
// CNumberCtrl::OnResetState - Reset control to default state

void CNumberCtrl::OnResetState()
{
	COleControl::OnResetState();  // Resets defaults found in DoPropExchange

	// TODO: Reset any other control state here.
}


/////////////////////////////////////////////////////////////////////////////
// CNumberCtrl::AboutBox - Display an "About" box to the user

void CNumberCtrl::AboutBox()
{
	CDialog dlgAbout(IDD_ABOUTBOX_NUMBER);
	dlgAbout.DoModal();
}


/////////////////////////////////////////////////////////////////////////////
// CNumberCtrl message handlers

void CNumberCtrl::OnNumber1Changed() 
{
	// TODO: Add notification handler code

	SetModifiedFlag();
   Invalidate(TRUE);
}

void CNumberCtrl::OnNumber2Changed() 
{
	// TODO: Add notification handler code

	SetModifiedFlag();
   Invalidate(TRUE);
}
