// getadctl.cpp : Implementation of the CGetadrsCtrl OLE control class.

#include "stdafx.h"
#include "gethost.h"
#include "getadctl.h"
#include "getadppg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


IMPLEMENT_DYNCREATE(CGetadrsCtrl, COleControl)


/////////////////////////////////////////////////////////////////////////////
// Message map

BEGIN_MESSAGE_MAP(CGetadrsCtrl, COleControl)
	//{{AFX_MSG_MAP(CGetadrsCtrl)
	// NOTE - ClassWizard will add and remove message map entries
	//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG_MAP
	ON_OLEVERB(AFX_IDS_VERB_PROPERTIES, OnProperties)
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// Dispatch map

BEGIN_DISPATCH_MAP(CGetadrsCtrl, COleControl)
	//{{AFX_DISPATCH_MAP(CGetadrsCtrl)
	DISP_PROPERTY_NOTIFY(CGetadrsCtrl, "HostName", m_hostName, OnHostNameChanged, VT_BSTR)
	DISP_PROPERTY_NOTIFY(CGetadrsCtrl, "ErrorNum", m_errorNum, OnErrorNumChanged, VT_I2)
	DISP_FUNCTION(CGetadrsCtrl, "GetHostAdrs", GetHostAdrs, VT_BSTR, VTS_NONE)
	//}}AFX_DISPATCH_MAP
	DISP_FUNCTION_ID(CGetadrsCtrl, "AboutBox", DISPID_ABOUTBOX, AboutBox, VT_EMPTY, VTS_NONE)
END_DISPATCH_MAP()


/////////////////////////////////////////////////////////////////////////////
// Event map

BEGIN_EVENT_MAP(CGetadrsCtrl, COleControl)
	//{{AFX_EVENT_MAP(CGetadrsCtrl)
	//}}AFX_EVENT_MAP
END_EVENT_MAP()


/////////////////////////////////////////////////////////////////////////////
// Property pages

// TODO: Add more property pages as needed.  Remember to increase the count!
BEGIN_PROPPAGEIDS(CGetadrsCtrl, 1)
	PROPPAGEID(CGetadrsPropPage::guid)
END_PROPPAGEIDS(CGetadrsCtrl)


/////////////////////////////////////////////////////////////////////////////
// Initialize class factory and guid

IMPLEMENT_OLECREATE_EX(CGetadrsCtrl, "GETHOST.GetadrsCtrl.1",
	0x2158ea29, 0x3514, 0x11ce, 0x96, 0xf, 0x52, 0x41, 0x53, 0x48, 0x0, 0x5)


/////////////////////////////////////////////////////////////////////////////
// Type library ID and version

IMPLEMENT_OLETYPELIB(CGetadrsCtrl, _tlid, _wVerMajor, _wVerMinor)


/////////////////////////////////////////////////////////////////////////////
// Interface IDs

const IID BASED_CODE IID_DGetAdrs =
		{ 0x2158ea2a, 0x3514, 0x11ce, { 0x96, 0xf, 0x52, 0x41, 0x53, 0x48, 0x0, 0x5 } };
const IID BASED_CODE IID_DGetAdrsEvents =
		{ 0x2158ea2b, 0x3514, 0x11ce, { 0x96, 0xf, 0x52, 0x41, 0x53, 0x48, 0x0, 0x5 } };


/////////////////////////////////////////////////////////////////////////////
// Control type information

static const DWORD BASED_CODE _dwGetAdrsOleMisc =
	OLEMISC_INVISIBLEATRUNTIME |
	OLEMISC_ACTIVATEWHENVISIBLE |
	OLEMISC_SETCLIENTSITEFIRST |
	OLEMISC_INSIDEOUT |
	OLEMISC_CANTLINKINSIDE |
	OLEMISC_RECOMPOSEONRESIZE;

	
IMPLEMENT_OLECTLTYPE(CGetadrsCtrl, IDS_GETADRS, _dwGetAdrsOleMisc)


/////////////////////////////////////////////////////////////////////////////
// CGetadrsCtrl::CGetadrsCtrlFactory::UpdateRegistry -
// Adds or removes system registry entries for CGetadrsCtrl

BOOL CGetadrsCtrl::CGetadrsCtrlFactory::UpdateRegistry(BOOL bRegister)
{
	if (bRegister)
		return AfxOleRegisterControlClass(
			AfxGetInstanceHandle(),
			m_clsid,
			m_lpszProgID,
			IDS_GETADRS,
			IDB_GETADRS,
			FALSE,                      //  Not insertable
			_dwGetAdrsOleMisc,
			_tlid,
			_wVerMajor,
			_wVerMinor);
	else
		return AfxOleUnregisterClass(m_clsid, m_lpszProgID);
}


/////////////////////////////////////////////////////////////////////////////
// CGetadrsCtrl::CGetadrsCtrl - Constructor

CGetadrsCtrl::CGetadrsCtrl()
{
	InitializeIIDs(&IID_DGetAdrs, &IID_DGetAdrsEvents);

	// TODO: Initialize your control's instance data here.
}


/////////////////////////////////////////////////////////////////////////////
// CGetadrsCtrl::~CGetadrsCtrl - Destructor

CGetadrsCtrl::~CGetadrsCtrl()
{
	// TODO: Cleanup your control's instance data here.
}


/////////////////////////////////////////////////////////////////////////////
// CGetadrsCtrl::OnDraw - Drawing function

void CGetadrsCtrl::OnDraw(
			CDC* pdc, const CRect& rcBounds, const CRect& rcInvalid)
{
	// TODO: Replace the following code with your own drawing code.
	CBitmap bitmap;
	BITMAP  bmp;
	CPictureHolder picHolder;
	CRect rcSrcBounds;

	// Load bitmap
	bitmap.LoadBitmap(IDB_GETAD);
	bitmap.GetObject(sizeof(BITMAP), &bmp);
	rcSrcBounds.right = bmp.bmWidth;
	rcSrcBounds.bottom = bmp.bmHeight;

	// Create picture and render
	picHolder.CreateFromBitmap((HBITMAP)bitmap.m_hObject, NULL, FALSE);
	picHolder.Render(pdc, rcBounds, rcSrcBounds);
}


/////////////////////////////////////////////////////////////////////////////
// CGetadrsCtrl::DoPropExchange - Persistence support

void CGetadrsCtrl::DoPropExchange(CPropExchange* pPX)
{
	ExchangeVersion(pPX, MAKELONG(_wVerMinor, _wVerMajor));
	COleControl::DoPropExchange(pPX);
	// TODO: Call PX_ functions for each persistent custom property.
	PX_String(pPX,_T("HostName"),m_hostName,"");
}


/////////////////////////////////////////////////////////////////////////////
// CGetadrsCtrl::OnResetState - Reset control to default state

void CGetadrsCtrl::OnResetState()
{
	COleControl::OnResetState();  // Resets defaults found in DoPropExchange

	// TODO: Reset any other control state here.
}


/////////////////////////////////////////////////////////////////////////////
// CGetadrsCtrl::AboutBox - Display an "About" box to the user

void CGetadrsCtrl::AboutBox()
{
	CDialog dlgAbout(IDD_ABOUTBOX_GETADRS);
	dlgAbout.DoModal();
}


/////////////////////////////////////////////////////////////////////////////
// CGetadrsCtrl message handlers


BSTR CGetadrsCtrl::GetHostAdrs() 
{
	// TODO: Add your dispatch handler code here

	CString 		s;
	int    			nListen_sd, nRc;
	struct 			sockaddr_in server_addr;
	WORD			wVersionRequested;
	WSADATA 		wsaData;
	char 			IPAddress[8], HName[100];
	BOOL			optionbool;
	struct hostent* hostinfo;
	

	//Initialize error property
	m_errorNum = 0;

	//Startup the sockets library
	wVersionRequested = MAKEWORD( 1, 1 );
	m_errorNum = WSAStartup( wVersionRequested, &wsaData );
	if ( m_errorNum != 0 ) 
	{
		m_errorNum = WSAGetLastError() - WSABASEERR;
		return(0);
	}
	 		
	//Open a socket and get a handle
	nListen_sd= socket(AF_INET, SOCK_DGRAM, 0);
	if(nListen_sd < 0)
	{
		m_errorNum = WSAGetLastError() - WSABASEERR;
		return(0);
	}
	else
	{
		optionbool = TRUE;
		setsockopt(nListen_sd,SOL_SOCKET,SO_OOBINLINE,
			(const char *)&optionbool,sizeof(optionbool));
	}

	//Prepare the address structure
	server_addr.sin_family=AF_INET;
	server_addr.sin_addr.s_addr = INADDR_ANY;
	server_addr.sin_port=htons(IPPORT_NAMESERVER);   

	//Connect to a remote address
	nRc=connect(nListen_sd, (struct sockaddr far *)&server_addr, 
		sizeof(server_addr));
	if  (nRc==-1) 
	{
		m_errorNum = WSAGetLastError() - WSABASEERR;
		return(0);
	}
	
	//Prepare the name for submission and make a request for the
	//	address of the named host
	memcpy((char far *)HName,m_hostName.GetBuffer(90),90);
	hostinfo = gethostbyname(HName);
	if  (hostinfo==0) 
	{
		m_errorNum = WSAGetLastError() - WSABASEERR;
		return(0);
	}
	else
	{
		//Prepare the returned IPAddress and return
		sprintf(IPAddress,"%hu.%hu.%hu.%hu",
			(unsigned char)hostinfo->h_addr_list[0][0],
			(unsigned char)hostinfo->h_addr_list[0][1],
			(unsigned char)hostinfo->h_addr_list[0][2],
			(unsigned char)hostinfo->h_addr_list[0][3]);	
		s=IPAddress;
	}
	shutdown(nListen_sd,0);
	WSACleanup();

	return s.AllocSysString();
}



void CGetadrsCtrl::OnHostNameChanged() 
{
	// TODO: Add notification handler code

	SetModifiedFlag();
}

void CGetadrsCtrl::OnErrorNumChanged() 
{
	// TODO: Add notification handler code

	SetModifiedFlag();
}

