// timectl.cpp : Implementation of the CTimeCtrl OLE control class.

#include "stdafx.h"
#include "time.h"
#include "timectl.h"
#include "timeppg.h"

#include <winsock.h>
#include <time.h>


#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


IMPLEMENT_DYNCREATE(CTimeCtrl, COleControl)


/////////////////////////////////////////////////////////////////////////////
// Message map

BEGIN_MESSAGE_MAP(CTimeCtrl, COleControl)
	//{{AFX_MSG_MAP(CTimeCtrl)
	// NOTE - ClassWizard will add and remove message map entries
	//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG_MAP
	ON_OLEVERB(AFX_IDS_VERB_PROPERTIES, OnProperties)
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// Dispatch map

BEGIN_DISPATCH_MAP(CTimeCtrl, COleControl)
	//{{AFX_DISPATCH_MAP(CTimeCtrl)
	DISP_PROPERTY_NOTIFY(CTimeCtrl, "TimeHost", m_timeHost, OnTimeHostChanged, VT_BSTR)
	DISP_PROPERTY_NOTIFY(CTimeCtrl, "ErrorNum", m_errorNum, OnErrorNumChanged, VT_I2)
	DISP_FUNCTION(CTimeCtrl, "GetTime", GetTime, VT_BSTR, VTS_NONE)
	//}}AFX_DISPATCH_MAP
	DISP_FUNCTION_ID(CTimeCtrl, "AboutBox", DISPID_ABOUTBOX, AboutBox, VT_EMPTY, VTS_NONE)
END_DISPATCH_MAP()


/////////////////////////////////////////////////////////////////////////////
// Event map

BEGIN_EVENT_MAP(CTimeCtrl, COleControl)
	//{{AFX_EVENT_MAP(CTimeCtrl)
	// NOTE - ClassWizard will add and remove event map entries
	//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_EVENT_MAP
END_EVENT_MAP()


/////////////////////////////////////////////////////////////////////////////
// Property pages

// TODO: Add more property pages as needed.  Remember to increase the count!
BEGIN_PROPPAGEIDS(CTimeCtrl, 1)
	PROPPAGEID(CTimePropPage::guid)
END_PROPPAGEIDS(CTimeCtrl)


/////////////////////////////////////////////////////////////////////////////
// Initialize class factory and guid

IMPLEMENT_OLECREATE_EX(CTimeCtrl, "TIME.TimeCtrl.1",
	0x933ff736, 0x5091, 0x11ce, 0x96, 0xf, 0x52, 0x41, 0x53, 0x48, 0x0, 0x5)


/////////////////////////////////////////////////////////////////////////////
// Type library ID and version

IMPLEMENT_OLETYPELIB(CTimeCtrl, _tlid, _wVerMajor, _wVerMinor)


/////////////////////////////////////////////////////////////////////////////
// Interface IDs

const IID BASED_CODE IID_DTime =
		{ 0x933ff737, 0x5091, 0x11ce, { 0x96, 0xf, 0x52, 0x41, 0x53, 0x48, 0x0, 0x5 } };
const IID BASED_CODE IID_DTimeEvents =
		{ 0x933ff738, 0x5091, 0x11ce, { 0x96, 0xf, 0x52, 0x41, 0x53, 0x48, 0x0, 0x5 } };


/////////////////////////////////////////////////////////////////////////////
// Control type information

static const DWORD BASED_CODE _dwTimeOleMisc =
	OLEMISC_INVISIBLEATRUNTIME |
	OLEMISC_ACTIVATEWHENVISIBLE |
	OLEMISC_SETCLIENTSITEFIRST |
	OLEMISC_INSIDEOUT |
	OLEMISC_CANTLINKINSIDE |
	OLEMISC_RECOMPOSEONRESIZE;

IMPLEMENT_OLECTLTYPE(CTimeCtrl, IDS_TIME, _dwTimeOleMisc)


/////////////////////////////////////////////////////////////////////////////
// CTimeCtrl::CTimeCtrlFactory::UpdateRegistry -
// Adds or removes system registry entries for CTimeCtrl

BOOL CTimeCtrl::CTimeCtrlFactory::UpdateRegistry(BOOL bRegister)
{
	if (bRegister)
		return AfxOleRegisterControlClass(
			AfxGetInstanceHandle(),
			m_clsid,
			m_lpszProgID,
			IDS_TIME,
			IDB_TIME,
			TRUE,                       //  Insertable
			_dwTimeOleMisc,
			_tlid,
			_wVerMajor,
			_wVerMinor);
	else
		return AfxOleUnregisterClass(m_clsid, m_lpszProgID);
}


/////////////////////////////////////////////////////////////////////////////
// CTimeCtrl::CTimeCtrl - Constructor

CTimeCtrl::CTimeCtrl()
{
	InitializeIIDs(&IID_DTime, &IID_DTimeEvents);

	// TODO: Initialize your control's instance data here.
}


/////////////////////////////////////////////////////////////////////////////
// CTimeCtrl::~CTimeCtrl - Destructor

CTimeCtrl::~CTimeCtrl()
{
	// TODO: Cleanup your control's instance data here.
}


/////////////////////////////////////////////////////////////////////////////
// CTimeCtrl::OnDraw - Drawing function

void CTimeCtrl::OnDraw(
			CDC* pdc, const CRect& rcBounds, const CRect& rcInvalid)
{
	// TODO: Replace the following code with your own drawing code.
	CBitmap bitmap;
	BITMAP  bmp;
	CPictureHolder picHolder;
	CRect rcSrcBounds;

	// Load bitmap
	bitmap.LoadBitmap(IDB_TIME);
	bitmap.GetObject(sizeof(BITMAP), &bmp);
	rcSrcBounds.right = bmp.bmWidth;
	rcSrcBounds.bottom = bmp.bmHeight;

	// Create picture and render
	picHolder.CreateFromBitmap((HBITMAP)bitmap.m_hObject, NULL, FALSE);
	picHolder.Render(pdc, rcBounds, rcSrcBounds);
}


/////////////////////////////////////////////////////////////////////////////
// CTimeCtrl::DoPropExchange - Persistence support

void CTimeCtrl::DoPropExchange(CPropExchange* pPX)
{
	ExchangeVersion(pPX, MAKELONG(_wVerMinor, _wVerMajor));
	COleControl::DoPropExchange(pPX);

	// TODO: Call PX_ functions for each persistent custom property.

}


/////////////////////////////////////////////////////////////////////////////
// CTimeCtrl::OnResetState - Reset control to default state

void CTimeCtrl::OnResetState()
{
	COleControl::OnResetState();  // Resets defaults found in DoPropExchange

	// TODO: Reset any other control state here.
}


/////////////////////////////////////////////////////////////////////////////
// CTimeCtrl::AboutBox - Display an "About" box to the user

void CTimeCtrl::AboutBox()
{
	CDialog dlgAbout(IDD_ABOUTBOX_TIME);
	dlgAbout.DoModal();
}


/////////////////////////////////////////////////////////////////////////////
// CTimeCtrl message handlers
int CTimeCtrl::StartSockets()
{
	WORD			wVersionRequested;
	WSADATA 		wsaData;

	wVersionRequested = MAKEWORD( 1, 1 );
	if ( WSAStartup( wVersionRequested, &wsaData ) != 0 ) 
	{
		m_errorNum = WSAGetLastError() - WSABASEERR;
		return 0;
	}
	return 1;
}

 	
int CTimeCtrl::OpenSocket()
{
	skt = socket(AF_INET, SOCK_DGRAM, 0);
	if(skt < 0)
	{
		m_errorNum = WSAGetLastError() - WSABASEERR;
		return 0;
	}
	return 1;
}


int CTimeCtrl::RecvRemote(CString& buffer)
{
	int				NumOfChars;
	char 			inbuff[500];
	int				TimeOut = 2000;

	buffer.Empty();	

	setsockopt(skt,SOL_SOCKET,SO_RCVTIMEO,(const char *)&TimeOut,sizeof(TimeOut));
	
	memset(inbuff,0,sizeof(inbuff));
	NumOfChars = recv(skt, inbuff, sizeof(inbuff), 0);

	switch(NumOfChars)
	{
		case -1	:	m_errorNum = WSAGetLastError() - WSABASEERR;
					return 0;
		case 0	:	break;
		default	:	buffer = inbuff;
					break;
	}

	return 1;
}


int CTimeCtrl::SendRemote(CString buffer)
{
	if (send(skt, buffer.GetBuffer(buffer.GetLength()), buffer.GetLength(), 0)<0) 
	{
		m_errorNum = WSAGetLastError() - WSABASEERR;
		return 0;
	}
	return 1;
}


int CTimeCtrl::ConnectRemote(CString IPAdrs)
{
	struct 	sockaddr_in server_addr;
	CString	msgbuffer;

	server_addr.sin_family=AF_INET;			
	server_addr.sin_addr.s_addr = inet_addr(IPAdrs.GetBuffer(60));
	server_addr.sin_port=htons(IPPORT_TIMESERVER);

	if  (connect(skt, (struct sockaddr far *)&server_addr,sizeof(server_addr))==-1) 
	{
		m_errorNum = WSAGetLastError() - WSABASEERR;
		return 0;
	}
	
	return 1;
}


int CTimeCtrl::CloseRemote()
{	
	shutdown(skt,0);
	WSACleanup();
	return 1;
}



void CTimeCtrl::OnTimeHostChanged() 
{
	// TODO: Add notification handler code

	SetModifiedFlag();
}

void CTimeCtrl::ConvertTime(unsigned long remotetime, CString& timestr)
{
	struct tm		*tmClock;
    time_t			tClock;
    char			timebuffer[75];

	//add minutes = correction value for remote time (GMT correct if necessary)
	//BASE_TIME = correction to midnight 1/1/70
	//newtime = the time from the remote
	tClock = remotetime - 2208988800L;	/* now in UNIX format */
	tmClock = gmtime(&tClock);
	strftime(timebuffer, sizeof(timebuffer), "%a %d-%b-%Y %H:%M:%S", tmClock);

	timestr = timebuffer;
}


BSTR CTimeCtrl::GetTime() 
{
	// TODO: Add your dispatch handler code here
	CString 		s;
	unsigned long	timeval;
		
	m_errorNum = 0;

	if(!StartSockets()) return 0;

	if(!OpenSocket()) return 0;

	if(!ConnectRemote(m_timeHost)) return 0;

	s = "";
	if(!SendRemote(s)) return 0;
	if(!RecvRemote(s)) return 0;

	memcpy(&timeval,s.GetBuffer(4),4);	//Number of seconds since 00:00 1/1/1900
	//Convert the retrieved 32bit value from network to host byte order before
	//sending to function
	ConvertTime(ntohl(timeval),s);
	  
	CloseRemote();

	return s.AllocSysString();
}

void CTimeCtrl::OnErrorNumChanged() 
{
	// TODO: Add notification handler code

	SetModifiedFlag();
}

