// timectl.h : Declaration of the CTimeCtrl OLE control class.

/////////////////////////////////////////////////////////////////////////////
// CTimeCtrl : See timectl.cpp for implementation.

class CTimeCtrl : public COleControl
{
	DECLARE_DYNCREATE(CTimeCtrl)

// Constructor
public:
	CTimeCtrl();

// Overrides

	// Drawing function
	virtual void OnDraw(
				CDC* pdc, const CRect& rcBounds, const CRect& rcInvalid);

	// Persistence
	virtual void DoPropExchange(CPropExchange* pPX);

	// Reset control state
	virtual void OnResetState();

// Implementation
protected:
	~CTimeCtrl();

	DECLARE_OLECREATE_EX(CTimeCtrl)    // Class factory and guid
	DECLARE_OLETYPELIB(CTimeCtrl)      // GetTypeInfo
	DECLARE_PROPPAGEIDS(CTimeCtrl)     // Property page IDs
	DECLARE_OLECTLTYPE(CTimeCtrl)		// Type name and misc status

// Message maps
	//{{AFX_MSG(CTimeCtrl)
		// NOTE - ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

// Dispatch maps
	//{{AFX_DISPATCH(CTimeCtrl)
	CString m_timeHost;
	afx_msg void OnTimeHostChanged();
	short m_errorNum;
	afx_msg void OnErrorNumChanged();
	afx_msg BSTR GetTime();
	//}}AFX_DISPATCH
	DECLARE_DISPATCH_MAP()

	afx_msg void AboutBox();

// Event maps
	//{{AFX_EVENT(CTimeCtrl)
	//}}AFX_EVENT
	DECLARE_EVENT_MAP()

	//Socket specific members
	int	skt;

	int StartSockets();
	int OpenSocket();
	int RecvRemote(CString& buffer);
	int SendRemote(CString buffer);
	int ConnectRemote(CString IPAdrs);
	int CloseRemote();
	void ConvertTime(unsigned long remotetime, CString& timestr);

// Dispatch and event IDs
public:
	enum {
	//{{AFX_DISP_ID(CTimeCtrl)
	dispidTimeHost = 1L,
	dispidErrorNum = 2L,
	dispidGetTime = 3L,
	//}}AFX_DISP_ID
	};
};
