// popctl.h : Declaration of the CPopCtrl OLE control class.

/////////////////////////////////////////////////////////////////////////////
// CPopCtrl : See popctl.cpp for implementation.

class CPopCtrl : public COleControl
{
	DECLARE_DYNCREATE(CPopCtrl)

// Constructor
public:
	CPopCtrl();

// Overrides

	// Drawing function
	virtual void OnDraw(
				CDC* pdc, const CRect& rcBounds, const CRect& rcInvalid);

	// Persistence
	virtual void DoPropExchange(CPropExchange* pPX);

	// Reset control state
	virtual void OnResetState();

// Implementation
protected:
	~CPopCtrl();

	DECLARE_OLECREATE_EX(CPopCtrl)    // Class factory and guid
	DECLARE_OLETYPELIB(CPopCtrl)      // GetTypeInfo
	DECLARE_PROPPAGEIDS(CPopCtrl)     // Property page IDs
	DECLARE_OLECTLTYPE(CPopCtrl)		// Type name and misc status

// Message maps
	//{{AFX_MSG(CPopCtrl)
		// NOTE - ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

// Dispatch maps
	//{{AFX_DISPATCH(CPopCtrl)
	short m_errorNum;
	afx_msg void OnErrorNumChanged();
	CString m_userName;
	afx_msg void OnUserNameChanged();
	CString m_password;
	afx_msg void OnPasswordChanged();
	CString m_popSrvrAdrs;
	afx_msg void OnPopSrvrAdrsChanged();
	afx_msg BSTR ListMail();
	afx_msg BSTR GetMail(short msgnum);
	afx_msg BSTR GetStatus();
	afx_msg short POPLogoff();
	afx_msg BSTR POPLogon();
	afx_msg short DelMail(short msgnum);
	afx_msg short UnDelMail();
	//}}AFX_DISPATCH
	DECLARE_DISPATCH_MAP()

	afx_msg void AboutBox();

// Event maps
	//{{AFX_EVENT(CPopCtrl)
	//}}AFX_EVENT
	DECLARE_EVENT_MAP()

	//Socket specific members
	int	skt;

	int StartSockets();
	int OpenSocket();
	int RecvRemote(CString& buffer, int TimeOut);
	int SendRemote(CString buffer, int TimeOut);
	int ConnectRemote(CString IPAdrs);
	int CloseRemote();

// Dispatch and event IDs
public:
	enum {
	//{{AFX_DISP_ID(CPopCtrl)
	dispidErrorNum = 1L,
	dispidUserName = 2L,
	dispidPassword = 3L,
	dispidPopSrvrAdrs = 4L,
	dispidListMail = 5L,
	dispidGetMail = 6L,
	dispidGetStatus = 7L,
	dispidPOPLogoff = 8L,
	dispidPOPLogon = 9L,
	dispidDelMail = 10L,
	dispidUnDelMail = 11L,
	//}}AFX_DISP_ID
	};
};
