// smtpctl.h : Declaration of the CSmtpCtrl OLE control class.

/////////////////////////////////////////////////////////////////////////////
// CSmtpCtrl : See smtpctl.cpp for implementation.

class CSmtpCtrl : public COleControl
{
	DECLARE_DYNCREATE(CSmtpCtrl)

// Constructor
public:
	CSmtpCtrl();

// Overrides

	// Drawing function
	virtual void OnDraw(
				CDC* pdc, const CRect& rcBounds, const CRect& rcInvalid);

	// Persistence
	virtual void DoPropExchange(CPropExchange* pPX);

	// Reset control state
	virtual void OnResetState();

// Implementation
protected:
	~CSmtpCtrl();

	DECLARE_OLECREATE_EX(CSmtpCtrl)    // Class factory and guid
	DECLARE_OLETYPELIB(CSmtpCtrl)      // GetTypeInfo
	DECLARE_PROPPAGEIDS(CSmtpCtrl)     // Property page IDs
	DECLARE_OLECTLTYPE(CSmtpCtrl)		// Type name and misc status

// Message maps
	//{{AFX_MSG(CSmtpCtrl)
		// NOTE - ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

// Dispatch maps
	//{{AFX_DISPATCH(CSmtpCtrl)
	CString m_origAdrs;
	afx_msg void OnOrigAdrsChanged();
	CString m_smtpSrvrAdrs;
	afx_msg void OnSmtpSrvrAdrsChanged();
	short m_errorNum;
	afx_msg void OnErrorNumChanged();
	CString m_destUserList;
	afx_msg void OnDestUserListChanged();
	CString m_mailData;
	afx_msg void OnMailDataChanged();
	CString m_origName;
	afx_msg void OnOrigNameChanged();
	CString m_subject;
	afx_msg void OnSubjectChanged();
	CString m_domainName;
	afx_msg void OnDomainNameChanged();
	CString m_mailDate;
	afx_msg void OnMailDateChanged();
	CString m_cCUserList;
	afx_msg void OnCCUserListChanged();
	CString m_mailTime;
	afx_msg void OnMailTimeChanged();
	afx_msg short SendMail();
	//}}AFX_DISPATCH
	DECLARE_DISPATCH_MAP()

	afx_msg void AboutBox();

// Event maps
	//{{AFX_EVENT(CSmtpCtrl)
	//}}AFX_EVENT
	DECLARE_EVENT_MAP()
	
// Dispatch and event IDs




	//Socket specific members
	int	skt;

	int	GetSendTime();
	int StartSockets();
	int OpenSocket();
	int RecvRemote(CString& buffer);
	int SendRemote(CString buffer);
	int ConnectRemote(CString IPAdrs);
	int SendHeaderInfo(CString from, CString to, CString cc);
	int StartData();
	int SendData(CString buffer);
	int CloseRemote();

public:
	enum {
	//{{AFX_DISP_ID(CSmtpCtrl)
	dispidOrigAdrs = 1L,
	dispidSmtpSrvrAdrs = 2L,
	dispidErrorNum = 3L,
	dispidDestUserList = 4L,
	dispidMailData = 5L,
	dispidOrigName = 6L,
	dispidSubject = 7L,
	dispidDomainName = 8L,
	dispidMailDate = 9L,
	dispidCCUserList = 10L,
	dispidMailTime = 11L,
	dispidSendMail = 12L,
	//}}AFX_DISP_ID
	};
};
