
/*******************************************************************************
*																										 *
*   CDTEST1: First half of a pair of programs demonstrating how to transfer	 *
*      data between two consenting adult programs under Windows NT. These		 *
*      programs use the WM_COPYDATA message to directly pass data to and from	 *
*      each program.																				 *
*																										 *
*		 9/9/93 by Mark Gamber																	 *
*																										 *
*******************************************************************************/

#include "windows.h"

BOOL WINAPI MainDlgProc( HWND, UINT, WPARAM, LPARAM );       //  No include file

// -----------------------------------------------------------------------------

HINSTANCE hInst;

// -----------------------------------------------------------------------------

int APIENTRY WinMain( HINSTANCE hInstance, HINSTANCE hPrev, LPSTR lpCmd, int nShow )
{
	hInst = hInstance;                     //  Save instance and start dialog box
	DialogBox( hInstance, MAKEINTRESOURCE( 10000 ), NULL, MainDlgProc );
	return( FALSE );
}

// ---- Main Window (Dialog) of App #1 -----------------------------------------

BOOL WINAPI MainDlgProc( HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam )
{
	switch( msg )
	{
		case WM_INITDIALOG:									            //  And it was...
		{
			char szWinName[ 32 ];
			HWND hOther;

			LoadString( hInst, 100, szWinName, 32 );	      //  Title of other half
			hOther = FindWindow( (LPSTR)0, szWinName );	     //  Locate other half
			if( ! hOther )									      //  If window not found...
			{
				LoadString( hInst, 101, szWinName, 32 );
				WinExec( szWinName, SW_SHOW );		    //  Attempt to start program
				Sleep( 500 );									            //  Wait a bit...
				LoadString( hInst, 100, szWinName, 32 );	    //  Now try the window
				hOther = FindWindow( (LPSTR)0, szWinName );
				if( ! hOther )
				{											  //  If still not there, forget it
					EndDialog( hDlg, FALSE );
					return( FALSE );
				}
			}
			SendMessage( GetDlgItem( hDlg, 102 ), EM_LIMITTEXT, 127, 0 );
			return( TRUE );
		}

		case WM_COPYDATA:								 //  Incoming data from another app
		{
			COPYDATASTRUCT *cds;
			char str[ 128 ];

		   cds = (COPYDATASTRUCT *)lParam;			  //  Point structure to address
			if( cds->dwData == 1 )						              //  Erase command?
			{
				SetDlgItemText( hDlg, 103, "" );			       //  If so, easy enough
				return( TRUE );
			}
			if( cds->dwData == 0 )						              //  Incoming text?
			{													   //  Copy text to local buffer
				memcpy( str, cds->lpData, cds->cbData );
				str[ cds->cbData ] = '\0';					            //  Append a NULL
				SetDlgItemText( hDlg, 103, str );		    //  Display text and exit
				return( TRUE );
			}
			return( FALSE );						         //  Unknown command, bad exit
		}

		case WM_COMMAND:
		{
			if( wParam == IDCANCEL )			          //  Cancel, of course, exits
			{
				EndDialog( hDlg, TRUE );
				return( TRUE );
			}
			if( wParam == 100 )		                 //  Copy from here to there...
			{
				char szWinName[ 32 ];
				char szText[ 128 ];
				LONG lResult;
				HWND hOther;
            COPYDATASTRUCT cds;
																	 //  Get text in edit control
				if( ! GetDlgItemText( hDlg, 102, szText, 128 ) )
					break;								   //  If none, what are you doing?
														    //  Get name of other app's window
				LoadString( hInst, 100, szWinName, 32 );
				hOther = FindWindow( (LPSTR)0, szWinName );
				if( ! hOther )
					break;					                //  Find other window or die

				cds.dwData = 0;					                      //  Text command
				cds.lpData = (LPSTR)szText;					         //  Point to text
				cds.cbData = lstrlen( szText );					   //  Length of string
				                                          //  Send to the other app.
				lResult = SendMessage( hOther, WM_COPYDATA, (WPARAM)hDlg,
											  (LPARAM)(COPYDATASTRUCT *)&cds );
				break;
			}
			if( wParam == 101 )            //  Tell other app to erase it's control
			{
				char szWinName[ 32 ];
				char szText[ 128 ];
				LONG lResult;
				HWND hOther;
            COPYDATASTRUCT cds;
														           //  Find other app's window
				LoadString( hInst, 100, szWinName, 32 );
				hOther = FindWindow( (LPSTR)0, szWinName );
				if( ! hOther )
					break;

				cds.dwData = 1;				                        //  Erase command
				cds.lpData = (LPSTR)0;						        //  The rest is blank
				cds.cbData = 0;										  //  Send to other app
				lResult = SendMessage( hOther, WM_COPYDATA, (WPARAM)hDlg,
											  (LPARAM)(COPYDATASTRUCT *)&cds );
				break;
			}
			break;
		}

	}
	return( FALSE );
}


