/******************************************************************************
*   Demonstration of how to pass a string to a dialog box for text entry to   *
*   the string. The example uses window properties to save and retrieve the   *
*   string pointer using macros defined in the source listing.                *
*   Public domain by Mark Gamber. In using the program or any included part,  *
*   the user assumes full responsibility for it's use and may not hold the    *
*   author liable for any loss or damage. If unable to accept this            *
*   restriction, the software and all included parts muct be destroyed.       *
******************************************************************************/

#include "windows.h"

#ifdef WIN32                                  //  Determines the WinMain() type
#define ENTRYPOINT APIENTRY
#else
#define ENTRYPOINT PASCAL
#endif

               //  These definitions provide macros to save and retrieve 32 bit
               //  pointer values which are attached to a window as properties.
              //  Note this requires breaking up the pointer for 16 bit Windows
#ifdef WIN32
#define SETPOINTER(h,lp) SetProp(h,MAKEINTATOM(10000),(HANDLE)lp)
#define GETPOINTER(h)    (LPVOID)GetProp(h,MAKEINTATOM(10000))
#define KILLPOINTER(h)   RemoveProp(h,MAKEINTATOM(10000))
#else
#define SETPOINTER(h,lp) SetProp(h,MAKEINTATOM(10000),(HANDLE)LOWORD(lp));\
                         SetProp(h,MAKEINTATOM(10001),(HANDLE)HIWORD(lp))
#define GETPOINTER(h)    (LPVOID)MAKELONG((WORD)GetProp(h,MAKEINTATOM(10000)),\
                         (WORD)GetProp(h,MAKEINTATOM(10001)))
#define KILLPOINTER(h)   RemoveProp(h,MAKEINTATOM(10000));\
                         RemoveProp(h,MAKEINTATOM(10001))
#endif

// === Function Prototypes ====================================================

LRESULT WINAPI MainWndProc( HWND, UINT, WPARAM, LPARAM );
BOOL WINAPI InputDlgProc( HWND, UINT, WPARAM, LPARAM );

// === Global Variables =======================================================

HINSTANCE hInst;
HWND hMainWnd;

// === Application Entrypoint =================================================

int ENTRYPOINT WinMain( HINSTANCE hInstance, HINSTANCE hPrev, LPSTR lpCmd,
                        int nShow )
{
   WNDCLASS wc;
   MSG msg;

   
   wc.style = 0;
   wc.lpfnWndProc = MainWndProc;             //  Register the main window class
   wc.hInstance = hInstance;
   wc.lpszClassName = "dlginput";
   wc.lpszMenuName = "MMenu";
   wc.hbrBackground = (HBRUSH)( COLOR_WINDOW + 1 );
   wc.hIcon = LoadIcon( hInstance, MAKEINTRESOURCE( 100 ) );
   wc.hCursor = LoadCursor( NULL, IDC_ARROW );
   wc.cbClsExtra = wc.cbWndExtra = 0;

   if( ! RegisterClass( &wc ) )
      return( FALSE );                  //  Crawl in a hole and die if it fails

   hInst = hInstance;                      //  Save instance handle in a global
                                                 //  and create the main window
   hMainWnd = CreateWindow( "dlginput", "Dialog Input",
                            WS_OVERLAPPEDWINDOW,
                            CW_USEDEFAULT, CW_USEDEFAULT,
                            CW_USEDEFAULT, CW_USEDEFAULT,
                            NULL, NULL, hInstance, NULL );
   if( ! hMainWnd )
      return( FALSE );

   ShowWindow( hMainWnd, nShow );
   UpdateWindow( hMainWnd );                //  Show the window and do messages

   while( GetMessage( &msg, NULL, 0, 0 ) )
   {
      TranslateMessage( &msg );
      DispatchMessage( &msg );
   }

   return( FALSE );                                     //  Until it's all done
}

// === Main Window Procedure ==================================================

LRESULT WINAPI MainWndProc( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam )
{
   switch( msg )
   {
      case WM_DESTROY:
         PostQuitMessage( 0 );              //  Close app when window is closed
         break;

      case WM_COMMAND:
         if( wParam == 100 )                      //  If "About" is selected...
         {
            char szText[ 128 ];

            lstrcpy( szText, "Initial Text" );        //  Add some initial text
                                     //  Call dialog box passing string address
            if( DialogBoxParam( hInst, MAKEINTRESOURCE( 10000 ), hWnd,
                                InputDlgProc, (LPARAM)(LPSTR)szText ) )
               if( lstrlen( szText ) )           //  If dialog returned TRUE...
                  MessageBox( hWnd, szText, "You Entered...", MB_OK );

            break;
         }
         if( wParam == 101 )
         {
            DestroyWindow( hWnd );   //  Kill window (and app) if Exit selected
            break;
         }
         break;

      default:
         return( DefWindowProc( hWnd, msg, wParam, lParam ) );
   }
   return( FALSE );
}

// === Input Dialog Box Procedure =============================================

BOOL WINAPI InputDlgProc( HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam )
{
   switch( msg )
   {
      case WM_INITDIALOG:
      {                                     //  Save string pointer passed here
         SETPOINTER( hDlg, lParam );

         if( lstrlen( (LPSTR)lParam ) )       //  If something is in the string
            SetWindowText( GetDlgItem( hDlg, 100 ),         //  put it into the
                           (LPSTR)lParam );                //  edit control now
         return( TRUE );
      }


      case WM_COMMAND:
         if( wParam == IDCANCEL )                //  If Cancel is pressed, quit
         {
            KILLPOINTER( hDlg );

            EndDialog( hDlg, FALSE );  //  Cause DialogBoxParam to return FALSE
            return( TRUE );
         }
         if( wParam == IDOK )
         {
            char szStr[ 128 ];

            if( ! GetDlgItemText( hDlg, 100, szStr, 128 ) )   //  If nothing in
               break;                                //  the edit control, quit
                          //  Copy from here to pointer passed to WM_INITDIALOG
            lstrcpy( GETPOINTER( hDlg ), szStr );
            KILLPOINTER( hDlg );

            EndDialog( hDlg, TRUE );    //  Cause DialogBoxParam to return TRUE
            return( TRUE );
         }
         break;
   }
   return( FALSE );
}

