/******************************************************************************
*                  Edit Size Example - 12/27/94 by Mark Gamber                *
*                                                                             *
*     This example demonstrates how to determine the approximate minimum size *
*  required of an edit control to display a given string using a given font.  *
*                                                                             *
*     By using the program or any included part, the user assumes full        *
*  responsibility for it's use and may not hold the author liable for any     *
*  loss or damage. In unable to accept this condition, the program and all    *
*  included parts must be destroyed immediately.                              *
******************************************************************************/

#include "windows.h"

// === Function Prototypes ====================================================

LRESULT WINAPI MainWndProc( HWND, UINT, WPARAM, LPARAM );
BOOL SnapEditToFont( HWND );

// === Global Variables =======================================================

HINSTANCE hInst;
HWND hMainWnd;
HFONT hFont;         //  Kept as a global, it could be applied as a window prop

// === Application Entry Point ================================================

int APIENTRY WinMain( HINSTANCE hInstance, HINSTANCE hPrev, LPSTR lpCmd,
                      int nShow )
{
   WNDCLASS wc;
   MSG msg;


   wc.style = 0;
   wc.hInstance = hInstance;
   wc.lpfnWndProc = MainWndProc;
   wc.lpszClassName = "FETEST32";            //  Register the main window class
   wc.lpszMenuName = "MainMenu";
   wc.hCursor = LoadCursor( NULL, IDC_ARROW );
   wc.hIcon = LoadIcon( NULL, IDI_APPLICATION );
   wc.hbrBackground = (HBRUSH)( COLOR_WINDOW + 1 );
   wc.cbClsExtra = wc.cbWndExtra = 0;

   if( ! RegisterClass( &wc ) )                  //  Fail if registration fails
      return( FALSE );
   hInst = hInstance;
                                                     //  Create the main window
   hMainWnd = CreateWindow( "FETEST32", "Edit Sizing Test", 
                            WS_OVERLAPPEDWINDOW,
                            CW_USEDEFAULT, CW_USEDEFAULT,
                            300, 200, NULL, NULL, hInstance, NULL );
   if( ! hMainWnd )
      return( FALSE );                            //  Fail if main window fails

   ShowWindow( hMainWnd, nShow );                        //  Otherwise, show it
   UpdateWindow( hMainWnd );

   while( GetMessage( &msg, NULL, 0, 0 ) )               //  Kick yer shoes off
   {                                                            //  stay awhile
      TranslateMessage( &msg );
      DispatchMessage( &msg );
   }
   return( FALSE );                              //  Y'all come back now, hear?
}

// === Main Window Procedure ==================================================

LRESULT WINAPI MainWndProc( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam )
{
   switch( msg )
   {
      case WM_CREATE:                //  Upon creating this, the main window...
      {
         HWND hEdit;

                                     //  Create a edit control of whatever size
         hEdit = CreateWindow( "edit", "Edit Test", WS_CHILD | WS_BORDER |
                               WS_VISIBLE | ES_AUTOHSCROLL,
                               2, 2, 80, 2, hWnd, (HMENU)100, hInst, NULL );
         if( ! hEdit )
            return( -1 );                    //  Fail this window if edit fails
                                                     //  Create an initial font
         hFont = CreateFont( -8, 0, 0, 0, FW_NORMAL, 0, 0, 0, 0, 0, 0, 0, 0,
                             "MS Sans Serif" );              //  Apply the font
         SendMessage( hEdit, WM_SETFONT, (WPARAM)hFont, 1 );
         SnapEditToFont( hEdit );             //  Size the edit to fit the text
         break;
      }                                     //  End of MainWndProc( WM_CREATE )


      case WM_DESTROY:                       //  Clean up before going to sleep
      {
         if( GetDlgItem( hWnd, 100 ) )      //  Kill the edit if it's lingering
            DestroyWindow( GetDlgItem( hWnd, 100 ) ); 
         if( hFont )
            DeleteObject( hFont );              //  Free whatever font is handy
         PostQuitMessage( 0 );                   //  Kill the app and it's done
         break;
      }


      case WM_COMMAND:                                        //  Menu commands
         if( wParam == 101 )
         {
            DestroyWindow( hWnd );             //  Impatient user want to leave
            break;          //  Destroying the window invokes the above cleanup
         }
         if( wParam == 100 )
         {
            CHOOSEFONT cf;                   //  Ah...user want to use new font
            LOGFONT lf;


            memset( &lf, 0, sizeof(LOGFONT) );           //  Nothing in LOGFONT
            memset( &cf, 0, sizeof(CHOOSEFONT) );     //  Nothing in CHOOSEFONT
            cf.lStructSize = sizeof(CHOOSEFONT);
            cf.hwndOwner = hWnd;           //  Specify enough to stay alive and
            cf.lpLogFont = &lf;                  //  let the user select a font
            cf.Flags = CF_SCREENFONTS | CF_INITTOLOGFONTSTRUCT;

            if( ChooseFont( &cf ) )
            {
               if( hFont )          //  If a font is chosen, delete the old one
                  DeleteObject( hFont );        //  before creating the new one
               hFont = CreateFontIndirect( &lf );         //  Create a new font
               SendMessage( GetDlgItem( hWnd, 100 ), WM_SETFONT,   //  Apply it
                            (WPARAM)hFont, 1 );    //  to the edit and snap the
               SnapEditToFont( GetDlgItem( hWnd, 100 ) );  //  edit size to fit
            }
            break;
         }
         break;                            //  End of MainWndProc( WM_COMMAND )


      default:                                  //  Different animal, same tail
         return( DefWindowProc( hWnd, msg, wParam, lParam ) );
   }
   return( FALSE );
}                                                      //  End of MainWndProc()

// === Size Specified Edit Control to fit Font ================================

BOOL SnapEditToFont( HWND hEdit )
{
   HDC hDC;
   TEXTMETRIC tm;
   SIZE size;
   char szText[ 256 ];

                                //  If there's no text, there's nothing to size
   if( ! GetWindowText( hEdit, szText, 256 ) )
      return( FALSE );                          //  so exit until there is text

   hDC = GetDC( hEdit );                                  //  Get the edit's DC
   if( ! hDC )
      return( FALSE );

   SelectObject( hDC, hFont );      //  Apply the current font for measurements
   GetTextMetrics( hDC, &tm );    //  Get the font metrics according to Windows
   GetTextExtentPoint( hDC, szText, lstrlen( szText ), &size );     //  and the
   ReleaseDC( hEdit, hDC );              //  string length, then release the DC

   SetWindowPos( hEdit, NULL, 0, 0,      //  Resize the edit using this forumla
                 size.cx +                            //  It tends to make it a
                 ( ( ( tm.tmAveCharWidth + tm.tmMaxCharWidth ) / 2 ) * 2 ),
                 tm.tmHeight + tm.tmDescent,  //  bit larger, especially horiz.
                 SWP_NOMOVE | SWP_NOZORDER );   //  but better large than small
   return( TRUE );
}                                                   //  End of SnapEditToFont()

// ============================================================================

