/*
 * pbnt4.c - Implements Windows NT 4.0 version of phonebook functions
 */


#define WIN32_LEAN_AND_MEAN
#define WINVER 0x401			// important!

#include <windows.h>

#include <ras.h>
#include <raserror.h>

#include <stdio.h>
#include <stdlib.h>

// Test for outdated ras.h (for example, a version included with VC 2)
#if RAS_MaxDeviceName != 128
	#error You have an outdated ras.h.  Make sure include path points to most recent Win32 SDK first.
#endif

// Test for outdated beta 1 ras.h
#ifndef RDEOPT_NoUser 
#if RAS_MaxDeviceName == 128
	#pragma message ("To run properly on NT 4, you need to upgrade your Win32 SDK to NT 4 ")
	#pragma message ("beta 2 (or newer).  The sample will run, but structure alignment will")
	#pragma message ("be incorrect.")
#endif
#endif

//
// When RAS.H is not from NT 4 SDK, provide stubs.  This allows sample to be
// built using only Windows 95 phonebook extensions.
//

#ifndef RASENTRY				

#if RAS_MaxDeviceName == 128
	#pragma message ("Because of an outdated ras.h, this sample will only be able to run on Windows 95.")
	#pragma message ("Install the most recent Win32 SDK (the NT 4.0 beta 2 SDK or newer) in order to run")
	#pragma message ("the sample on NT 4.0.")
#endif

BOOL InitFunctionsNT4 (void)
	{
	printf ("You complied this sample with an outdated RAS header that does not\n"
			"have NT 4.0 structures and prototypes.  For NT 4.0 support, upgrade\n"
			"to the most recent Win32 SDK.\n");
	return FALSE;
	}

void SetPropertiesNT4 (char *szPhonebook, char *szOldEntry, char *szNewEntry)
	{
	}

void GetPropertiesNT4 (char *szPhonebook, char *szEntry)
	{
	}

BOOL EnumDevicesNT4 (LPSTR szDeviceNameBuf, LPSTR szDeviceTypeBuf)
	{
	return FALSE;
	}

void NewEntryNT4 (char *szPhonebook, char *szEntry)
	{
	}

#else  // ifndef RASENTRY


//
// Else NT 4 SDK is installed.  Implement NT versions.
//

#include "extapi.h"
#include "pbnt4.h"

//
// WINDOWS NT 4.0 NOTES:
//
// NT 4.0 header currently does not define the constant RASNP_Netbeui.
//

#ifndef RASNP_Netbeui
#define RASNP_Netbeui 0x00000001
#endif


BOOL InitFunctionsNT4 (void)
	{
	// Try only RASAPI32.DLL
	g_hRnaInst = LoadLibrary ("rasapi32.dll");
	if (!g_hRnaInst)
		{
		printf ("RASAPI32.DLL is not available.  RAS may not be installed.\n");
		return FALSE;
		}

	// All function names here have 'A' appended because we want the ANSI char 
	// version (not the WIDE char version).

	fnRasGetEntryProperties = (void *) GetProcAddress (g_hRnaInst, "RasGetEntryPropertiesA");
	
	if (!fnRasGetEntryProperties)
		{
		printf ("Can't find Phone Book APIs\n");
		return FALSE;
		}

	// Get the rest of the needed phone book functions
	fnRasSetEntryProperties = (void *) GetProcAddress (g_hRnaInst, "RasSetEntryPropertiesA");
	fnRasValidateEntryName =  (void *) GetProcAddress (g_hRnaInst, "RasValidateEntryNameA");
	fnRasRenameEntry =        (void *) GetProcAddress (g_hRnaInst, "RasRenameEntryA");
	fnRasDeleteEntry =        (void *) GetProcAddress (g_hRnaInst, "RasDeleteEntryA");
	fnRasGetCountryInfo =     (void *) GetProcAddress (g_hRnaInst, "RasGetCountryInfoA");
	fnRasEnumDevices =        (void *) GetProcAddress (g_hRnaInst, "RasEnumDevicesA");

	return TRUE;
	}


//
// Set properties of an existing entry
//

void SetPropertiesNT4 (char *szPhonebook, char *szOldEntry, char *szNewEntry)
	{
	DWORD rc;
	DWORD dwEntryInfoSize, dwDeviceInfoSize;
	LPRASENTRY lpEntryInfo;
	LPRASDEVINFO lpDeviceInfo;

	// Obtain sizes
	dwEntryInfoSize = 0;
	dwDeviceInfoSize = 0;

	rc = fnRasGetEntryProperties (szPhonebook, szOldEntry, 
								  NULL, &dwEntryInfoSize,
								  NULL, &dwDeviceInfoSize);

	// Make the call
	if (rc == ERROR_BUFFER_TOO_SMALL || (!rc && dwEntryInfoSize))
		{
		// Allocate memory
		lpEntryInfo = (LPRASENTRY) malloc (dwEntryInfoSize);
		if (dwDeviceInfoSize)
			lpDeviceInfo = (LPRASDEVINFO) malloc (dwDeviceInfoSize);
		else
			lpDeviceInfo = NULL;

		lpEntryInfo->dwSize = dwEntryInfoSize;
		if (lpDeviceInfo)
			lpDeviceInfo->dwSize = dwDeviceInfoSize;

		// Get the entry properties
		rc = fnRasGetEntryProperties (szPhonebook, szOldEntry,
									  (LPBYTE) lpEntryInfo, &dwEntryInfoSize,
									  (LPBYTE) lpDeviceInfo, &dwDeviceInfoSize);

		if (!rc)
			{
			// Modify the properties here (this sample rotates the number)
			char szBuf[RAS_MaxPhoneNumber + 1];

			lstrcpy (szBuf, lpEntryInfo->szLocalPhoneNumber);
			lstrcpy (lpEntryInfo->szLocalPhoneNumber, &szBuf[1]);
			szBuf[1] = 0;
			lstrcat (lpEntryInfo->szLocalPhoneNumber, &szBuf[0]);

			// Set the properties
			rc = fnRasSetEntryProperties (szPhonebook, szNewEntry,
										  (LPBYTE) lpEntryInfo, dwEntryInfoSize,
										  (LPBYTE) lpDeviceInfo, dwDeviceInfoSize);

			printf ("RasSetEntryProperties rc=%i\n", rc);
			}
		else
			printf ("Second RasGetEntryProperties call failed, rc=%i\n", rc);

		// Cleanup
		if (lpDeviceInfo)
			free (lpDeviceInfo);

		free (lpEntryInfo);
		}
	else
		printf ("Sizing call (RasGetEntryProperties) failed, rc=%i\n", rc);
	}


//
// Display the properties for an entry
//

void GetPropertiesNT4 (char *szPhonebook, char *szEntry)
	{
	DWORD rc;
	DWORD dwEntryInfoSize, dwDeviceInfoSize;
	LPRASENTRY lpEntryInfo;
	LPRASDEVINFO lpDeviceInfo;

	// Obtain sizes
	dwEntryInfoSize = 0;
	dwDeviceInfoSize = 0;

	rc = fnRasGetEntryProperties (szPhonebook, szEntry, 
								  NULL, &dwEntryInfoSize,
								  NULL, &dwDeviceInfoSize);

	// Make the call
	if (rc == ERROR_BUFFER_TOO_SMALL || (!rc && dwEntryInfoSize))
		{
		// Allocate memory
		lpEntryInfo = (LPRASENTRY) malloc (dwEntryInfoSize);

		//dwDeviceInfoSize = max (dwDeviceInfoSize, 4);
		if (dwDeviceInfoSize)
			lpDeviceInfo = (LPRASDEVINFO) malloc (dwDeviceInfoSize);
		else
			lpDeviceInfo = NULL;

		lpEntryInfo->dwSize = dwEntryInfoSize;
		if (lpDeviceInfo)
			lpDeviceInfo->dwSize = dwDeviceInfoSize;

		// Call RAS
		rc = fnRasGetEntryProperties (szPhonebook, szEntry,
									  (LPBYTE) lpEntryInfo, &dwEntryInfoSize,
									  (LPBYTE) lpDeviceInfo, &dwDeviceInfoSize);

		// Print the results
		if (!rc)
			{
			printf ("Members of the RASENTRY struct:\n\n");

			printf ("  dwSize            %u\n", lpEntryInfo->dwSize);

			printf ("  dwfOptions        %08Xh\n", lpEntryInfo->dwfOptions);
			if (lpEntryInfo->dwfOptions & RASEO_UseCountryAndAreaCodes)
				printf ("    RASEO_UseCountryAndAreaCodes\n");
			if (lpEntryInfo->dwfOptions & RASEO_SpecificIpAddr)
				printf ("    RASEO_SpecificIpAddr\n");
			if (lpEntryInfo->dwfOptions & RASEO_SpecificNameServers)
				printf ("    RASEO_SpecificNameServers\n");
			if (lpEntryInfo->dwfOptions & RASEO_IpHeaderCompression)
				printf ("    RASEO_IpHeaderCompression\n");
			if (lpEntryInfo->dwfOptions & RASEO_RemoteDefaultGateway)
				printf ("    RASEO_RemoteDefaultGateway\n");
			if (lpEntryInfo->dwfOptions & RASEO_DisableLcpExtensions)
				printf ("    RASEO_DisableLcpExtensions\n");
			if (lpEntryInfo->dwfOptions & RASEO_TerminalBeforeDial)
				printf ("    RASEO_TerminalBeforeDial\n");
			if (lpEntryInfo->dwfOptions & RASEO_TerminalAfterDial)
				printf ("    RASEO_TerminalAfterDial\n");
			if (lpEntryInfo->dwfOptions & RASEO_ModemLights)
				printf ("    RASEO_ModemLights\n");
			if (lpEntryInfo->dwfOptions & RASEO_SwCompression)
				printf ("    RASEO_SwCompression\n");
			if (lpEntryInfo->dwfOptions & RASEO_RequireEncryptedPw)
				printf ("    RASEO_RequireEncryptedPw\n");
			if (lpEntryInfo->dwfOptions & RASEO_RequireMsEncryptedPw)
				printf ("    RASEO_RequireMsEncryptedPw\n");
			if (lpEntryInfo->dwfOptions & RASEO_RequireDataEncryption)
				printf ("    RASEO_RequireDataEncryption\n");
			if (lpEntryInfo->dwfOptions & RASEO_NetworkLogon)
				printf ("    RASEO_NetworkLogon\n");
			if (lpEntryInfo->dwfOptions & RASEO_UseLogonCredentials)
				printf ("    RASEO_UseLogonCredentials\n");
			if (lpEntryInfo->dwfOptions & RASEO_PromoteAlternates)
				printf ("    RASEO_PromoteAlternates\n");

			printf ("  dwCountryID        %u\n", lpEntryInfo->dwCountryID);
			printf ("  dwCountryCode      %u\n", lpEntryInfo->dwCountryCode);
			printf ("  szAreaCode         %s\n", lpEntryInfo->szAreaCode);
			printf ("  szLocalPhoneNumber %s\n", lpEntryInfo->szLocalPhoneNumber);
			printf ("  dwAlternateOffset  %u\n", lpEntryInfo->dwAlternateOffset);	// newer

			PrintIpAddr ("  ipaddr             ", lpEntryInfo->ipaddr);
			PrintIpAddr ("  ipaddrDns          ", lpEntryInfo->ipaddrDns);
			PrintIpAddr ("  ipaddrDnsAlt       ", lpEntryInfo->ipaddrDnsAlt);
			PrintIpAddr ("  ipaddrWins         ", lpEntryInfo->ipaddrWins);
			PrintIpAddr ("  ipaddrWinsAlt      ", lpEntryInfo->ipaddrWinsAlt);

			printf ("  dwFrameSize:       %u\n", lpEntryInfo->dwFrameSize);

			printf ("  dwfNetProtocols    %08Xh\n", lpEntryInfo->dwfNetProtocols);
			if (lpEntryInfo->dwfNetProtocols & RASNP_Netbeui)
				printf ("    RASNP_Netbeui\n");
			if (lpEntryInfo->dwfNetProtocols & RASNP_Ip)
				printf ("    RASNP_Ip\n");
			if (lpEntryInfo->dwfNetProtocols & RASNP_Ipx)
				printf ("    RASNP_Ipx\n");

			printf ("  dwFramingProtocol  %08Xh\n", lpEntryInfo->dwFramingProtocol);
			if (lpEntryInfo->dwFramingProtocol & RASFP_Ppp)
				printf ("    RASFP_Ppp\n");
			if (lpEntryInfo->dwFramingProtocol & RASFP_Slip)
				printf ("    RASFP_Slip\n");
			if (lpEntryInfo->dwFramingProtocol & RASFP_Ras)
				printf ("    RASFP_Ras (NT 3.1 and WFW)\n");

			printf ("  szScript           %s\n", lpEntryInfo->szScript);
			printf ("  szAutodialDll      %s\n", lpEntryInfo->szAutodialDll);
			printf ("  szAutodialFunc     %s\n", lpEntryInfo->szAutodialFunc);
			printf ("  szDeviceType       %s\n", lpEntryInfo->szDeviceType);
			printf ("  szDeviceName       %s\n", lpEntryInfo->szDeviceName);
            printf ("  szX25PadType       %s\n", lpEntryInfo->szX25PadType);
			printf ("  szX25Address       %s\n", lpEntryInfo->szX25Address);
			printf ("  szX25Facilities    %s\n", lpEntryInfo->szX25Facilities);
			printf ("  szX25UserData      %s\n", lpEntryInfo->szX25UserData);
            printf ("  dwChannels         %08Xh\n", lpEntryInfo->dwChannels);
            printf ("  dwReserved1        %08Xh\n", lpEntryInfo->dwReserved1);
            printf ("  dwReserved2        %08Xh\n", lpEntryInfo->dwReserved2);

			printf ("\n  Extra Members in NT 4\n");
			printf ("  dwSubEntries               %u\n", lpEntryInfo->dwSubEntries);
			printf ("  dwDialMode                 %u\n", lpEntryInfo->dwDialMode);
			printf ("  dwDialExtraPercent         %u\n", lpEntryInfo->dwDialExtraPercent);
			printf ("  dwDialExtraSampleSeconds   %u\n", lpEntryInfo->dwDialExtraSampleSeconds);
			printf ("  dwHangUpExtraPercent       %u\n", lpEntryInfo->dwHangUpExtraPercent);
			printf ("  dwHangUpExtraSampleSeconds %u\n", lpEntryInfo->dwHangUpExtraSampleSeconds);
			printf ("  dwIdleDisconnectSeconds    %u\n", lpEntryInfo->dwIdleDisconnectSeconds);
			}
		else
			printf ("Second call to RasGetEntryProperties failed with rc=%i\n", rc);

		// Cleanup
		if (lpDeviceInfo)
			free (lpDeviceInfo);
		free (lpEntryInfo);
		}
	else
		printf ("Sizing call (RasGetEntryProperties) failed, rc=%i\n", rc);
	}


//
// EnumDevices enumerates all the RAS devices & returns default device if necessary
//

BOOL EnumDevicesNT4 (LPSTR szDeviceNameBuf, LPSTR szDeviceTypeBuf)
	{
	LPRASDEVINFO lpRasDevInfo;
	DWORD dwBufSize;
	DWORD dwDevCount;
	DWORD rc;
	DWORD i;

	//
	// EnumDevices serves two purposes.  When szDeviceNameBuf is NULL,
	// the function prints out all devices and returns.  When szDeviceNameBuf
	// is non-NULL, it does not print device names, but instead copies the
	// first available device info to a buffer.
	//
	// lpRasDevInfo is an undocumented device specific structure in RAS, but 
	// if the device is a modem, it is documented in TAPI under comm/datamodem.
	// Make sure RasEntry.szDeviceType == "modem" before using this info.  Also,
	// this is undocumented as far as RAS is concerned and may change.
	//

	// Determine buffer size; API returns 0 even though buffer is too small
	dwBufSize = 0;
	rc = fnRasEnumDevices (NULL, &dwBufSize, &dwDevCount);

	if (!dwBufSize)
		{
		printf ("No devices present.\n");
		return FALSE;
		}

	// Allocate a buffer, then get the devices
	lpRasDevInfo = (LPRASDEVINFO) malloc (dwBufSize);
	lpRasDevInfo->dwSize = sizeof (RASDEVINFO);

	rc = fnRasEnumDevices (lpRasDevInfo, &dwBufSize, &dwDevCount);

	// if either name buffer is NULL, print results and return
	if (!szDeviceNameBuf || !szDeviceTypeBuf)
		{
		if (!rc)
			{
			for (i = 0 ; i < dwDevCount ; i++)
				{
				printf ("%2i. %s (%s)\n", i + 1, 
						lpRasDevInfo[i].szDeviceName,
						lpRasDevInfo[i].szDeviceType);
				}
			}
		else
			{
			// Display error, then force a NULL return val
			printf ("RasEnumDevices rc=%i\n", rc);
			}

		free (lpRasDevInfo);
		return FALSE;
		}

	// Otherwise return default info
	lstrcpy (szDeviceNameBuf, lpRasDevInfo[0].szDeviceName);
	lstrcpy (szDeviceTypeBuf, lpRasDevInfo[0].szDeviceType);

	free (lpRasDevInfo);
	return TRUE;
	}

//
// Demonstrate how to create a new entry without calling RasGetEntryProperties
// first.
//

void NewEntryNT4 (char *szPhonebook, char *szEntry)
	{
	DWORD rc;

	//
	// NT 4 beta 2 does not obey the RAS_OPTIONS entirely.  Experiment
	// with this sample to determine how your version of NT behaves, as
	// any bugs are likely to be fixed eventually.
	//

	#define RAS_OPTIONS  \
	   RASEO_UseCountryAndAreaCodes+\
	   RASEO_RemoteDefaultGateway+\
	   RASEO_ModemLights+\
	   RASEO_TerminalAfterDial

	RASENTRY reNew = 
		{
		sizeof(RASENTRY),	// dwSize
		RAS_OPTIONS,		// dwfOptions
		1,					// dwCountryID, 1 == United States
		0,					// dwCountryCode, 0 == Use default for Country ID
		"800",				// szAreaCode, could be a space but must be set
		"555-5555",			// szLocalPhoneNumber
		0,					// dwAlternateOffset (aka dwAlternatesOffset)
		{0,0,0,0},			// ipaddr
		{0,0,0,0},			// Dns
		{0,0,0,0},			// DnsAlt
		{0,0,0,0},			// addrWins
		{0,0,0,0},			// addrWinsAlt
		0,					// dwFrameSize
		RASNP_Ip,			// dwfNetProtocol
		RASFP_Ppp,			// dwFramingProtocol
		"",					// szScript
		"",					// szAutodialDll
		"",					// szAutodialFunc
		"",					// szDeviceType, this will be set below
		"",					// szDeviceName, this will be set below
		"", 				// szX25PadType
		"", 				// szX25Address
		"", 				// szX25Facilities
		"", 				// szX25UserData
		0,					// dwChannels
		0,					// dwReserved1
		0,					// dwReserved2

		// Extra NT 4 members
		0,					// dwSubEntries
		0,					// dwDialMode
		0,					// dwDialExtraPercent
		0,					// dwDialExtraSampleSeconds
		0,					// dwHangUpExtraPercent
		0,					// dwHangUpExtraSampleSeconds
		0					// dwIdleDisconnectSeconds
		};

	//
	// Let's get a device name and type (it's required)
	//

	
	if (!EnumDevicesNT4 (reNew.szDeviceName, reNew.szDeviceType))
		{
		printf ("A required device is not installed.  Cannot complete operation.\n");
		return;
		}

	//
	// Ready to add entry.  Call RasSetEntryProperties.
	//

	rc = fnRasSetEntryProperties (szPhonebook, szEntry,
								  (LPBYTE) &reNew, reNew.dwSize,
								  (LPBYTE) NULL, 0);

	printf ("RasSetEntryProperties rc=%i\n", rc);
	}


#endif // else ifndef RASENTRY
