/* Copyright (c) 1995, Microsoft Corporation, all rights reserved
**
** rnaph.h  (to be merged with ras.h)
**
** Remote Access external API
** Public header for external API clients
*/

#ifndef _RNAPH_H_
#define _RNAPH_H_

#ifdef __cplusplus
extern "C" {
#endif

#define RAS_MaxAreaCode     10
#define RAS_MaxPadType      32
#define RAS_MaxX25Address   200
#define RAS_MaxFacilities   200
#define RAS_MaxUserData     200


/* Describes a RAS IP Address
*/
typedef struct tagRasIpAddr {
	BYTE  a;
	BYTE  b;
	BYTE  c;
	BYTE  d;
} RASIPADDR;
typedef RASIPADDR * LPRASIPADDR;


/* Describes a RAS phonebook entry
*/
typedef struct  tagRasEntry {
	DWORD       dwSize;
	DWORD       dwfOptions;
	DWORD       dwCountryID;
	DWORD       dwCountryCode;
	CHAR        szAreaCode[ RAS_MaxAreaCode + 1 ];
	CHAR        szLocalPhoneNumber[ RAS_MaxPhoneNumber + 1 ];
	DWORD       dwAlternatesOffset;
	RASIPADDR   ipaddr;
	RASIPADDR   ipaddrDns;
	RASIPADDR   ipaddrDnsAlt;
	RASIPADDR   ipaddrWins;
	RASIPADDR   ipaddrWinsAlt;
	DWORD       dwFrameSize;
	DWORD       dwfNetProtocols;
	DWORD       dwFramingProtocol;
	CHAR        szScript[ MAX_PATH ];
        CHAR        szAutodialDll[ MAX_PATH ];
        CHAR        szAutodialFunc[ MAX_PATH ];
	CHAR        szDeviceType[ RAS_MaxDeviceType + 1 ];
	CHAR        szDeviceName[ RAS_MaxDeviceName + 1 ];
	CHAR        szX25PadType[ RAS_MaxPadType + 1 ];
	CHAR        szX25Address[ RAS_MaxX25Address + 1 ];
	CHAR        szX25Facilities[ RAS_MaxFacilities + 1 ];
	CHAR        szX25UserData[ RAS_MaxUserData + 1 ];
	DWORD       dwChannels;
	DWORD       dwReserved1;
	DWORD       dwReserved2;
} RASENTRY;
typedef RASENTRY * LPRASENTRY;


/* Describes Country Information
*/
typedef struct  tagRasCtryInfo {
	DWORD       dwSize;
	DWORD       dwCountryID;
	DWORD       dwNextCountryID;
	DWORD       dwCountryCode;
	DWORD       dwCountryNameOffset;
} RASCTRYINFO;
typedef RASCTRYINFO * LPRASCTRYINFO;


/* Describes RAS Device Information
*/
typedef struct  tagRasDevInfo {
	DWORD       dwSize;
	CHAR        szDeviceType[RAS_MaxDeviceType+1];
	CHAR        szDeviceName[RAS_MaxDeviceName+1];
} RASDEVINFO;
typedef RASDEVINFO * LPRASDEVINFO;


/* RASENTRY 'dwfOptions' bit flags.
*/
#define RASEO_UseCountryAndAreaCodes  0x00000001
#define RASEO_SpecificIpAddr          0x00000002
#define RASEO_SpecificNameServers     0x00000004
#define RASEO_IpHeaderCompression     0x00000008
#define RASEO_RemoteDefaultGateway    0x00000010
#define RASEO_DisableLcpExtensions    0x00000020
#define RASEO_TerminalBeforeDial      0x00000040
#define RASEO_TerminalAfterDial       0x00000080
#define RASEO_ModemLights             0x00000100
#define RASEO_SwCompression           0x00000200
#define RASEO_RequireEncryptedPw      0x00000400
#define RASEO_RequireMsEncryptedPw    0x00000800
#define RASEO_RequireDataEncryption   0x00001000
#define RASEO_NetworkLogon            0x00002000
#define RASEO_UseLogonCredentials     0x00004000
#define RASEO_PromoteAlternates       0x00008000



/* RASENTRY 'dwfNetProtocols' bit flags. (session negotiated protocols)
*/
#define RASNP_Netbeui       0x00000001  // Negotiate NetBEUI
#define RASNP_Ipx           0x00000002  // Negotiate IPX
#define RASNP_Ip            0x00000004  // Negotiate TCP/IP


/* RASENTRY 'dwFramingProtocols' (framing protocols used by the server)
*/
#define RASFP_Ppp           0x00000001  // Point-to-Point Protocol (PPP)
#define RASFP_Slip          0x00000002  // Serial Line Internet Protocol (SLIP)
#define RASFP_Ras           0x00000004  // Microsoft proprietary protocol


/* RASENTRY 'szDeviceType' strings
*/
#define RASDT_Modem         "modem"     // Modem
#define RASDT_Isdn          "isdn"      // ISDN
#define RASDT_X25           "x25"       // X.25



/* RAS functions found in RNAPH.DLL
*/
DWORD WINAPI RasValidateEntryName(LPSTR lpszPhonebook, LPSTR szEntry);
DWORD WINAPI RasRenameEntry(LPSTR lpszPhonebook, LPSTR szEntryOld, LPSTR szEntryNew);
DWORD WINAPI RasDeleteEntry(LPSTR lpszPhonebook, LPSTR szEntry);

DWORD WINAPI RasGetEntryProperties(LPSTR lpszPhonebook, LPSTR szEntry,
	LPBYTE lpbEntry, LPDWORD lpdwEntrySize, LPBYTE lpb, LPDWORD lpdwSize);
DWORD WINAPI RasSetEntryProperties(LPSTR lpszPhonebook, LPSTR szEntry,
	LPBYTE lpbEntry, DWORD dwEntrySize, LPBYTE lpb, DWORD dwSize);

DWORD WINAPI RasGetCountryInfo(LPRASCTRYINFO lpCtryInfo, LPDWORD lpdwSize);
DWORD WINAPI RasEnumDevices(LPRASDEVINFO lpBuff, LPDWORD lpcbSize, LPDWORD lpcDevices);


#ifdef __cplusplus
}
#endif

#endif // _RNAPH_H_
