char EMSG_ErrorReading[]="Error READing file...";
char EMSG_UnexpectedEOF[]="Unexpected end of file.";

// ==== Default virtual functions for ImgSize class

LPSTR ImgSize::Apply(LPSTR szFile)
{
  return NULL;  // OK
}

LRESULT ImgSize::Command(WPARAM wParam,LPARAM lParam)
{
  return FALSE; // No processing
}

void ImgSize::Destroy() {}

LPSTR ImgSize::Update()
{
  return NULL;  // OK
}

// ==== ImgSize: service functions
LPSTR ImgSize::Reopen(LPSTR szFile,int pos)
{
  hFile=_lopen(szFile, OF_WRITE);
  if( hFile == HFILE_ERROR ) { hFile=NULL; return "Can't open %s."; }

  if(pos)
  {
    if( _llseek(hFile,pos,FILE_BEGIN) == 0xFFFFFFFF ) return "Can't move file pointer in %s.";
  }
  return NULL;
}

// fShow=SW_HIDE, SW_SHOW
void ImgSize::Show(int idFrom, int idTo, int fShow)
{
  HWND hWnd, hWndLast;
  hWndLast=GetDlgItem(hDlg,idTo);
  for( hWnd=GetDlgItem(hDlg,idFrom); hWnd; hWnd=GetWindow(hWnd,GW_HWNDNEXT) )
  {
    ShowWindow(hWnd,fShow);
    if(hWnd==hWndLast) break;
  }
}

//    .
void ImgSize::Add(LPSTR sLabel,LPSTR sText)
{
  RECT r;

  r.left = 11;
  r.top  = yAdd;
  r.right = 75; // width
  r.bottom= 8;  // height

  CreateWindow("STATIC", sLabel, SS_LEFT | WS_CHILD | WS_VISIBLE,
    r.left, r.top, r.right, r.bottom, hDlg, NULL, g_hmodThisDll, 0 );

  r.left += 80;
  r.bottom= 12; // height
  CreateWindow("EDIT", sText, ES_LEFT | WS_CHILD | WS_VISIBLE | WS_BORDER | WS_TABSTOP,
    r.left, r.top-3, r.right, r.bottom, hDlg, NULL, g_hmodThisDll, 0 );

  yAdd += 16;
}
// The function, common to several classes

// Put number of colors or number of bits, if iColorBits>10
void SetColorsInfo(HWND hWndText,int iColorBits)
{
  char buf[32];
  if(iColorBits<=10) wsprintf( buf, "%u", 1<<iColorBits );
  else wsprintf( buf, "%u bit", iColorBits );
  SetWindowText(hWndText,buf);
}

 // BMP Class implemetation
LPSTR BmpProp::Load()
{
  char buf[32];
  int t;

  #pragma pack( push, pp1 )
  #pragma pack( 1 )
  struct tagFIH
  {
    BITMAPFILEHEADER fh;
    BITMAPINFOHEADER ih;
  } BmpData;
  #pragma pack( pop, pp1 )

  READ(BmpData);
  if(BmpData.fh.bfType=='B'+256*'M')
  {
    SetDlgItemText(hDlg,IDC_HEADER, "Windows Bitmap");

    SetDlgItemInt(hDlg,IDC_WIDTH,(UINT)BmpData.ih.biWidth,0);
    SetDlgItemInt(hDlg,IDC_HEIGHT,(UINT)BmpData.ih.biHeight,0);
    SetColorsInfo( GetDlgItem(hDlg,IDC_COLORS), BmpData.ih.biBitCount );

    switch(BmpData.ih.biCompression)
    {
      case BI_RLE8:
      case BI_RLE4:
        t=BmpData.ih.biWidth*BmpData.ih.biHeight*BmpData.ih.biBitCount;
        if(t)
        {
          t=800*BmpData.ih.biSizeImage/t;
          wsprintf(buf,"to %d%% of original size", t);
          SetDlgItemText(hDlg,IDC_COMPRESSION,buf);
        }
        else
        {
          SetDlgItemText(hDlg,IDC_COMPRESSION,"Error: division by zero");
        }
        break;

      default:
        SetDlgItemText(hDlg,IDC_COMPRESSION,"NO");
        break;
    }

    SetDlgItemInt(hDlg,IDC_PELSPERX,(UINT)BmpData.ih.biXPelsPerMeter,0);
    SetDlgItemInt(hDlg,IDC_PELSPERY,(UINT)BmpData.ih.biYPelsPerMeter,0);
    SetProp(hDlg, "PPM-X", (HANDLE)BmpData.ih.biXPelsPerMeter );
    SetProp(hDlg, "PPM-Y", (HANDLE)BmpData.ih.biYPelsPerMeter );

    //SetDlgItemInt(hDlg,IDC_COLORS,(UINT)BmpData.ih.biClrUsed,0);

    //IDC_CMBRATIO
    Show(IDC_BMP0,IDC_CMBRATIO,SW_SHOW);
    SendDlgItemMessage( hDlg, IDC_CMBRATIO, CB_ADDSTRING, 0,
      (LPARAM)(LPCTSTR)"Small fonts - 100%" );
    SendDlgItemMessage( hDlg, IDC_CMBRATIO, CB_ADDSTRING, 0,
      (LPARAM)(LPCTSTR)"Large fonts - 125%" );
    SendDlgItemMessage( hDlg, IDC_CMBRATIO, CB_ADDSTRING, 0,
      (LPARAM)(LPCTSTR)"Undefined" );
    SetCmbRatio(
      GetDlgItem(hDlg,IDC_CMBRATIO),
      BmpData.ih.biXPelsPerMeter,
      BmpData.ih.biYPelsPerMeter);
  }
  else
  {
    return "Bad bitmap header...";
  }

  return NULL; // No error
}


void BmpProp::Destroy()
{
  RemoveProp(hDlg, "PPM-X");
  RemoveProp(hDlg, "PPM-Y");
}


LRESULT BmpProp::Command(WPARAM wParam,LPARAM lParam)
{
  switch (LOWORD(wParam))
  {
    case IDC_PELSPERX:
    case IDC_PELSPERY:
      if(HIWORD(wParam)==EN_CHANGE)
      {
        SetCmbRatio(
          GetDlgItem(hDlg,IDC_CMBRATIO),
          GetDlgItemInt(hDlg,IDC_PELSPERX,NULL,0),
          GetDlgItemInt(hDlg,IDC_PELSPERY,NULL,0) );
        PropSheet_Changed(GetParent(hDlg), hDlg);
      }
      break;

    case IDC_CMBRATIO:
      if(HIWORD(wParam)==CBN_SELCHANGE)
      {
        switch( SendDlgItemMessage(hDlg,IDC_CMBRATIO,CB_GETCURSEL,0,0) )
        {
          case 0:
            SetDlgItemInt(hDlg,IDC_PELSPERX,3790,0);
            SetDlgItemInt(hDlg,IDC_PELSPERY,3780,0);
            break;

          case 1:
            SetDlgItemInt(hDlg,IDC_PELSPERX,4740,0);
            SetDlgItemInt(hDlg,IDC_PELSPERY,4740,0);
            break;

          case 2:
            SetDlgItemInt(hDlg,IDC_PELSPERX,0,0);
            SetDlgItemInt(hDlg,IDC_PELSPERY,0,0);
            break;
        }
      }
      break;
    default:
      break;
  }
  return TRUE;
}


LPSTR BmpProp::Apply(LPSTR szFile)
{
  DWORD r[2];

  r[0]=GetDlgItemInt(hDlg,IDC_PELSPERX,NULL,0);
  r[1]=GetDlgItemInt(hDlg,IDC_PELSPERY,NULL,0);

  if( GetProp(hDlg, "PPM-X") != (HANDLE)r[0]  ||
      GetProp(hDlg, "PPM-Y") != (HANDLE)r[1]  )
  {
    LPSTR msg;
    // User changed ratio -- save
    msg=Reopen(szFile,0x26);
    if(!msg)
    {
      if( _hwrite(hFile,(LPSTR)r,sizeof(r)) == sizeof(r) ) return NULL;
      else return "Cannot write to %s.\n";
    }
    else return msg;
  }
  return NULL;
}

//internal service function
void BmpProp::SetCmbRatio(HWND hWnd,int x,int y)
{
  int i;
  if( x==3790 && y==3780 ) i=0;
  else if( x==4740 && y==4740 ) i=1;
  else if( x==0 && y==0 ) i=2;
  else i=-1;

  SendMessage(hWnd,CB_SETCURSEL,i,0);
}

// GIF class implementation
LPSTR GifProp::Load()
{
  char buf[32];
  int t,len;

  #pragma pack( push, pp1 )
  #pragma pack( 1 )
  struct tagGIF
  {
    BYTE label[6];
    GIFScreenDesc gif;
  } GifData;
  #pragma pack( pop, pp1 )

  READ(GifData);
  wsprintf(buf,"%.6s",GifData.label);
  SetDlgItemText(hDlg,IDC_HEADER, buf);

  SetDlgItemInt(hDlg,IDC_WIDTH,GifData.gif.width,0);
  SetDlgItemInt(hDlg,IDC_HEIGHT,GifData.gif.height,0);


  //SetDlgItemInt(hDlg,IDC_BITS,BITSPERPIXEL(GifData.gif),0);
  SetColorsInfo( GetDlgItem(hDlg,IDC_COLORS), BITSPERPIXEL(GifData.gif) );

  //SetDlgItemInt(hDlg,IDC_BACKGROUND,GifData.gif.ColorTransparent,0);
  //SetDlgItemInt(hDlg,IDC_COLORBITS,COLORDEPTH(GifData.gif),0);

  t=GifData.gif.width * GifData.gif.height * BITSPERPIXEL(GifData.gif);
  len=_llseek(hFile,0,FILE_END);
  if(t)
  {
    t=(800*len)/t;
    wsprintf( buf, "to %d%% of original size", t );
    SetDlgItemText(hDlg,IDC_COMPRESSION,buf);
  }
  else
  {
    SetDlgItemText(hDlg,IDC_COMPRESSION,"Error: division by zero");
  }

  // List of GIF blocks - to IDC_LISTVIEW
  {
    LV_COLUMN lvc;
    RECT rc,rcDlg;
    HWND hlv=GetDlgItem(hDlg,IDC_LISTVIEW);

    // Resize IDC_LISTVIEW
    GetWindowRect(hDlg,&rcDlg);
    GetWindowRect(hlv,&rc);

    // wsprintf(buf,"%u,%u %u,%u",rc.left,rc.top,rc.right,rc.bottom);
    // MessageBox(NULL,buf,"IDC_LISTVIEW",0);
    // wsprintf(buf,"%u,%u %u,%u",rcDlg.left,rcDlg.top,rcDlg.right,rcDlg.bottom);
    // MessageBox(NULL,buf,"hDlg",0);

    t=rc.left-rcDlg.left;
    MoveWindow( hlv,
      rc.left-rcDlg.left,
      rc.top-rcDlg.top,
      rcDlg.right - rc.left, // - t,
      rcDlg.bottom- rc.top,  // - t,
      0);

    GetClientRect(hlv,&rc);
    lvc.mask = LVCF_WIDTH|LVCF_TEXT|LVCF_SUBITEM;

    lvc.pszText = "Name";
    rc.right -= GetSystemMetrics(SM_CYHSCROLL);
    lvc.cx = rc.right/4+2;
    lvc.iSubItem=1;
    ListView_InsertColumn(hlv,0,&lvc);

    lvc.pszText ="Details";
    lvc.cx = (rc.right/4-1)*3;
    lvc.iSubItem=2;
    ListView_InsertColumn(hlv,1,&lvc);
  }
  Show(IDC_GIF0,IDC_LISTVIEW,SW_SHOW);

  t=sizeof(GifData);
  if( HAS_GMAP(GifData.gif) ) t+= ( 2<<(GifData.gif.dif & 0x07) )*3;
  _llseek(hFile,t,0);
  nImages=0;

  return (LPSTR)-1; // Let us start Update()ing
}

// Retrieve several CONTROL/not more than one IMAGE block at a time
LPSTR GifProp::Update()
{
  int i;
  BYTE ch;
  char buf[300], *name;
  buf[0]=0;

  READ(ch);
  switch(ch)
  {
    case 0x3B:
      i=ListView_GetColumnWidth(GetDlgItem(hDlg,IDC_LISTVIEW),0);
      ListView_SetColumnWidth(GetDlgItem(hDlg,IDC_LISTVIEW),0,LVSCW_AUTOSIZE);
      if(i>ListView_GetColumnWidth(GetDlgItem(hDlg,IDC_LISTVIEW),0))
        ListView_SetColumnWidth(GetDlgItem(hDlg,IDC_LISTVIEW),0,i);

      SetFocus(GetDlgItem(hDlg,IDC_LISTVIEW));
      return NULL; // GIF stream terminator

    case 0x2C: // Image Descriptor
    {
      name="IMAGE";
      nImages++;
      GIFImageDesc id;
      READ(id);
      wsprintf(buf,"%ux%u at (%u,%u)",
        (int)id.width,(int)id.height,(int)id.left,(int)id.top);
      if(id.dif & 0x80) // Local Color Table Flag
      {
        strcat(buf,", local pallete");
        SCIP( ( 2<<(id.dif & 7) )*3 );
      }
      if(id.dif & 0x40) // Interlace Flag
      {
        strcat(buf,", interlaced");
      }
      // Scip image data
      SCIP(1);  // LZW code size
    }
    break;

    case 0x21: // extension
    {
      struct
      {
        BYTE n,size;
      } ext;
      READ(ext);

      ch=ext.size;
      switch(ext.n)
      {
        case 0xFF: // Application Extension
          name="APPLICATION";
          PREAD(buf,8); ch-=8; buf[8]=0;
          for(i=0;i<8;i++) if(buf[i]<' ') buf[i]=0;
          break;

        case 0xFE: // Comment Extension
          name="COMMENT";
          i=_hread(hFile,buf,ch);
          if(i==-1) return EMSG_ErrorReading;
          if(i!=ch) return EMSG_UnexpectedEOF;
          buf[ch]=0;
          ch=0;
          break;

        case 0xF9: // Graphic Control Extension
          name="CONTROL";
          {
            GIFControl gc;
            READ(gc);
            if(gc.delay) wsprintf(buf, "anim.delay %u.%u, ",(unsigned)(gc.delay/100),(unsigned)(gc.delay%100) );
            if(gc.dif & 1) strcat(buf,"transparent, ");
            switch( (gc.dif >> 2) & 7 )
            {
              case 1: strcat(buf,"don't dispose, "); break;
              case 2: strcat(buf,"dispose with background, "); break;
              case 3: strcat(buf,"dispose with prev.image, "); break;
            }
            ch=strlen(buf);
            if(ch>1) buf[ch-2]=0;
          }
          ch=0;
          break;

        case 0x01: // Plain Text Extension
          name="PLAIN TEXT";
          break;

        default:
          name="UNKNOWN";
          break;
      }
      if(ch) SCIP(ch);
    }
    break;

    default: return "Corrupted GIF file.";

  }

  // Add line to ListView
  {
    LV_ITEM lvi;
    HWND h= GetDlgItem(hDlg,IDC_LISTVIEW);

    lvi.mask = LVIF_TEXT;
    lvi.iItem = ListView_GetItemCount(h);
    lvi.iSubItem = 0;
    lvi.pszText = name;
    ListView_InsertItem( h, &lvi);

    lvi.iSubItem = 1;
    lvi.pszText = buf;
    ListView_SetItem( h, &lvi);

    wsprintf(buf,"GIF blocks %u, image blocks %u",lvi.iItem+1,nImages);
    SetDlgItemText(hDlg,IDC_GIF0,buf);
  }

  for(;;) // Scip data sub-blocks
  {
    READ(ch); // Data sub-block length
    if(ch==0) break;
    SCIP(ch);
  }

  return (LPSTR)-1;
}
