#define READ(x) PREAD(&x,sizeof(x))
#define PREAD(p,size)\
  switch( _hread(hFile,p,size) )\
  {\
    case -1: return EMSG_ErrorReading;\
    case size: break;\
    default: return EMSG_UnexpectedEOF;\
  }
#define SCIP(size) _llseek(hFile,size,1)

class ImgSize{
public:
  // ==== Callback virtual functions

  // Returns: NULL: ok, close hFile
  //          (-1): ok, enable Update, do not close hFile
  //          else: pointer to ErrorMsg, close hFile
  virtual LPSTR Load()=0; //  hFile - handle   ;

  // optional functions
  virtual LPSTR Apply(LPSTR szFile); //       Reopen()
                                     // . NULL ok, else ErrorMsg
  virtual LRESULT Command(WPARAM wParam,LPARAM lParam); // all WM_COMMAND messages
  virtual void Destroy();
  // for ~slow~ collecting/updaing information (e.g. number of words in text)
  // Returns: see Load()
  virtual LPSTR Update();

  // ==== Class variables
  HFILE hFile;
  HWND hDlg;
  int yAdd;
  //LPVOID lpData;

  // ==== Class service functions
  void Show(int idFrom, int idTo, int fShow); //   
  void Add(LPSTR sLabel,LPSTR sText);         //    .
  LPSTR Reopen(LPSTR szFile,int pos);         // . NULL ok, else ErrorMsg
};

typedef ImgSize *pImgSize;

// Children of ImgSize: one for each file type

class BmpProp:public ImgSize
{
public:
  LPSTR Load();
  void Destroy();
  LRESULT Command(WPARAM wParam,LPARAM lParam);
  LPSTR Apply(LPSTR szFile);

  // BmpProp service function
  void SetCmbRatio(HWND hWnd,int x,int y);
};

class GifProp:public ImgSize
{
public:
  LPSTR Load();
  LPSTR Update();

  // GifProp custom data
  int nImages;
  //int len;
};


