#ifndef _SHELLEXT_H
#define _SHELLEXT_H

#define ODS(sz) OutputDebugString(sz)

// The class ID of this Shell extension class:
// {51F0ACC0-9E3F-11d0-B82B-444553540000}
DEFINE_GUID(CLSID_ShellExtension,0x51f0acc0, 0x9e3f, 0x11d0, 0xb8, 0x2b, 0x44, 0x45, 0x53, 0x54, 0x0, 0x0);

// this class factory object creates context menu handlers for Windows 95 shell
class CShellExtClassFactory : public IClassFactory
{
protected:
	ULONG	m_cRef;

public:
	CShellExtClassFactory();
	~CShellExtClassFactory();

	//IUnknown members
	STDMETHODIMP			QueryInterface(REFIID, LPVOID FAR *);
	STDMETHODIMP_(ULONG)	AddRef();
	STDMETHODIMP_(ULONG)	Release();

	//IClassFactory members
	STDMETHODIMP		CreateInstance(LPUNKNOWN, REFIID, LPVOID FAR *);
	STDMETHODIMP		LockServer(BOOL);

};
typedef CShellExtClassFactory *LPCSHELLEXTCLASSFACTORY;

// this is the actual OLE Shell context menu handler
class ImgSize;
class CShellExt : public IShellExtInit, IShellPropSheetExt
{
public:
    char szFile[MAX_PATH];
    //VSAP

protected:
	ULONG        m_cRef;
	LPDATAOBJECT m_pDataObj;

public:
  CShellExt();
  ~CShellExt();

  //IUnknown members
  STDMETHODIMP            QueryInterface(REFIID, LPVOID FAR *);
  STDMETHODIMP_(ULONG)    AddRef();
  STDMETHODIMP_(ULONG)    Release();

  //IShellExtInit methods
  STDMETHODIMP            Initialize(LPCITEMIDLIST pIDFolder,
                                     LPDATAOBJECT pDataObj,
                                     HKEY hKeyID);

  //IShellPropSheetExt methods
  STDMETHODIMP AddPages(LPFNADDPROPSHEETPAGE lpfnAddPage, LPARAM lParam);

  STDMETHODIMP ReplacePage(UINT uPageID,
    LPFNADDPROPSHEETPAGE lpfnReplaceWith, LPARAM lParam);

};
typedef CShellExt *LPCSHELLEXT;

#pragma pack( push, pp1 )
#pragma pack( 1 )
typedef struct tagMoreData
{
  PROPSHEETPAGE psp;
  ImgSize *pObjImgSize;
  //int  nExtNumber;
  char szFile[MAX_PATH];
} MoreData;
#pragma pack( pop, pp1 )

#endif // _SHELLEXT_H
