//  Implements the IShellPropSheetExt member functions necessary to
//  support the property sheet page of this shell extension.  This
//  page is displayed when the user selects "Properties..." after
//  right clicking on a file

#include "priv.h"
#include "ImgSize.h"
#include "resource.h"
#include "gif.h"
#include "pcx.h"
#include "classes.h"

extern UINT g_cRefThisDll;      // Reference count of this DLL
extern HINSTANCE g_hmodThisDll; // Handle to this DLL itself
#define UM_UPDATE (WM_USER+1)

#include "classes.cpp"

// Generate object-creation functions + 3 arrays from Binding.cpp
#define DEF(ext,idd,cls) pImgSize CALLBACK MK_##cls() {return new cls;}
  #include "Binding.cpp"

//   ..array of pointers to object-creation functions
typedef pImgSize CALLBACK MK_ImgSize();
typedef MK_ImgSize *pMK_ImgSize;
#define DEF(ext,idd,cls) &MK_##cls,
  const pMK_ImgSize procFileExt[]={
  #include "Binding.cpp"
  NULL};

//   ..array filename extensions
#define DEF(ext,idd,cls) ext,
const char szFileExt[][5]={
  #include "Binding.cpp"
  "\0"};

//   ..array resource ids for dialog templates
#define DEF(ext,idd,cls) idd,
const int iddFileExt[]={
  #include "Binding.cpp"
  0};


// Hide all child controls but show IDC_HEADER
// Put error message to IDC_HEADER
void PropError(HWND hDlg,LPSTR msg)
{
  HWND hWnd;
  for( hWnd=GetWindow(hDlg,GW_CHILD); hWnd; hWnd=GetWindow(hWnd,GW_HWNDNEXT) )
  {
    ShowWindow(hWnd,SW_HIDE);
  }

  hWnd=GetDlgItem(hDlg,IDC_HEADER);
  SetWindowText(hWnd,msg);
  ShowWindow( hWnd, SW_SHOW );
}


//  Callback dialog procedure for the BMP property page
//  RETURN VALUE:
//    Depends on message.  In general, return TRUE if we process it.

BOOL CALLBACK PropPageDlgProc(
  HWND hDlg, UINT uMessage, WPARAM wParam, LPARAM lParam)
{
  MoreData *pm;
  ImgSize *pObjImgSize;

  switch (uMessage)
  {
    case WM_INITDIALOG:
      // When the shell creates a dialog box for a property sheet page,
      // it passes the pointer to the PROPSHEETPAGE data structure as
      // lParam. The dialog procedures of extensions typically store it
      // in the DWL_USER of the dialog box window.
      SetWindowLong(hDlg, DWL_USER, lParam);
      pm = (MoreData *)lParam;

      pObjImgSize = (procFileExt[pm->psp.lParam])();
      pm->pObjImgSize = pObjImgSize;

      pObjImgSize->hDlg = hDlg;
      {
        RECT r;
        GetWindowRect(GetDlgItem(hDlg, IDC_LINE),&r);
        ScreenToClient(hDlg,(LPPOINT)&r);
        pObjImgSize->yAdd = r.top+10;
      }
      //pm->lpData = NULL;
      if( *(pm->szFile) )
      {
        HFILE hfile;

        if( (hfile = _lopen(pm->szFile, OF_READ)) != HFILE_ERROR )
        {
          pObjImgSize->hFile = hfile;
          LPSTR msg = pObjImgSize->Load();
          if(msg!=(LPSTR)-1)
          {
            _lclose(hfile);
            pObjImgSize->hFile = NULL;
            if( msg!=NULL  ) PropError(hDlg, msg);
            //if( pm->lpData!=NULL )
            //{
            //  free(pm->lpData);
            //  pm->lpData = NULL;
            //}
          }
          else
          {
            PostMessage(hDlg,UM_UPDATE,0,0);
          }
        }
        else{ PropError(hDlg,"Error OPENing file..."); }
      }
      break;

    case UM_UPDATE:
      pm=(MoreData*)GetWindowLong(hDlg, DWL_USER);
      pObjImgSize = pm->pObjImgSize;
      {
        LPSTR msg = pObjImgSize->Update();
        if(msg!=(LPSTR)-1)
        {
          _lclose(pObjImgSize->hFile);
          pObjImgSize->hFile = NULL;
          if( msg!=NULL ) MessageBox(hDlg, msg, "Error", MB_ICONSTOP );

          //if( pm->lpData!=NULL )
          //{
          //  free(pm->lpData);
          //  pm->lpData = NULL;
          //}
        }
        else
        {
          PostMessage(hDlg,UM_UPDATE,0,0);
        }
      }
      break;

    case WM_DESTROY:
      pm=(MoreData*)GetWindowLong(hDlg, DWL_USER);
      pObjImgSize = pm->pObjImgSize;

      pObjImgSize->Destroy();
      delete pObjImgSize;
      break;

    case WM_COMMAND:
      pm=(MoreData*)GetWindowLong(hDlg, DWL_USER);
      pObjImgSize = pm->pObjImgSize;

      return pObjImgSize->Command(wParam,lParam);

    case WM_NOTIFY:
      switch (((NMHDR FAR *)lParam)->code)
      {
        case PSN_SETACTIVE:
          break;

        case PSN_APPLY:
          pm=(MoreData*)GetWindowLong(hDlg, DWL_USER);
          pObjImgSize = pm->pObjImgSize;
          {
            AgainApply:

            //User has clicked the OK or Apply button
            LPSTR msg;
            msg = pObjImgSize->Apply(pm->szFile);
            if( pObjImgSize->hFile ) _lclose(pObjImgSize->hFile);

            if(msg)
            {
              char buf[300];
              wsprintf(buf,msg,pm->szFile);
              switch(MessageBox(hDlg,buf,"Error saving properties",MB_ABORTRETRYIGNORE ))
              {
                case IDRETRY: goto AgainApply;
                case IDABORT:
                  SetWindowLong(hDlg,DWL_MSGRESULT,PSNRET_INVALID_NOCHANGEPAGE);
                  return TRUE;
              }
            }
          }

          break;

        default:
          break;
      }
      break;

    default:
      return FALSE;
  }

  return TRUE;
}

//  PURPOSE: Called by the shell just before the property sheet is displayed.
//
//  PARAMETERS:
//    lpfnAddPage -  Pointer to the Shell's AddPage function
//    lParam      -  Passed as second parameter to lpfnAddPage
//
//  RETURN VALUE:
//    NOERROR in all cases.  If for some reason our pages don't get added,
//    the Shell still needs to bring up the Properties... sheet.

STDMETHODIMP CShellExt::AddPages(LPFNADDPROPSHEETPAGE lpfnAddPage, LPARAM lParam)
{
  MoreData m;
  HPROPSHEETPAGE hpage;

  ODS("CShellExt::AddPages()\r\n");

  FORMATETC fmte = {
    CF_HDROP, (DVTARGETDEVICE FAR *)NULL,
    DVASPECT_CONTENT, -1,TYMED_HGLOBAL};

  STGMEDIUM medium;
  HRESULT hres = 0;

  if (m_pDataObj)  //Paranoid check, m_pDataObj should have something by now...
     hres = m_pDataObj->GetData(&fmte, &medium);

  if (SUCCEEDED(hres))
  {
    //Find out how many files the user has selected...
    UINT cbFiles = 0;
    //LPCSHELLEXT lpcsext = this;

    if (medium.hGlobal)
      cbFiles = DragQueryFile((HDROP)medium.hGlobal, (UINT)-1, 0, 0);

    if (cbFiles < 2)
    {
      //OK, the user has only selected a single file, so lets go ahead
      //and add the property sheet.  Note that it doesn't HAVE to be this
      //way, but for simplicity and educational reasons, I'll only add
      //the property sheet if a single file is selected.

      //Get the name of the file the user has clicked on
      if (cbFiles)
      {
        DragQueryFile((HDROP)medium.hGlobal, 0,
          szFile, sizeof(szFile));
      }

      int i=strlen(szFile);
      if( i<4 ) return NOERROR; // Not BMP/GIF/..

      int nExtNumber;
      for(nExtNumber=0;szFileExt[nExtNumber][0];nExtNumber++)
      {
        if( !stricmp(szFile+i-4,szFileExt[nExtNumber]) ) goto ExtFound;
      }
      return NOERROR; // Not supported extension
      ExtFound:
      // Create a property sheet page object from a dialog box.
      //
      // We store a pointer to our class in the m.psp.lParam, so we
      // can access our class members from within the PropPageDlgProc
      //
      // If the page needs more instance data, you can append
      // arbitrary size of data at the end of this structure,
      // and pass it to the CreatePropSheetPage. In such a case,
      // the size of entire data structure (including page specific
      // data) must be stored in the dwSize field.   Note that in
      // general you should NOT need to do this, as you can simply
      // store a pointer to data in the lParam member.

      m.psp.dwSize      = sizeof(m);
      m.psp.dwFlags     = PSP_USEREFPARENT | PSP_USETITLE;
      m.psp.hInstance   = g_hmodThisDll;
      m.psp.pszTemplate = MAKEINTRESOURCE(iddFileExt[nExtNumber]);
      m.psp.hIcon       = 0;
      m.psp.pszTitle    = "Picture";//szPageTitleFileExt[nExtNumber];
      m.psp.pfnDlgProc  = PropPageDlgProc;
      m.psp.pcRefParent = &g_cRefThisDll;
      m.psp.lParam      = nExtNumber;//(LPARAM)lpcsext;
      m.pObjImgSize    = NULL;
      strcpy(m.szFile,szFile);

      hpage = CreatePropertySheetPage(&m.psp);

      if (hpage)
      {
        if (!lpfnAddPage(hpage, lParam))
          DestroyPropertySheetPage(hpage);
      }
    }
  }

  return NOERROR;
}

//  Called by the shell only for Control Panel property sheet extensions
STDMETHODIMP CShellExt::ReplacePage(
  UINT uPageID, LPFNADDPROPSHEETPAGE lpfnReplaceWith, LPARAM lParam)
{
    ODS("CShellExt::ReplacePage()\r\n");
    // We don't support this function.  It should never be called.
    return E_FAIL;
}
