//---------------------------------------------------------------------------
#pragma warn -dup
#include <vcl\vcl.h>
#include <vcl\inifiles.hpp>
#pragma hdrstop

#include "nntpmain.h"
#include "msabout.h"
#include "nntpsu.h"
#include "popview.h"
#include "nntppst.h"
//---------------------------------------------------------------------------
#pragma link "msnntp"
#pragma link "msmb"
#pragma link "agsocket"
#pragma link "msmsg"
#pragma resource "*.dfm"
TNNTPForm *NNTPForm;
//---------------------------------------------------------------------------
__fastcall TNNTPForm::TNNTPForm(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TNNTPForm::EnableControls(void)
{
  HeadersButton->Enabled=true;
  RetrieveHeaders1->Enabled=true;
  ArticleButton->Enabled=true;
  RetrieveArticles1->Enabled=true;
  PostButton->Enabled=true;
  Post1->Enabled=true;
  CancelButton->Enabled=false;
  Cancel1->Enabled=true;
  SetupButton->Enabled=true;
  Setup1->Enabled=true;
  ExitButton->Enabled=true;
  Exit1->Enabled=true;
  Help1->Enabled=true;
  NGEdit->Enabled=true;
  ListView1->Cursor=crDefault;
}
//---------------------------------------------------------------------------
void __fastcall TNNTPForm::DisableControls(void)
{
  HeadersButton->Enabled=false;
  RetrieveHeaders1->Enabled=false;
  ArticleButton->Enabled=false;
  RetrieveArticles1->Enabled=false;
  PostButton->Enabled=false;
  Post1->Enabled=false;
  CancelButton->Enabled=true;
  Cancel1->Enabled=true;
  SetupButton->Enabled=false;
  Setup1->Enabled=false;
  ExitButton->Enabled=false;
  Exit1->Enabled=false;
  Help1->Enabled=false;
  ListView1->Cursor=crHourGlass;
  NGEdit->Enabled=false;
}
//---------------------------------------------------------------------------
void __fastcall TNNTPForm::About1Click(TObject *Sender)
{
  TAboutDlg *AboutDlg=new TAboutDlg(this);
  try
  {
    AboutDlg->ProgramName->Caption="TmsNNTP component demo for C++ Builder";
    AboutDlg->ProductVersion->Caption=msVersion;
    AboutDlg->ShowModal();
    delete AboutDlg;
  }
  catch(...)
  {
    delete AboutDlg;
    throw;
  };
}
//---------------------------------------------------------------------------
void __fastcall TNNTPForm::SetupButtonClick(TObject *Sender)
{
  TSetupDlg *SetupDlg=new TSetupDlg(this);
  try
  {
    SetupDlg->ServerEdit->Text=msNNTP1->Server;
    SetupDlg->UserAddressEdit->Text=UserAddress;
    SetupDlg->UserNameEdit->Text=UserName;
    SetupDlg->EncodingComboBox->ItemIndex=(int)Encoding;
    SetupDlg->CharSetComboBox->ItemIndex=(int)CharSet;
    SetupDlg->LogFileNameEdit->Text=msNNTP1->LogFileName;
    SetupDlg->HdrStepEdit->Text=IntToStr(HdrStep);
    if (SetupDlg->ShowModal()==mrOk)
    {
      msNNTP1->Server=SetupDlg->ServerEdit->Text;
      UserAddress=SetupDlg->UserAddressEdit->Text;
      UserName=SetupDlg->UserNameEdit->Text;
      Encoding=(TMsgEncoding)SetupDlg->EncodingComboBox->ItemIndex;
      CharSet=(TCharSet)SetupDlg->CharSetComboBox->ItemIndex;
      msNNTP1->LogFileName=SetupDlg->LogFileNameEdit->Text;
      try
      {
        HdrStep=StrToInt(Trim(SetupDlg->HdrStepEdit->Text));
      }
      catch (EConvertError&)
      {
        HdrStep=50;
      }
    };
    delete SetupDlg;
  }
  catch(...)
  {
    delete SetupDlg;
    throw;
  }
}
//---------------------------------------------------------------------------
void __fastcall TNNTPForm::FormCreate(TObject *Sender)
{
  IniFileName=ChangeFileExt(Application->ExeName,".INI");
  TIniFile *IniFile=new TIniFile(IniFileName);
  msNNTP1->Server=IniFile->ReadString("Setup","Server","");
  UserAddress=IniFile->ReadString("Setup","EMail Address","");
  UserName=IniFile->ReadString("Setup","Name","");
  msNNTP1->LogFileName=IniFile->ReadString("Setup","Log File","");
  CharSet=(TCharSet)IniFile->ReadInteger("Setup","CharSet",0);
  Encoding=(TMsgEncoding)IniFile->ReadInteger("Setup","Encoding",0);
  HdrStep=IniFile->ReadInteger("Setup","Header Step",50);
  delete IniFile;
  Posting=false;
}
//---------------------------------------------------------------------------
void __fastcall TNNTPForm::FormClose(TObject *Sender, TCloseAction &Action)
{
  msNNTP1->CloseConnection();
  TIniFile *IniFile=new TIniFile(IniFileName);
  IniFile->WriteString("Setup","Server",msNNTP1->Server);
  IniFile->WriteString("Setup","EMail Address",UserAddress);
  IniFile->WriteString("Setup","Name",UserName);
  IniFile->WriteString("Setup","Log File",msNNTP1->LogFileName);
  IniFile->WriteInteger("Setup","CharSet",(int)CharSet);
  IniFile->WriteInteger("Setup","Encoding",(int)Encoding);
  IniFile->WriteInteger("Setup","Header Step",HdrStep);
  delete IniFile;
}
//---------------------------------------------------------------------------
void __fastcall TNNTPForm::HeadersButtonClick(TObject *Sender)
{
  DisableControls();
  try
  {
    msNNTP1->NewsGroup=NGEdit->Text;
    msNNTP1->RetrieveNextNHeaders(HdrStep,true);
    EnableControls();
  }
  catch(...)
  {
    EnableControls();
    throw;
  }
}
//---------------------------------------------------------------------------
void __fastcall TNNTPForm::ArticleButtonClick(TObject *Sender)
{
 if (ListView1->Selected)
 {
  DisableControls();
  try
  {
    msNNTP1->RetrieveArticleByNumber(msNNTP1->NewsHeadersList->Items[ListView1->Selected->Index]->Number);
    EnableControls();
  }
  catch(...)
  {
    EnableControls();
    throw;
  }
  TMsgViewDlg *MsgViewDlg=new TMsgViewDlg(this);
  try
  {
    MsgViewDlg->MailMessage=msArticle1;
    MsgViewDlg->ShowModal();
    delete MsgViewDlg;
  }
  catch(...)
  {
    delete MsgViewDlg;
    throw;
  }
 }
 else
  MessageDlg("Please select an article first",
              mtError,TMsgDlgButtons() << mbOK,0);

}
//---------------------------------------------------------------------------
void __fastcall TNNTPForm::CancelButtonClick(TObject *Sender)
{
  msNNTP1->Cancel();	
}
//---------------------------------------------------------------------------
void __fastcall TNNTPForm::ExitButtonClick(TObject *Sender)
{
  Close();
}
//---------------------------------------------------------------------------
void __fastcall TNNTPForm::msNNTP1ArticleRetrieved(TObject *Sender)
{
  StatusBar1->Panels->Items[1]->Text="Article retrieved";
}
//---------------------------------------------------------------------------
void __fastcall TNNTPForm::msNNTP1Cancel(TObject *Sender)
{
  StatusBar1->Panels->Items[1]->Text="Operation has been canceled";
}
//---------------------------------------------------------------------------
void __fastcall TNNTPForm::msNNTP1Closed(TObject *Sender)
{
  StatusBar1->Panels->Items[1]->Text="Connection closed";
}
//---------------------------------------------------------------------------
void __fastcall TNNTPForm::msNNTP1Error(TObject *Sender, AnsiString &Msg)
{
  StatusBar1->Panels->Items[1]->Text=Msg;
}
//---------------------------------------------------------------------------
void __fastcall TNNTPForm::msNNTP1GroupSelected(TObject *Sender)
{
  StatusBar1->Panels->Items[0]->Text="Total articles: "+IntToStr(msNNTP1->TotalArticles);
  StatusBar1->Panels->Items[2]->Text=msNNTP1->NewsGroup;
}
//---------------------------------------------------------------------------
void __fastcall TNNTPForm::msNNTP1NextHeaderRetrieved(TObject *Sender, int Num)
{
  TListItem *Item;
  AnsiString Addr,AName,s,TZ;
  TDateTime DT;
  Item=ListView1->Items->Add();
  Item->Caption=msNNTP1->NewsHeadersList->Items[Num]->GetFieldBody("Subject");
  s=msNNTP1->NewsHeadersList->Items[Num]->GetFieldBody("From");
  SplitAddress(s,Addr,AName);
  if (AName!="")
    s=AName; else s=Addr;
  Item->SubItems->Add(s);
  s=msNNTP1->NewsHeadersList->Items[Num]->GetFieldBody("Date");
  MailDateToDateTime(s,DT,TZ);
  Item->SubItems->Add(DT.DateString());
  Item->SubItems->Add(msNNTP1->NewsHeadersList->Items[Num]->GetFieldBody("Lines"));
  StatusBar1->Panels->Items[1]->Text=IntToStr(Num+1)+" headers retrieved";
}
//---------------------------------------------------------------------------
void __fastcall TNNTPForm::msNNTP1Open(TObject *Sender)
{
  StatusBar1->Panels->Items[1]->Text="Opening connection";
}
//---------------------------------------------------------------------------
void __fastcall TNNTPForm::NGEditChange(TObject *Sender)
{
  if (msNNTP1->NewsHeadersList->Count)
  {
    msNNTP1->NewsHeadersList->Clear();
    ListView1->Items->Clear();
  }
}
//---------------------------------------------------------------------------
void __fastcall TNNTPForm::PostButtonClick(TObject *Sender)
{
  TArticleForm *ArticleForm=new TArticleForm(this);
  try
  {
    ArticleForm->NewsGroupsEdit->Text=NGEdit->Text;
    if (ArticleForm->ShowModal()==mrOk)
    {
      msArticle1->Clear();
      msArticle1->Sender->Address=UserAddress;
      msArticle1->Sender->Name=UserName;
      msArticle1->NewsGroups=ArticleForm->NewsGroupsEdit->Text;
      msArticle1->Subject=ArticleForm->SubjectEdit->Text;
      msArticle1->Encoding=Encoding;
      msArticle1->CharSet=CharSet;
      for (int i=0; i<ArticleForm->AttComboBox->Items->Count; i++)
        msArticle1->Attachments->AddFile(ArticleForm->AttComboBox->Items->Strings[i]);
      msArticle1->Body=ArticleForm->BodyMemo->Lines;
      DisableControls();
      try
      {
        Posting=true;
        msNNTP1->PostArticle();
        EnableControls();
        Posting=false;
      }
      catch(...)
      {
        Posting=false;
        EnableControls();
        throw;
      }
    }
  delete ArticleForm;
 }
 catch(...)
 {
  delete ArticleForm;
  throw;
 }
}
//---------------------------------------------------------------------------
void __fastcall TNNTPForm::msNNTP1Posted(TObject *Sender)
{
  StatusBar1->Panels->Items[1]->Text="Article has been successfully posted";
}
//---------------------------------------------------------------------------
void __fastcall TNNTPForm::msNNTP1Posting(TObject *Sender)
{
  StatusBar1->Panels->Items[1]->Text="Posting article...";
}
//---------------------------------------------------------------------------
void __fastcall TNNTPForm::msNNTP1LastHeaderRetrieved(TObject *Sender)
{
  StatusBar1->Panels->Items[1]->Text="Last header retrieved";
}
//---------------------------------------------------------------------------
void __fastcall TNNTPForm::msNNTP1Progress(TObject *Sender, int Perc,
	long Transferred)
{
  if (!Posting)
   StatusBar1->Panels->Items[1]->Text=IntToStr(Perc)+"% retrieved";
}
//---------------------------------------------------------------------------
