//---------------------------------------------------------------------------
#pragma warn -dup
#include <vcl\vcl.h>
#include <vcl\inifiles.hpp>
#pragma hdrstop

#include "rmmain.h"
#include "rmdemosu.h"
#include "msabout.h"
//---------------------------------------------------------------------------
#pragma link "mspop3"
#pragma link "msmb"
#pragma link "agsocket"
#pragma resource "*.dfm"
TRemotePOPForm *RemotePOPForm;
//---------------------------------------------------------------------------
__fastcall TRemotePOPForm::TRemotePOPForm(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TRemotePOPForm::About1Click(TObject *Sender)
{
  TAboutDlg *AboutDlg=new TAboutDlg(this);
  try
  {
   AboutDlg->ProgramName->Caption="Remote Mail Demo";
   AboutDlg->ProductVersion->Caption=msVersion;
   AboutDlg->ShowModal();
   delete AboutDlg;
  }
  catch(...)
  {
   delete AboutDlg;
   throw;
  };
}
//---------------------------------------------------------------------------
void __fastcall TRemotePOPForm::ExitButtonClick(TObject *Sender)
{
  Close();	
}
//---------------------------------------------------------------------------
void __fastcall TRemotePOPForm::SetupButtonClick(TObject *Sender)
{
  TSetupDlg *SetupDlg=new TSetupDlg(this);
  try
  {
   SetupDlg->ServerEdit->Text=msRemotePOP1->Server;
   SetupDlg->UserNameEdit->Text=msRemotePOP1->UserName;
   SetupDlg->PasswordEdit->Text=msRemotePOP1->Password;
   SetupDlg->LogFileNameEdit->Text=msRemotePOP1->LogFileName;
   SetupDlg->AttDirEdit->Text=msRemotePOP1->MessageDirectory;
   if (SetupDlg->ShowModal()==mrOk)
   {
     msRemotePOP1->Server=SetupDlg->ServerEdit->Text;
     msRemotePOP1->UserName=SetupDlg->UserNameEdit->Text;
     msRemotePOP1->Password=SetupDlg->PasswordEdit->Text;
     msRemotePOP1->LogFileName=SetupDlg->LogFileNameEdit->Text;
     msRemotePOP1->MessageDirectory=SetupDlg->AttDirEdit->Text;
   }
   delete SetupDlg;
  }
  catch(...)
  {
   delete SetupDlg;
   throw;
  }
}
//---------------------------------------------------------------------------
void __fastcall TRemotePOPForm::FormCreate(TObject *Sender)
{
  IniFileName=ChangeFileExt(Application->ExeName,".INI");
  TIniFile *IniFile=new TIniFile(IniFileName);
  msRemotePOP1->Server=IniFile->ReadString("Setup","Server","");
  msRemotePOP1->UserName=IniFile->ReadString("Setup","User Name","");
  msRemotePOP1->Password=IniFile->ReadString("Setup","Password","");
  msRemotePOP1->LogFileName=IniFile->ReadString("Setup","Log File","");
  msRemotePOP1->MessageDirectory=IniFile->ReadString("Setup","Messages","");
  delete IniFile;
}
//---------------------------------------------------------------------------
void __fastcall TRemotePOPForm::FormClose(TObject *Sender, TCloseAction &Action)
{
  TIniFile *IniFile=new TIniFile(IniFileName);
  IniFile->WriteString("Setup","Server",msRemotePOP1->Server);
  IniFile->WriteString("Setup","User Name",msRemotePOP1->UserName);
  IniFile->WriteString("Setup","Password",msRemotePOP1->Password);
  IniFile->WriteString("Setup","Log File",msRemotePOP1->LogFileName);
  IniFile->WriteString("Setup","Messages",msRemotePOP1->MessageDirectory);
  delete IniFile;
}
//---------------------------------------------------------------------------
void __fastcall TRemotePOPForm::UpdateButtonClick(TObject *Sender)
{
  if (ListView1->Items->Count)
    ListView1->Items->Clear();
  CancelButton->Enabled=true;
  Cancel1->Enabled=true;
  try
  {
   msRemotePOP1->UpdateRemoteInfo();
   CancelButton->Enabled=false;
   Cancel1->Enabled=false;
  }
  catch(...)
  {
   CancelButton->Enabled=false;
   Cancel1->Enabled=false;
   throw;
  }
}
//---------------------------------------------------------------------------
void __fastcall TRemotePOPForm::RetrieveButtonClick(TObject *Sender)
{
  for (int i=0; i<ListView1->Items->Count; i++)
  {
   if (ListView1->Items->Item[i]->Selected)
   {
    msRemotePOP1->MarkToRetrieve(i);
    msRemotePOP1->MarkToDelete(i);
    ListView1->Items->Item[i]->StateIndex=0;
   }
  }
}
//---------------------------------------------------------------------------
void __fastcall TRemotePOPForm::RetrCopyButtonClick(TObject *Sender)
{
  for (int i=0; i<ListView1->Items->Count; i++)
  {
   if (ListView1->Items->Item[i]->Selected)
   {
    msRemotePOP1->MarkToRetrieve(i);
    ListView1->Items->Item[i]->StateIndex=1;
   }
  }
}
//---------------------------------------------------------------------------
void __fastcall TRemotePOPForm::DeleteButtonClick(TObject *Sender)
{
  for (int i=0; i<ListView1->Items->Count; i++)
  {
   if (ListView1->Items->Item[i]->Selected)
   {
    msRemotePOP1->MarkToDelete(i);
    ListView1->Items->Item[i]->StateIndex=2;
   }
  }
}
//---------------------------------------------------------------------------
void __fastcall TRemotePOPForm::ResetButtonClick(TObject *Sender)
{
  for(int i=0; i<ListView1->Items->Count; i++)
  {
   msRemotePOP1->Reset(i);
   ListView1->Items->Item[i]->StateIndex=-1;
  }
}
//---------------------------------------------------------------------------
void __fastcall TRemotePOPForm::TransferButtonClick(TObject *Sender)
{
  ListView1->Items->Clear();
  CancelButton->Enabled=true;
  Cancel1->Enabled=true;
  try
  {
   msRemotePOP1->Transfer();
   msRemotePOP1->UpdateRemoteInfo();
   CancelButton->Enabled=false;
   Cancel1->Enabled=false;
  }
  catch(...)
  {
   CancelButton->Enabled=false;
   Cancel1->Enabled=false;
   throw;
  }
}
//---------------------------------------------------------------------------
void __fastcall TRemotePOPForm::CancelButtonClick(TObject *Sender)
{
  msRemotePOP1->Cancel();
  ListView1->Items->Clear();
}
//---------------------------------------------------------------------------
void __fastcall TRemotePOPForm::msRemotePOP1Cancel(TObject *Sender)
{
  StatusBar1->SimpleText="Operation has been canceled";
}
//---------------------------------------------------------------------------
void __fastcall TRemotePOPForm::msRemotePOP1Closed(TObject *Sender)
{
  StatusBar1->SimpleText="Connection closed";
}
//---------------------------------------------------------------------------
void __fastcall TRemotePOPForm::msRemotePOP1Closing(TObject *Sender)
{
  StatusBar1->SimpleText="Closing connection";
}
//---------------------------------------------------------------------------
void __fastcall TRemotePOPForm::msRemotePOP1DataTransfered(TObject *Sender)
{
  StatusBar1->SimpleText="Data has been transfered";
}
//---------------------------------------------------------------------------
void __fastcall TRemotePOPForm::msRemotePOP1Error(TObject *Sender,
	AnsiString &Msg)
{
  StatusBar1->SimpleText=Msg;
}
//---------------------------------------------------------------------------
void __fastcall TRemotePOPForm::msRemotePOP1InfoUpdated(TObject *Sender)
{
  StatusBar1->SimpleText=(AnsiString)msRemotePOP1->RemoteInfo->Count+" message(s)";
}
//---------------------------------------------------------------------------
void __fastcall TRemotePOPForm::msRemotePOP1NextInfoUpdated(TObject *Sender,
	int Num)
{
  AnsiString s,TZ;
  AnsiString Addr,AName;
  TDateTime DT;
  TListItem *Item;
  Item=ListView1->Items->Add();
  Item->Caption=msRemotePOP1->RemoteInfo->Items[Num]->Headers->GetFieldBody("Subject");
  s=msRemotePOP1->RemoteInfo->Items[Num]->Headers->GetFieldBody("From");
  SplitAddress(s,Addr,AName);
  if (AName!="")
    s=AName;
  else
    s=Addr;
  Item->SubItems->Add(s);
  Item->SubItems->Add((int)msRemotePOP1->RemoteInfo->Items[Num]->Size);
  s=msRemotePOP1->RemoteInfo->Items[Num]->Headers->GetFieldBody("Date");
  MailDateToDateTime(s,DT,TZ);
  Item->SubItems->Add(DT.DateString());
  StatusBar1->SimpleText=(AnsiString)(Num+1)+"/"+
      (AnsiString)msRemotePOP1->TotalMessages;
}
//---------------------------------------------------------------------------
void __fastcall TRemotePOPForm::msRemotePOP1Open(TObject *Sender)
{
  StatusBar1->SimpleText="Opening connection";
}
//---------------------------------------------------------------------------
void __fastcall TRemotePOPForm::msRemotePOP1TransferringData(TObject *Sender)
{
  StatusBar1->SimpleText="Transfering data";
}
//---------------------------------------------------------------------------
void __fastcall TRemotePOPForm::msRemotePOP1UpdatingInfo(TObject *Sender)
{
  StatusBar1->SimpleText="Updating headers";
}
//---------------------------------------------------------------------------
void __fastcall TRemotePOPForm::msRemotePOP1UserMessageSave(TObject *Sender,
	int Num, TMemoryStream *Contents)
{
  AnsiString FileName=msRemotePOP1->MessageDirectory+"msg_"+Num+".eml";
  Contents->SaveToFile(FileName);
}
//---------------------------------------------------------------------------
void __fastcall TRemotePOPForm::FormResize(TObject *Sender)
{
  Bevel1->Width=Width;	
}
//---------------------------------------------------------------------------