//---------------------------------------------------------------------------
#pragma warn -dup
#include <vcl\vcl.h>
#include <math.h>
#pragma hdrstop

#include "timemain.h"
//---------------------------------------------------------------------------
#pragma link "Agtime"
#pragma link "agsocket"
#pragma resource "*.dfm"
TTimeForm *TimeForm;
//---------------------------------------------------------------------------
__fastcall TTimeForm::TTimeForm(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TTimeForm::FormCreate(TObject *Sender)
{
  ServerComboBox->ItemIndex=0;
}
//---------------------------------------------------------------------------
void __fastcall TTimeForm::EnableControls(void)
{
  ServerComboBox->Enabled=true;
  ConnectButton->Enabled=true;
  CancelButton->Enabled=false;
}
//---------------------------------------------------------------------------
void __fastcall TTimeForm::DisableControls(void)
{
  ServerComboBox->Enabled=false;
  ConnectButton->Enabled=false;
  CancelButton->Enabled=true;
}
//---------------------------------------------------------------------------
void __fastcall TTimeForm::DrawClock(TDateTime DT)
{
  unsigned short Hour, Min, Sec, MSec;
  double pi=3.141592;
  int r;
  float Angle;
  int x1=PaintBox1->Width/2;
  int y1=PaintBox1->Height/2;
  DecodeTime(DT,Hour,Min,Sec,MSec);
  if (Hour>12)
    Hour=Hour-12;
  PaintBox1->Canvas->Brush->Color=clBtnFace;
  PaintBox1->Canvas->Pen->Color=clBlue;
  PaintBox1->Canvas->Pen->Width=2;
  PaintBox1->Canvas->Ellipse(2,2,2*x1-2,2*y1-2);
  PaintBox1->Canvas->Pen->Width=4;
  PaintBox1->Canvas->Pen->Color=clRed;
  PaintBox1->Canvas->MoveTo(x1, y1);
  r=x1-15;
  Angle=pi*Hour/6+2*pi*Min/12/60;
  PaintBox1->Canvas->LineTo(x1+r*sin(Angle),y1-r*cos(Angle));
  PaintBox1->Canvas->MoveTo(x1, y1);
  r=x1-4;
  Angle=pi*Min/30;
  PaintBox1->Canvas->LineTo(x1+r*sin(Angle),y1-r*cos(Angle));
  PaintBox1->Canvas->MoveTo(x1, y1);
  r=x1-4;
  Angle=pi*Sec/30;
  PaintBox1->Canvas->Pen->Color=clGreen;
  PaintBox1->Canvas->Pen->Width=1;
  PaintBox1->Canvas->LineTo(x1+r*sin(Angle),y1-r*cos(Angle));
}
//---------------------------------------------------------------------------

void __fastcall TTimeForm::ConnectButtonClick(TObject *Sender)
{
  DisableControls();
  agTime1->Server=ServerComboBox->Text;
  try
  {
    agTime1->Execute();
    Label1->Caption=DateTimeToStr(agTime1->DateTime);
    Label1->Caption=FormatDateTime("ddd, mmm dd yyyy",agTime1->DateTime);
    Label2->Caption=FormatDateTime("hh:mm:ss 'UTC'",agTime1->DateTime);
    DrawClock(agTime1->DateTime);
    EnableControls();
  }
  catch(...)
  {
    EnableControls();
    throw;
  };
}
//---------------------------------------------------------------------------
void __fastcall TTimeForm::CancelButtonClick(TObject *Sender)
{
  agTime1->Cancel();	
}
//---------------------------------------------------------------------------
void __fastcall TTimeForm::agTime1Cancel(TObject *Sender)
{
  StatusBar->SimpleText="Operation has been canceled";
}
//---------------------------------------------------------------------------
void __fastcall TTimeForm::agTime1Closed(TObject *Sender)
{
  StatusBar->SimpleText="Connection closed";
}
//---------------------------------------------------------------------------
void __fastcall TTimeForm::agTime1Connected(TObject *Sender)
{
  StatusBar->SimpleText="Connected to server";
}
//---------------------------------------------------------------------------
void __fastcall TTimeForm::agTime1Open(TObject *Sender)
{
  StatusBar->SimpleText="Opening connection";
}
//---------------------------------------------------------------------------
