/******************************************************************************
*    LISTFUN: Nice effect example using a listbox - 2/20/95 by Mark Gamber    *
*                                                                             *
*  This example uses an ownerdraw listbox to contain a list of checkboxes and *
*  associated text. The listbox tracks the checkbox handles and handles the   *
*  scrolling automatically.                                                   *
*                                                                             *
*     By using this program or any included part, the user assumes full       *
*  responsibility for it's use and may not hold the author liable for any     *
*  loss or damage. If unable to accept this condition, the program and any    *
*  included part may not be used and must be destroyed immediately.           *
******************************************************************************/

#include "windows.h"

// === Function Prototypes ====================================================

BOOL WINAPI MainDlgProc( HWND, UINT, WPARAM, LPARAM );

// === Global Variables =======================================================

HINSTANCE hInst;

// === Application Entry Point ================================================

int APIENTRY WinMain( HINSTANCE hInstance, HINSTANCE hPrev, LPSTR lpCmd,
                      int nShow )
{
   hInst = hInstance;                    //  Save instance handle in global and
   DialogBox( hInstance, MAKEINTRESOURCE( 10000 ), NULL,   //  start the dialog
              MainDlgProc );
   return( FALSE );                  //  Quit the program when dialog is closed
}

// === Main Dialog Box Procedure ==============================================

BOOL WINAPI MainDlgProc( HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam )
{
   switch( msg )
   {
      case WM_INITDIALOG:                 //  When the dialog box is started...
      {
         char szText[ 64 ];
         int i, iItem;
         RECT Rect;
         HWND hList;


         for( i = 0; i < 30; i++ )           //  Adding 30 items to the listbox
         {                                          //  Make up a string to add
            wsprintf( szText, "Item Number %d", i + 1 );         //  and add it
            iItem = SendDlgItemMessage( hDlg, 100, LB_ADDSTRING, 0,
                                        (LPARAM)szText );
            if( iItem != LB_ERR )                     //  If it was added ok...
            {                            //  Get the RECT the new item occupies
               SendDlgItemMessage( hDlg, 100, LB_GETITEMRECT, iItem, 
                                   (LPARAM)&Rect );
               hList = CreateWindow( "button", NULL,      //  Create a checkbox
                             WS_CHILD | WS_VISIBLE | BS_AUTOCHECKBOX,
                             1, Rect.top,                //  in the position of
                             Rect.bottom - Rect.top,   //  the new listbox item
                             Rect.bottom - Rect.top,       //  RECT so it works
                             GetDlgItem( hDlg, 100 ),       //  relative to the
                             (HMENU)( 100 + i ),                    //  listbox
                             hInst, NULL );
               if( hList )       //  Save the checkbox handle as list item data
                  SendDlgItemMessage( hDlg, 100, LB_SETITEMDATA, iItem,
                                      (LPARAM)hList );
            }
         }
         return( TRUE );
      }                                 //  End of MainDlgProc( WM_INITDIALOG )


      case WM_DRAWITEM:                            //  Listbox item needs drawn
      {
         LPDRAWITEMSTRUCT lpDs = (LPDRAWITEMSTRUCT)lParam;
         char szText[ 64 ];
         RECT Rect;
         HBRUSH hBrush;


         if( lpDs->itemID < 0 )                //  Not a legal value? Then quit
            break;

         GetClientRect( lpDs->hwndItem, &Rect );           //  Get listbox size
         Rect.top = lpDs->rcItem.top;              //  Use item vertical height
         Rect.bottom = lpDs->rcItem.bottom;
         Rect.left += 15;        //  Move right so the checkbox isn't clobbered
         hBrush = CreateSolidBrush( GetSysColor( COLOR_WINDOW ) );
         FillRect( lpDs->hDC, &Rect, hBrush );           //  Fill the item area
         DeleteObject( hBrush );                        //  Clean up fill brush
                                        
         SendMessage( lpDs->hwndItem, LB_GETTEXT, lpDs->itemID,
                      (LPARAM)szText );       //  Now get the listbox item text
         TextOut( lpDs->hDC, 17, lpDs->rcItem.top + 1,    //  And display it in
                  szText, lstrlen( szText ) );            //  the item position
         if( lpDs->itemState & ODS_SELECTED )
         {
            lpDs->rcItem.left += 15;             //   Don't invert the checkbox
            InvertRect( lpDs->hDC, &Rect );    //  If selected, invert the area
         }
         return( TRUE );
      }                                   //  End of MainDlgProc( WM_DRAWITEM )


      case WM_COMMAND:
         if( wParam == IDCANCEL )                                    //  See ya
         {
            EndDialog( hDlg, TRUE );
            return( TRUE );
         }
         if( HIWORD( wParam ) == LBN_DBLCLK )      //  List item double-clicked
         {
            HWND hCheckbox;
            int i;
                                                      //  Get the selected item
            i = SendDlgItemMessage( hDlg, 100, LB_GETCURSEL, 0, 0 );
            if( i == LB_ERR )
               break;                           //  Go away if there's an error
                                             //  Get the checkbox window handle
            hCheckbox = (HWND)SendDlgItemMessage( hDlg, 100, LB_GETITEMDATA,
                                                  i, 0 );
            if( SendMessage( hCheckbox, BM_GETCHECK, 0, 0 ) )    //  Invert the
               SendMessage( hCheckbox, BM_SETCHECK, 0, 0 );   //  current state
            else
               SendMessage( hCheckbox, BM_SETCHECK, 1, 0 );

            break;
         }
         break;                            //  End of MainDlgProc( WM_COMMAND )
   }
   return( FALSE );
}                                                      //  End of MainDlgProc()

// ============================================================================

