/******************************************************************************
|            Example of walking a network from Windows NT (Win32)             |
|                             1994 by Mark Gamber                             |
******************************************************************************/

#include "windows.h"
#include "string.h"

BOOL WINAPI MainDlgProc( HWND, UINT, WPARAM, LPARAM );           //  Prototypes
BOOL EnumHandler( HWND, DWORD, LPNETRESOURCE );

// ----------------------------------------------------------------------------

int APIENTRY WinMain( HINSTANCE hInstance, HINSTANCE hPrev, LPSTR lpCmd, 
                      int nShow )
{
   DialogBox( hInstance, MAKEINTRESOURCE( 10000 ), NULL, MainDlgProc );
   return( FALSE );
}

// ----------------------------------------------------------------------------

BOOL WINAPI MainDlgProc( HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam )
{
   switch( msg )
   {
      case WM_INITDIALOG:
         return( TRUE );

      case WM_COMMAND:
      {
         if( wParam == IDCANCEL || wParam == 102 )
         {
            EndDialog( hDlg, TRUE );                //  Exit if cancel or Close
            return( TRUE );
         }
       
         if( wParam == 101 )                                  //  Retry pressed
         {                                         //  Empty listbox and update
            SendMessage( GetDlgItem( hDlg, 100 ), LB_RESETCONTENT, 0, 0 );
            UpdateWindow( GetDlgItem( hDlg, 100 ) );
                    //  Call recursive routine, NULL specifies the network root
            return( EnumHandler( hDlg, 0, NULL ) );
         }
         break;
      }
   }
   return( FALSE );                                       //  Short dialog proc
}

// +--------------------------------------------------------------------------+
// |  EnumHandler() is a recursive routine which enumerates all found objects |
// |  given the network resource passed to it. NULL in LPNETRESOURCE begins   |
// |  enumeration at the network root. Subsequent calls from within the       |
// |  function specify a network segment based on findings of it's iteration  |
// +--------------------------------------------------------------------------+

BOOL EnumHandler( HWND hDlg, DWORD dwLevel, LPNETRESOURCE lpNet )
{
   DWORD dwStatus, dwSize, dwEntries, i, j;
   HANDLE hMem, hStr;
   LPSTR lpStr;
   LPNETRESOURCE lpNewNet;
   HANDLE hEnum;
      
   dwStatus = WNetOpenEnum( RESOURCE_GLOBALNET,          //  Look for the works
                            RESOURCETYPE_ANY,                  //  when opening
                            0, lpNet, &hEnum );
   if( dwStatus != NO_ERROR )
      return( FALSE );                       //  If there's an error, just exit
                                //  Allocate buffer space for a mess of objects
   hMem = GlobalAlloc( GHND, sizeof(NETRESOURCE) * 128 );
   if( ! hMem )
      return( FALSE );

   lpNewNet = (LPNETRESOURCE)GlobalLock( hMem );           //  Ready the buffer

   dwEntries = 128;                         //  We can handle up to 128 entries
   dwSize = sizeof(NETRESOURCE) * 128;
                                                  //  Enumerate into the buffer
   dwStatus = WNetEnumResource( hEnum, &dwEntries, (LPVOID)lpNewNet, &dwSize );

   if( dwStatus != NO_ERROR )            //  Rats...error, free memory and exit
   {                   
      WNetCloseEnum( hEnum );
      GlobalUnlock( hMem );
      GlobalFree( hMem );
      return( FALSE );
   }
   WNetCloseEnum( hEnum );                  //  Done with the handle...close it

   hStr = GlobalAlloc( GHND, 512 );              //  Allocate some string space
   lpStr = GlobalLock( hStr );

   for( i = 0; i < dwEntries; i++ )                 //  Loop through each entry
   {
      if( lpNewNet[ i ].lpRemoteName )                     //  Is there a name?
      {
         if( lpNewNet[ i ].dwDisplayType == RESOURCEDISPLAYTYPE_DOMAIN )
            strcpy( lpStr, "Domain..." );

         if( lpNewNet[ i ].dwDisplayType == RESOURCEDISPLAYTYPE_GENERIC )
            strcpy( lpStr, "Generic.." );

         if( lpNewNet[ i ].dwDisplayType == RESOURCEDISPLAYTYPE_SERVER )
            strcpy( lpStr, "Server..." );
         
         if( lpNewNet[ i ].dwDisplayType == RESOURCEDISPLAYTYPE_SHARE )
            strcpy( lpStr, "Share...." );
            
         for( j = 0; j < dwLevel; j++ )    //  Indent levels deeper with spaces
            strcat( lpStr, "......" );
                                               //  Add name and send to listbox
         strcat( lpStr, lpNewNet[ i ].lpRemoteName );
         SendMessage( GetDlgItem( hDlg, 100 ), LB_ADDSTRING, 0,(LPARAM)lpStr );
      }                                           //  Call again for each entry

      EnumHandler( hDlg, dwLevel + 1, lpNewNet + i );
   }

   GlobalUnlock( hStr );                           //  Free memory when leaving
   GlobalFree( hStr );     
   GlobalUnlock( hMem );
   GlobalFree( hMem );

   return( TRUE );
}

// ----------------------------------------------------------------------------


