/******************************************************************************
*                                                                             *
*  Example of a window with no actual caption but allows itself to be moved   *
*     and resized on the right border only. Public domain by Mark Gamber.     *
*     See NOTITLE.MAK for details on building this program.                   *
*                                                                             *
******************************************************************************/

#include "windows.h"
#include "notitle.h"


#ifdef WIN32                                              //  Defines for Win32
#define WMENTRY WINAPI
#else
#define WMENTRY PASCAL
#endif


HINSTANCE hInst;                                             //  Couple globals
HWND MainWin;

                                                        //  Program Entry Point

int WMENTRY WinMain( HINSTANCE hInstance, HINSTANCE hPrev, LPSTR lpCmd,
							int nShow )
{
   WNDCLASS wc;
   MSG msg;

   hInst = hInstance;                           //  We'll be needing this later

   wc.style = 0;
   wc.lpfnWndProc = MainWndProc;         //  Take care of the window class junk
   wc.cbClsExtra = 0;
   wc.cbWndExtra = 0;
   wc.hInstance = hInstance;
   wc.hCursor = LoadCursor( NULL, IDC_ARROW );
   wc.hIcon = LoadIcon( NULL, IDI_APPLICATION );
   wc.hbrBackground = (HBRUSH)( COLOR_WINDOW + 1 );
   wc.lpszMenuName = (LPSTR)0;
   wc.lpszClassName = "notitle";

   if( ! RegisterClass( &wc ) )    
      return( FALSE );

                                                //  Create the "minimal" window

   MainWin = CreateWindow( "notitle", NULL,
                           WS_POPUP | WS_THICKFRAME | WS_BORDER | WS_VISIBLE, 
                           CW_USEDEFAULT, CW_USEDEFAULT, 162, 37,
                           NULL, NULL, hInstance, NULL );
   if( ! MainWin )
      return( FALSE );           

   ShowWindow( MainWin, nShow );
   UpdateWindow( MainWin );

   while( GetMessage( &msg, NULL, 0, 0 ) )                 //  Loop until death
   {
      TranslateMessage( &msg );
      DispatchMessage( &msg );
   }
   return( msg.wParam );           
}

// ============================================================================
// ============================================================================

LRESULT WINAPI MainWndProc( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam )
{
   switch( msg )
   {
      case WM_CREATE:                              //  The window is created...
         CreateButtons( hWnd );    //  Create controls on windows face and font
         break;

      // ----------------------------------------------------------------------

      case WM_NCHITTEST:                         //  The mouse did something...
      {
         POINT Pt;
         RECT Rect;

         Pt.x = LOWORD( lParam );        //  Transfer pointer position to POINT
         Pt.y = HIWORD( lParam );             //  to convert screen position to
         ScreenToClient( hWnd, (LPPOINT)&Pt );              //  client position

         if( Pt.y < 8 )                  //  If over the "caption" when clicked
            return( HTCAPTION );            //  Tell Windows to move the window

         GetClientRect( hWnd, &Rect );
         if( Pt.x > Rect.right )
            return( HTRIGHT );

         return( HTCLIENT );
      }

      // ----------------------------------------------------------------------

      case WM_NCACTIVATE:                     //  Non-client area needs painted
      {                                        //  This is of interest since we
         HDC hDC;                         //  are drawing a "caption" ourselves
         HBRUSH hBrush;                          //  and it's a non-client area
         HPEN hPen;
         RECT Rect;
                                       //  Save new state for WM_PAINT messages
         SetProp( hWnd, MAKEINTATOM( 20000 ), (HANDLE)wParam );
         hDC = GetDC( hWnd );

         if( ! wParam )            //  If it's now inactive, get inactive color
         {
            hBrush = CreateSolidBrush( GetSysColor( COLOR_INACTIVECAPTION ) );
            hPen = CreatePen( PS_SOLID, 1,
                              GetSysColor( COLOR_INACTIVECAPTION ) );
         }
         else                                //  Else, get active caption color
         {
            hBrush = CreateSolidBrush( GetSysColor( COLOR_ACTIVECAPTION ) );
            hPen = CreatePen( PS_SOLID, 1,
                              GetSysColor( COLOR_ACTIVECAPTION ) );
         }

         SelectObject( hDC, hBrush );             //  Select all this stuff and
         SelectObject( hDC, hPen );                 //  draw the "caption" area

         GetClientRect( hWnd, &Rect );
         Rectangle( hDC, 0, 0, Rect.right, 8 );

         ReleaseDC( hWnd, hDC );

         DeleteObject( hBrush );
         DeleteObject( hPen );
                     //  Return through default processing so border is updated
         return( DefWindowProc( hWnd, msg, wParam, lParam ) );
      }

      // ----------------------------------------------------------------------

      case WM_DESTROY:
         PostQuitMessage( 0 );             
         break;

      // ----------------------------------------------------------------------

      case WM_COMMAND:
         if( wParam == IDM_EXIT )                   //  If button pressed, exit
         {
            PostQuitMessage( 0 );
            break;
         }
         break;

      // ----------------------------------------------------------------------

      case WM_PAINT:                            //  Paint the window background
      {
         PAINTSTRUCT Ps;
         HDC hDC;
         HBRUSH hBrush;
         HPEN hPen;
         int i, w;
         char str[ 8 ];
	
         hDC = BeginPaint( hWnd, &Ps );
                                    //  Make a brush with the caption bar color
         if( GetProp( hWnd, MAKEINTATOM( 20000 ) ) )
         {
            hBrush = CreateSolidBrush( GetSysColor( COLOR_ACTIVECAPTION ) );
            hPen = CreatePen( PS_SOLID, 1, GetSysColor( COLOR_ACTIVECAPTION ) );
         }
         else
         {
            hBrush = CreateSolidBrush( GetSysColor( COLOR_INACTIVECAPTION ) );
            hPen = CreatePen( PS_SOLID, 1, GetSysColor( COLOR_INACTIVECAPTION ) );
         }

         SelectObject( hDC, hBrush );
         SelectObject( hDC, hPen );

         Rectangle( hDC, 0, 0, Ps.rcPaint.right, 8 );

         DeleteObject( hBrush );
         DeleteObject( hPen );

         TextOut( hDC, 32, 11, "Exit", 4 );

         EndPaint( hWnd, &Ps );
         return( TRUE );
      }

      // ----------------------------------------------------------------------

      case WM_DRAWITEM:                        //  Handles the ownerdraw button
      {
         LPDRAWITEMSTRUCT lpDs = (LPDRAWITEMSTRUCT)lParam;
         HBITMAP hBmp;
         HDC mDC;
         int ButtonDown;
	
         if( lpDs->itemState & ODS_SELECTED )    //  Flag if the button is down
             ButtonDown = 1;
         else
             ButtonDown = 0;
                           //  Load the bitmap based on the button press status

         hBmp = LoadBitmap( hInst,
                            MAKEINTRESOURCE( BMP_FULLUP + ButtonDown ) );

         if( hBmp )               //  Next, create a DC to select the bitmap to
         {
            mDC = CreateCompatibleDC( lpDs->hDC );

            if( mDC )                //  Now select the bitmap and blast it out
            {
               SelectObject( mDC, hBmp );
               BitBlt( lpDs->hDC, 0, 0, 28, 16, mDC, 0, 0, SRCCOPY );
               DeleteDC( mDC );
            }
            DeleteObject( hBmp );               //  Back out the way we came in
         }
         return( TRUE );
      }

      // ----------------------------------------------------------------------

      default:
         return( DefWindowProc( hWnd, msg, wParam, lParam ) );
   }
	return( FALSE );
}

// ============================================================================
// ============================================================================

                                  //  Create the scrollbar and ownerdraw button
void CreateButtons( HWND hWnd )
{
   CreateWindow( "button", NULL, WS_CHILD | WS_VISIBLE | BS_OWNERDRAW,
                 2, 11, 28, 16,
                 hWnd, (HMENU)IDM_EXIT, hInst, NULL );
}


