#include <windows.h>

#include <winsock.h>
#include <winioctl.h>
#include <nspapi.h>

#include <stdio.h>
#include <stdlib.h>

#include "..\errstr.h"

#include "versinfo.h"


static const char *GetRegValStr(const HKEY root,const char * const subkey,const char * const name, const char * const def_val)
{
	HKEY key;
	static char string[1024];
	DWORD size = sizeof(string);
	DWORD type = REG_SZ;
	if(RegOpenKey(root,subkey,&key)) return def_val;
	if(RegQueryValueEx(key,name,0,&type,string,&size)) { *string=0; type = REG_SZ; }
	RegCloseKey(key);
	if(type!=REG_SZ) { fprintf(stderr,"%s\\%s should be string\n",subkey,name); *string=0; }
	return *string ? string : def_val;
}


static DWORD GetRegValNum(const HKEY root,const char * const subkey,const char * const name, const DWORD def_val)
{
	HKEY key;
	DWORD val;
	DWORD size = sizeof(val);
	DWORD type = REG_DWORD;
	if(RegOpenKey(root,subkey,&key)) return def_val;
	if(RegQueryValueEx(key,name,0,&type,(LPBYTE)&val,&size)) val = def_val;
	RegCloseKey(key);
	if(type!=REG_DWORD) { fprintf(stderr,"%s\\%s should be DWORD\n",subkey,name); val=def_val; }
	return val;
}


#define sample_dll "kernel32.dll"		// for version info
#define MAX_PROTS 100

int main(void)
{
	SetErrorMode(SEM_FAILCRITICALERRORS);
	
	// user and wksta, general info
	{ char username[100],wkstaname[MAX_COMPUTERNAME_LENGTH+1];
	  DWORD dummy = sizeof(username);
	  GetUserName(username,&dummy);
	  GetComputerName(wkstaname,&dummy);
	  printf("+++ Info for \"%s\" (current user \"%s\") +++\n",wkstaname,username);
	}

	puts("\nControl Panel:");
	{ printf("ParseAutoexec: %s\n",atoi(GetRegValStr(HKEY_CURRENT_USER,"Software\\Microsoft\\Windows NT\\CurrentVersion\\WinLogon","ParseAutoexec","1"))?"yes":"no");
	  printf("MinAnimate: %s\n",atoi(GetRegValStr(HKEY_CURRENT_USER,"Control Panel\\Desktop\\WindowMetrics","MinAnimate","1"))?"yes":"no");
	  printf("Beep: %s\n",GetRegValStr(HKEY_CURRENT_USER,"Control Panel\\Sound","Beep","???"));
	  printf("DragFullWindows: %s\n",atoi(GetRegValStr(HKEY_CURRENT_USER,"Control Panel\\Desktop","DragFullWindows","1"))?"yes":"no");
	  printf("ScreenSaver: %s\n",atoi(GetRegValStr(HKEY_CURRENT_USER,"Control Panel\\Desktop","ScreenSaveActive","0"))? (atoi(GetRegValStr(HKEY_CURRENT_USER,"Control Panel\\Desktop","ScreenSaverIsSecure","0"))?"secure":"yes") :"no");
	  printf("ActiveWindowTracking: %s\n",GetRegValNum(HKEY_CURRENT_USER,"Control Panel\\Mouse","ActiveWindowTracking",0) ? "yes" : "no");
	  printf("SnapToDefaultButton: %s\n",atoi(GetRegValStr(HKEY_CURRENT_USER,"Control Panel\\Mouse","SnapToDefaultButton","0"))?"yes":"no");
	  printf("SwapMouseButtons: %s\n",atoi(GetRegValStr(HKEY_CURRENT_USER,"Control Panel\\Mouse","SwapMouseButtons","0"))?"yes":"no");
	}

	puts("ErrorMode:");
	{ UINT errmode = GetRegValNum(HKEY_LOCAL_MACHINE,"SYSTEM\\CurrentControlSet\\Control\\Windows","ErrorMode",0);
	  #define testbit(bit) puts( errmode&bit ? "\t " #bit : "\t!" #bit);
	  testbit(SEM_FAILCRITICALERRORS);
	  testbit(SEM_NOGPFAULTERRORBOX);
	  testbit(SEM_NOALIGNMENTFAULTEXCEPT);
	  testbit(SEM_NOOPENFILEERRORBOX);
	  #undef testbit
	}

	{ HDC scr = GetDC(0);
	  printf("Screen: %d x %d Pixels, %d Bits/Pixel\n",GetDeviceCaps(scr,HORZRES),GetDeviceCaps(scr,VERTRES),GetDeviceCaps(scr,BITSPIXEL),GetDeviceCaps(scr,PLANES));
	  ReleaseDC(0,scr);
	}
	
	
	// nt-version
	puts("\nOS-Version:");
	{ char windir[MAX_PATH];
	  OSVERSIONINFO os;
	  os.dwOSVersionInfoSize = sizeof(os);
	  GetVersionEx(&os);
	  printf("Win32 Version %d.%d (Build %d)\nPlatform: ",os.dwMajorVersion,os.dwMinorVersion,LOWORD(os.dwBuildNumber));
	  switch(os.dwPlatformId) { case VER_PLATFORM_WIN32s: puts("Windows 3.1"); break;
				    case VER_PLATFORM_WIN32_WINDOWS: puts("Windows 95"); break;
				    case VER_PLATFORM_WIN32_NT: puts("Windows NT"); break;
				    default: puts("unknown"); break;
	  			  }
	  if(*os.szCSDVersion) printf("%s\n",os.szCSDVersion);

	  printf("Debugging kernel: %s\n",GetSystemMetrics(SM_DEBUG)?"yes":"no");
	  printf("Secure system: %s\n",GetSystemMetrics(SM_SECURE)?"yes":"no");

	  GetWindowsDirectory(windir,sizeof(windir));
	  printf("installed in \"%s\"\n",windir);
	  printf("Shell: %s\n",GetRegValStr(HKEY_LOCAL_MACHINE,"Software\\Microsoft\\Windows NT\\CurrentVersion\\WinLogon","Shell","(unknown)"));
	  { char buffer[100];
	    ExpandEnvironmentStrings("Command processor: %COMSPEC%",buffer,sizeof(buffer));
	    puts(buffer);
	  }
	  printf("\tExtensions %s\n",GetRegValNum(HKEY_CURRENT_USER,"Software\\Microsoft\\Command Processor","EnableExtensions",0) ? "enabled" : "disabled");
	  printf("\tCompletion char 0x%02x\n",GetRegValNum(HKEY_CURRENT_USER,"Software\\Microsoft\\Command Processor","CompletionChar",0));

	  puts("\nVersion-info of \"" sample_dll "\":");
	  GetSystemDirectory(windir,sizeof(windir));
	  strcat(windir,"\\" sample_dll);
	  print_version_info(windir);
	}

	// system-info
	{ SYSTEM_INFO info;
	  GetSystemInfo(&info);
	  puts("\nSystem:");
	  printf("%d processors level %d revision %04x - ",info.dwNumberOfProcessors,info.wProcessorLevel,info.wProcessorRevision);
	  switch(info.wProcessorArchitecture)
	  	{ case PROCESSOR_ARCHITECTURE_INTEL: puts("Intel"); break;
	  	  case PROCESSOR_ARCHITECTURE_MIPS: puts("MIPS"); break;
	  	  case PROCESSOR_ARCHITECTURE_ALPHA: puts("DEC Alpha"); break;
	  	  case PROCESSOR_ARCHITECTURE_PPC: puts("IBM Power PC"); break;
	  	  default: puts("unknown Processor"); break;
	  	}
	  { char buffer[100];
	    ExpandEnvironmentStrings("   (%PROCESSOR_IDENTIFIER%)",buffer,sizeof(buffer));
	    puts(buffer);
	  }
	  printf("Normal priority foreground processes boosted %d levels\n",GetRegValNum(HKEY_LOCAL_MACHINE,"System\\CurrentControlSet\\Control\\PriorityControl","Win32PrioritySeparation",2));
	  printf("Slow machine: %s\n",GetSystemMetrics(SM_SLOWMACHINE)?"yes":"no");
	  printf("addresses %#x - %#x, pages %d KB, alloc chunks %d KB\n",info.lpMinimumApplicationAddress,info.lpMaximumApplicationAddress,info.dwPageSize/1024,info.dwAllocationGranularity/1024);
	}

	// memory
	{ MEMORYSTATUS mem;
	  mem.dwLength = sizeof(mem);
	  GlobalMemoryStatus(&mem);
	  puts("\nMemory:");
	  printf("%u MB RAM, %u MB pagefile, %u MB virtual address space (user mode)\n",mem.dwTotalPhys/1024/1024,mem.dwTotalPageFile/1024/1024,mem.dwTotalVirtual/1024/1024);
	  printf("%s is preferred\n",GetRegValNum(HKEY_LOCAL_MACHINE,"System\\CurrentControlSet\\Control\\Session Manager\\Memory Management","LargeSystemCache",0) ? "Cache" : "Working Set");
	}

	// log. drives
	puts("\nlogical drives:");
	{ char roots[10240], *ptr=roots;
	  GetLogicalDriveStrings(sizeof(roots)-2,roots);
	  for(ptr = roots; *ptr; ptr = strchr(ptr,0)+1)
	  	{ UINT dr_type;

	  	  puts(ptr);

	  	   // drive type
		  fputs("\ttype: ",stdout);
		  switch(dr_type=GetDriveType(ptr)) { case 1: puts("(not a root)"); break;
		     				      case DRIVE_REMOVABLE: puts("removable"); break;
		     				      case DRIVE_FIXED: puts("fixed"); break;
		     				      case DRIVE_REMOTE: puts("network"); break;
		     				      case DRIVE_CDROM: puts("CD ROM"); break;
		     				      case DRIVE_RAMDISK: puts("Ramdisk"); break;
		     				      case 0:
		     				      default: puts("(unknown)\n"); break;
		     				    }

	  		// supported Media
		  if(dr_type!=DRIVE_REMOTE)
		  	    { char devpath[100] = "\\\\.\\X:";
			      HANDLE devhdl;
			      devpath[4] = *ptr;
			      devhdl=CreateFile(devpath,0,FILE_SHARE_WRITE,0,OPEN_EXISTING,0,0);
			      if(devhdl==INVALID_HANDLE_VALUE)
			      		printf("\tError opening Partition (%s)\n",Win32ErrString(GetLastError()));
			      else { DISK_GEOMETRY m_types[300];
			      	     DWORD els_returned;
			      	     if(!DeviceIoControl(devhdl,dr_type==DRIVE_REMOVABLE?IOCTL_DISK_GET_MEDIA_TYPES:IOCTL_DISK_GET_DRIVE_GEOMETRY,0,0,m_types,sizeof m_types,&els_returned,0))
			      			printf("\tError requesting supported media: (%s)\n",Win32ErrString(GetLastError()));
			      	     else { DISK_GEOMETRY *m_akt_type = m_types;
			      	     	    for(els_returned /= sizeof(*m_akt_type);els_returned--;m_akt_type++)
			      	     	    	{ char *descr;
			      	     	    	  switch(m_akt_type->MediaType) { case   F5_1Pt2_512:		descr = "5.25\", 1.2MB,  512 bytes/sector"; break;
								  case   F3_1Pt44_512:		descr = "3.5\", 1.44MB, 512 bytes/sector"; break;
								  case   F3_2Pt88_512:		descr = "3.5\", 2.88MB, 512 bytes/sector"; break;
								  case   F3_20Pt8_512:		descr = "3.5\", 20.8MB, 512 bytes/sector"; break;
								  case   F3_720_512:		descr = "3.5\", 720KB, 512 bytes/sector"; break;
								  case   F5_360_512:		descr = "5.25\", 360KB, 512 bytes/sector"; break;
								  case   F5_320_512:		descr = "5.25\", 320KB, 512 bytes/sector"; break;
								  case   F5_320_1024:		descr = "5.25\", 320KB, 1024 bytes/sector"; break;
								  case   F5_180_512:		descr = "5.25\", 180KB, 512 bytes/sector"; break;
								  case   F5_160_512:		descr = "5.25\", 160KB, 512 bytes/sector"; break;
								  case   RemovableMedia:	descr = "Removable media other than floppy"; break;
								  case   FixedMedia:		descr = "Fixed hard disk media"; break;
								  case Unknown:
								  default:			descr = "Format is unknown"; break;
			      	     	    					}
			      	     	    	  printf("\tsupported: %s\n\t\t%6d Cylinders\n\t\t%6d Tracks/Cylinder\n\t\t%6d Sectors/Track\n\t\t%6d Bytes/Sector\n",descr,m_akt_type->Cylinders.LowPart,m_akt_type->TracksPerCylinder,m_akt_type->SectorsPerTrack,m_akt_type->BytesPerSector);
			      	     	    	}
			      	     	  }
			      	     CloseHandle(devhdl);
			      	   }
			    }

	     	  // inserted medium
	     	  { char volname[MAX_PATH];
  		    DWORD sernum,max_fname_len,fsys_flags;
  		    char fsys_name[MAX_PATH];
  		    DWORD secperclus,bytespersec,numfreeclus,numtotalclus;
				  		     
		    if(!(GetVolumeInformation(ptr,volname,sizeof(volname),&sernum,&max_fname_len,&fsys_flags,fsys_name,sizeof(fsys_name)) &&
	     		GetDiskFreeSpace(ptr,&secperclus,&bytespersec,&numfreeclus,&numtotalclus)))
			printf("\tError requesting inserted medium: (%s)\n",Win32ErrString(GetLastError()));
	     	    else printf("\tMedium: \"%s\"\n"
	            		 "\t\tSer.Num.: \t0x%08lx\n"
	            		 "\t\tF'name Len: \t%lu\n"
	            		 "\t\tCase Sens.: \t%s\n"
	            		 "\t\tF'system Name: \t%s\n"
	            		 "\t\tBytes/Sec: \t%lu\n"
	            		 "\t\tSec/Cluster: \t%lu\n"
	            		 "\t\tKB total: \t%9u (%4u MB)\n"
	            		 "\t\tKB free: \t%9u (%4u MB)\n",
		            	volname,
		            	(ULONG)sernum,
		            	max_fname_len,
		            	fsys_flags&FS_CASE_SENSITIVE?"da":"njet",
		            	fsys_name,
		            	bytespersec,
		            	secperclus,
		            	secperclus*bytespersec*numtotalclus/1024,secperclus*bytespersec*numtotalclus/1024/1024,
		            	secperclus*bytespersec*numfreeclus/1024,secperclus*bytespersec*numfreeclus/1024/1024);
	     	  }
	  	}
	}
	puts("");
	printf("Long names in FAT will be %s\n",GetRegValNum(HKEY_LOCAL_MACHINE,"System\\CurrentControlSet\\Control\\FileSystem","Win31FileSystem",0) ? "forbidden" : "allowed");
	printf("Short names in NTFS will be %s\n",GetRegValNum(HKEY_LOCAL_MACHINE,"System\\CurrentControlSet\\Control\\FileSystem","NtfsDisable8dot3NameCreation",0) ? "omitted" : "created");

	// protocols
	{ PROTOCOL_INFO prots[MAX_PROTS];
	  DWORD protsize = sizeof(prots);
	  int numprots = EnumProtocols(0,prots,&protsize);
	  puts("\nNetwork:");
	  printf("Network installed: %s\n",GetSystemMetrics(SM_NETWORK)&0x1?"yes":"no");

	  if(numprots==SOCKET_ERROR) puts("EnumProtocols() failed");
	  else while(numprots--)
		{
			printf("\"%s\":\n",prots[numprots].lpProtocol);

			fputs("\tmax. MessageSize: ",stdout);
			if(prots[numprots].dwMessageSize==0) puts("(Stream)");
			else if(prots[numprots].dwMessageSize==~0UL) puts("(no limit)");
			else printf("%lu\n",prots[numprots].dwMessageSize);

			printf("\tSockAddr-Length: %d - %d\n",prots[numprots].iMinSockAddr,prots[numprots].iMaxSockAddr);

			#define bitout(bit) printf("\t%c "#bit"\n",bit&prots[numprots].dwServiceFlags?'*':' ')
			bitout(XP_CONNECTIONLESS);
			bitout(XP_GUARANTEED_DELIVERY);
			bitout(XP_GUARANTEED_ORDER);
			bitout(XP_MESSAGE_ORIENTED);
			bitout(XP_PSEUDO_STREAM);
			bitout(XP_GRACEFUL_CLOSE);
			bitout(XP_EXPEDITED_DATA);
			bitout(XP_CONNECT_DATA);
			bitout(XP_DISCONNECT_DATA);
			bitout(XP_SUPPORTS_BROADCAST);
			bitout(XP_SUPPORTS_MULTICAST);
			bitout(XP_BANDWIDTH_ALLOCATION);
			bitout(XP_FRAGMENTATION);
			bitout(XP_ENCRYPTS);
			#undef bitout
		}
	}

	// sockets
	{ WSADATA wsa;
	  puts("\nSockets:");
	  if(WSAStartup(MAKEWORD(1,1),&wsa)) puts("WSAStartup() failed");
	  else { printf("highest version supported: %d.%d\n"
			"max. sockets per process: %d\n"
			"max. UDP datagram: %d bytes\n"
			"description: \"%s\"\n"
			"state: \"%s\"\n",
			LOBYTE(wsa.wHighVersion),HIBYTE(wsa.wHighVersion),
			wsa.iMaxSockets,
			wsa.iMaxUdpDg,
			wsa.szDescription,
			wsa.szSystemStatus);
	  	 { char myname[100];
	  	   puts("\nAddresses:");
	  	   if(gethostname(myname,sizeof(myname)-1)) puts("\tgethostname() failed");
	  	   else { struct hostent *ich = gethostbyname(myname);
	  	   	  printf("standard hostname: \"%s\"\n",myname);
	  	   	  if(!ich) puts("gethostbyname() failed");
	  	   	  else { printf("official hostname: \"%s\"\n",ich->h_name);
	  	   	  	 { char **name;
	  	   	  	   puts("aliases:");
	  	   	  	   for(name=ich->h_aliases;*name;name++) printf("\t%s\n",*name);
	  	   	  	 }
	  	   	  	 { char **addresses;
	  	   	  	   puts("adresses:");
	  	   	  	   for(addresses=ich->h_addr_list;*addresses;addresses++) printf("\t%s\n",inet_ntoa(*(struct in_addr*)*addresses));
	  	   	  	 }
	  	   	       }
	  	   	}
	         }
  		 WSACleanup();
	       }
	}
	return 0;
}

