//======================================================================
// 
//  Filemon.h
//
//  Copyright (C) 1996 Mark Russinovich and Bryce Cogswell
//
//======================================================================

// undocumented ntoskrnl variable
extern PSHORT           NtBuildNumber;

// A structure representing the instance information associated with
// a particular device
typedef struct _DEVICE_EXTENSION
{
    ULONG  StateVariable;
} DEVICE_EXTENSION, *PDEVICE_EXTENSION;

// Structure for device specific data that keeps track of what
// drive and what filesystem device are hooked 
typedef struct {
   PDEVICE_OBJECT	FileSystem;
   unsigned		LogicalDrive;
} HOOK_EXTENSION, *PHOOK_EXTENSION;			

// Structure for our name hash table
typedef struct _nameentry {
   PFILE_OBJECT		FileObject;
   PCHAR		FullPathName;
   struct _nameentry 	*Next;
} HASH_ENTRY, *PHASH_ENTRY;

// Structure for keeping linked lists of output buffers
typedef struct _store {
    ULONG		Len;
    struct _store *	Next;
    CHAR		Data[ MAX_STORE ];
} STORE_BUF, *PSTORE_BUF;

// number of hash buckets
#define NUMHASH		0x100
#define HASHOBJECT(_fileobject)		(((ULONG)_fileobject)>>2)%NUMHASH

// NT Final Build number
#define NT4FINAL     1381

// internal data structure offsets - there is *no* clean way to get a process' name
// without doing a full systeminformation query on each call (which would obtain info
// on every process and thread in the system!)
#define NAMEOFFSET		0x1DC




