//======================================================================
// 
// Ioctlcmd.h
//
// Copyright (C) 1996 Mark Russinovich and Bryce Cogswell
//
// Common header file for device driver and GUI. Contains common
// data structure definitions and IOCTL command codes.
//
//======================================================================

// Define the various device type values.  Note that values used by Microsoft
// Corporation are in the range 0-32767, and 32768-65535 are reserved for use
// by customers.
#define FILE_DEVICE_FILEMON	0x00008300

// commands that the GUI can send the device driver
#define FILEMON_setdrives (ULONG) CTL_CODE( FILE_DEVICE_FILEMON, 0x00, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define FILEMON_zerostats (ULONG) CTL_CODE( FILE_DEVICE_FILEMON, 0x01, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define FILEMON_getstats  (ULONG) CTL_CODE( FILE_DEVICE_FILEMON, 0x02, METHOD_IN_DIRECT, FILE_ANY_ACCESS )
#define FILEMON_unloadquery (ULONG) CTL_CODE( FILE_DEVICE_FILEMON, 0x03, METHOD_BUFFERED, FILE_ANY_ACCESS )

// format of a data entry
typedef struct {
	ULONG	seq;
	char	text[0];
} ENTRY, *PENTRY;


// define page size for use by GUI
#ifndef PAGE_SIZE
#define PAGE_SIZE 4096
#endif

// an allocation unit size 
#define MAX_STORE	(PAGE_SIZE*16 - 8)

