/*** line ***/

#include "windows.h"
#include "pcl4w.h"
#include "sioerror.h"
#include "paint.h"
#include "line.h"

extern HWND hMainWnd;
extern int  OnLineFlag;

/* private */

static WORD RxSelector = 0;
static WORD TxSelector = 0;
static void FreeDOSmemory(void);

static void FreeDOSmemory(void)
{if(RxSelector)
   {GlobalPageUnlock(RxSelector);
    GlobalDosFree(RxSelector);
    RxSelector = 0;
   }
 if(TxSelector)
   {GlobalPageUnlock(TxSelector);
    GlobalDosFree(TxSelector);
    TxSelector = 0;
   }
}

/* public */

int GoOnLine(int Port, int BaudCode, int RxQueSize, int TxQueSize)
{DWORD dwValue;
 int RetCode;
 if(OnLineFlag) return TRUE;
 /* allocate windows/DOS memory for receive buffer */
 dwValue = GlobalDosAlloc(1<<(3+RxQueSize));
 if(dwValue)
   {/* get selector */
    RxSelector = LOWORD(dwValue);
    GlobalPageLock(RxSelector);
   }
 else
   {/* memory allocation error */
    RxSelector = 0;
    MessageBox(hMainWnd,"Cannot allocate memory","ERROR",MB_ICONEXCLAMATION | MB_OK);
    return FALSE;
   }
 /* pass selector to PCL4W */
 RetCode = SioRxBuf(Port,RxSelector,RxQueSize);
 if(RetCode<0)
   {SioError(RetCode,"SioRxBuf");
    FreeDOSmemory();
    return FALSE;
   }
 if(SioInfo('I'))
   {/* allocate windows/DOS memory for transmit buffer */
    dwValue = GlobalDosAlloc(1<<(3+TxQueSize));
    if(dwValue)
      {/* get selector */
       TxSelector = LOWORD(dwValue);
       GlobalPageLock(TxSelector);
      }
    else
      {/* memory allocation error */
       TxSelector = 0;
       MessageBox(hMainWnd,"Cannot allocate memory","ERROR",MB_ICONEXCLAMATION | MB_OK);
       return FALSE;
      }
    /* pass selector to PCL4W */
    RetCode = SioTxBuf(Port,TxSelector,TxQueSize);
    if(RetCode<0)
      {SioError(RetCode,"SioTxBuf");
       FreeDOSmemory();
       return FALSE;
      }
    DisplayLine("TX interrupts enabled");
   }
 /* reset Port */
 RetCode = SioReset(Port,BaudCode);
 if(RetCode<0)
   {SioError(RetCode,"SioReset");
    SioDone(Port); /* just in case */
    FreeDOSmemory();
    return FALSE;
   }
 SioParms(Port,NoParity,OneStopBit,WordLength8);
 DisplayLine("Port reset\n");
 /* set DTR & RTS */
 SioDTR(Port,'S');
 SioRTS(Port,'S');
#if 0
 /* set flow control */
 SioFlow(Port,TRUE);
 DisplayLine("Flow control enabled");
#endif
 /* Set FIFO level for 16550 */
 if( SioFIFO(Port,LEVEL_8) ) DisplayLine("16550 UART");
 /* clear PCL4C receive buffer */
 SioRxClear(Port);
 return TRUE;
} /* end GoOnLine */

void GoOffLine(int Port)
{SioDone(Port);
 FreeDOSmemory();
} /* end GoOffLine */