#include <windows.h>

#include <stdio.h>
#include <io.h>
#include <fcntl.h>
#include <stddef.h>
#include <time.h>


#include "versinfo.h"

//#include "..\debug.h"


#define isin(address,start,length) ((address)>=(start) && (address)<(start)+(length))


static void dump_export_directory(const void * const section_base, const DWORD section_base_virtual, const IMAGE_EXPORT_DIRECTORY * const exp)
{
	#define indent "      "
	#define adr(rva) ((void*)((char*)section_base+((DWORD)(rva))-section_base_virtual))
	
	int i;
	if(IsBadReadPtr(exp,sizeof(*exp))) puts(indent"!! data inaccessible!!");

	printf(indent"module name: \"%s\"\n",adr(exp->Name));
	printf(indent"created (GMT): %s",asctime(gmtime((const time_t*)&exp->TimeDateStamp)));
	printf(indent"version: %d.%d\n",exp->MajorVersion,exp->MinorVersion);
	printf(indent"%d exported functions\n",exp->NumberOfFunctions);
	printf(indent"%d exported names (entries relative to image base in RAM):\n",exp->NumberOfNames);

	printf(indent"%4s %8s %s\n","ord.","entry","name");
	printf(indent"%4s %8s %s\n","----","-----","----");

	{ const WORD * ordinal_table = adr(exp->AddressOfNameOrdinals);
	  const DWORD * function_table = adr(exp->AddressOfFunctions);
	  const DWORD * name_table = adr(exp->AddressOfNames);
	  for(i=min(exp->NumberOfFunctions,exp->NumberOfNames);i--;ordinal_table++,function_table++,name_table++)
		    printf(indent"%4d %8x %s\n",*ordinal_table + exp->Base,*function_table,adr(*name_table));
	}
	
	#undef adr
	#undef indent
}


static void dump_import_directory(const void * const section_base, const DWORD section_base_virtual, const IMAGE_IMPORT_DESCRIPTOR * imp)
{
	#define indent "      "
	#define adr(rva) ((void*)((char*)section_base+((DWORD)(rva))-section_base_virtual))

	for(;!IsBadReadPtr(imp,sizeof(*imp)) && imp->Name;imp++)
		{ IMAGE_THUNK_DATA *import_entry;
		  printf("\n"indent"from \"%s\":\n",adr(imp->Name));
		  if(imp->TimeDateStamp==~0) puts(indent"bound, new style");
		  else if(imp->TimeDateStamp) printf(indent"bound to %s",asctime(gmtime((const time_t*)&imp->TimeDateStamp)));
		  if(imp->OriginalFirstThunk) import_entry = adr(imp->OriginalFirstThunk);
		  else { puts(indent"(hint table missing, propably Borland bug)");
		  	 import_entry = adr(imp->FirstThunk);
		       }
		  printf(indent"%6s %s\n","ord.","name");
		  printf(indent"%6s %s\n","----","----");
		  for(;import_entry->u1.Ordinal;import_entry++)
		  	if(IMAGE_SNAP_BY_ORDINAL(import_entry->u1.Ordinal))
		  		printf(indent"%6u <only number supplied>\n",IMAGE_ORDINAL(import_entry->u1.Ordinal));
		  	else { IMAGE_IMPORT_BY_NAME *name_import = adr(import_entry->u1.AddressOfData);
		  	       printf(indent"%6u %.50s\n",name_import->Hint,name_import->Name);
		  	     }
		}
	if(IsBadReadPtr(imp,sizeof(*imp))) puts(indent"!! data inaccessible!!");
		
	#undef adr
	#undef indent
}


static void dump_resource_directory_entry(const int indent,const IMAGE_RESOURCE_DIRECTORY * const res_start, const IMAGE_RESOURCE_DIRECTORY_ENTRY * const entry,const BOOL output_types)
{
	if(entry->NameIsString) { char buffer[300];
				  IMAGE_RESOURCE_DIR_STRING_U * uni_name = (void*)((char*)res_start+entry->NameOffset);
				  WideCharToMultiByte(CP_OEMCP,0,uni_name->NameString,uni_name->Length,buffer,sizeof(buffer),0,0);
				  buffer[min(sizeof(buffer)-1,uni_name->Length)]=0;
				  printf("%*sname: \"%s\"",indent,"",buffer);
				}
	else if(output_types) switch(entry->Id) { case  1: printf("%*scursor",indent,""); break;
						  case  2: printf("%*sbitmap",indent,""); break;
						  case  3: printf("%*sicon",indent,""); break;
						  case  4: printf("%*smenu",indent,""); break;
						  case  5: printf("%*sdialog",indent,""); break;
						  case  6: printf("%*sstring",indent,""); break;
						  case  7: printf("%*sfontdir",indent,""); break;
						  case  8: printf("%*sfont",indent,""); break;
						  case  9: printf("%*saccelerators",indent,""); break;
						  case 10: printf("%*sRCdata",indent,""); break;
						  case 11: printf("%*smessage table",indent,""); break;
						  case 12: printf("%*sgroup cursor",indent,""); break;
						  case 14: printf("%*sgroup icon",indent,""); break;
						  case 16: printf("%*sversion info",indent,""); break;
						  default: printf("%*sunknown resource type %#4x",indent,"",entry->Id); break;
					        }
	else printf("%*sid: %#x",indent,"",entry->Id);
	fputs(", ",stdout);
	if(entry->DataIsDirectory) dump_resource_directory(indent+4,res_start,(void*)((char*)res_start+entry->OffsetToDirectory),FALSE);
	else { IMAGE_RESOURCE_DATA_ENTRY *data = (void*)((char*)res_start+entry->OffsetToData);
	       printf("%d bytes from offset %#x, codepage 0x%04x\n",data->Size,data->OffsetToData,data->CodePage);
	     }
}


static void dump_resource_directory(const int indent,const IMAGE_RESOURCE_DIRECTORY * const res_start, const IMAGE_RESOURCE_DIRECTORY * const dir,const BOOL output_types)
{
	if(IsBadReadPtr(dir,sizeof(*dir))) { puts("!! data inaccessible!!"); return; }
	printf("version: %d.%d, created (GMT): %s",dir->MajorVersion,dir->MinorVersion,asctime(gmtime((const time_t*)&dir->TimeDateStamp)));
	{ IMAGE_RESOURCE_DIRECTORY_ENTRY *single_resource = (void*)(dir+1);
	  int i;
	  for(i=0;i<dir->NumberOfNamedEntries+dir->NumberOfIdEntries;i++,single_resource++)
	  	dump_resource_directory_entry(indent,res_start,single_resource,output_types);
  	}
}

static void map_exe(const void *base)
{
	IMAGE_DOS_HEADER *dos_head = base;
	_Packed struct { DWORD signature;
			 IMAGE_FILE_HEADER _head;
			 IMAGE_OPTIONAL_HEADER opt_head;
			 IMAGE_SECTION_HEADER section_header[];		// actual number in NumberOfSections
		       } *header;
	
	if(dos_head->e_magic!='ZM') { puts("unknown type of file"); return; }	// verify DOS-EXE-Header
	header = (void*)((char*)dos_head + dos_head->e_lfanew);		// after end of DOS-EXE-Header: offset to PE-Header

	if(IsBadReadPtr(header,sizeof(*header)))					// start of PE-Header
		{ puts("(no PE header, propably DOS executable)"); return; }
	printf("DOS-stub: %ld bytes\n",(char*)header-(char*)dos_head-sizeof(IMAGE_DOS_HEADER));
	{ if(header->signature!=IMAGE_NT_SIGNATURE)					// verify PE format
		{ switch((unsigned short)header->signature)
		  	{ case IMAGE_DOS_SIGNATURE: puts("(DOS signature)"); return;
		  	  case IMAGE_OS2_SIGNATURE: puts("(Windows or OS/2 signature)"); return;
		  	  case IMAGE_OS2_SIGNATURE_LE: puts("(Windows, OS/2 or VxD signature)"); return;
		  	  default: puts("(unknown signature, propably DOS)"); return;
		  	}
		}
	}

	// finally, we have the PE image header
	  
	switch(header->_head.Machine)
	  	{ case IMAGE_FILE_MACHINE_I386: puts("Intel 80386 processor"); break;
	  	  case 0x014d: puts("Intel 80486 processor"); break;
	  	  case 0x014e: puts("Intel Pentium processor"); break;
		  case 0x0160: puts("R3000 (MIPS) processor, big endian"); break;
	  	  case IMAGE_FILE_MACHINE_R3000: puts("R3000 (MIPS) processor, little endian"); break;
	  	  case IMAGE_FILE_MACHINE_R4000: puts("R4000 (MIPS) processor, little endian"); break;
	  	  case IMAGE_FILE_MACHINE_R10000: puts("R10000 (MIPS) processor, little endian"); break;
	  	  case IMAGE_FILE_MACHINE_ALPHA: puts("DEC Alpha_AXP processor"); break;
	  	  case IMAGE_FILE_MACHINE_POWERPC: puts("IBM Power PC, little endian"); break;
	  	  default: printf("unknown processor: %04x\n",header->_head.Machine); break;
	  	}

	  printf("Relocation info %s\n",header->_head.Characteristics & IMAGE_FILE_RELOCS_STRIPPED ? "stripped" : "not stripped");
	  puts(header->_head.Characteristics & IMAGE_FILE_EXECUTABLE_IMAGE ? "executable file" : "object/library file");
	  printf("Line nunbers %s\n",header->_head.Characteristics & IMAGE_FILE_LINE_NUMS_STRIPPED ? "stripped" : "not stripped");
	  printf("Local symbols %s\n",header->_head.Characteristics & IMAGE_FILE_LOCAL_SYMS_STRIPPED ? "stripped" : "not stripped");
	  printf("Bytes of machine word are %s\n",header->_head.Characteristics & IMAGE_FILE_BYTES_REVERSED_LO ? "reversed" : "normal");
	  printf("%s32 bit word machine\n",header->_head.Characteristics & IMAGE_FILE_32BIT_MACHINE ? "":"non-");
	  printf("Debugging info %s\n",header->_head.Characteristics & IMAGE_FILE_DEBUG_STRIPPED ? "stripped" : "not stripped");
	  if(header->_head.Characteristics & IMAGE_FILE_SYSTEM) puts("System File");
	  if(header->_head.Characteristics & IMAGE_FILE_DLL) { puts("File is a DLL");
	  						       printf("  %snotify on ProcAttach\n",header->opt_head.DllCharacteristics & 0x1 ? "":"do not ");
	  						       printf("  %snotify on ThreadAttach\n",header->opt_head.DllCharacteristics & 0x4 ? "":"do not ");
	  						       printf("  %snotify on ProcDetach\n",header->opt_head.DllCharacteristics & 0x8 ? "":"do not ");
	  						       printf("  %snotify on ThreadDetach\n",header->opt_head.DllCharacteristics & 0x2 ? "":"do not ");
							     }

	  printf("%d entries in symbol table\n",header->_head.NumberOfSymbols);
	  printf("%d sections\n",header->_head.NumberOfSections);
	  printf("created (GMT): %s",asctime(gmtime((const time_t*)&header->_head.TimeDateStamp)));

	  printf("Linker version: %d.%d\n",header->opt_head.MajorLinkerVersion,header->opt_head.MinorLinkerVersion);
	  printf(".text start: %#8x, length: %6u bytes\n",header->opt_head.BaseOfCode,header->opt_head.SizeOfCode);
	  printf(".data start: %#8x, length: %6u bytes\n",header->opt_head.BaseOfData,header->opt_head.SizeOfInitializedData);
	  printf(".bss  start:      -/-, length: %6u bytes\n",header->opt_head.SizeOfUninitializedData);
	  printf("Preferred load base is %#8x\n",header->opt_head.ImageBase);
	  printf("Image size in RAM: %d KB\n",header->opt_head.SizeOfImage/1024);
	  printf("Sections aligned to %d bytes in RAM, %d bytes in file\n",header->opt_head.SectionAlignment,header->opt_head.FileAlignment);
	  printf("Versions: NT %d.%d, Win32 %d.%d, App %d.%d\n",header->opt_head.MajorOperatingSystemVersion,header->opt_head.MinorOperatingSystemVersion,header->opt_head.MajorSubsystemVersion,header->opt_head.MinorSubsystemVersion,header->opt_head.MajorImageVersion,header->opt_head.MinorImageVersion);
	  printf("Checksum: 0x%08x\n",header->opt_head.CheckSum);
	  switch(header->opt_head.Subsystem)
	  	{ case IMAGE_SUBSYSTEM_NATIVE: puts("uses no subsystem"); break;
	  	  case IMAGE_SUBSYSTEM_WINDOWS_GUI: puts("uses Windows graphical subsystem"); break;
	  	  case IMAGE_SUBSYSTEM_WINDOWS_CUI: puts("uses Windows console subsystem"); break;
	  	  case IMAGE_SUBSYSTEM_OS2_CUI: puts("uses OS/2 console subsystem"); break;
	  	  case IMAGE_SUBSYSTEM_POSIX_CUI: puts("uses Posix console subsystem"); break;
	  	  default: puts("uses unknown subsystem"); break;
	  	}
	  printf("Stack: %3d KB reserved, %3d KB committed\n",header->opt_head.SizeOfStackReserve/1024,header->opt_head.SizeOfStackCommit/1024);
	  printf("Heap:  %3d KB reserved, %3d KB committed\n",header->opt_head.SizeOfHeapReserve/1024,header->opt_head.SizeOfHeapCommit/1024);
	  printf("Size of headers / offset to sections in file: %#x\n",header->opt_head.SizeOfHeaders);

	  // walk through sections
	  { int sect;
	    const IMAGE_SECTION_HEADER * section_header;
	    for(sect=0,section_header=header->section_header;sect<header->_head.NumberOfSections;sect++,section_header++)
	  	{	// first, dump header
		  #define indent "    "
	  	  printf("\n\"%.*s\" (virt. Size/Address: %#x)\n",IMAGE_SIZEOF_SHORT_NAME,section_header->Name,section_header->Misc.VirtualSize);
	  	  printf("  %6d bytes at offset %#8x in RAM, %#8x in file\n",section_header->SizeOfRawData,section_header->VirtualAddress,section_header->PointerToRawData);

		  if(section_header->Characteristics & IMAGE_SCN_CNT_CODE)			puts(indent"contains code");
		  if(section_header->Characteristics & IMAGE_SCN_CNT_INITIALIZED_DATA)		puts(indent"contains initialized data");
		  if(section_header->Characteristics & IMAGE_SCN_CNT_UNINITIALIZED_DATA)	puts(indent"contains uninitialized data");

		  if(section_header->Characteristics & IMAGE_SCN_LNK_INFO)		puts(indent"contains comments / information");
		  if(section_header->Characteristics & IMAGE_SCN_LNK_REMOVE)		puts(indent"contents will not become part of image");
		  if(section_header->Characteristics & IMAGE_SCN_LNK_COMDAT)		puts(indent"contents is COMDAT (common block data, packaged functions)");
		  if(section_header->Characteristics & IMAGE_SCN_MEM_FARDATA)		puts(indent"? far data ?");
		  if(section_header->Characteristics & IMAGE_SCN_MEM_PURGEABLE)		puts(indent"purgeable");
		  if(section_header->Characteristics & IMAGE_SCN_MEM_16BIT)		puts(indent"? 16-bit-section ?");
		  if(section_header->Characteristics & IMAGE_SCN_MEM_LOCKED)		puts(indent"locked in memory");
		  if(section_header->Characteristics & IMAGE_SCN_MEM_PRELOAD)		puts(indent"preload");

		  if(!(section_header->Characteristics & IMAGE_SCN_ALIGN_64BYTES))	puts(indent"default alignment (16 bytes)");
		  else if(section_header->Characteristics & IMAGE_SCN_ALIGN_1BYTES)	puts(indent"1-byte-alignment");
		  else if(section_header->Characteristics & IMAGE_SCN_ALIGN_2BYTES)	puts(indent"2-byte-alignment");
		  else if(section_header->Characteristics & IMAGE_SCN_ALIGN_4BYTES)	puts(indent"4-byte-alignment");
		  else if(section_header->Characteristics & IMAGE_SCN_ALIGN_8BYTES)	puts(indent"8-byte-alignment");
		  else if(section_header->Characteristics & IMAGE_SCN_ALIGN_16BYTES)	puts(indent"16-byte-alignment");
		  else if(section_header->Characteristics & IMAGE_SCN_ALIGN_32BYTES)	puts(indent"32-byte-alignment");
		  else if(section_header->Characteristics & IMAGE_SCN_ALIGN_64BYTES)	puts(indent"64-byte-alignment");
		  else									puts(indent"unknown alignment");

		  if(section_header->Characteristics & IMAGE_SCN_LNK_NRELOC_OVFL)	puts(indent"contains extended relocations");
		  if(section_header->Characteristics & IMAGE_SCN_MEM_DISCARDABLE)	puts(indent"can be discarded");
		  if(section_header->Characteristics & IMAGE_SCN_MEM_NOT_CACHED)	puts(indent"is not cachable");
		  if(section_header->Characteristics & IMAGE_SCN_MEM_NOT_PAGED)		puts(indent"is not pageable");
		  if(section_header->Characteristics & IMAGE_SCN_MEM_SHARED)		puts(indent"is shareable");
		  if(section_header->Characteristics & IMAGE_SCN_MEM_EXECUTE)		puts(indent"is executable");
		  if(section_header->Characteristics & IMAGE_SCN_MEM_READ)		puts(indent"is readable");
		  if(section_header->Characteristics & IMAGE_SCN_MEM_WRITE)		puts(indent"is writeable");

	  	  if(isin(header->opt_head.AddressOfEntryPoint,section_header->VirtualAddress,section_header->SizeOfRawData))
	  	  	printf("\n"indent"at offset %#x: execution start\n",header->opt_head.AddressOfEntryPoint-section_header->VirtualAddress);

			// look for directory in section
	  	  	// if found, dump interesting stuff
	  	  { int directory;
	  	    const void * const section_data = (char*)base + section_header->PointerToRawData;
	  	    for(directory=0;directory<IMAGE_NUMBEROF_DIRECTORY_ENTRIES;directory++)
	  	  	if(isin(header->opt_head.DataDirectory[directory].VirtualAddress,section_header->VirtualAddress,section_header->SizeOfRawData))
	  	  		{ const void * const stuff_start = (char*)section_data + (header->opt_head.DataDirectory[directory].VirtualAddress - section_header->VirtualAddress);
	  				                                              // (virtual address of stuff               -                   virtual address of section) = offset of stuff in section
	  	  		  const unsigned stuff_length = header->opt_head.DataDirectory[directory].Size;
	  	  		  printf("\n"indent"at offset %#x (%u bytes): ",(char*)stuff_start-(char*)section_data,stuff_length);
	  	  		  switch(directory)
	  	  			{ case IMAGE_DIRECTORY_ENTRY_EXPORT:	puts("Export Directory");
	  	  								dump_export_directory(section_data,section_header->VirtualAddress,stuff_start);
	  	  								break;
	  	  			  case IMAGE_DIRECTORY_ENTRY_IMPORT:	puts("Import Directory");
	  	  			  					dump_import_directory(section_data,section_header->VirtualAddress,stuff_start);
	  	  			  					break;
	  	  			  case IMAGE_DIRECTORY_ENTRY_RESOURCE:	fputs("Resource Directory\n"indent indent,stdout);
						  	  			dump_resource_directory(sizeof(indent)*2,stuff_start,stuff_start,TRUE);
	  	  			  					break;
	  	  			  case IMAGE_DIRECTORY_ENTRY_EXCEPTION:	puts("Exception Directory"); break;
	  	  			  case IMAGE_DIRECTORY_ENTRY_SECURITY:	puts("Security Directory"); break;
	  	  			  case IMAGE_DIRECTORY_ENTRY_BASERELOC:	puts("Base Relocation Table"); break;
	  	  			  case IMAGE_DIRECTORY_ENTRY_DEBUG:	puts("Debug Directory"); break;
	  	  			  case IMAGE_DIRECTORY_ENTRY_COPYRIGHT:	printf("Description String \"%.*s\"\n",stuff_length,stuff_start);
	  	  			  					break;
	  	  			  case IMAGE_DIRECTORY_ENTRY_GLOBALPTR:	puts("Machine Value (MIPS GP)"); break;
	  	  			  case IMAGE_DIRECTORY_ENTRY_TLS:	puts("TLS Directory"); break;
	  	  			  case IMAGE_DIRECTORY_ENTRY_LOAD_CONFIG:	puts("Load Configuration Directory"); break;
	  	  			  case IMAGE_DIRECTORY_ENTRY_BOUND_IMPORT:	puts("Bound Import Directory"); break;
	  	  			  case IMAGE_DIRECTORY_ENTRY_IAT:	puts("Import Address Table"); break;
	  	  			  default:				puts("unknown directory"); break;
	  	  			}
	  	  		}
	  	  }
	  	}
	    #undef indent
	  }
}


int main(int argc, char **argv)
{
	while(*++argv) { HANDLE hFile, hMapping;
			 void *basepointer;
			 printf("\n+++ Portable Executable Map of \"%s\" +++\n\n",*argv);
			 if((hFile = CreateFile(*argv,GENERIC_READ,0,0,OPEN_EXISTING,FILE_FLAG_SEQUENTIAL_SCAN,0))==INVALID_HANDLE_VALUE)
			 	{ puts("(could not open)"); continue; }
			 if(!(hMapping = CreateFileMapping(hFile,0,PAGE_READONLY|SEC_COMMIT,0,0,0)))
			 	{ puts("(mapping failed)"); CloseHandle(hFile); continue; }
			 if(!(basepointer = MapViewOfFile(hMapping,FILE_MAP_READ,0,0,0)))
			 	{ puts("(view failed)"); CloseHandle(hMapping); CloseHandle(hFile); continue; }
			 map_exe(basepointer);
			 UnmapViewOfFile(basepointer);
			 CloseHandle(hMapping);
			 CloseHandle(hFile);
			 puts("\nVersion Info:");
			 print_version_info(*argv);
		       }
	return 0;
}

