/******************************************************************************
*                     Rotating Font example by Mark Gamber                    *
*                                                                             *
*  This example demonstrates how to create and use a True-Type font with an   *
*  angle other than "straight across". To build the example, use WIN32=1      *
*  to build for Win32 or no arguements to build for 16 bit Windows.           *
*  This software is public domain. By using the program or any included part, *
*  the user assumes full responsibility for it's use and may not hold the     *
*  author liable for any loss or damage. If unable to accept this restriction *
*  the software and all included parts must be destroyed immediately.         *
******************************************************************************/

#include "windows.h"

#ifdef WIN32                         //  Define WinMain type depending if Win32
#define ENTRYPOINT APIENTRY      
#else
#define ENTRYPOINT PASCAL
#endif

                                                        //  Function prototypes
LRESULT WINAPI MainWndProc( HWND, UINT, WPARAM, LPARAM );

                                                           //  Global variables
HINSTANCE hInst;
HWND hMainWnd;

                                                    //  Application entry point
int ENTRYPOINT WinMain( HINSTANCE hInstance, HINSTANCE hPrev, 
                        LPSTR lpCmd, int nShow )
{
   WNDCLASS wc;
   MSG msg;


   wc.style = 0;
   wc.lpfnWndProc = MainWndProc;             //  Initialize the class structure
   wc.hInstance = hInstance;
   wc.lpszClassName = wc.lpszMenuName = "RFont";
   wc.hIcon = LoadIcon( NULL, IDI_APPLICATION );
   wc.hCursor = LoadCursor( NULL, IDC_ARROW );
   wc.hbrBackground = GetStockObject( WHITE_BRUSH );
   wc.cbClsExtra = wc.cbWndExtra = 0;

   if( ! RegisterClass( &wc ) )               //  and register the class or die
      return( FALSE );
                                 //  Next, create the main window or die trying
   hMainWnd = CreateWindow( "RFont", "Rotating Font",
                            WS_OVERLAPPEDWINDOW,
                            CW_USEDEFAULT, CW_USEDEFAULT, 
                            200, 200,
                            NULL, NULL, hInstance, NULL );
   if( ! hMainWnd )
      return( FALSE );

   ShowWindow( hMainWnd, nShow );                        //  Display the window
   UpdateWindow( hMainWnd );

   while( GetMessage( &msg, NULL, 0, 0 ) )      //  Loop until the queue is dry
   {
      TranslateMessage( &msg );
      DispatchMessage( &msg );
   }

   return( FALSE );
}                                                          //  End of WinMain()


// ----------------------------------------------------------------------------
                                                      //  Main window procedure

LRESULT WINAPI MainWndProc( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam )
{
   switch( msg )
   {
      case WM_CREATE:                   //  Set angle in window prop 10000 to 0
         SetProp( hWnd, MAKEINTATOM( 10000 ), (HANDLE)0 );
         SetTimer( hWnd, 1, 250, 0 );     //  Start a 1/4 second timer and exit
         break;


      case WM_DESTROY:
         KillTimer( hWnd, 1 );                 //  Kill the timer, then the app
         PostQuitMessage( 0 );
         break;


      case WM_SIZE:                      //  Repaint the whole thing if resized
         InvalidateRect( hWnd, NULL, TRUE );
         break;


      case WM_TIMER:                           //  1/4 second timer has sounded
      {
         int iLastValue;
         HDC hDC;
         HFONT hFont;
         RECT Rect;
                                                        //  Get last angle used
         iLastValue = (int)GetProp( hWnd, MAKEINTATOM( 10000 ) );

         hDC = GetDC( hWnd );             //  Get a DC to the window and create
         hFont = CreateFont( 24, 0, iLastValue, 0, FW_BOLD,      //  a new font
                             0, 0, 0, 0, 0, 0, 0, 0,           //  based on the
                             "Arial" );                   //  angle using Arial
         SelectObject( hDC, hFont );                    //  Select the font and
         SetTextColor( hDC, RGB( 255, 255, 255 ) );     //  color white (erase)

         GetClientRect( hWnd, &Rect );
         Rect.right = Rect.right / 2;         //  Find the center of the window
         Rect.bottom = Rect.bottom / 2;
                                                //  Draw the text at last angle
         TextOut( hDC, Rect.right, Rect.bottom, "Arial", 5 );

         iLastValue += 150;                      //  Add 150 TENTHS OF A DEGREE
         if( iLastValue >= 3600 )                        //  Reset to 0 at 3600
            iLastValue = 0;                        //  Save this as window prop
         SetProp( hWnd, MAKEINTATOM( 10000 ), (HANDLE)iLastValue );
                                         //  Create new font based on new angle
         hFont = CreateFont( 24, 0, iLastValue, 0, FW_BOLD, 
                             0, 0, 0, 0, 0, 0, 0, 0,
                             "Arial" );
                                             //  Select new and delete old font
         DeleteObject( SelectObject( hDC, hFont ) );

         SetTextColor( hDC, RGB( 0, 0, 0 ) );      //  Use black text this time
         TextOut( hDC, Rect.right, Rect.bottom, "Arial", 5 );       //  Draw it

         ReleaseDC( hWnd, hDC );  //  Release the DC (which deselects the font)
         DeleteObject( hFont );             //  Now deselected, delete the font
         break;
      }                                                      // End of WM_TIMER


      case WM_COMMAND:
         if( wParam == 100 )
         {
            DestroyWindow( hWnd );          //  Quit if Exit menu item selected
            break;
         }
         break;


      default:
         return( DefWindowProc( hWnd, msg, wParam, lParam ) );
   }
   return( FALSE );
}                                                      //  End of MainWndProc()

