/***************************************************************
  LOCKHIGH library. Functions to PageLock segments above 1M line
  LOCKHIGH.C
  by Alex Shmidt, January 1994
  small model
  for MS compilers compile with LOCKHIGH.MAK
****************************************************************/

#include <windows.h>
LPVOID pHead;       /* head of the link list */

// LowAllocAll (DWORD maxleft)
//
// Allocates ALL the DOS memory in blocks in such a way that the biggest
// block left there will not be bigger than maxleft.
// Allocates all 64K blocks, then twice less, an so on, until maxleft
// barrier gets reached. This strategy supposedly conserves selectors.
// Note! It's unlikely, but theoretically possible, that it might get
// so crowdy in the LDT, that GlobalDosAlloc will fail not because of
// DOS memory pool is exhausted, but because of the lack of selectors.
// That's why performance isn't garanteed, use the library at your own risk.
void LowAllocAll (DWORD maxleft)
{
DWORD blocksiz = 0x20000U;       // starts off with 0x20000 / 2 = 64K blocks
LPVOID far *pblock = &pHead;

   do
   {
      //don't waste selectors!
      blocksiz /= 2;
      //grab all the blocks of this size
      //and attach them to the link list
      while (1)
      {
         if ((*pblock = MAKELP(LOWORD(GlobalDosAlloc(blocksiz)),0)) == NULL)
            break;

         pblock = (LPVOID far *)*pblock;     // next, please
      }
   }while (blocksiz >= maxleft);
}

// LowFreeAll (void)
//
// frees up all the blocks in the link list.
void LowFreeAll (void)
{
LPVOID far *pblock = (LPVOID far *) pHead;

   while (pblock)
   {
      pHead = *pblock;
      GlobalDosFree (HIWORD(pblock));
      pblock = (LPVOID far *) pHead;
   }
}

// GlobalPageLockHigh (WORD sel)   -  locks a segment above 1M
//
// first makes sure there will be no free block in the DOS MCB chain
// large enough for our to-be-pagelocked segment to fit in there,
// so that when GlobalPageLock is called Windows has no way
// to move our segment down below 1M;
// after that gets all the allocated blocks back to DOS
UINT GlobalPageLockHigh (WORD sel)
{
UINT lockcnt;

   LowAllocAll (GetSelectorLimit (sel) - 1);
   lockcnt = GlobalPageLock (sel);
   LowFreeAll ();
   return (lockcnt);
}
