/***************************************************
RINGO.H -- VMM and RINGO defines and functions
by Alex Shmidt. Nov, 1993
***************************************************/

//system controls
#define  Sys_Critical_Init       0x0
#define  Device_Init             0x1
#define  Init_Complete           0x2
#define  Sys_VM_Init             0x3
#define  Sys_VM_Terminate        0x4
#define  System_Exit             0x5
#define  Sys_Critical_Exit       0x6
#define  Create_VM               0x7
#define  VM_Critical_Init        0x8
#define  VM_Init                 0x9
#define  VM_Terminate            0xa
#define  VM_Not_Executeable      0xb
#define  Destroy_VM              0xc
#define  VM_Suspend              0xd
#define  VM_Resume               0xe
#define  Set_Device_Focus        0xf
#define  Begin_Message_Mode      0x10
#define  End_Message_Mode        0x11
#define  Reboot_Processor        0x12
#define  Query_Destroy           0x13
#define  Debug_Query             0x14
#define  Begin_PM_App            0x15
#define  End_PM_App              0x16
#define  Device_Reboot_Notify    0x17
#define  Crit_Reboot_Notify      0x18
#define  Close_VM_Notify         0x19
#define  Power_Event             0x1a

//   Flags for VM_Not_Executeable control call (passed in EDX)
#define VNE_Crashed     0x1
#define VNE_Nuked       0x2
#define VNE_CreateFail  0x4
#define VNE_CrInitFail  0x8
#define VNE_InitFail    0x10
#define VNE_Closed      0x20

// Flags for Begin_PM_App (passed in EDX)
#define BPA_32_Bit      1

// Close_VM_Notify flags
#define CVNF_Crit_Close  1

#define  VMStat_Exclusive        0x1
#define  VMStat_Background       0x2
#define  VMStat_Creating         0x4
#define  VMStat_Suspended        0x8
#define  VMStat_Not_Executeable  0x10
#define  VMStat_PM_Exec          0x20
#define  VMStat_PM_App           0x40
#define  VMStat_PM_Use32         0x80
#define  VMStat_VxD_Exec         0x100
#define  VMStat_High_Pri_Back    0x200
#define  VMStat_Blocked          0x400
#define  VMStat_Awakening        0x800
#define  VMStat_PageableV86      0x1000
#define  VMStat_V86IntsLocked    0x2000
#define  VMStat_TS_Sched         0x4000
#define  VMStat_Idle             0x8000
#define  VMStat_Closing          0x10000

typedef struct {
   DWORD pgphys;
   WORD  pgatr;
   WORD  pgtype;
}PGMAP, far *LPPGMAP;

typedef struct {
   DWORD base;       // descriptor base
   DWORD limit;      // descriptor limit
   BYTE  dpl;        // descriptor dpl
   BYTE  type;       // access type field
   BYTE  gran;       // granularity byte
}SEGDESCMAP, far *LPSEGDESCMAP;

typedef struct {
   WORD  pdir;
   WORD  ptab;
   WORD  offs;
}LINMAP, far *LPLINMAP;

// Global Descriptor Table
typedef struct {
   WORD  GDTRL;      /* GDT limit */
   DWORD GDTRB;      /* GDT base */
}GDTSTRUCT, far *LPGDTSTRUCT;

// Interrupt Descriptor Table
typedef struct {
   WORD  IDTRL;      /* IDT limit */
   DWORD IDTRB;      /* IDT base */
}IDTSTRUCT, far *LPIDTSTRUCT;

// Local Descriptor Table
typedef struct {
   WORD  LDTRS;      /* LDT register (GDT selector) */
   DWORD LDTB;       /* LDT base */
   WORD  LDTSL;      /* LDT limit */
   DWORD LDTSR;      /* LDT selector access rights */
}LDTSTRUCT, far * LPLDTSTRUCT;

// Task Register and Task State Segment
typedef struct {
   WORD  TREG;       /* task register */
   DWORD TSSB;       /* TSS base */
   WORD  TSSL;       /* TSS limit */
   DWORD TSSR;       /* TSS access rights */
}TSSSTRUCT, far *LPTSSSTRUCT;

// Control Registers
typedef struct {
   DWORD CR0R;       /* CR0 */
   DWORD CR2R;       /* CR2 */
   DWORD CR3R;       /* CR3 */
   DWORD PDIRL;      /* Page Dir linear address */
}CRSTRUCT, far *LPCRSTRUCT;

// Debug Registers
typedef struct {
   DWORD DR0R;       /* DR0 */
   DWORD DR1R;       /* DR1 */
   DWORD DR2R;       /* DR2 */
   DWORD DR3R;       /* DR3 */
   DWORD DR6R;       /* DR6 */
   DWORD DR7R;       /* DR7 */
}DRSTRUCT, far *LPDRSTRUCT;

// communicate with RINGO through this structure
typedef struct {
   GDTSTRUCT   SysGdt;
   LDTSTRUCT   SysLdt;
   IDTSTRUCT   SysIdt;
   TSSSTRUCT   SysTss;
   CRSTRUCT    SysCr;
   DRSTRUCT    SysDr;
   DWORD       VxDRoot;
   WORD        VMMVer;
   DWORD       VMMRev;
   WORD        VMCount;
   DWORD       VMHndl[10];
}SYSTEMSTRUCT, *PSYSTEMSTRUCT, far *LPSYSTEMSTRUCT;

// Device Descriptor Block
typedef struct {
   DWORD DDB_Next;
   WORD  DDB_SDK_Version;
   WORD  DDB_Req_Device_Number;
   BYTE  DDB_Dev_Major_Version;
   BYTE  DDB_Dev_Minor_Version;
   WORD  DDB_Flags;
   BYTE  DDB_Name[8];
   DWORD DDB_Init_Order;
   DWORD DDB_Control_Proc;
   DWORD DDB_V86_API_Proc;
   DWORD DDB_PM_API_Proc;
   void  (far *DDB_V86_API_CSIP)();
   void  (far *DDB_PM_API_CSIP)();
   DWORD DDB_Reference_Data;
   DWORD DDB_Service_Table_Ptr;
   DWORD DDB_Service_Table_Size;
}DDB, far *LPDDB;

// Documented VM fields
typedef struct {
   DWORD CB_VM_Status;
   DWORD CB_High_Linear;
   DWORD CB_Client_Pointer;
   DWORD CB_VMID;
}VM, far *LPVM;

typedef struct {
   DWORD VMM_Fault;
   DWORD V86_Fault;
   DWORD PM_Fault;
}FAULT, *PFAULT, far *LPFAULT;

// WM_RINGO message structure
typedef struct {
   DWORD msg_VM;
   DWORD msg_Param1;
   DWORD msg_Param2;
   DWORD msg_Param3;
}MSGSTRUC, far *LPMSGSTRUC;

typedef DWORD PAGE, far *LPPAGE;

// RINGO's exports
DWORD WINAPI GetSys (LPSYSTEMSTRUCT);
DWORD WINAPI MapPhysToLinear (DWORD, WORD);
void  WINAPI GateRegisterWindow (HWND);
void  WINAPI GateUnregisterWindow (HWND);
void  WINAPI NoDosBox (WORD);
DWORD WINAPI GateGetFault (WORD, DWORD);
