;************************************************************************
;RINGO.INC
;by Alex Shmidt, November 1993
;usefule defines and macros to be used with installable VxD RINGO
;************************************************************************
 svcid = 0
Declare_Service macro   svcname
 svcname = svcid
 LASTSVC = svcid
 svcid   = svcid + 1
endm

Declare_Service Get386_Svc
Declare_Service PhysToLin_Svc
Declare_Service Register_Hwnd_Svc
Declare_Service Unregister_Hwnd_Svc
Declare_Service StopVM_Svc
Declare_Service RemapGate_Svc
Declare_Service GetFault_Svc

GPARAM  struc
 G_Dword        dd      ?
 G_Word         dw      ?
 G_Svc          dw      ?
GPARAM  ends
.erre   (type GPARAM and 3) eq 0

CALLGATE_FRAME  struc
 CG_pushbp      dd      ?
 CG_Old_EIP     dd      ?               ; this is where we came from
 CG_Old_CS      dd      ?               ; and will get back
 CG_Params      db (type GPARAM) dup (?)
 CG_Old_ESP     dd      ?               ; caller's
 CG_Old_SS      dd      ?               ; stack
CALLGATE_FRAME  ends
.erre   size CG_Params le (CALLGATE_DDCOUNT_MASK * 4)

; lexical
GateSvc equ     <CG_Params.G_Svc>
GateDw  equ     <CG_Params.G_Dword>
GateW   equ     <CG_Params.G_Word>

EXITRINGOCALL   equ     0FFFFh

MSGSTRUC        struc
 MSG_VM         dd      ?
 MSG_PARAM1     dd      ?
 MSG_PARAM2     dd      ?
 MSG_PARAM3     dd      ?
 MSG_MSG        dd      ?
MSGSTRUC        ends

GDTSTRUCT       struc
 GDTRL  dw      ?     ;GDT limit
 GDTRB  dd      ?     ;GDT base
GDTSTRUCT       ends

IDTSTRUCT       struc
 IDTRL  dw      ?           ;IDT limit
 IDTRB  dd      ?           ;IDT base
IDTSTRUCT       ends

LDTSTRUCT       struc
 LDTRS  dw      ?   ;LDT register (GDT selector)
 LDTB   dd      ?   ;LDT base
 LDTSL  dw      ?   ;LDT limit
 LDTSR  dd      ?   ;LDT selector access rights
LDTSTRUCT       ends

TSSSTRUCT       struc
 TREG    dw      ?    ;task register
 TSSB    dd     ?    ;base
 TSSL    dw     ?    ;limit
 TSSR    dd     ?    ;access rights
TSSSTRUCT       ends

CRSTRUCT        struc
 CR0R   dd      ?
 CR2R   dd      ?
 CR3R   dd      ?
 PDIRL  dd      ?       ;Page Dir linear address
CRSTRUCT        ends

DRSTRUCT        struc
 DR0R   dd      ?
 DR1R   dd      ?
 DR2R   dd      ?
 DR3R   dd      ?
 DR6R   dd      ?
 DR7R   dd      ?
DRSTRUCT        ends

SYSTEMSTRUCT    struc
 SysGdt  db type GDTSTRUCT dup (?)
 SysLdt  db type LDTSTRUCT dup (?)
 SysIdt  db type IDTSTRUCT dup (?)
 SysTss  db type TSSSTRUCT dup (?)
 SysCr   db type CRSTRUCT  dup (?)
 SysDr   db type DRSTRUCT  dup (?)
 VxDRoot dd     ?
 VMMVer  dw     ?
 VMMRev  dd     ?
 VMCount dw     ?
 VMHndl  dd     ?
SYSTEMSTRUCT   ends

FAULT   struc
 VMM_Fault      dd      ?
 V86_Fault      dd      ?
 PM_Fault       dd      ?
FAULT   ends

BuildGateStackFrame     macro dataseg
        push    ebp
        mov     ebp,esp
        push    gs
        push    ds
        push    es
        push    fs
        push    esi
        push    edi
 ifidni <dataseg>,<_DATA>
        mov     ax,ds
        mov     gs,ax           ; we'll access our data seg via gs
 endif
        mov     ax,ss
        mov     ds,ax           ; ring 0 flat data delector
        mov     es,ax
        mov     fs,ax
 ifdifi <dataseg>,<_DATA>
        call    GetRingoGdtDataSel
 endif
endm

G_GS    equ     word ptr - 4
G_DS    equ     word ptr - 8
G_ES    equ     word ptr - 0ch
G_FS    equ     word ptr - 10h

ClearGateStackFrame     macro cleanup
        pop     edi
        pop     esi
        pop     fs
        pop     es
        pop     ds
        pop     gs
        pop     ebp
        ret     cleanup
endm

movoffs macro   reg,off32
ifb <off32>
 .err <movoffs>:missing operand
exitm
endif
ifb <reg>
 .err <movoffs>:missing operand
exitm
endif
        mov     reg, offset &off32
        add     reg,gs:[ringo_flat]
endm

WM_USER         equ     400h
WM_RINGO        equ     0
